/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartObject;
import jsbugs.ChartProperties;
import jsbugs.PanelEventsBase;
import jsbugs.PanelEventsProperties;
import jsbugs.SBGraphics;
import jsbugs.SchemeBlock;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import util.AgeFormat;
import util.SB;
import util.SBException;

public class PanelCompositeStandard
extends PanelEventsBase {
    private final SchemeBlock block;
    CompositeStandard cmpStd;

    public PanelCompositeStandard(CompositeStandard c, SBdb sbdb, SchemeBlock block) throws SQLException {
        this.cmpStd = c;
        this.block = block;
        this.p = new PanelEventsProperties(sbdb, false);
        if (this.cmpStd != null) {
            this.cmpStd.loadEvents();
        }
    }

    public PanelCompositeStandard(CompositeStandard c, SBdb sbdb, SchemeBlock block, String props) throws SQLException, SBException {
        this.cmpStd = c;
        this.block = block;
        this.p = new PanelEventsProperties(sbdb, props);
        if (this.cmpStd != null) {
            this.cmpStd.loadEvents();
        }
    }

    CompositeStandard getStd() {
        return this.cmpStd;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Iterator it;
        if (this.movedPositions == null) {
            System.out.println("movedPositions is null");
            return null;
        }
        float BRACKET = 2.5f / zoom;
        boolean list2 = this.separate && x > this.getWidth(bp) / 2.0f;
        int i = 0;
        Iterator iterator = it = list2 ? this.chartObjects2.iterator() : this.chartObjects.iterator();
        while (it.hasNext()) {
            float symbolSize;
            ChartObject chartObject = (ChartObject)it.next();
            float yPos = list2 ? this.movedPositions2[i] : this.movedPositions[i];
            float f = symbolSize = list2 ? this.symbolSizes2[i] : this.symbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                List list = (List)chartObject.o;
                if (list.size() == 1) {
                    return list.get(0);
                }
                float rowHeight = symbolSize / (float)list.size();
                for (int j = 0; j < list.size(); ++j) {
                    if (!(y > yPos + (float)j * rowHeight) || !(y < yPos + ((float)j + 1.0f * rowHeight))) continue;
                    return list.get(j);
                }
                return list.get(list.size() - 1);
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "Composite Standard" + (this.cmpStd != null ? " - " + this.cmpStd.getName() : "");
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object event = this.getObject(x, y, cp, bp, zoom);
        if (event != null) {
            return event.toString();
        }
        return null;
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        g.setFont(cp.font, 0, cp.fontTiny);
        g.setStroke(0.1f);
        try {
            this.setData(cp, bp, null, g);
            LinkedList compositeList = new LinkedList();
            compositeList.addAll(this.chartObjects);
            if (this.chartObjects2 != null) {
                compositeList.addAll(this.chartObjects2);
            }
            Iterator it = compositeList.iterator();
            int i1 = 0;
            int i2 = 0;
            while (it.hasNext()) {
                ChartObject chartObject = (ChartObject)it.next();
                List events = (List)chartObject.o;
                SBEvent.EventType type = ((CompositeStandardEvent)events.get(0)).getType();
                this.drawEvents(g, cp, mode, x, y, this.separate && type == SBEvent.EventType.BASE ? i2 : i1, chartObject, bp.units);
                if (this.separate && type == SBEvent.EventType.BASE) {
                    ++i2;
                    continue;
                }
                ++i1;
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        g.setColor(Color.BLACK);
        return x + this.p.panelWidth;
    }

    @Override
    String getCaption() {
        return this.cmpStd.getName();
    }

    @Override
    void calcTickIndent(boolean left, ChartProperties cp, SBGraphics g) {
        if (!this.p.showDepths) {
            if (left) {
                this.leftTickIndent = 0.0f;
            } else {
                this.rightTickIndent = 0.0f;
            }
            return;
        }
        float f = 0.0f;
        for (CompositeStandardEvent event : this.cmpStd.getEventsByCSU(true)) {
            if ((!left || event.getType() == SBEvent.EventType.BASE) && (left || event.getType() != SBEvent.EventType.BASE)) continue;
            float age = (float)this.cmpStd.getAge(event.getCSU());
            String strg = "" + SB.getAgeFloat((double)age, (AgeFormat)cp.ageFormat);
            float f2 = g != null ? g.stringWidth(strg) : SBGraphics.stringWidth(strg, cp.fontTiny);
            float strgWidth = f2;
            if (!(f < strgWidth)) continue;
            f = strgWidth;
        }
        if (left) {
            this.leftTickIndent = f;
        } else {
            this.rightTickIndent = f;
        }
    }

    @Override
    float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        if (this.cmpStd != null) {
            float ageIndent = 4.0f;
            float eventIndent = 5.25f * cp.fontTiny;
            if (!this.p.showDepths) {
                eventIndent -= ageIndent;
                ageIndent = 0.0f;
            }
            g.setColor(Color.BLACK);
            g.setFont(cp.font, 0, cp.fontTiny);
            g.setStroke(0.1f);
            float yBase = y + this.p.panelWidth;
            Iterator it = this.cmpStd.getEventsByCSU(bp.ageLeftToRight).iterator();
            LinkedList<Float> positions = new LinkedList<Float>();
            while (it.hasNext()) {
                float age;
                CompositeStandardEvent event = (CompositeStandardEvent)it.next();
                try {
                    if (!this.p.plotEvent(event)) {
                        continue;
                    }
                }
                catch (SQLException sql) {
                    SB.showStackError((String)"SQL Error", (SQLException)sql);
                }
                if (!((age = (float)this.cmpStd.getAge(event.getCSU())) >= bp.min) || !(age <= bp.max)) continue;
                float xPos = this.getXPos(age, bp) + x;
                g.drawLine(xPos, yBase, xPos, yBase - 1.0f);
                float offset = this.getEvTypeOffset(event.getType(), cp.fontTiny);
                positions.add(Float.valueOf(xPos + offset));
            }
            float[] movedPositionsStd = new float[positions.size()];
            if (!positions.isEmpty()) {
                float lPosition;
                float hPosition;
                for (int i = 0; i < positions.size(); ++i) {
                    movedPositionsStd[i] = ((Float)positions.get(i)).floatValue();
                }
                if (bp.ageLeftToRight) {
                    hPosition = this.getXPos(bp.min, bp) + x;
                    lPosition = this.getXPos(bp.max, bp) + x;
                } else {
                    hPosition = this.getXPos(bp.max, bp) + x;
                    lPosition = this.getXPos(bp.min, bp) + x;
                }
                PanelCompositeStandard.moveSamplePositions(movedPositionsStd.length, movedPositionsStd, cp.fontTiny, hPosition, lPosition);
            }
            it = this.cmpStd.getEventsByCSU(bp.ageLeftToRight).iterator();
            int i = 0;
            Color colour = Color.BLACK;
            while (it.hasNext()) {
                String eventName;
                float age;
                CompositeStandardEvent event = (CompositeStandardEvent)it.next();
                try {
                    if (!this.p.plotEvent(event)) {
                        continue;
                    }
                }
                catch (SQLException sql) {
                    SB.showStackError((String)"SQL Error", (SQLException)sql);
                }
                if (!((age = (float)this.cmpStd.getAge(event.getCSU())) >= bp.min) || !(age <= bp.max)) continue;
                float xPos = this.getXPos(age, bp) + x;
                if (this.p.useColours) {
                    try {
                        colour = this.p.getColor(event.getDisc());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    g.setColor(colour);
                }
                float movedPosition = movedPositionsStd[i] - this.getEvTypeOffset(event.getType(), cp.fontTiny);
                g.drawLine(xPos, yBase - 1.0f, movedPosition, yBase - 2.0f);
                float[] xP = new float[3];
                float[] yP = new float[3];
                xP[0] = movedPosition;
                yP[1] = yP[2] = yBase - 2.0f - 1.0f;
                yP[0] = yBase - 2.0f;
                if (event.getEvType() == 'L') {
                    xP[1] = movedPosition + (bp.ageLeftToRight ? -0.6f : 0.6f);
                    xP[2] = movedPosition;
                } else if (event.getEvType() == 'F') {
                    xP[1] = movedPosition + (bp.ageLeftToRight ? 0.6f : -0.6f);
                    xP[2] = movedPosition;
                } else {
                    xP[1] = movedPosition - 0.6f;
                    xP[2] = movedPosition + 0.6f;
                }
                g.fillPolygon(xP, yP, 3, colour);
                String string = eventName = this.p.showType ? event.toStringName() : event.getName();
                if (this.p.showDepths) {
                    g.drawStringVertical("" + SB.round((double)age, (int)2), movedPositionsStd[i], yBase - ageIndent, yBase - y - ageIndent, false, false);
                }
                g.drawStringVertical(eventName, movedPositionsStd[i], yBase - eventIndent, yBase - y - eventIndent, false, false);
                ++i;
            }
            return yBase - y;
        }
        return 0.0f;
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    int getIdentifier() {
        if (this.cmpStd != null) {
            return this.cmpStd.getStdID();
        }
        return -1;
    }

    @Override
    public int getType() {
        return 42;
    }

    @Override
    void addEvents(ChartProperties cp) throws SQLException {
        Iterator it = this.cmpStd.getEventsByCSU(true).iterator();
        LinkedList<ChartObject> compositeList = new LinkedList<ChartObject>();
        while (it.hasNext()) {
            Float[] pos;
            float age;
            CompositeStandardEvent event = (CompositeStandardEvent)it.next();
            if (!this.p.plotEvent(event) || !((age = (float)this.cmpStd.getAge(event.getCSU())) >= this.block.getMinAge()) || !(age <= this.block.getMaxAge()) || (pos = this.block.calcPlotPositions(age)) == null) continue;
            Float[] arr$ = pos;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float yPos = arr$[i$].floatValue();
                ChartObject co = new ChartObject(event, yPos);
                co.plotName = "" + SB.getAgeFloat((double)this.cmpStd.getAge(event.getCSU()), (AgeFormat)cp.ageFormat);
                compositeList.add(co);
            }
        }
        Collections.sort(compositeList);
        LinkedList<ChartObject> compositeList2 = new LinkedList<ChartObject>();
        Iterator itt = compositeList.iterator();
        LinkedList<ChartObject> list = null;
        class ChartObjectCompounder {
            ChartObjectCompounder() {
            }

            ChartObject createChartObject(LinkedList<ChartObject> list) {
                LinkedList<CompositeStandardEvent> events = new LinkedList<CompositeStandardEvent>();
                for (ChartObject coEvent : list) {
                    events.add((CompositeStandardEvent)coEvent.o);
                }
                ChartObject listObject = new ChartObject(events, list.getLast().yPos);
                listObject.plotName = list.getLast().plotName;
                return listObject;
            }
        }
        ChartObjectCompounder compounder = new ChartObjectCompounder();
        while (itt.hasNext()) {
            ChartObject chartObject = (ChartObject)itt.next();
            CompositeStandardEvent event = (CompositeStandardEvent)chartObject.o;
            if (list == null) {
                list = new LinkedList<ChartObject>();
                list.add(chartObject);
                continue;
            }
            CompositeStandardEvent lastEvent = (CompositeStandardEvent)((ChartObject)list.getLast()).o;
            float lastYpos = ((ChartObject)list.getLast()).yPos;
            if (event.getType() == lastEvent.getType() && (double)Math.abs(chartObject.yPos - lastYpos) < 0.1) {
                list.add(chartObject);
                continue;
            }
            compositeList2.add(compounder.createChartObject(list));
            list = new LinkedList();
            list.add(chartObject);
        }
        if (list != null && !list.isEmpty()) {
            compositeList2.add(compounder.createChartObject(list));
        }
        for (ChartObject co : compositeList2) {
            if (this.separate) {
                SBEvent.EventType type = ((CompositeStandardEvent)((List)co.o).get(0)).getType();
                if (type == SBEvent.EventType.BASE) {
                    this.chartObjects2.add(co);
                    continue;
                }
                this.chartObjects.add(co);
                continue;
            }
            this.chartObjects.add(co);
        }
    }

    @Override
    float gethPosition(ChartProperties cp, BlockProperties bp) throws SBException {
        return this.block.scaleValue(bp.min, bp.scaleType) + cp.fontTiny / 2.0f;
    }

    @Override
    float getlPosition(ChartProperties cp, BlockProperties bp) throws SBException {
        return this.block.scaleValue(bp.max, bp.scaleType) - cp.fontTiny / 2.0f;
    }

    @Override
    List getEvents() {
        return this.cmpStd.getEventsByCSU(true);
    }
}

