/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelCoreImagesProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.CoreImage;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;

public class PanelCoreImages
extends SBPanel
implements Observer {
    private PanelCoreImagesProperties p;
    WellBlock block;
    LinkedList<SBPanel.ChartImage> images;

    PanelCoreImages(WellBlock block, SBdb sbdb) {
        this.block = block;
        this.p = new PanelCoreImagesProperties(sbdb);
        block.well.addObserver((Observer)this);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        g.setColor(this.p.backColour);
        try {
            for (SBPanel.ChartImage pi : this.images) {
                float top = y + PanelCoreImages.getPanelHeaderHeight(cp, mode) + pi.origTop;
                float base = y + PanelCoreImages.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)((CoreImage)pi.object).getBaseDepth());
                g.fillRect(x, top, this.p.panelWidth, base - top);
                float xpos = x;
                float ypos = top;
                switch (this.p.fit) {
                    case 1: {
                        if (!(pi.height > base - top) || !this.p.crop) break;
                        g.setClip(x, top, this.p.panelWidth, base - top);
                        break;
                    }
                    case 2: {
                        if (!(pi.width > this.p.panelWidth)) break;
                        g.setClip(x, top, this.p.panelWidth, pi.height);
                        xpos -= (pi.width - this.p.panelWidth) / 2.0f;
                        break;
                    }
                }
                g.drawImage(pi.image, xpos, ypos, pi.width, pi.height);
                g.setClip(null);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error drawing core images panel", (Exception)e);
        }
        return x + this.p.panelWidth;
    }

    @Override
    String getCaption() {
        return "Core Images";
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException, IOException {
        System.out.println("PanelCoreImages setting data...");
        this.images = new LinkedList();
        for (CoreImage img : this.block.well.getCoreImages()) {
            float top = this.block.scaleDepth((float)img.getTopDepth());
            float base = this.block.scaleDepth((float)img.getBaseDepth());
            ImageIcon icon = img.getImage().getImage();
            float imgHeight = icon.getIconHeight();
            float imgWidth = icon.getIconWidth();
            switch (this.p.fit) {
                case 1: {
                    if (!(imgWidth > this.p.panelWidth)) break;
                    imgHeight /= imgWidth / this.p.panelWidth;
                    imgWidth = this.p.panelWidth;
                    if (!(imgHeight > base - top) || this.p.crop) break;
                    imgHeight /= imgWidth / (imgWidth - 5.0f);
                    imgWidth -= 5.0f;
                    break;
                }
                case 2: {
                    if (!(imgHeight > base - top)) break;
                    imgWidth /= imgHeight / (base - top);
                    imgHeight = base - top;
                    break;
                }
                default: {
                    if (imgHeight > base - top) {
                        imgWidth /= imgHeight / (base - top);
                        imgHeight = base - top;
                    }
                    if (!(imgWidth > this.p.panelWidth)) break;
                    imgHeight /= imgWidth / this.p.panelWidth;
                    imgWidth = this.p.panelWidth;
                }
            }
            SBPanel.ChartImage pi = new SBPanel.ChartImage(this, icon, top, imgWidth, imgHeight);
            img.getImage().clearImage();
            pi.object = img;
            this.images.add(pi);
        }
    }

    private void setData() {
        try {
            this.setData(null, null);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error setting data in PanelCoreImages", (Exception)e);
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        ListIterator<SBPanel.ChartImage> it = this.images.listIterator(this.images.size());
        block3: while (it.hasPrevious()) {
            SBPanel.ChartImage pi = it.previous();
            CoreImage ci = (CoreImage)pi.object;
            switch (this.p.fit) {
                case 1: {
                    if (!(this.p.crop ? (double)depth >= ci.getTopDepth() && (double)depth < ci.getBaseDepth() : y >= pi.origTop && y < pi.origTop + pi.height)) continue block3;
                    return pi;
                }
            }
            if (!((double)depth >= ci.getTopDepth()) || !((double)depth < ci.getBaseDepth())) continue;
            return pi;
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            SBPanel.ChartImage pi = (SBPanel.ChartImage)o;
            CoreImage ci = (CoreImage)pi.object;
            float depth = this.block.getDepth(y);
            String s = SB.floatString((double)SB.convFromM((double)ci.getTopDepth(), (char)this.block.prop.units), (int)2) + " - " + SB.floatString((double)SB.convFromM((double)ci.getBaseDepth(), (char)this.block.prop.units), (int)2);
            if (this.p.fit == 1) {
                depth = this.block.getDepth(pi.origTop + (this.block.scaleDepth((float)ci.getBaseDepth()) - pi.origTop) * ((y - pi.origTop) / pi.height));
            }
            if (!this.block.well.getCoreNumber((double)depth).isEmpty()) {
                s = s + " (" + this.block.well.getCoreNumber((double)depth) + ")";
            }
            String depthString = SB.getDepthString((double)depth, (char)this.block.prop.units, (int)2);
            return depthString + "  Core Image: " + s;
        }
        return null;
    }

    public String toString() {
        return "Core Images";
    }

    public PanelCoreImagesProperties getProps() {
        return this.p;
    }

    public void setProperties(PanelCoreImagesProperties p) {
        this.p = p;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well && arg instanceof CoreImage) {
            this.setData();
            this.setChanged();
            this.notifyObservers();
        }
    }
}

