/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.CoredInterval;
import model2.Cores;
import model2.Coreshift;
import model2.SBdb;
import util.SB;
import util.SBException;

public class PanelCores
extends SBPanel {
    private final WellBlock block;
    private final SBdb sbdb;
    private float width = 20.0f;
    private float shiftWidth = 20.0f;
    private boolean drawShiftCol = true;

    public PanelCores(SBdb sbdb, WellBlock block) {
        this.block = block;
        this.sbdb = sbdb;
        try {
            Coreshift coreShift = block.well.getCoreShift();
            if (coreShift == null || coreShift.getSize() == 0) {
                this.drawShiftCol = false;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, this.getWidth(bp), y + PanelCores.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(bp.max))) {
            return x + this.getWidth(bp);
        }
        try {
            Cores cores = this.block.well.getCores();
            g.setColor(Color.BLACK);
            g.setStroke(0.1f);
            g.setFont(cp.font, 0, cp.fontSmall);
            for (CoredInterval core : cores.getList()) {
                double topUnshifted = core.getTopDepth();
                double topShifted = this.block.well.getCorrectedDepth(topUnshifted);
                double baseUnshifted = core.getBaseDepth();
                double baseShifted = this.block.well.getCorrectedDepth(baseUnshifted);
                if (topShifted < (double)this.block.getTopDepth() && topUnshifted < (double)this.block.getTopDepth() && baseShifted < (double)this.block.getTopDepth() && baseUnshifted < (double)this.block.getTopDepth() || topShifted > (double)this.block.getBaseDepth() && topUnshifted > (double)this.block.getBaseDepth() && baseShifted > (double)this.block.getBaseDepth() && baseUnshifted > (double)this.block.getBaseDepth()) continue;
                if (topShifted < (double)this.block.getTopDepth()) {
                    topShifted = this.block.getTopDepth();
                    if (topUnshifted < (double)this.block.getTopDepth()) {
                        topUnshifted = this.block.getTopDepth();
                    }
                }
                if (baseShifted > (double)this.block.getBaseDepth()) {
                    baseShifted = this.block.getBaseDepth();
                    if (baseUnshifted > (double)this.block.getBaseDepth()) {
                        baseUnshifted = this.block.getBaseDepth();
                    }
                }
                float yTop = this.block.scaleDepth((float)topShifted) + y + PanelCores.getPanelHeaderHeight(cp, mode);
                float yBase = this.block.scaleDepth((float)baseShifted) + y + PanelCores.getPanelHeaderHeight(cp, mode);
                if (core.getRecovered()) {
                    g.drawRect(x, yTop, this.width, yBase - yTop);
                    g.fillRect(x, yTop, this.width / 3.0f, yBase - yTop, Color.BLACK);
                    g.fillRect(x + this.width - this.width / 3.0f, yTop, this.width / 3.0f, yBase - yTop, Color.BLACK);
                } else {
                    g.fillRect(x, yTop, this.width, yBase - yTop, Color.LIGHT_GRAY);
                }
                if (!core.getCorenum().isEmpty()) {
                    g.drawString(core.getCorenum(), x + this.width / 3.0f, yTop + (yBase - yTop) / 2.0f, this.width / 3.0f, 0);
                }
                if (!(Math.abs(topShifted - topUnshifted) > 0.1) && !(Math.abs(baseShifted - baseUnshifted) > 0.1)) continue;
                yTop = this.block.scaleDepth((float)topUnshifted) + y + PanelCores.getPanelHeaderHeight(cp, mode);
                yBase = this.block.scaleDepth((float)baseUnshifted) + y + PanelCores.getPanelHeaderHeight(cp, mode);
                g.setColor(Color.WHITE);
                g.drawRect(x, yTop, this.width / 3.0f, yBase - yTop);
                g.drawRect(x + this.width - this.width / 3.0f, yTop, this.width / 3.0f, yBase - yTop);
                g.setColor(Color.BLACK);
                g.setDashStroke(0.2f);
                g.drawRect(x, yTop, this.width / 3.0f, yBase - yTop);
                g.drawRect(x + this.width - this.width / 3.0f, yTop, this.width / 3.0f, yBase - yTop);
                g.setStroke(0.1f);
            }
            this.drawSubHeader(g, x, x + this.width, y, cp, bp, "Cored Intervals");
            if (this.drawShiftCol) {
                g.setStroke(0.2f);
                g.drawLine(x + this.shiftWidth, y + cp.panelCaptionHeight, x + this.shiftWidth, y + PanelCores.getPanelHeaderHeight(cp, mode) + bp.height);
                this.drawShiftCol(g, x + this.shiftWidth, y, cp, bp, mode);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        return x + this.getWidth(bp);
    }

    void drawShiftCol(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SQLException {
        Coreshift coreShift = this.block.well.getCoreShift();
        if (coreShift.getSize() == 0) {
            return;
        }
        double min = Math.floor(coreShift.getMinShift());
        if (Math.abs(min - (double)coreShift.getMinShift()) < 1.0) {
            min -= 1.0;
        }
        double max = Math.floor(coreShift.getMaxShift()) + 1.0;
        assert (max > min);
        double scale = (double)this.shiftWidth / (max - min);
        Point2D.Float[] points = new Point2D.Float[coreShift.getSize()];
        for (int i = 0; i < coreShift.getSize(); ++i) {
            Coreshift.CoreShiftDepth csd = coreShift.get(i);
            float yPos = this.block.scaleDepth((float)csd.getDepth());
            float shift = csd.getShift();
            if (csd.getDepth() < (double)this.block.getTopDepth()) {
                yPos = this.block.scaleDepth(this.block.getTopDepth());
                if (i + 1 == coreShift.getSize()) break;
                double nextDepth = coreShift.get(i + 1).getDepth();
                float nextShift = coreShift.get(i + 1).getShift();
                shift = (float)(((double)this.block.getTopDepth() - csd.getDepth()) * (double)(nextShift - shift) / (nextDepth - csd.getDepth()));
            }
            float xPos = x + (float)((double)shift * scale + (0.0 - min) * scale);
            points[i] = new Point2D.Float(xPos, yPos);
        }
        GeneralPath gp = SBGraphics.createGeneralPath(points[0].x, this.block.scaleDepth(this.block.getTopDepth()) + y + PanelCores.getPanelHeaderHeight(cp, mode));
        int lastPoint = 0;
        try {
            for (int i = 0; i < points.length; ++i) {
                if (points[i] == null) continue;
                SBGraphics.appendLine(gp, points[i].x, points[i].y + y + PanelCores.getPanelHeaderHeight(cp, mode));
                lastPoint = i;
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        try {
            if (points[lastPoint] != null) {
                SBGraphics.appendLine(gp, points[lastPoint].x, this.block.scaleDepth(this.block.getBaseDepth()) + y + PanelCores.getPanelHeaderHeight(cp, mode));
                g.setStroke(PanelZones.bndStroke * 2.0f);
                g.setColor(Color.LIGHT_GRAY);
                g.drawShape(gp);
            }
        }
        catch (NullPointerException npe) {
            System.out.println("Null pointer exception from gp.drawShape");
            npe.printStackTrace();
        }
        if (mode != Chart.Mode.NO_HEADER && (bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01)) {
            float hdrYpos = y + cp.getPanelHeaderHeight() - 10.0f;
            g.drawLine(x, hdrYpos, x + this.shiftWidth, hdrYpos);
            g.setFont(cp.font, 1, cp.fontSmall);
            g.setColor(Color.BLACK);
            g.drawString("core shift", x, hdrYpos - cp.fontTiny * 1.75f, this.shiftWidth, 0);
            g.setFont(cp.font, 0, cp.fontTiny);
            char units = this.block.well.getWellUnits();
            g.drawString(units == 'M' ? "(m)" : "(ft)", x, hdrYpos - cp.fontTiny / 2.0f, this.shiftWidth, 0);
            g.drawString(SB.floatString((double)SB.convFromM((double)min, (char)units), (int)0), x + 0.7f, hdrYpos - cp.fontTiny / 2.0f);
            String maxstrg = "" + SB.floatString((double)SB.convFromM((double)max, (char)units), (int)0);
            g.drawString(maxstrg, x + this.shiftWidth - g.stringWidth(maxstrg) - 0.7f, hdrYpos - cp.fontTiny / 2.0f);
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.width + (this.drawShiftCol ? this.shiftWidth : 0.0f);
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        try {
            Cores cores = this.block.well.getCores();
            for (CoredInterval core : cores.getList()) {
                double topShifted = this.block.well.getCorrectedDepth(core.getTopDepth());
                double baseShifted = this.block.well.getCorrectedDepth(core.getBaseDepth());
                if (!((double)depth >= topShifted) || !((double)depth <= baseShifted)) continue;
                return core;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o;
        if (this.drawShiftCol && x > this.shiftWidth) {
            try {
                float depth = this.block.getDepth(y);
                String strg = "Coreshift at " + SB.round((double)SB.convFromM((double)depth, (char)bp.units), (int)2) + (bp.units == 'M' ? "m" : "ft") + ": ";
                Coreshift coreShift = this.block.well.getCoreShift();
                for (int i = 0; i < coreShift.getSize(); ++i) {
                    Coreshift.CoreShiftDepth d = coreShift.get(i);
                    if ((double)depth > d.getDepth()) continue;
                    if ((double)depth < d.getDepth() && i == 0) {
                        return strg + (d.getShift() > 0.0f ? "+" : "") + SB.roundToSignificantFigures((double)SB.convFromM((double)d.getShift(), (char)bp.units), (int)4);
                    }
                    if (!((double)depth < d.getDepth()) || i <= 0) continue;
                    double proportion = ((double)depth - coreShift.get(i - 1).getDepth()) / (d.getDepth() - coreShift.get(i - 1).getDepth());
                    double shift = (double)coreShift.get(i - 1).getShift() + proportion * (double)(d.getShift() - coreShift.get(i - 1).getShift());
                    return strg + (shift > 0.0 ? "+" : "") + SB.roundToSignificantFigures((double)SB.convFromM((double)shift, (char)bp.units), (int)4);
                }
                return strg + (coreShift.get(coreShift.getSize() - 1).getShift() > 0.0f ? "+" : "") + SB.roundToSignificantFigures((double)SB.convFromM((double)coreShift.get(coreShift.getSize() - 1).getShift(), (char)bp.units), (int)4);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((o = this.getObject(x, y, cp, bp, zoom)) != null) {
            if (o instanceof CoredInterval) {
                CoredInterval core = (CoredInterval)o;
                return core.toString() + " (" + SB.getDepthString((double)core.getTopDepth(), (char)this.block.prop.units, (int)2) + " - " + SB.getDepthString((double)core.getBaseDepth(), (char)this.block.prop.units, (int)2) + ")";
            }
            return o.toString();
        }
        return null;
    }

    public String toString() {
        return "Cores";
    }

    @Override
    String getCaption() {
        return "Cores";
    }
}

