/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Observable;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelDendrogramProperties;
import jsbugs.PanelProperties;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonPropertiesBase;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.WellBlock;
import model2.AbnScheme;
import model2.Category;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.TxGroupSet;
import util.SBException;

public class PanelDendrogram
extends PanelTaxonBase {
    private PanelDendrogramProperties p;
    boolean writeTransformedData = false;
    boolean writeResults = false;
    private double[][] x;
    private double[] sampleDepths;
    private ClusterResult[] cluster;
    private String titleString = null;
    private TxGroupSet filter_set = null;
    private TxGroup filter_group = null;
    private Category filter_cat = null;
    private boolean includeSubCats = true;
    private final float INDENT = 2.0f;

    PanelDendrogram(PanelTaxonGroup parent, PanelDendrogramProperties p) {
        super(parent);
        this.p = p != null ? p : new PanelDendrogramProperties();
    }

    PanelDendrogram(PanelTaxonGroup parent, LinkedList<Chart.ChartPref> panelProps) throws SBException, SQLException {
        super(parent);
        ListIterator it = panelProps.listIterator();
        String props = null;
        while (it.hasNext()) {
            Chart.ChartPref pref = (Chart.ChartPref)it.next();
            if (!pref.key.endsWith("P")) continue;
            props = pref.value;
            it.remove();
            break;
        }
        if (props != null) {
            this.decode(parent.getDb(), props);
        }
        this.p = new PanelDendrogramProperties(panelProps);
    }

    private void decode(SBdb sbdb, String props) throws SQLException {
        String[] s = props.split("\\|");
        block5: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: 
                case 1: {
                    int ID;
                    int n = ID = s[i].isEmpty() ? 0 : Integer.parseInt(s[i]);
                    if (ID <= 0) continue block5;
                    if (i == 0) {
                        this.filter_set = sbdb.getTxGroupSet(ID);
                        continue block5;
                    }
                    if (i != 1) continue block5;
                    this.filter_group = sbdb.getTxGroup(ID);
                    continue block5;
                }
                case 2: {
                    if (s[i].isEmpty()) continue block5;
                    this.filter_cat = sbdb.getCategory(s[i]);
                    continue block5;
                }
                case 3: {
                    this.includeSubCats = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    @Override
    void setProperties(PanelProperties pp) {
        if (pp instanceof PanelDendrogramProperties) {
            this.p = (PanelDendrogramProperties)pp;
            return;
        }
        throw new IllegalArgumentException("Wrong properties type for PanelDendrogram: " + pp);
    }

    void setWidth(float w) {
        this.p.panelWidth = w;
    }

    boolean hasClusterData() {
        return this.cluster != null;
    }

    @Override
    PanelTaxonPropertiesBase getPanelTaxonProperties() {
        return this.p;
    }

    @Override
    public PanelDendrogramProperties getProperties() {
        return this.p;
    }

    @Override
    boolean setFilterGroup(TxGroup group) {
        boolean change = false;
        if (group != this.filter_group) {
            change = true;
            this.filter_group = group;
        }
        return change;
    }

    @Override
    boolean setFilterCat(Category cat, boolean includeSubCats) {
        boolean change = false;
        if (cat != this.filter_cat) {
            change = true;
            this.filter_cat = cat;
        }
        if (this.includeSubCats != includeSubCats) {
            change = true;
            this.includeSubCats = includeSubCats;
        }
        return change;
    }

    void setData() {
    }

    void clearData() {
        this.cluster = null;
        this.x = null;
        this.sampleDepths = null;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        LinkedList taxa = new LinkedList();
        this.getBlock().well.fillTaxonList(taxa, this.parent.getDiscID().getChar(), 0, 0);
        LinkedList<Taxon> toRemove = new LinkedList<Taxon>();
        for (Taxon taxon : taxa) {
            if (this.filter_cat != null) {
                if (this.includeSubCats) {
                    if (taxon.getCatMnem().startsWith(this.filter_cat.getMnem())) continue;
                    toRemove.add(taxon);
                    continue;
                }
                if (taxon.getCatMnem().equals(this.filter_cat.getMnem())) continue;
                toRemove.add(taxon);
                continue;
            }
            if (this.filter_group != null) {
                if (this.filter_group.isMember(taxon.getSpecID())) continue;
                toRemove.add(taxon);
                continue;
            }
            if (this.filter_set == null) continue;
            boolean found = false;
            for (TxGroup group : this.filter_set.getGroups()) {
                if (!group.isMember(taxon.getSpecID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(taxon);
        }
        for (Taxon taxon : toRemove) {
            taxa.remove(taxon);
        }
        int nTracks = taxa.size();
        double[][] sampleData = new double[this.parent.getnSamples()][nTracks];
        Iterator sampleIt = this.getBlock().well.getSamples(cp.correctDepths, cp.correctCuttings).iterator();
        int nSample = 0;
        while (sampleIt.hasNext()) {
            Sample sample = (Sample)sampleIt.next();
            Boolean sampleOutsideRange = this.isOutsideBlockRange(sample);
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, false) || sampleOutsideRange != null) continue;
                AbnScheme abnScheme = this.parent.getDb().getAbnScheme(smpdtl.getHeader().getAbnSchID(), false);
                for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                    if (!this.useOcc(fss)) continue;
                    Iterator taxonIt = taxa.iterator();
                    int j = 0;
                    while (taxonIt.hasNext()) {
                        Taxon t = (Taxon)taxonIt.next();
                        if (fss.getTaxon().getSpecID() == t.getSpecID()) break;
                        ++j;
                    }
                    float count = (float)fss.getDerivedCount(abnScheme, this.p.useSplits ? smpdtl.getCoarse() : 0.0f, this.p.useSplits ? smpdtl.getMedium() : 0.0f, this.p.useSplits ? smpdtl.getFine() : 0.0f);
                    if (this.p.normaliseWeight && smpdtl.getWeight() > 0.0029f) {
                        count *= this.p.normalWeight / smpdtl.getWeight();
                    }
                    double[] dArray = sampleData[nSample];
                    int n = j;
                    dArray[n] = dArray[n] + (double)count;
                }
                ++nSample;
            }
        }
        this.x = sampleData;
        this.sampleDepths = new double[this.parent.getnSamples()];
        for (int i = 0; i < this.sampleDepths.length; ++i) {
            this.sampleDepths[i] = this.parent.plotSamples[i].getDepth();
        }
        this.calcCONISS();
    }

    private WellBlock getBlock() {
        return this.parent.getBlock();
    }

    private void loadTestData() {
        this.x = this.initX();
        this.sampleDepths = this.initSamples();
    }

    private double[] initSamples() {
        double[] levs = new double[]{650.0, 662.0, 670.0, 680.0, 690.0, 702.0, 710.0, 714.0, 722.0, 730.0, 738.0, 742.0};
        return levs;
    }

    private double[][] initX() {
        return new double[][]{{7.5, 1.0, 19.0, 9.0, 10.0, 1.0, 26.0, 226.0, 77.0, 28.0, 15.0, 26.0, 25.0, 83.0, 12.0, 9.0, 12.0}, {3.5, 1.0, 8.0, 7.0, 15.0, 2.0, 14.0, 178.0, 69.0, 25.0, 10.0, 16.0, 41.0, 112.0, 12.0, 18.0, 15.0}, {3.5, 0.0, 6.0, 4.0, 4.0, 2.0, 11.0, 120.0, 38.0, 19.0, 10.0, 8.0, 24.0, 109.0, 6.0, 13.0, 17.0}, {2.5, 1.0, 7.0, 3.0, 14.0, 1.0, 25.0, 264.0, 32.0, 41.0, 4.0, 30.5, 43.0, 100.0, 17.0, 8.0, 6.0}, {4.5, 0.0, 9.0, 9.0, 11.0, 3.0, 17.0, 173.0, 30.0, 24.0, 15.0, 16.0, 56.0, 103.0, 13.0, 10.0, 19.0}, {1.0, 2.0, 5.0, 5.0, 10.0, 4.0, 17.0, 139.0, 36.0, 39.0, 4.0, 15.0, 24.0, 79.0, 7.0, 13.0, 12.0}, {6.5, 1.0, 21.0, 10.0, 16.0, 4.0, 19.0, 172.0, 41.0, 66.0, 10.0, 18.0, 53.0, 29.0, 13.0, 18.0, 12.0}, {1.5, 2.0, 10.0, 8.0, 30.0, 11.0, 9.0, 228.0, 33.0, 88.0, 11.0, 29.5, 65.0, 25.0, 19.0, 13.0, 9.0}, {2.0, 6.0, 13.0, 4.0, 11.0, 4.0, 13.0, 254.0, 69.0, 137.0, 20.0, 35.0, 44.0, 15.0, 14.0, 10.0, 9.0}, {6.5, 2.0, 26.0, 10.0, 22.0, 9.0, 14.0, 265.0, 49.0, 134.0, 27.0, 7.0, 65.0, 11.0, 21.0, 12.0, 7.0}, {1.5, 2.0, 24.0, 13.0, 33.0, 8.0, 13.0, 274.0, 66.0, 168.0, 27.0, 6.0, 60.0, 12.0, 20.0, 11.0, 3.0}, {2.5, 3.0, 25.0, 11.0, 28.0, 19.0, 6.0, 238.0, 38.0, 179.0, 17.0, 4.0, 63.0, 28.0, 21.0, 14.0, 11.0}};
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        return x;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, Integer iKey) {
        if (!g.isVisible(x, bp == this.getBlock().prop ? y : this.getBlock().scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelDendrogram.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height + (bp == this.getBlock().prop ? PanelDendrogram.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        float xpos = x + this.p.panelWidth;
        g.setColor(Color.BLACK);
        float topy = Math.min(this.getBlock().scaleDepth(bp.min), this.getBlock().scaleDepth(bp.max)) + y + PanelDendrogram.getPanelHeaderHeight(cp, mode);
        g.setStroke(0.2f);
        if (mode != Chart.Mode.NO_HEADER && (this.getBlock().prop == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01)) {
            this.drawSubHeader(g, x, xpos, y, cp, bp, this.getCaption());
            g.drawLine(x, y + cp.panelCaptionHeight, x, y + bp.height + PanelDendrogram.getPanelHeaderHeight(cp, mode));
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.height + PanelDendrogram.getPanelHeaderHeight(cp, mode));
        } else {
            g.drawLine(x, topy, x, topy + bp.height);
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.height + PanelDendrogram.getPanelHeaderHeight(cp, mode));
        }
        if (this.cluster != null && this.cluster.length > 1) {
            int lineLoop;
            int nLoops;
            float basey = topy + bp.height;
            float[] clusterYpos = new float[this.sampleDepths.length];
            float[] clusterXpos = new float[this.sampleDepths.length];
            g.setStroke(PanelZones.bndStroke);
            if (this.p.drawShading) {
                nLoops = 2;
                lineLoop = 1;
            } else {
                nLoops = 1;
                lineLoop = 0;
            }
            for (int iLoop = 0; iLoop < nLoops; ++iLoop) {
                if (iLoop != lineLoop) {
                    g.setColor(new Color(220, 220, 220));
                }
                for (int i = 0; i < clusterYpos.length; ++i) {
                    clusterYpos[i] = topy + this.getBlock().scaleDepth((float)this.sampleDepths[i]);
                    clusterXpos[i] = 0.0f;
                }
                float xSize = 0.0f;
                float midPoint = 0.0f;
                for (int i = 0; i < this.cluster.length - 1; ++i) {
                    if (!(this.cluster[i].totalDisp > 0.0)) continue;
                    int pindex = this.cluster[i].namep - 1;
                    int qindex = this.cluster[i].nameq - 1;
                    float yPos1 = clusterYpos[pindex];
                    float yPos2 = clusterYpos[qindex];
                    xSize = this.scaleDispersion(this.cluster[i].totalDisp);
                    midPoint = (yPos1 + yPos2) * 0.5f;
                    if (yPos2 > topy && yPos1 < basey) {
                        if (iLoop == lineLoop) {
                            if (yPos1 >= topy) {
                                g.setColor(Color.BLACK);
                                g.drawLine(x + 2.0f + clusterXpos[pindex], yPos1, x + 2.0f + xSize, yPos1);
                            }
                            if (yPos2 <= basey) {
                                g.setColor(Color.DARK_GRAY);
                                g.drawLine(x + 2.0f + clusterXpos[qindex], yPos2, x + 2.0f + xSize, yPos2);
                            }
                            g.setColor(Color.BLACK);
                            g.drawLine(x + 2.0f + xSize, Math.max(yPos1, topy), x + 2.0f + xSize, Math.min(yPos2, basey));
                        } else if (xSize < (this.p.panelWidth - 4.0f) * this.p.shadingCutoff) {
                            g.fillRect(x + 2.0f, Math.max(yPos1, topy), xSize, Math.min(yPos2, basey) - Math.max(yPos1, topy));
                        }
                    }
                    clusterYpos[pindex] = midPoint;
                    clusterXpos[pindex] = xSize;
                    clusterXpos[qindex] = 0.0f;
                }
                if (!(midPoint < basey) || !(midPoint > topy) || iLoop != lineLoop) continue;
                g.drawLine(x + 2.0f + xSize, midPoint, x + this.p.panelWidth - 2.0f, midPoint);
            }
        }
        return xpos;
    }

    private float scaleDispersion(double disp) {
        double maxd = this.cluster[this.cluster.length - 2].totalDisp;
        return (float)(disp / (maxd *= 1.05) * (double)(this.p.panelWidth - 4.0f));
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Dendrogram";
    }

    @Override
    String getCaption() {
        return "Total Dispersion" + (this.titleString != null ? ": " + this.titleString : "");
    }

    @Override
    boolean hasFilter() {
        return this.filter_cat != null || this.filter_group != null || this.filter_set != null;
    }

    @Override
    int getnTracks() {
        return 1;
    }

    void appendTitle(String strg) {
        this.titleString = this.titleString == null ? "" : this.titleString + ", ";
        this.titleString = this.titleString + strg;
    }

    @Override
    public void update(Observable o, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    TxGroup getFilterGroup() {
        return this.filter_group;
    }

    @Override
    Category getFilterCat() {
        return this.filter_cat;
    }

    @Override
    boolean getIncludeSubCats() {
        return this.includeSubCats;
    }

    @Override
    TxGroupSet getFilterSet() {
        return this.filter_set;
    }

    @Override
    Taxon getFilterSpec() {
        return null;
    }

    @Override
    boolean setFilterSet(TxGroupSet set) {
        boolean change = false;
        if (set != this.filter_set) {
            change = true;
            this.filter_set = set;
        }
        return change;
    }

    @Override
    String getDataProps() {
        String[] data = new String[]{"" + (this.filter_set != null ? this.filter_set.getID() : 0), "" + (this.filter_group != null ? this.filter_group.getID() : 0), "" + (this.filter_cat != null ? this.filter_cat.getMnem() : ""), "" + (this.includeSubCats ? 1 : 0)};
        String props = "";
        for (String string : data) {
            props = props + string + "|";
        }
        return props;
    }

    private void calcCONISS() throws SBException {
        int i;
        int i2;
        if (this.sampleDepths == null || this.sampleDepths.length < 1) {
            throw new SBException("Sample depths not initialised in calcCONISS");
        }
        int nSamples = this.sampleDepths.length;
        if (this.x == null || this.x.length < 1) {
            throw new SBException("Data matrix (x) not initialised in calcCONISS");
        }
        int nVars = this.x[0].length;
        if (this.sampleDepths.length < 3) {
            System.out.println("CONISS: Not enough clusters with less than 3 samples");
            this.cluster = null;
            return;
        }
        this.cluster = new ClusterResult[nSamples];
        for (i2 = 0; i2 < nSamples; ++i2) {
            this.cluster[i2] = new ClusterResult();
            this.cluster[i2].name = i2 + 1;
        }
        if (this.p.convertToProportions) {
            switch (this.p.inputData) {
                case COUNT: {
                    for (i2 = 0; i2 < nSamples; ++i2) {
                        int j;
                        double sum = 0.0;
                        for (j = 0; j < nVars; ++j) {
                            sum += this.x[i2][j];
                        }
                        for (j = 0; j < nVars; ++j) {
                            if (sum > 0.0) {
                                double[] dArray = this.x[i2];
                                int n = j;
                                dArray[n] = dArray[n] / sum;
                                continue;
                            }
                            this.x[i2][j] = 0.0;
                        }
                    }
                    System.out.println("Data converted to proportions");
                    break;
                }
                case PERCENTAGE: {
                    for (i2 = 0; i2 < nSamples; ++i2) {
                        for (int j = 0; j < nVars; ++j) {
                            this.x[i2][j] = (double)0.01f * this.x[i2][j];
                        }
                    }
                    System.out.println("% data converted to proportions");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        switch (this.p.transformation) {
            case SQRT: {
                for (i2 = 0; i2 < nSamples; ++i2) {
                    for (int j = 0; j < nVars; ++j) {
                        this.x[i2][j] = Math.sqrt(this.x[i2][j]);
                    }
                }
                System.out.println("Square root transformation");
                if (!this.p.convertToProportions && this.p.inputData != PanelDendrogramProperties.InputData.PERCENTAGE) break;
                System.out.println("Dissimilarity coefficient is edwards and Cavalli-Sforza's chord distance");
                break;
            }
            case STDISEVARS: {
                int j;
                int i3;
                double xlevs = nSamples;
                double xlevs1 = xlevs - 1.0;
                for (i3 = 0; i3 < nVars; ++i3) {
                    double sx = 0.0;
                    double sx2 = 0.0;
                    for (j = 0; j < nSamples; ++j) {
                        double xij = this.x[j][i3];
                        sx += xij;
                        sx2 += xij * xij;
                    }
                    if (!(sx > 0.0)) continue;
                    double xbar = sx / xlevs;
                    double sd = Math.sqrt((sx2 - sx * sx / xlevs) / xlevs1);
                    for (int j2 = 0; j2 < nSamples; ++j2) {
                        this.x[j2][i3] = (this.x[j2][i3] - xbar) / sd;
                    }
                }
                System.out.println("Variables standardised to mean 0, standard deviation 1, dissimilarity coefficient is standard euclidian distance.");
                break;
            }
            case NRMLISESAMPS: {
                int j;
                int i3;
                for (i3 = 0; i3 < nSamples; ++i3) {
                    double sx2 = 0.0;
                    for (int j3 = 0; j3 < nVars; ++j3) {
                        double xij = this.x[i3][j3];
                        sx2 += xij * xij;
                    }
                    double sx = Math.sqrt(sx2);
                    j = 0;
                    while (j < nVars) {
                        double[] dArray = this.x[i3];
                        int n = j++;
                        dArray[n] = dArray[n] / sx;
                    }
                }
                System.out.println("Sample vectors normalised to length 1, dissimilarity coefficient is Orloci's chord distance.");
                break;
            }
            case NONE: {
                System.out.println("No data transformation, dissimilarity coefficient is euclidian distance");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.writeTransformedData) {
            for (int i4 = 0; i4 < nSamples; ++i4) {
                System.out.print(this.sampleDepths[i4] + "\t");
                for (int j = 0; j < nVars; ++j) {
                    System.out.print(this.x[i4][j] + "\t");
                }
                System.out.print("\n");
            }
        }
        double[][] d = new double[nSamples - 1][];
        for (i = 1; i < nSamples; ++i) {
            d[i - 1] = new double[i];
            for (int j = 0; j < i; ++j) {
                double dsqd = 0.0;
                for (int k = 0; k < nVars; ++k) {
                    double temp = this.x[i][k] - this.x[j][k];
                    dsqd += temp * temp;
                }
                d[i - 1][j] = dsqd;
            }
        }
        if (this.p.constrained) {
            this.clusterConstrained(nSamples, d, this.cluster);
            System.out.println("Constrained incremental sum of squares cluster analysis");
        } else {
            this.clusterUnconstrained(nSamples, d, this.cluster);
            System.out.println("Unconstrained incremental sum of squares cluster analysis");
        }
        System.out.println("Stage\tClusters\t\tIncrease in \t\tTotal      \t\tWithin cluster\t\tMean within cluster");
        System.out.println("\t\t\t\tdispersion  \t\tdispersion \t\tDispersion     \t\tDispertion\n\n");
        if (this.writeResults) {
            for (i = 0; i < nSamples - 1; ++i) {
                System.out.print("" + (i + 1) + '\t' + this.cluster[i].namep + '\t' + this.cluster[i].nameq + '\t');
                System.out.print("\t" + this.cluster[i].incDisp);
                System.out.print("\t" + this.cluster[i].totalDisp);
                System.out.print("\t" + this.cluster[i].clusterDisp);
                System.out.print("\t" + this.cluster[i].meanClusterDisp);
                System.out.print("\n");
            }
        }
    }

    private void clusterConstrained(int nlevs, double[][] d, ClusterResult[] res) throws SBException {
        double[] ess = new double[nlevs];
        int[] nclus = new int[nlevs];
        for (int i = 0; i < nlevs; ++i) {
            nclus[i] = 1;
            ess[i] = 0.0;
        }
        int msiz = nlevs - 1;
        double e = 0.0;
        for (int iter = 0; iter < nlevs - 1; ++iter) {
            double dshort = d[0][0];
            int p = 0;
            for (int n = 1; n < msiz; ++n) {
                if (!(d[n][n] < dshort)) continue;
                dshort = d[n][n];
                p = n;
            }
            int q = p + 1;
            int namp = res[p].name;
            int namq = res[q].name;
            res[iter].namep = namp;
            res[iter].nameq = namq;
            int np = nclus[p];
            int nq = nclus[q];
            double de = 0.5 * dshort;
            ess[namp - 1] = ess[namp - 1] + ess[namq - 1] + de;
            res[iter].incDisp = de;
            res[iter].totalDisp = e += de;
            res[iter].clusterDisp = ess[namp - 1];
            res[iter].meanClusterDisp = ess[namp - 1] / (double)(np + nq);
            double[][] dNew = new double[msiz - 1][];
            for (int i = 0; i < msiz - 1; ++i) {
                dNew[i] = new double[i + 1];
                for (int j = 0; j <= i; ++j) {
                    if (i < p - 1 && j < p - 1) {
                        dNew[i][j] = d[i][j];
                        continue;
                    }
                    if (i == p - 1) {
                        dNew[i][j] = this.update((double[][])d, j, p - 1, q - 1, np, nq, nclus[j], dshort, true);
                        continue;
                    }
                    if (i > p - 1) {
                        if (j < p) {
                            dNew[i][j] = d[i + 1][j];
                            continue;
                        }
                        if (j == p) {
                            dNew[i][j] = this.update((double[][])d, i + 1, p, q, np, nq, nclus[i + 2], dshort, false);
                            continue;
                        }
                        dNew[i][j] = d[i + 1][j + 1];
                        continue;
                    }
                    throw new SBException("Cannot process index i=" + i);
                }
            }
            d = dNew;
            nclus[p] = np + nq;
            for (int m = q; m < msiz; ++m) {
                res[m].name = res[m + 1].name;
                nclus[m] = nclus[m + 1];
            }
            --msiz;
        }
    }

    private void clusterUnconstrained(int nlevs, double[][] d, ClusterResult[] res) throws SBException {
        double[] ess = new double[nlevs];
        int[] nclus = new int[nlevs];
        for (int i = 0; i < nlevs; ++i) {
            nclus[i] = 1;
            ess[i] = 0.0;
        }
        int msiz = nlevs - 1;
        double e = 0.0;
        for (int iter = 0; iter < nlevs - 1; ++iter) {
            double dshort = d[0][0];
            int p = 0;
            int q = 0;
            for (int n = 1; n < msiz; ++n) {
                for (int m = 0; m < n; ++m) {
                    if (!(d[n][m] < dshort)) continue;
                    dshort = d[n][m];
                    p = n;
                    q = m;
                }
            }
            int namp = res[p].name;
            int namq = res[q].name;
            res[iter].namep = namp;
            res[iter].nameq = namq;
            int np = nclus[p];
            int nq = nclus[q];
            double de = 0.5 * dshort;
            ess[namp - 1] = ess[namp - 1] + ess[namq - 1] + de;
            res[iter].incDisp = de;
            res[iter].totalDisp = e += de;
            res[iter].clusterDisp = ess[namp - 1];
            res[iter].meanClusterDisp = ess[namp - 1] / (double)(np + nq);
            double[][] dNew = new double[msiz - 1][];
            for (int i = 0; i < msiz - 1; ++i) {
                dNew[i] = new double[i + 1];
                for (int j = 0; j <= i; ++j) {
                    if (i < p - 1 && j < p - 1) {
                        dNew[i][j] = d[i][j];
                        continue;
                    }
                    if (i == p - 1) {
                        dNew[i][j] = this.update((double[][])d, j, p - 1, q - 1, np, nq, nclus[j], dshort, true);
                        continue;
                    }
                    if (i > p - 1) {
                        if (j < p) {
                            dNew[i][j] = d[i + 1][j];
                            continue;
                        }
                        if (j == p) {
                            dNew[i][j] = this.update((double[][])d, i + 1, p, q, np, nq, nclus[i + 2], dshort, false);
                            continue;
                        }
                        dNew[i][j] = d[i + 1][j + 1];
                        continue;
                    }
                    throw new SBException("Cannot process index i=" + i);
                }
            }
            d = dNew;
            nclus[p] = np + nq;
            for (int m = q; m < msiz; ++m) {
                res[m].name = res[m + 1].name;
                nclus[m] = nclus[m + 1];
            }
            --msiz;
        }
    }

    private double update(double[][] d, int r, int p, int q, int np, int nq, int nr, double distPQ, boolean column) {
        double update = ((double)(nr + np) * this.getClust(d, r, p, column) + (double)(nr + nq) * this.getClust(d, r, q, column) - (double)nr * distPQ) / (double)(nr + np + nq);
        return update;
    }

    private double getClust(double[][] d, int r, int n, boolean column) {
        if (!column) {
            return d[r][n];
        }
        return d[n][r];
    }

    private static class ClusterResult {
        double incDisp;
        double totalDisp;
        double clusterDisp;
        double meanClusterDisp;
        int name;
        int namep;
        int nameq;

        private ClusterResult() {
        }
    }
}

