/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.LinkedList;
import jsbugs.Chart;
import jsbugs.PanelTaxonPropertiesBase;
import model2.Lastval;
import model2.SBdb;
import util.SBException;

public class PanelDendrogramProperties
extends PanelTaxonPropertiesBase {
    boolean constrained = true;
    boolean convertToProportions = true;
    float panelWidth = 70.0f;
    boolean drawShading = true;
    float shadingCutoff = 0.5f;
    InputData inputData = InputData.COUNT;
    Transformation transformation = Transformation.SQRT;

    PanelDendrogramProperties() {
    }

    PanelDendrogramProperties(PanelDendrogramProperties rhs) {
        super(rhs);
        this.inputData = rhs.inputData;
        this.transformation = rhs.transformation;
        this.constrained = rhs.constrained;
        this.convertToProportions = rhs.convertToProportions;
        this.panelWidth = rhs.panelWidth;
        this.drawShading = rhs.drawShading;
        this.shadingCutoff = rhs.shadingCutoff;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        Lastval.putString((SBdb)sbdb, (String)(key + "E"), (String)this.getPrefs());
    }

    @Override
    public String getPrefs() {
        String[] options = new String[]{"" + (this.constrained ? 1 : 0), "" + (this.convertToProportions ? 1 : 0), "" + this.panelWidth, "" + (this.drawShading ? 1 : 0), "" + this.shadingCutoff};
        String props = "";
        for (String string : options) {
            props = props + string + "|";
        }
        return props;
    }

    PanelDendrogramProperties(LinkedList<Chart.ChartPref> props) throws SQLException, SBException {
        assert (props.size() == 1);
        String s = props.getFirst().value;
        String[] splits = s.split("\\|");
        block7: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    this.constrained = Integer.parseInt(splits[i]) == 1;
                    continue block7;
                }
                case 1: {
                    this.convertToProportions = Integer.parseInt(splits[i]) == 1;
                    continue block7;
                }
                case 2: {
                    this.panelWidth = Float.parseFloat(splits[i]);
                    continue block7;
                }
                case 3: {
                    this.drawShading = Integer.parseInt(splits[i]) == 1;
                    continue block7;
                }
                case 4: {
                    this.shadingCutoff = Float.parseFloat(splits[i]);
                }
            }
        }
    }

    static enum Transformation {
        NONE,
        SQRT,
        STDISEVARS,
        NRMLISESAMPS;

    }

    static enum InputData {
        COUNT,
        PERCENTAGE;

    }
}

