/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelDepthProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.TickScheme;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.Sample;
import util.SB;

public class PanelDepth
extends SBPanel {
    private WellBlock block;
    private final TickScheme scheme = new TickScheme();
    private PanelDepthProperties p;

    public PanelDepth(SBdb db, WellBlock block) {
        this.block = block;
        this.p = new PanelDepthProperties();
    }

    public PanelDepth(SBdb db, WellBlock block, String props) {
        this.block = block;
        this.p = new PanelDepthProperties(props);
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Depths";
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Depth Scale";
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, (bp == this.block.prop ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max)) + y + PanelDepth.getPanelHeaderHeight(cp, mode), this.p.width, bp.height)) {
            return x + this.p.width;
        }
        g.setClip(x, y + PanelDepth.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.prop), this.block.getHeight());
        try {
            float x2;
            float x1;
            float ypos;
            float baseDepth;
            float topDepth;
            if (this.p.seaBed) {
                float sb = this.block.scaleDepth((float)this.block.well.getHeader().getSB()) + PanelDepth.getPanelHeaderHeight(cp, mode) + y;
                g.setColor(Color.lightGray);
                g.setStroke(0.2f);
                g.drawLine(x, sb, x + this.getWidth(bp), sb);
                g.setFont(cp.font, 1, cp.fontPanel);
                g.drawString("SB", x + this.getWidth(bp) - g.stringWidth("SB") - 1.0f, sb - 1.0f);
                g.setColor(Color.BLACK);
            }
            if (this.p.TD && this.block.well.getHeader().getTD() > (double)this.block.getTopDepth() && this.block.well.getHeader().getTD() < (double)this.block.getBaseDepth()) {
                float td = this.block.scaleDepth((float)this.block.well.getHeader().getTD()) + PanelDepth.getPanelHeaderHeight(cp, mode) + y;
                g.setColor(Color.lightGray);
                g.setStroke(0.2f);
                g.drawLine(x, td, x + this.getWidth(bp), td);
                g.setFont(cp.font, 1, cp.fontPanel);
                g.drawString("TD", x + this.getWidth(bp) - g.stringWidth("TD") - 1.0f, td - 1.0f);
                g.setColor(Color.BLACK);
            }
            g.setStroke(0.15f);
            g.setFont(cp.font, 0, cp.fontSmall);
            if (this.block.prop != bp || this.block.prop.scaleType == BlockProperties.ScaleType.TVD) {
                topDepth = bp.min;
                baseDepth = bp.max;
            } else {
                topDepth = this.block.getTopDepth();
                baseDepth = this.block.getBaseDepth();
            }
            this.scheme.calcScaleLabels(topDepth, this.block.getScale(), this.block.prop.units);
            float depth = this.scheme.start;
            depth -= this.scheme.tickInterval;
            float left = x;
            float SMALL = 1.0E-6f;
            while (depth > topDepth) {
                if (depth < baseDepth) {
                    ypos = this.calcPlotPosition(y, depth, cp, mode);
                    x1 = left;
                    x2 = left + 1.0f;
                    g.drawLine(x1, ypos, x2, ypos);
                }
                depth -= this.scheme.tickInterval;
            }
            depth = this.scheme.start;
            float yPreviousLabel = -9999999.0f;
            while (depth <= baseDepth + 1.0E-6f) {
                String buffer = SB.floatString((float)SB.convFromM((float)depth, (char)this.block.prop.units, (char)this.block.getWellType()), (int)this.scheme.precision);
                ypos = this.calcPlotPosition(y, depth, cp, mode);
                x1 = left;
                x2 = left + 2.0f;
                g.drawLine(x1, ypos, x2, ypos);
                float w = g.stringWidth(buffer);
                float h = g.stringHeight();
                float xpos = x2;
                if (Math.abs(ypos - yPreviousLabel) > h) {
                    g.drawString(buffer, xpos, ypos + g.stringHeightSB() / 2.0f, this.getWidth(bp) - 2.0f, 1);
                    yPreviousLabel = ypos;
                }
                float nextDepth = depth + this.scheme.labelInterval;
                if (this.p.TD && (double)nextDepth > this.block.well.getHeader().getTD()) break;
                depth += this.scheme.tickInterval;
                while (depth < nextDepth && depth <= baseDepth) {
                    ypos = this.calcPlotPosition(y, depth, cp, mode);
                    x1 = left;
                    x2 = left + 1.0f;
                    g.drawLine(x1, ypos, x2, ypos);
                    depth += this.scheme.tickInterval;
                }
                depth = nextDepth;
            }
            g.setClip(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    String getCaption() {
        if (this.block.prop.scaleType == BlockProperties.ScaleType.TVD) {
            return "TVD";
        }
        return "Depth";
    }

    @Override
    String getSubHeader() {
        return this.block.prop.units == 'F' ? "(ft)" : "(m)";
    }

    float calcPlotPosition(float y, float value, ChartProperties cp, Chart.Mode mode) {
        if (this.block.prop.scaleType == BlockProperties.ScaleType.AGE) {
            return y + this.block.scaleDepth(value) + PanelDepth.getPanelHeaderHeight(cp, mode);
        }
        return y + PanelDepth.getPanelHeaderHeight(cp, mode) + (value - this.block.prop.min) * 1000.0f / this.block.prop.scale;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    public String toString() {
        if (this.block.prop.scaleType == BlockProperties.ScaleType.TVD) {
            return "TVD Scale";
        }
        return "Depth Scale";
    }

    public void setProperties(PanelDepthProperties p) {
        this.p = p;
    }

    @Override
    public PanelDepthProperties getProperties() {
        return this.p;
    }

    @Override
    boolean pipe() {
        return this.block.prop.scaleType != BlockProperties.ScaleType.TVD;
    }

    @Override
    public int getType() {
        return 29;
    }
}

