/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelEnvProperties;
import jsbugs.ProjectBlock;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Well;
import model2.WellInterp;
import util.SBException;

public class PanelEnv
extends SBPanel
implements Observer {
    final WellBlock block;
    private PanelEnvProperties p;
    int interpID;
    private EnvScheme scheme;
    private LinkedList<DrawEnv> drawEnvs;
    private LinkedList<DrawEnvAnalysis> drawEnvAnalys;
    private boolean[] classes = null;
    private String[] titles;
    private Color[] colours;
    private static float SMALL_HEIGHT = 1.5f;

    PanelEnv(WellBlock block, int interpID, int schID, SBdb db) throws SQLException, SBException {
        this.block = block;
        this.interpID = interpID;
        this.scheme = db.getEnvScheme(schID);
        if (this.scheme == null) {
            throw new SBException("Null scheme in PanelEnv, ID is " + schID);
        }
        this.p = new PanelEnvProperties(db);
        this.init();
    }

    PanelEnv(WellBlock block, int interpID, String props) throws SQLException, SBException {
        this.block = block;
        this.interpID = interpID;
        this.p = new PanelEnvProperties(props);
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (!(this.block instanceof ProjectBlock)) {
            this.block.well.loadInterps();
            this.block.well.getInterp(this.interpID).addObserver((Observer)this);
        }
    }

    public void setScheme(EnvScheme scheme) {
        this.scheme = scheme;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelEnv.getPanelHeaderHeight(cp, mode), (float)this.titles.length * this.p.columnWidth, bp.height + (firstOrOnly ? PanelEnv.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        try {
            g.setColor(Color.BLACK);
            float xpos = x;
            g.setStroke(0.1f);
            g.setFont(cp.font, 0, cp.fontHeader - 1.0f);
            if (this.p.drawIntervals) {
                this.drawIntervals(g, x, y + PanelEnv.getPanelHeaderHeight(cp, mode), cp, bp, mode);
            }
            float ytop = (bp == this.block.prop ? y : y + this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max)) + PanelEnv.getPanelHeaderHeight(cp, mode);
            float pad = cp.fontHeader / 2.0f;
            for (int i = 0; i < this.titles.length; ++i) {
                g.drawLine(xpos, ytop - (firstOrOnly ? pad : 0.0f), xpos, ytop + bp.height);
                if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
                    g.drawStringVertical(this.titles[i], xpos + this.p.columnWidth / 2.0f, ytop - pad * 2.0f, cp.panelSubHeaderHeight - pad * 2.0f, true, false);
                }
                xpos += this.p.columnWidth;
            }
            if (this.p.drawAnalyses) {
                this.drawAnalyses(g, x, y, cp, bp, mode);
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    @Override
    float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        if (!(this.block instanceof ProjectBlock)) {
            return 0.0f;
        }
        g.setFont(cp.font, 0, cp.fontPanel);
        g.setStroke(0.1f);
        LinkedList<String> wellNames = new LinkedList<String>();
        float ypos = y;
        Iterator wellIterator = ((ProjectBlock)this.block).getProject().getWellIterator();
        while (wellIterator.hasNext()) {
            Well well = (Well)wellIterator.next();
            try {
                float wellWidth = this.drawHorzWell(g, x, ypos, cp, bp, well);
                if (wellWidth > 0.0f) {
                    wellNames.add(well.getWellName());
                }
                ypos += wellWidth;
            }
            catch (Exception sbe) {
                this.handleException(g, x, y, cp, bp, sbe);
            }
        }
        if (!wellNames.isEmpty()) {
            float maxWidth = 0.0f;
            for (String s : wellNames) {
                float sWidth = g.stringWidth(s);
                if (!(sWidth > maxWidth)) continue;
                maxWidth = sWidth;
            }
            maxWidth += 2.0f;
            ypos = y;
            g.setColor(Color.BLACK);
            for (String s : wellNames) {
                g.fillRect(x, ypos, maxWidth, this.p.columnWidth, Color.WHITE);
                g.drawString(s, x + 1.0f, ypos + this.p.columnWidth / 2.0f + g.stringHeightSB() / 2.0f, maxWidth - 2.0f, 1);
                ypos += this.p.columnWidth;
            }
        }
        g.setStroke(0.35f);
        g.drawRect(x, y, bp.height, ypos - y);
        return ypos - y;
    }

    float drawHorzWell(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Well well) throws SBException, SQLException {
        WellInterp interp = well.getInterp(this.interpID);
        if (interp != null && interp.getLOC() != null) {
            interp.loadEnvs(well);
            if (interp.getEnvs() != null && !interp.getEnvs().isEmpty() && interp.getEnvScheme() == this.scheme) {
                for (IGDIntervalEnv env : interp.getEnvs()) {
                    float x2;
                    double topDepth = well.getDepth(env.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    double baseDepth = well.getDepth(env.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                    double topAge = interp.getLOC().getAge(topDepth, false);
                    double baseAge = interp.getLOC().getAge(baseDepth, false);
                    if (!(baseAge > (double)bp.min) || !(topAge < (double)bp.max)) continue;
                    float x1 = this.getXPos((float)topAge, bp);
                    if (x1 > (x2 = this.getXPos((float)baseAge, bp))) {
                        float temp = x1;
                        x1 = x2;
                        x2 = temp;
                    }
                    if (x1 < 0.0f) {
                        x1 = 0.0f;
                    }
                    if (x2 > bp.height) {
                        x2 = bp.height;
                    }
                    g.setColor(this.scheme.getColour(bp.ageLeftToRight ? env.getUp() : env.getLp()));
                    g.fillRect(x + x1, y, (x2 - x1) / 2.0f, this.p.columnWidth / 2.0f, g.getColor());
                    g.setColor(this.scheme.getColour(bp.ageLeftToRight ? env.getLp() : env.getUp()));
                    g.fillRect(x + x1 + (x2 - x1) / 2.0f, y, (x2 - x1) / 2.0f, this.p.columnWidth / 2.0f, g.getColor());
                    g.setColor(this.scheme.getColour(bp.ageLeftToRight ? env.getUd() : env.getLd()));
                    g.fillRect(x + x1, y + this.p.columnWidth / 2.0f, (x2 - x1) / 2.0f, this.p.columnWidth / 2.0f, g.getColor());
                    g.setColor(this.scheme.getColour(bp.ageLeftToRight ? env.getLd() : env.getUd()));
                    g.fillRect(x + x1 + (x2 - x1) / 2.0f, y + this.p.columnWidth / 2.0f, (x2 - x1) / 2.0f, this.p.columnWidth / 2.0f, g.getColor());
                }
                g.setColor(Color.BLACK);
                g.drawRect(x, y, this.block.getHeight(), this.p.columnWidth);
                return this.p.columnWidth;
            }
        }
        return 0.0f;
    }

    @Override
    String getCaption() {
        return "Palaeoenvironments : " + this.scheme.getName();
    }

    @Override
    String getSubCaption() {
        String interpTitle = null;
        if (this.interpID >= 0) {
            try {
                interpTitle = this.block.well.getInterp(this.interpID).toString();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
        return interpTitle;
    }

    private int usedClassIndex(int classNo) throws SBException {
        int nUsed = 0;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i]) {
                ++nUsed;
            }
            if (i != classNo) continue;
            return nUsed;
        }
        throw new SBException("classNo " + classNo + " not found");
    }

    private void drawAnalyses(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        g.setStroke(this.p.analyWidth);
        g.setColor(this.p.analyColour);
        for (DrawEnvAnalysis analy : this.drawEnvAnalys) {
            if (bp != this.block.prop && (analy.depth < (double)bp.min || analy.depth > (double)bp.max)) continue;
            float startPoint = x;
            int nUsed = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                if (i == analy.start) {
                    startPoint += (float)nUsed * this.p.columnWidth;
                    break;
                }
                if (!this.classes[i]) continue;
                ++nUsed;
            }
            float span = 0.0f;
            for (int i = analy.start; i <= analy.end; ++i) {
                if (!this.classes[i]) continue;
                span += 1.0f;
            }
            g.drawLine(startPoint, analy.ypos + y + PanelEnv.getPanelHeaderHeight(cp, mode), startPoint + span * this.p.columnWidth, analy.ypos + y + PanelEnv.getPanelHeaderHeight(cp, mode));
        }
    }

    private void drawIntervals(SBGraphics g, float x, float ypos, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        LinkedList<GeneralPath> paths = new LinkedList<GeneralPath>();
        GeneralPath clip = new GeneralPath();
        for (DrawEnv env : this.drawEnvs) {
            if (bp != this.block.prop && (env.baseDepth <= (double)bp.min || env.topDepth >= (double)bp.max)) continue;
            float upx = x + env.xpos[0];
            float udx = x + env.xpos[1];
            float ldx = x + env.xpos[2];
            float lpx = x + env.xpos[3];
            float uy = ypos + env.yposTop;
            float ly = ypos + env.yposBase;
            GeneralPath path = SBGraphics.createGeneralPath(upx, uy);
            SBGraphics.appendLine(path, udx, uy);
            SBGraphics.appendLine(path, ldx, ly);
            SBGraphics.appendLine(path, lpx, ly);
            path.closePath();
            paths.add(path);
            clip.append(path, false);
        }
        g.setClip(clip);
        float ytop = bp == this.block.prop ? ypos : ypos + this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max);
        float xPos = x;
        for (int i = 0; i < this.titles.length; ++i) {
            g.setColor(this.colours[i]);
            g.fillRect(xPos, ytop, this.p.columnWidth, bp.height);
            xPos += this.p.columnWidth;
        }
        g.setClip(null);
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        for (GeneralPath gp : paths) {
            g.drawShape(gp);
        }
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        System.out.println("PanelEnv setting data...");
        this.drawEnvs = new LinkedList();
        for (IGDIntervalEnv env : this.block.well.getInterp(this.interpID).getEnvs()) {
            float ly;
            if (this.scheme != null && this.scheme.getID() != env.getSchID()) continue;
            double topSampleDepth = this.block.well.getDepth(env.getTopSample(), cp.correctDepths, cp.correctCuttings);
            double baseSampleDepth = this.block.well.getDepth(env.getBaseSample(), cp.correctDepths, cp.correctCuttings);
            if (!(baseSampleDepth >= (double)this.block.getTopDepth()) || !(topSampleDepth <= (double)this.block.getBaseDepth())) continue;
            double topDepth = Math.max(topSampleDepth, (double)this.block.getTopDepth());
            double baseDepth = Math.min(baseSampleDepth, (double)this.block.getBaseDepth());
            float uy = this.block.scaleDepth((float)topDepth);
            if (Math.abs(uy - (ly = this.block.scaleDepth((float)baseDepth))) < SMALL_HEIGHT) {
                if ((float)topDepth > this.block.getTopDepth()) {
                    uy -= SMALL_HEIGHT / 2.0f;
                }
                if ((float)baseDepth < this.block.getBaseDepth()) {
                    ly += SMALL_HEIGHT / 2.0f;
                }
            }
            this.drawEnvs.add(new DrawEnv(env, topSampleDepth, baseSampleDepth, uy, ly));
        }
        if (!this.drawEnvs.isEmpty()) {
            this.scheme = this.block.db.getEnvScheme(this.drawEnvs.get((int)0).env.getSchID());
        } else if (this.scheme == null) {
            this.scheme = (EnvScheme)this.block.db.getEnvSchemes().get(0);
            if (this.scheme == null) {
                return;
            }
        }
        this.classes = new boolean[this.scheme.getNClasses()];
        if (!this.drawEnvs.isEmpty() && !this.p.drawAllClasses) {
            for (DrawEnv de : this.drawEnvs) {
                this.classes[de.env.getUp() - 1] = true;
                this.classes[de.env.getLp() - 1] = true;
                this.classes[de.env.getUd() - 1] = true;
                this.classes[de.env.getLd() - 1] = true;
            }
        } else {
            for (int i = 0; i < this.classes.length; ++i) {
                this.classes[i] = true;
            }
        }
        LinkedList<String> titlesList = new LinkedList<String>();
        LinkedList<Color> coloursList = new LinkedList<Color>();
        for (int i = 0; i < this.classes.length; ++i) {
            if (!this.classes[i]) continue;
            titlesList.add(this.scheme.getTerm(i + 1));
            coloursList.add(this.scheme.getColour(i + 1));
        }
        this.titles = titlesList.toArray(new String[titlesList.size()]);
        this.colours = coloursList.toArray(new Color[coloursList.size()]);
        for (DrawEnv env : this.drawEnvs) {
            env.xpos[0] = (float)(this.p.drawAllClasses ? env.env.getUp() : this.usedClassIndex(env.env.getUp() - 1)) * this.p.columnWidth - this.p.columnWidth;
            env.xpos[1] = (float)(this.p.drawAllClasses ? env.env.getUd() : this.usedClassIndex(env.env.getUd() - 1)) * this.p.columnWidth;
            env.xpos[2] = (float)(this.p.drawAllClasses ? env.env.getLd() : this.usedClassIndex(env.env.getLd() - 1)) * this.p.columnWidth;
            env.xpos[3] = (float)(this.p.drawAllClasses ? env.env.getLp() : this.usedClassIndex(env.env.getLp() - 1)) * this.p.columnWidth - this.p.columnWidth;
        }
        if (sections != null) {
            LinkedList<DrawEnv> modList = new LinkedList<DrawEnv>();
            boolean YPOS = false;
            boolean DDEPTH = true;
            for (int j = 1; j < sections.length; ++j) {
                if (Math.abs(sections[j - 1][1] - sections[j][1]) < 0.001) continue;
                for (int k = 0; k < this.drawEnvs.size(); ++k) {
                    DrawEnv dEnv = this.drawEnvs.get(k);
                    if (dEnv.baseDepth < sections[j - 1][1] || dEnv.topDepth > sections[j][1]) continue;
                    if (dEnv.topDepth >= sections[j - 1][1] && dEnv.baseDepth <= sections[j][1]) {
                        if (Math.abs(dEnv.topDepth - sections[j - 1][1]) < 0.01) {
                            dEnv.yposTop = (float)sections[j - 1][0];
                        }
                        if (Math.abs(dEnv.baseDepth - sections[j][1]) < 0.01) {
                            dEnv.yposBase = (float)sections[j][0];
                        }
                        modList.add(dEnv);
                        continue;
                    }
                    if (dEnv.topDepth < sections[j - 1][1] && dEnv.baseDepth > sections[j][1]) {
                        modList.add(new DrawEnv(dEnv, sections[j - 1][1], sections[j][1], (float)sections[j - 1][0], (float)sections[j][0]));
                        continue;
                    }
                    if (dEnv.baseDepth > sections[j][1]) {
                        modList.add(new DrawEnv(dEnv, dEnv.topDepth, sections[j][1], dEnv.yposTop, (float)sections[j][0]));
                        continue;
                    }
                    modList.add(new DrawEnv(dEnv, sections[j - 1][1], dEnv.baseDepth, (float)sections[j - 1][0], dEnv.yposBase));
                }
            }
            this.drawEnvs = modList;
        }
        this.drawEnvAnalys = null;
        if (this.p.drawAnalyses) {
            this.drawEnvAnalys = new LinkedList();
            for (Sample sample : this.block.well.getSamples()) {
                Integer min = null;
                Integer max = null;
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    if (this.p.suites != null && !this.p.suites.contains(smpdtl.getHeader()) || smpdtl.getHeader().getEnvSchID() <= 0 || smpdtl.getHeader().getEnvSchID() != this.scheme.getID() || smpdtl.getProximal() <= 0 || smpdtl.getDistal() <= 0) continue;
                    if (min == null || min > smpdtl.getProximal()) {
                        min = smpdtl.getProximal();
                    }
                    if (max != null && max >= smpdtl.getDistal()) continue;
                    max = smpdtl.getDistal();
                }
                if (min == null || max == null) continue;
                double depth = this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                float ypos = this.block.scaleDepth((float)depth);
                this.drawEnvAnalys.add(new DrawEnvAnalysis(depth, ypos, min - 1, max - 1));
            }
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        if (this.block instanceof ProjectBlock) {
            float width = 0.0f;
            Iterator wellIterator = ((ProjectBlock)this.block).getProject().getWellIterator();
            while (wellIterator.hasNext()) {
                Well well = (Well)wellIterator.next();
                try {
                    if (well.getInterp(this.interpID) == null || well.getInterp(this.interpID).getLOC() == null || well.getInterp(this.interpID).getEnvScheme() != this.scheme) continue;
                    width += this.p.columnWidth;
                }
                catch (SBException sbe) {
                    sbe.printStackTrace();
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
            return width;
        }
        if (this.titles == null) {
            return this.p.columnWidth;
        }
        return this.p.columnWidth * (float)this.titles.length;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.drawEnvs.isEmpty()) {
            return null;
        }
        float depth = this.block.getDepth(y, bp);
        float BRACKET = 2.5f / zoom;
        for (DrawEnv env : this.drawEnvs) {
            float basepos;
            float toppos = bp.getNormal() ? env.yposTop : env.yposBase;
            float f = basepos = bp.getNormal() ? env.yposBase : env.yposTop;
            if (!(y > toppos - BRACKET) || !(y < basepos + BRACKET) || bp != this.block.prop && ((double)depth > env.baseDepth || (double)depth < env.topDepth)) continue;
            if (env.topDepth - (double)BRACKET < (double)depth && env.topDepth + (double)BRACKET > (double)depth) {
                return "Bnd: " + env.env.getTopSample();
            }
            if (env.baseDepth - (double)BRACKET < (double)depth && env.baseDepth + (double)BRACKET > (double)depth) {
                return "Bnd: " + env.env.getBaseSample();
            }
            return env.env;
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public String toString() {
        String string = "Palaeoenvironments";
        if (this.scheme != null) {
            try {
                string = string + " : " + this.scheme + " : " + this.block.well.getInterp(this.interpID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public Sample getBoundarySample(float y, float zoom) {
        float depth = this.block.getDepth(y);
        float depthBracket = this.block.getDepth(y + 2.5f / zoom) - depth;
        for (DrawEnv env : this.drawEnvs) {
            if (Math.abs(env.topDepth - (double)depth) < (double)depthBracket) {
                return env.env.getTopSample();
            }
            if (!(Math.abs(env.baseDepth - (double)depth) < (double)depthBracket)) continue;
            return env.env.getBaseSample();
        }
        return null;
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.well.getSampleNearest((double)depth, 2.5f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public PanelEnvProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public int getIdentifier() {
        return this.interpID;
    }

    @Override
    public int getIdentifier2() {
        return this.getSchemeID();
    }

    public int getSchemeID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return -1;
    }

    public void setProperties(PanelEnvProperties p) {
        if (p == null) {
            assert (false);
            return;
        }
        this.p = p;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && (arg != null && arg instanceof IGDIntervalEnv || arg.getClass() == Integer.class && (Integer)arg == 5)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private static class DrawEnvAnalysis {
        final double depth;
        final float ypos;
        final int start;
        final int end;

        DrawEnvAnalysis(double corrDepth, float ypos, int start, int end) {
            this.depth = corrDepth;
            this.ypos = ypos;
            this.start = start;
            this.end = end;
        }
    }

    private static class DrawEnv {
        final IGDIntervalEnv env;
        final double topDepth;
        final double baseDepth;
        float yposTop;
        float yposBase;
        final float[] xpos;

        DrawEnv(IGDIntervalEnv env, double topDepth, double baseDepth, float yposTop, float yposBase) {
            this.env = env;
            this.topDepth = topDepth;
            this.baseDepth = baseDepth;
            this.yposTop = yposTop;
            this.yposBase = yposBase;
            this.xpos = new float[4];
        }

        DrawEnv(DrawEnv dEnv, double topDepth, double baseDepth, float yposTop, float yposBase) {
            this.env = dEnv.env;
            this.xpos = Arrays.copyOf(dEnv.xpos, 4);
            this.topDepth = topDepth;
            this.baseDepth = baseDepth;
            this.yposTop = yposTop;
            this.yposBase = yposBase;
        }
    }
}

