/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import jsbugs.PanelProperties;
import model2.AnalystHeader;
import model2.Lastval;
import model2.SBdb;
import util.SB;

public class PanelEnvProperties
implements PanelProperties {
    private static final String KEY = "PANENV";
    float columnWidth = 10.0f;
    boolean drawIntervals = true;
    boolean drawAllClasses = true;
    boolean drawAnalyses = false;
    float analyWidth = 1.5f;
    Color analyColour = Color.BLUE;
    List<AnalystHeader> suites = null;

    PanelEnvProperties(PanelEnvProperties rhs) {
        this.columnWidth = rhs.columnWidth;
        this.drawIntervals = rhs.drawIntervals;
        this.drawAllClasses = rhs.drawAllClasses;
        this.drawAnalyses = rhs.drawAnalyses;
        this.analyWidth = rhs.analyWidth;
        this.analyColour = rhs.analyColour;
        if (rhs.suites != null) {
            this.suites = new LinkedList<AnalystHeader>(rhs.suites);
        }
    }

    PanelEnvProperties(String prefs) {
        this.decodeProperties(prefs);
    }

    PanelEnvProperties(SBdb sbdb) {
        try {
            this.decode(sbdb);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + this.getPrefs()));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + this.analyWidth, "" + (this.drawAllClasses ? 1 : 0), "" + (this.drawAnalyses ? 1 : 0), "" + (this.drawIntervals ? 1 : 0), "" + SB.getColourString((Color)this.analyColour)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    void encodeProperties(SBdb sbdb) {
        String string = this.getPrefs();
        try {
            Lastval.putString((SBdb)sbdb, (String)KEY, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb) throws SQLException {
        String params = Lastval.getString((SBdb)sbdb, (String)KEY);
        if (params.isEmpty()) {
            return;
        }
        this.decodeProperties(params);
    }

    private void decodeProperties(String params) {
        String[] s = params.split("\\|");
        block8: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block8;
                }
                case 1: {
                    this.analyWidth = Float.parseFloat(s[i]);
                    continue block8;
                }
                case 2: {
                    this.drawAllClasses = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 3: {
                    this.drawAnalyses = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 4: {
                    this.drawIntervals = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 5: {
                    if (!s[i].contains(",")) continue block8;
                    this.analyColour = SB.getColour((String)s[i]);
                }
            }
        }
    }
}

