/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartObject;
import jsbugs.ChartObjectCompareDepth;
import jsbugs.ChartProperties;
import jsbugs.PanelEventsBase;
import jsbugs.PanelEventsProperties;
import jsbugs.SBGraphics;
import jsbugs.WellBlock;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelEvents
extends PanelEventsBase
implements Observer {
    WellBlock block;
    final int interpID;

    public PanelEvents(WellBlock block, int interpID, SBdb sbdb) throws SQLException, SBException {
        this.p = new PanelEventsProperties(sbdb, true);
        this.block = block;
        this.interpID = interpID;
        block.well.getInterp(interpID).addObserver((Observer)this);
    }

    public PanelEvents(WellBlock block, int interpID, SBdb sbdb, String props) throws SQLException, SBException {
        this.p = new PanelEventsProperties(sbdb, props);
        this.block = block;
        this.interpID = interpID;
        block.well.getInterp(interpID).addObserver((Observer)this);
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Iterator it;
        if (this.movedPositions == null) {
            System.out.println("movedPositions is null");
            return null;
        }
        float BRACKET = 2.5f / zoom;
        boolean list2 = this.separate && x > this.getWidth(bp) / 2.0f;
        int i = 0;
        Iterator iterator = it = list2 ? this.chartObjects2.iterator() : this.chartObjects.iterator();
        while (it.hasNext()) {
            float symbolSize;
            ChartObject chartObject = (ChartObject)it.next();
            float yPos = list2 ? this.movedPositions2[i] : this.movedPositions[i];
            float f = symbolSize = list2 ? this.symbolSizes2[i] : this.symbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                List list;
                if (bp != this.block.prop) {
                    try {
                        if (chartObject.getDepth() < (double)bp.min || chartObject.getDepth() > (double)bp.max) {
                            continue;
                        }
                    }
                    catch (SBException sbe) {
                        sbe.printStackTrace();
                        return null;
                    }
                }
                if ((list = (List)chartObject.o).size() == 1) {
                    return list.get(0);
                }
                float rowHeight = symbolSize / (float)list.size();
                for (int j = 0; j < list.size(); ++j) {
                    if (!(y > yPos + (float)j * rowHeight) || !(y < yPos + ((float)j + 1.0f * rowHeight))) continue;
                    return list.get(j);
                }
                return list.get(list.size() - 1);
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        String name = "Events";
        try {
            if (this.interpID >= 0) {
                name = name + " : " + this.block.well.getInterp(this.interpID);
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return name;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof WellEvent) {
            return ((WellEvent)o).toString(true, true, true, bp.units);
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && (arg instanceof WellEvent || arg.getClass() == Integer.class && (Integer)arg == 20)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        LinkedList<List> lists = new LinkedList<List>();
        lists.add(this.chartObjects);
        if (this.chartObjects2 != null) {
            lists.add(this.chartObjects2);
        }
        for (List list : lists) {
            for (ChartObject pe : list) {
                try {
                    ++nSamples;
                    Sample.insert(samples, (Sample)pe.getSample(), (char)this.block.prop.units);
                }
                catch (SBException sbe) {}
            }
        }
        return nSamples;
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        String row = "";
        for (ChartObject pe : this.chartObjects) {
            List list = (List)pe.o;
            for (WellEvent event : list) {
                if (event.getSample() != sample) continue;
                if (!row.isEmpty()) {
                    row = row + "<br>";
                }
                if (this.p.useColours) {
                    row = row + PanelEvents.getHTMLFontColour(this.p.getColor(event.getDiscipline()));
                }
                row = row + event.toString(true, true, false);
                if (!this.p.useColours) continue;
                row = row + "</font>";
            }
        }
        if (!row.isEmpty() && this.p.showDepths) {
            row = sample.toString(this.block.prop.units, false, false) + "<br>" + row;
        }
        return "<td>" + row + "</td>";
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, (bp == this.block.prop ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max)) + y + PanelEvents.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height)) {
            return x + this.getWidth(bp);
        }
        if (this.interpID < 0 || this.chartObjects == null || this.chartObjects.isEmpty() && (this.chartObjects2 == null || this.chartObjects2.isEmpty())) {
            return x + this.getWidth(bp);
        }
        g.setFont(cp.font, 0, cp.fontTiny);
        g.setStroke(0.1f);
        try {
            LinkedList compositeList = new LinkedList();
            compositeList.addAll(this.chartObjects);
            if (this.chartObjects2 != null) {
                compositeList.addAll(this.chartObjects2);
            }
            Iterator it = compositeList.iterator();
            int i1 = 0;
            int i2 = 0;
            while (it.hasNext()) {
                ChartObject chartObject = (ChartObject)it.next();
                List events = (List)chartObject.o;
                SBEvent.EventType type = ((WellEvent)events.get(0)).getTypeObj();
                if (bp != this.block.prop) {
                    if (chartObject.getDepth() < (double)bp.min) {
                        if (this.separate && type == SBEvent.EventType.BASE) {
                            ++i2;
                            continue;
                        }
                        ++i1;
                        continue;
                    }
                    if (chartObject.getDepth() > (double)bp.max) break;
                }
                this.drawEvents(g, cp, mode, x, y, this.separate && type == SBEvent.EventType.BASE ? i2 : i1, chartObject, this.block.prop.units);
                if (this.separate && type == SBEvent.EventType.BASE) {
                    ++i2;
                    continue;
                }
                ++i1;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Event plotting: " + e.getMessage());
            e.printStackTrace();
        }
        g.setColor(Color.BLACK);
        return x + this.p.panelWidth;
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        System.out.println("PanelEvents setting data...");
        this.setData(cp, this.block.prop, sections, null);
    }

    @Override
    void calcTickIndent(boolean left, ChartProperties cp, SBGraphics g) throws SQLException {
        if (!this.p.showDepths) {
            if (left) {
                this.leftTickIndent = 0.0f;
            } else {
                this.rightTickIndent = 0.0f;
            }
            return;
        }
        float f = 0.0f;
        try {
            List events = this.block.well.getInterp(this.interpID).getEventsByDepth();
            for (WellEvent event : events) {
                String strg;
                if (!this.p.plotEvent(event) || (!left || event.getTypeObj() == SBEvent.EventType.BASE) && (left || event.getTypeObj() != SBEvent.EventType.BASE) || !(f < SBGraphics.stringWidth(strg = Sample.roundSampleDepth((double)SB.convFromM((double)event.getSample().getDepth(), (char)this.block.prop.units), (String)event.getSample().getType()), cp.fontTiny))) continue;
                f = SBGraphics.stringWidth(strg, cp.fontTiny);
            }
            if (left) {
                this.leftTickIndent = f;
            } else {
                this.rightTickIndent = f;
            }
        }
        catch (SBException e) {
            SB.showStackError((String)"Error getting events: ", (Exception)((Object)e));
        }
    }

    @Override
    String getCaption() {
        return "Events";
    }

    @Override
    String getSubCaption() {
        String sc = "";
        try {
            sc = this.block.well.getInterp(this.interpID).toString();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return sc;
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    int getIdentifier() {
        return this.interpID;
    }

    @Override
    List getEvents() throws SBException {
        return this.block.well.getInterp(this.interpID).getEventsByDepth();
    }

    @Override
    void addEvents(ChartProperties cp) throws SBException, SQLException {
        LinkedList<ChartObject> compositeList = new LinkedList<ChartObject>();
        for (WellEvent event : this.block.well.getInterp(this.interpID).getEventsByDepth()) {
            double corrDepth;
            if (!this.p.plotEvent(event) || !((corrDepth = this.block.well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings)) >= (double)this.block.getTopDepth()) || !(corrDepth <= (double)this.block.getBaseDepth())) continue;
            float yPos = this.block.scaleDepth((float)corrDepth);
            ChartObject cObj = new ChartObject(event, yPos);
            if (Math.abs(corrDepth - event.getSample().getDepth()) > (double)0.0029f) {
                cObj.corrDepth = corrDepth;
            }
            compositeList.add(cObj);
        }
        Collections.sort(compositeList, new ChartObjectCompareDepth());
        class ChartObjectCompounder {
            ChartObjectCompounder() {
            }

            ChartObject createChartObject(LinkedList<ChartObject> list) {
                LinkedList<WellEvent> events = new LinkedList<WellEvent>();
                for (ChartObject wellEvent : list) {
                    events.add((WellEvent)wellEvent.o);
                }
                ChartObject listObject = new ChartObject(events, list.getLast().yPos);
                listObject.corrDepth = list.getLast().corrDepth;
                return listObject;
            }
        }
        ChartObjectCompounder compounder = new ChartObjectCompounder();
        LinkedList<ChartObject> compositeList2 = new LinkedList<ChartObject>();
        Iterator it = compositeList.iterator();
        int i1 = 0;
        int i2 = 0;
        LinkedList<ChartObject> list = null;
        while (it.hasNext()) {
            ChartObject chartObject = (ChartObject)it.next();
            WellEvent event = (WellEvent)chartObject.o;
            if (list == null) {
                list = new LinkedList<ChartObject>();
                list.add(chartObject);
            } else {
                WellEvent lastEvent = (WellEvent)((ChartObject)list.getLast()).o;
                if (event.getSample() == lastEvent.getSample() && event.getTypeObj() == lastEvent.getTypeObj()) {
                    list.add(chartObject);
                } else {
                    compositeList2.add(compounder.createChartObject(list));
                    list = new LinkedList();
                    list.add(chartObject);
                }
            }
            if (this.separate && event.getTypeObj() == SBEvent.EventType.BASE) {
                ++i2;
                continue;
            }
            ++i1;
        }
        if (list != null && !list.isEmpty()) {
            compositeList2.add(compounder.createChartObject(list));
        }
        for (ChartObject co : compositeList2) {
            if (this.separate) {
                SBEvent.EventType type = ((WellEvent)((List)co.o).get(0)).getTypeObj();
                if (type == SBEvent.EventType.BASE) {
                    this.chartObjects2.add(co);
                    continue;
                }
                this.chartObjects.add(co);
                continue;
            }
            this.chartObjects.add(co);
        }
    }

    @Override
    float gethPosition(ChartProperties cp, BlockProperties bp) {
        return this.block.scaleDepth(this.block.getTopDepth()) + cp.fontTiny / 2.0f;
    }

    @Override
    float getlPosition(ChartProperties cp, BlockProperties bp) {
        return this.block.scaleDepth(this.block.getBaseDepth()) - cp.fontTiny / 2.0f;
    }
}

