/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartObject;
import jsbugs.ChartProperties;
import jsbugs.PanelEventsProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHTML;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.Sample;
import model2.WellEvent;
import util.SB;
import util.SBException;

public abstract class PanelEventsBase
extends SBPanelHTML {
    PanelEventsProperties p;
    static final float indent = 1.0f;
    static final float arrowHeight = 0.6f;
    float leftTickIndent = 1.0f;
    float rightTickIndent = 1.0f;
    boolean separate = false;
    float[] movedPositions;
    float[] movedPositions2 = null;
    float[] symbolSizes;
    float[] symbolSizes2;
    List<ChartObject> chartObjects;
    List<ChartObject> chartObjects2;

    void drawEvents(SBGraphics g, ChartProperties cp, Chart.Mode mode, float x, float y, int i, ChartObject chartObject, char units) throws SQLException, SBException {
        float l2;
        float l1;
        List events = (List)chartObject.o;
        if (events.isEmpty()) {
            return;
        }
        SBEvent.EventType type = this.getEventType(events.get(0));
        float yPos = chartObject.yPos + y + PanelEventsBase.getPanelHeaderHeight(cp, mode);
        g.setColor(Color.BLACK);
        boolean left = this.p.singleColumn || type != SBEvent.EventType.BASE;
        boolean list2 = type == SBEvent.EventType.BASE && this.movedPositions2 != null;
        float xPos = left ? x : x + this.getWidth(null);
        float[] xP = new float[3];
        float[] yP = new float[3];
        xP[0] = xPos;
        xP[2] = left ? (xPos = xPos + 2.0f) : (xPos = xPos - 2.0f);
        xP[1] = xP[2];
        yP[0] = yPos;
        if (type == SBEvent.EventType.BASE) {
            yP[1] = yPos - 0.6f;
            yP[2] = yPos;
        } else if (type == SBEvent.EventType.TOP) {
            yP[1] = yPos + 0.6f;
            yP[2] = yPos;
        } else {
            yP[1] = yPos - 0.6f;
            yP[2] = yPos + 0.6f;
        }
        g.fillPolygon(xP, yP, 3, Color.BLACK);
        g.drawLine(xP[2], yPos, left ? (xPos = xPos + 1.0f) : (xPos = xPos - 1.0f), yPos);
        float movedPos = (list2 ? this.movedPositions2[i] : this.movedPositions[i]) + y + PanelEventsBase.getPanelHeaderHeight(cp, mode);
        float symbolSize = (float)(events.size() - 1) * cp.fontTiny + g.stringHeightSB();
        switch (type) {
            case TOP: 
            case SINGLE: {
                l1 = movedPos;
                l2 = movedPos + symbolSize;
                break;
            }
            case BASE: {
                l1 = movedPos + symbolSize;
                l2 = l1 - symbolSize;
                break;
            }
            default: {
                assert (false);
                l1 = 0.0f;
                l2 = 0.0f;
            }
        }
        g.drawLine(xPos, yPos, left ? (xPos = xPos + 1.5f) : (xPos = xPos - 1.5f), type == SBEvent.EventType.SINGLE ? movedPos + symbolSize / 2.0f : l1);
        g.drawLine(xPos, l1, xPos, l2);
        if (this.p.showDepths) {
            float depthPos = movedPos;
            switch (type) {
                case TOP: 
                case SINGLE: {
                    depthPos = movedPos + g.stringHeightSB();
                    break;
                }
                case BASE: {
                    depthPos = movedPos + symbolSize;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            String depthString = events.get(0) instanceof WellEvent ? Sample.roundSampleDepth((double)SB.convFromM((double)chartObject.getDepth(), (char)units), (String)((WellEvent)events.get(0)).getSample().getType()) : chartObject.plotName;
            if (left) {
                g.drawString(depthString, xPos += 0.5f, depthPos, x + this.p.panelWidth - xPos, 1);
                xPos += this.leftTickIndent;
            } else {
                g.drawString(depthString, xPos -= 0.5f, depthPos, xPos - x, 2);
                xPos -= this.rightTickIndent;
            }
        }
        xPos = left ? (xPos += 0.5f) : (xPos -= 0.5f);
        float yPosText = movedPos + g.stringHeightSB();
        for (Object event : events) {
            String string;
            Color colour;
            if (event instanceof WellEvent) {
                WellEvent wEvent = (WellEvent)event;
                colour = this.p.getColor(wEvent.getDiscIDTaxon());
                string = wEvent.toString(this.p.showType, true, false);
            } else {
                CompositeStandardEvent csEvent = (CompositeStandardEvent)event;
                colour = this.p.getColor(csEvent.getDisc());
                string = this.p.showType ? csEvent.toStringName() : csEvent.getName();
            }
            g.setColor(colour);
            g.drawString(string, xPos, yPosText, left ? x + this.p.panelWidth - xPos : xPos - x, left ? 1 : 2);
            yPosText += cp.fontTiny;
        }
    }

    float getEvTypeOffset(SBEvent.EventType type, float fontSize) {
        float offset;
        switch (type) {
            case TOP: {
                offset = 0.7f * fontSize;
                break;
            }
            case BASE: {
                offset = 0.05f * fontSize;
                break;
            }
            default: {
                offset = 0.3f * fontSize;
            }
        }
        return offset;
    }

    float getEvTypeOffset(ChartObject co, float fontSize, SBGraphics g) {
        List list = (List)co.o;
        SBEvent.EventType type = this.getEventType(list);
        switch (type) {
            case TOP: {
                return 0.0f;
            }
            case BASE: {
                return (float)(list.size() - 1) * fontSize + g.stringHeightSB();
            }
            case SINGLE: {
                return (float)list.size() * fontSize / 2.0f;
            }
        }
        throw new IllegalArgumentException("Unrecognised event type");
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    public PanelEventsProperties getProperties() {
        return this.p;
    }

    void setProperties(PanelEventsProperties p) {
        this.p = p;
    }

    abstract void calcTickIndent(boolean var1, ChartProperties var2, SBGraphics var3) throws SQLException;

    abstract List getEvents() throws SBException;

    abstract void addEvents(ChartProperties var1) throws SBException, SQLException;

    abstract float gethPosition(ChartProperties var1, BlockProperties var2) throws SBException;

    abstract float getlPosition(ChartProperties var1, BlockProperties var2) throws SBException;

    void setData(ChartProperties cp, BlockProperties bp, double[][] sections, final SBGraphics g) throws SQLException, SBException {
        int i;
        block27: {
            this.calcTickIndent(true, cp, g);
            if (!this.getProperties().singleColumn) {
                this.calcTickIndent(false, cp, g);
            }
            this.separate = false;
            if (!this.p.singleColumn) {
                float maxLeft = 0.0f;
                float maxRight = 0.0f;
                List events = this.getEvents();
                String strg = "";
                SBEvent.EventType type = null;
                for (Object event : events) {
                    if (event instanceof CompositeStandardEvent) {
                        CompositeStandardEvent cse = (CompositeStandardEvent)event;
                        if (!this.p.plotEvent(cse)) continue;
                        strg = this.p.showType ? cse.toStringName() : cse.getName();
                        type = cse.getType();
                    } else if (event instanceof WellEvent) {
                        WellEvent wellEvent = (WellEvent)event;
                        if (!this.p.plotEvent(wellEvent)) continue;
                        strg = wellEvent.toString(this.p.showType, true, false);
                        type = wellEvent.getTypeObj();
                    }
                    float width = SBGraphics.stringWidth(strg, cp.fontTiny);
                    if (type == SBEvent.EventType.BASE) {
                        if (width > maxRight) {
                            maxRight = width;
                        }
                    } else if (width > maxLeft) {
                        maxLeft = width;
                    }
                    if (!(maxLeft + maxRight > this.p.panelWidth)) continue;
                    break block27;
                }
                float extra = this.leftTickIndent + this.rightTickIndent + 15.0f;
                if (maxRight + maxLeft + extra < this.p.panelWidth) {
                    this.separate = true;
                }
            }
        }
        this.chartObjects = new LinkedList<ChartObject>();
        this.chartObjects2 = new LinkedList<ChartObject>();
        this.addEvents(cp);
        this.movedPositions = new float[this.chartObjects.size()];
        final float fontSize = cp.fontTiny;
        this.symbolSizes = new float[this.chartObjects.size()];
        this.symbolSizes2 = null;
        class SymbolOffsetter {
            SymbolOffsetter() {
            }

            float getOffset(ChartObject co) {
                List list = (List)co.o;
                SBEvent.EventType type = PanelEventsBase.this.getEventType(list);
                switch (type) {
                    case TOP: {
                        return 0.0f;
                    }
                    case BASE: {
                        return (float)(list.size() - 1) * fontSize + (g != null ? g.stringHeightSB() : fontSize * 0.8f);
                    }
                    case SINGLE: {
                        return (float)list.size() * fontSize / 2.0f;
                    }
                }
                throw new IllegalArgumentException("Unrecognised event type");
            }
        }
        SymbolOffsetter offsetter = new SymbolOffsetter();
        for (i = 0; i < this.chartObjects.size(); ++i) {
            this.movedPositions[i] = this.chartObjects.get((int)i).yPos - offsetter.getOffset(this.chartObjects.get(i));
            this.symbolSizes[i] = (float)((List)this.chartObjects.get((int)i).o).size() * cp.fontTiny;
        }
        if (this.chartObjects2.size() > 0) {
            Collections.sort(this.chartObjects2);
            this.movedPositions2 = new float[this.chartObjects2.size()];
            this.symbolSizes2 = new float[this.chartObjects2.size()];
            for (i = 0; i < this.chartObjects2.size(); ++i) {
                this.movedPositions2[i] = this.chartObjects2.get((int)i).yPos - offsetter.getOffset(this.chartObjects2.get(i));
                this.symbolSizes2[i] = (float)((List)this.chartObjects2.get((int)i).o).size() * cp.fontTiny;
            }
        } else {
            this.movedPositions2 = null;
        }
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int it = 0; it < 2; ++it) {
                float[] positions;
                List<ChartObject> list;
                if (it == 0) {
                    list = this.chartObjects;
                    positions = this.movedPositions;
                } else {
                    if (this.chartObjects2 == null || this.chartObjects2.isEmpty()) break;
                    list = this.chartObjects2;
                    positions = this.movedPositions2;
                }
                for (int j = 0; j < sections.length - 1; ++j) {
                    int k;
                    for (k = pos; k < list.size() && !(list.get(k).getDepth() > sections[j + 1][1]); ++k) {
                    }
                    if (k - pos > 0) {
                        float[] section = Arrays.copyOfRange(positions, pos, k);
                        float pos1 = (float)sections[j][0];
                        float pos2 = (float)sections[j + 1][0];
                        PanelEventsBase.moveSamplePositions(k - pos, section, cp.fontPanel, Math.min(pos1, pos2) + cp.fontTiny * 1.8f, Math.max(pos1, pos2) - cp.fontTiny * 1.8f);
                        System.arraycopy(section, 0, positions, pos, k - pos);
                    }
                    pos = k;
                }
            }
        } else {
            float hPosition = this.gethPosition(cp, bp);
            float lPosition = this.getlPosition(cp, bp);
            if (this.movedPositions.length > 0) {
                PanelEventsBase.moveSamplePositions(this.movedPositions.length, this.movedPositions, this.symbolSizes, hPosition, lPosition);
            }
            if (this.movedPositions2 != null) {
                PanelEventsBase.moveSamplePositions(this.movedPositions2.length, this.movedPositions2, this.symbolSizes2, hPosition, lPosition);
            }
        }
    }

    private SBEvent.EventType getEventType(Object o) {
        if (o instanceof List && !((List)o).isEmpty()) {
            o = ((List)o).get(0);
        }
        if (o instanceof CompositeStandardEvent) {
            return ((CompositeStandardEvent)o).getType();
        }
        if (o instanceof WellEvent) {
            return ((WellEvent)o).getTypeObj();
        }
        throw new IllegalArgumentException("Unrecognised object: " + o);
    }
}

