/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jsbugs.PanelProperties;
import model2.CompositeStandardEvent;
import model2.Discipline;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBEvent;
import model2.SBdb;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SBException;

public class PanelEventsProperties
implements PanelProperties {
    float panelWidth = 70.0f;
    boolean singleColumn = false;
    boolean showDepths = true;
    boolean showType = true;
    Color col_M = Color.BLACK;
    Color col_N = Color.BLUE;
    Color col_P = Color.RED;
    Color col_A = Color.GREEN;
    Color col_default = Color.LIGHT_GRAY;
    boolean useColours = false;
    boolean plotM = true;
    boolean plotN = true;
    boolean plotA = true;
    boolean plotP = true;
    boolean plotNonDes = true;
    InterpHdr filterInterp = null;
    Well filterWell = null;
    Project filterProj = null;

    PanelEventsProperties(SBdb db, boolean depth) {
        this.decode(db, depth);
    }

    PanelEventsProperties(PanelEventsProperties rhs) {
        this.panelWidth = rhs.panelWidth;
        this.singleColumn = rhs.singleColumn;
        this.showDepths = rhs.showDepths;
        this.showType = rhs.showType;
        this.useColours = rhs.useColours;
        this.col_M = rhs.col_M;
        this.col_N = rhs.col_N;
        this.col_A = rhs.col_A;
        this.col_P = rhs.col_P;
        this.col_default = rhs.col_default;
        this.plotA = rhs.plotA;
        this.plotM = rhs.plotM;
        this.plotN = rhs.plotN;
        this.plotP = rhs.plotP;
        this.filterInterp = rhs.filterInterp;
        this.filterWell = rhs.filterWell;
        this.filterProj = rhs.filterProj;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        String prefs = this.getPrefs();
        String[] props = new String[]{"" + (this.plotM ? 1 : 0), "" + (this.plotN ? 1 : 0), "" + (this.plotP ? 1 : 0), "" + (this.plotA ? 1 : 0), "" + (this.plotNonDes ? 1 : 0), "" + (this.filterInterp != null ? Integer.valueOf(this.filterInterp.getInterpID()) : ""), "" + (this.filterWell != null ? this.filterWell.getWellID() : -1), "" + (this.showType ? 1 : 0), "" + (this.filterProj != null ? this.filterProj.getID() : -1)};
        for (String prop : props) {
            prefs = prefs + prop + "|";
        }
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + prefs));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.panelWidth, "" + (this.singleColumn ? 1 : 0), "" + (this.showDepths ? 1 : 0), "" + this.col_A.getRed() + "," + this.col_A.getGreen() + "," + this.col_A.getBlue(), "" + this.col_M.getRed() + "," + this.col_M.getGreen() + "," + this.col_M.getBlue(), "" + this.col_N.getRed() + "," + this.col_N.getGreen() + "," + this.col_N.getBlue(), "" + this.col_P.getRed() + "," + this.col_P.getGreen() + "," + this.col_P.getBlue(), "" + this.col_default.getRed() + "," + this.col_default.getGreen() + "," + this.col_default.getBlue(), "" + (this.useColours ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    PanelEventsProperties(SBdb sbdb, String props) throws SBException, SQLException {
        String[] s = props.split("\\|");
        block20: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.panelWidth = Float.parseFloat(s[i]);
                    continue block20;
                }
                case 1: {
                    this.singleColumn = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 2: {
                    this.showDepths = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 3: {
                    this.col_A = PanelEventsProperties.decodeColor(new StringTokenizer(s[i], ","));
                    continue block20;
                }
                case 4: {
                    this.col_M = PanelEventsProperties.decodeColor(new StringTokenizer(s[i], ","));
                    continue block20;
                }
                case 5: {
                    this.col_N = PanelEventsProperties.decodeColor(new StringTokenizer(s[i], ","));
                    continue block20;
                }
                case 6: {
                    this.col_P = PanelEventsProperties.decodeColor(new StringTokenizer(s[i], ","));
                    continue block20;
                }
                case 7: {
                    this.col_default = PanelEventsProperties.decodeColor(new StringTokenizer(s[i], ","));
                    continue block20;
                }
                case 8: {
                    this.useColours = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 9: {
                    this.plotM = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 10: {
                    this.plotN = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 11: {
                    this.plotP = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 12: {
                    this.plotA = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 13: {
                    this.plotNonDes = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 14: {
                    int filterInterpID;
                    if (s[i].isEmpty() || (filterInterpID = Integer.parseInt(s[i])) <= -1) continue block20;
                    this.filterInterp = sbdb.getInterp(filterInterpID);
                    continue block20;
                }
                case 15: {
                    int filterWellID;
                    if (!s[i].isEmpty() && (filterWellID = Integer.parseInt(s[i])) > 0 && this.filterInterp != null) {
                        this.filterWell = sbdb.getProject(0).getWell(sbdb, filterWellID);
                        if (this.filterWell != null) {
                            WellInterp interp = this.filterWell.getInterp(this.filterInterp.getInterpID());
                            this.filterWell.loadInterp(interp);
                        }
                    }
                }
                case 16: {
                    this.showType = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 17: {
                    int filterProjID = Integer.parseInt(s[i]);
                    if (filterProjID <= 0 || this.filterInterp == null) continue block20;
                    this.filterProj = sbdb.getProject(filterProjID);
                    this.filterProj.loadWells(sbdb, null);
                    Iterator wellIterator = this.filterProj.getWellIterator();
                    while (wellIterator.hasNext()) {
                        Well well = (Well)wellIterator.next();
                        well.loadInterps();
                        WellInterp interp = well.getInterp(this.filterInterp.getInterpID());
                        well.loadInterp(interp);
                    }
                    continue block20;
                }
            }
        }
    }

    public void encode(SBdb sbdb, boolean depth) {
        String string = this.getPrefs();
        string = string + (this.showDepths ? 1 : 0) + "|";
        try {
            String key = depth ? "EVPANPROP" : "CSPANPROP";
            Lastval.putString((SBdb)sbdb, (String)key, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb, boolean depth) {
        try {
            String key = depth ? "EVPANPROP" : "CSPANPROP";
            String params = Lastval.getString((SBdb)sbdb, (String)key);
            if (params.isEmpty()) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                this.panelWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.singleColumn = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showDepths = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.col_A = PanelEventsProperties.decodeColor(new StringTokenizer(tok.nextToken(), ","));
            }
            if (tok.hasMoreTokens()) {
                this.col_M = PanelEventsProperties.decodeColor(new StringTokenizer(tok.nextToken(), ","));
            }
            if (tok.hasMoreTokens()) {
                this.col_N = PanelEventsProperties.decodeColor(new StringTokenizer(tok.nextToken(), ","));
            }
            if (tok.hasMoreTokens()) {
                this.col_P = PanelEventsProperties.decodeColor(new StringTokenizer(tok.nextToken(), ","));
            }
            if (tok.hasMoreTokens()) {
                this.col_default = PanelEventsProperties.decodeColor(new StringTokenizer(tok.nextToken(), ","));
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.useColours = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.showType = Integer.parseInt(tok.nextToken()) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Color decodeColor(StringTokenizer tok2) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (tok2.hasMoreTokens()) {
            r = Integer.parseInt(tok2.nextToken());
        }
        if (tok2.hasMoreTokens()) {
            g = Integer.parseInt(tok2.nextToken());
        }
        if (tok2.hasMoreTokens()) {
            b = Integer.parseInt(tok2.nextToken());
        }
        return new Color(r, g, b);
    }

    public Color getColor(Discipline discID) {
        if (discID == null) {
            return this.col_default;
        }
        switch (discID) {
            case MICRO: {
                return this.col_M;
            }
            case NANNO: {
                return this.col_N;
            }
            case PALY: {
                return this.col_P;
            }
            case MACRO: {
                return this.col_A;
            }
        }
        assert (false);
        return this.col_default;
    }

    boolean plotEvent(WellEvent e) throws SQLException {
        if (e.getDiscIDTaxon() == null) {
            return this.plotNonDes;
        }
        switch (e.getDiscIDTaxon()) {
            case MACRO: {
                return this.plotA;
            }
            case MICRO: {
                return this.plotM;
            }
            case NANNO: {
                return this.plotN;
            }
            case PALY: {
                return this.plotP;
            }
        }
        assert (false);
        return this.plotNonDes;
    }

    boolean plotEvent(CompositeStandardEvent cse) throws SQLException {
        return this.plotEvent(cse.getEvent(), cse.getDisc(), cse.getType());
    }

    boolean plotEvent(SBEvent e, Discipline discID, SBEvent.EventType type) {
        if (discID == null) {
            if (!this.plotNonDes) {
                return false;
            }
        } else {
            switch (discID) {
                case MICRO: {
                    if (this.plotM) break;
                    return false;
                }
                case MACRO: {
                    if (this.plotA) break;
                    return false;
                }
                case NANNO: {
                    if (this.plotN) break;
                    return false;
                }
                case PALY: {
                    if (this.plotP) break;
                    return false;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.filterInterp == null || this.filterWell == null && this.filterProj == null) {
            return true;
        }
        try {
            LinkedList<WellInterp> interps = new LinkedList<WellInterp>();
            if (this.filterWell != null) {
                interps.add(this.filterWell.getInterp(this.filterInterp.getInterpID()));
            } else if (this.filterProj != null) {
                Iterator wellIterator = this.filterProj.getWellIterator();
                while (wellIterator.hasNext()) {
                    interps.add(((Well)wellIterator.next()).getInterp(this.filterInterp.getInterpID()));
                }
            }
            for (WellInterp interp : interps) {
                for (WellEvent w : interp.getEvents()) {
                    if (w.getSbEvent().getEvID() != e.getEvID() || w.getTypeObj() != type) continue;
                    return true;
                }
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return false;
    }
}

