/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import model2.TxGroup;
import util.ColorEditor;
import util.ColorRenderer;
import util.SB;

class PanelGroupsTableModel
extends AbstractTableModel {
    private static final int COL_NAME = 0;
    private static final int COL_COLOUR = 1;
    private static String[] columnTitles = new String[]{"Group", "Colour"};
    private static int[] columnWidths = new int[]{130, 50};
    List<TxGroup> groups = new LinkedList<TxGroup>();

    PanelGroupsTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TxGroup group = this.groups.get(row);
        if (group == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return group;
            }
            case 1: {
                return group.getColour();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return TxGroup.class;
            }
            case 1: {
                return Color.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.groups.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        TxGroup group = this.groups.get(row);
        if (group == null) {
            return;
        }
        switch (col) {
            case 1: {
                try {
                    group.setColour((Color)obj);
                    group.getDatabase().commit();
                    break;
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error saving colour", sql, group.getDatabase());
                }
            }
        }
    }

    void setupTable(JTable jTableGroup) {
        TableColumnModel columnModel = jTableGroup.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(columnTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        columnModel.getColumn(1).setMaxWidth(columnWidths[1]);
        columnModel.getColumn(1).setMinWidth(columnWidths[1]);
        ColorEditor.setUpColorEditor((JTable)jTableGroup);
        SB.setTableHeaderBold((JTable)jTableGroup);
        jTableGroup.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
    }
}

