/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelIGDSchemeProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelIGDScheme
extends SBPanel {
    final SchemeBlock block;
    final IGDScheme scheme;
    private PanelIGDSchemeProperties p;
    WellInterp wellInterp = null;
    boolean refreshWidth = true;
    private float width;

    PanelIGDScheme(IGDScheme scheme, SchemeBlock block) throws SQLException {
        if (scheme == null) {
            throw new IllegalArgumentException("Attempt to construct scheme block with null scheme");
        }
        this.block = block;
        this.scheme = scheme;
        scheme.loadUnits();
        this.p = new PanelIGDSchemeProperties(scheme, block.prop.min, block.prop.max);
    }

    PanelIGDScheme(IGDScheme scheme, SchemeBlock block, String prefs) throws SQLException, SBException {
        if (scheme == null) {
            throw new IllegalArgumentException("Attempt to construct scheme block with null scheme");
        }
        this.block = block;
        this.scheme = scheme;
        scheme.loadUnits();
        this.p = new PanelIGDSchemeProperties(scheme, block.prop.min, block.prop.max, prefs);
    }

    public void setWellInterp(WellInterp wellInterp) {
        this.wellInterp = wellInterp;
    }

    public String toString() {
        String strg = "Stratigraphic Scheme";
        if (this.scheme != null) {
            strg = IGDInterval.getIGDName((int)this.scheme.getIGDType()) + " scheme";
            strg = strg + " - " + this.scheme.toString();
        }
        return strg;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return this.getUnit(x, y, bp);
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        IGDUnit unit = this.getUnit(x, y, bp);
        if (unit != null) {
            return unit.toString(true, cp.ageFormat);
        }
        return this.toString();
    }

    IGDUnit getUnit(float x, float y, BlockProperties bp) {
        if (this.scheme == null) {
            return null;
        }
        if (this.block.prop.scaleType == BlockProperties.ScaleType.AGE) {
            for (IGDUnit unit : this.scheme.getUnitsX()) {
                if (!(unit.getLage() > (double)bp.min) || !(unit.getUage() < (double)bp.max) || !this.p.plotHier[unit.getHier() - 1]) continue;
                int indent = 0;
                for (int i = 0; i < unit.getHier() - 1; ++i) {
                    if (!this.p.plotHier[i]) continue;
                    indent = (int)((float)indent + this.p.hierWidths[i]);
                }
                float xLeft = indent;
                float yTop = (float)(Math.max(unit.getUage(), (double)bp.min) - (double)bp.min) * bp.scale;
                float yBot = (float)(Math.min(unit.getLage(), (double)bp.max) - (double)bp.min) * bp.scale;
                if (!(x >= xLeft) || !(x <= xLeft + this.p.hierWidths[unit.getHier() - 1]) || !(y >= yTop) || !(y <= yBot)) continue;
                return unit;
            }
        }
        return null;
    }

    IGDScheme getScheme() {
        return this.scheme;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float lastX = x;
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                if (this.scheme != null) {
                    g.setStroke(0.1f);
                    try {
                        if (bp.scaleType != BlockProperties.ScaleType.AGE) {
                            this.p.includeMaScale = false;
                            lastX = this.drawUnitsDepth(g, x, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode), cp, bp);
                        } else {
                            lastX = this.drawUnitsAge(g, x, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode), bp, cp, true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return lastX;
                    }
                }
                this.drawSubheaders(g, x, y, cp, bp, mode);
            }
            case HEADER_ONLY: {
                g.setColor(Color.BLACK);
                float total = 0.0f;
                for (int i = 0; i < this.p.plotHier.length; ++i) {
                    if (!this.p.plotHier[i]) continue;
                    g.drawLine(x + (total += this.p.hierWidths[i]), y + PanelIGDScheme.getPanelCaptionHeight(cp, mode), x + total, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode) + (this.p.spanEmptyHiers ? 0.0f : bp.height));
                }
                if (!this.p.includeMaScale || !this.p.key) break;
                float xpos = x + this.p.getTotalWidth() + this.p.maWidth;
                g.drawLine(xpos, y + PanelIGDScheme.getPanelCaptionHeight(cp, mode), xpos, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode) + (this.p.spanEmptyHiers ? 0.0f : bp.height));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                this.drawColHeaders(g, x, y, cp, bp, mode);
            }
            case NO_HEADER: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return Math.max(lastX, x + this.width);
    }

    private float drawUnitsAge(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, boolean vertical) throws SQLException, SBException {
        float lastX = x;
        float maxW = 0.0f;
        if (!vertical) {
            maxW = this.getXPos(bp.ageLeftToRight ? bp.max : bp.min, bp);
        }
        g.setColor(Color.BLACK);
        TreeSet<Float> boundaryAges = new TreeSet<Float>();
        List wellList = null;
        if (this.wellInterp != null) {
            wellList = this.wellInterp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
        }
        Iterator it = this.scheme.getUnits().iterator();
        float totalWidth = this.p.getTotalWidth();
        while (it.hasNext()) {
            float w1;
            float h1;
            float yTop;
            float xLeft;
            IGDUnit unit = (IGDUnit)it.next();
            if (Math.abs(unit.getUage() - unit.getLage()) < 0.001 || !(unit.getLage() > (double)this.block.getMinAge()) || !(unit.getUage() < (double)this.block.getMaxAge()) || !this.p.plotHier[unit.getHier() - 1]) continue;
            int hierIndent = 0;
            for (int i = 0; i < unit.getHier() - 1; ++i) {
                if (!this.p.plotHier[i]) continue;
                hierIndent = (int)((float)hierIndent + this.p.hierWidths[i]);
            }
            if (vertical) {
                xLeft = x + (float)hierIndent;
                yTop = y + this.block.scaleValue((float)Math.max(unit.getUage(), (double)bp.min), BlockProperties.ScaleType.AGE);
                float yBot = y + this.block.scaleValue((float)Math.min(unit.getLage(), (double)bp.max), BlockProperties.ScaleType.AGE);
                h1 = yBot - yTop;
                w1 = this.p.spanEmptyHiers ? totalWidth - (float)hierIndent : this.p.hierWidths[unit.getHier() - 1];
            } else {
                float x2;
                float x1 = this.getXPos((float)unit.getUage(), bp);
                if (x1 > (x2 = this.getXPos((float)unit.getLage(), bp))) {
                    float temp = x1;
                    x1 = x2;
                    x2 = temp;
                }
                if (x1 < 0.0f) {
                    x1 = 0.0f;
                }
                if (x2 > maxW) {
                    x2 = maxW;
                }
                w1 = x2 - x1;
                xLeft = x1 + x;
                yTop = y + (float)hierIndent + (this.p.key ? this.p.keyWidth : 0.0f) + (this.p.includeMaScale ? this.p.maWidth : 0.0f);
                h1 = this.p.spanEmptyHiers ? totalWidth - (float)hierIndent : this.p.hierWidths[unit.getHier() - 1];
            }
            g.fillRect(xLeft, yTop, w1, h1, unit.getColour());
            String name = this.p.useAbrs && unit.getAbr() != null && !unit.getAbr().isEmpty() ? unit.getAbr() : unit.getName();
            float tw = this.p.hierWidths[unit.getHier() - 1];
            if (this.p.spanEmptyHiers) {
                block2: for (int h = unit.getHier() + 1; h <= this.p.getMaxHier(); ++h) {
                    if (!this.p.plotHier[h - 1]) continue;
                    for (IGDUnit comp : this.scheme.getUnitsX()) {
                        if (comp.getHier() != h || !(comp.getUage() >= unit.getUage()) || !(comp.getLage() <= unit.getLage())) continue;
                        break block2;
                    }
                    tw += this.p.hierWidths[h - 1];
                }
            }
            if (vertical && wellList != null) {
                for (IGDIntervalZone zone : wellList) {
                    if (zone.getUppZone() != unit.getUnitID() && zone.getLowZone() != unit.getUnitID()) continue;
                    float xRight = xLeft + tw;
                    float boxWid = this.p.columnWidth / 10.0f;
                    g.fillRect(xRight - boxWid - 0.15f, yTop, boxWid, h1, Color.RED);
                    break;
                }
            }
            this.drawString(g, name, xLeft, yTop, vertical ? tw : w1, vertical ? h1 : tw, cp.font, 0, cp.fontPanel);
            if (unit.getUage() >= (double)this.block.getMinAge() && unit.getUage() <= (double)this.block.getMaxAge()) {
                boundaryAges.add(new Float(unit.getUage()));
            }
            if (unit.getLage() >= (double)this.block.getMinAge() && unit.getLage() <= (double)this.block.getMaxAge()) {
                boundaryAges.add(new Float(unit.getLage()));
            }
            lastX = Math.max(lastX, xLeft + this.p.hierWidths[unit.getHier() - 1]);
        }
        g.setFont(cp.font, 0, cp.fontTiny);
        if (this.p.includeMaScale && !boundaryAges.isEmpty()) {
            it = boundaryAges.iterator();
            int i = 0;
            float[] agePosition = new float[boundaryAges.size()];
            String[] ageString = new String[boundaryAges.size()];
            while (it.hasNext()) {
                Float yAge = (Float)it.next();
                agePosition[i] = vertical ? y + (yAge.floatValue() - bp.min) * bp.scale : x + this.getXPos(yAge.floatValue(), bp);
                ageString[i] = cp.ageFormat.toAgeString((double)yAge.floatValue(), 2, false);
                ++i;
            }
            float[] movedPositions = new float[agePosition.length];
            System.arraycopy(agePosition, 0, movedPositions, 0, agePosition.length);
            float hPosition = vertical ? y + this.block.scaleValue(bp.min, BlockProperties.ScaleType.AGE) + g.stringHeightSB() : x;
            float lPosition = vertical ? y + this.block.scaleValue(bp.max, BlockProperties.ScaleType.AGE) - g.stringHeightSB() : x + maxW;
            PanelIGDScheme.moveSamplePositions(boundaryAges.size(), movedPositions, cp.fontTiny, hPosition, lPosition);
            float xLeft = lastX;
            for (int j = 0; j < agePosition.length; ++j) {
                if (vertical) {
                    g.drawLine(xLeft, agePosition[j], xLeft + 0.5f, agePosition[j]);
                    g.drawLine(xLeft + 0.5f, agePosition[j], xLeft + 1.0f, movedPositions[j]);
                    g.drawLine(xLeft + 1.0f, movedPositions[j], xLeft + 1.5f, movedPositions[j]);
                    g.drawString(ageString[j], xLeft + 1.7f, movedPositions[j] + g.stringHeightSB() / 2.0f);
                    continue;
                }
                float maBase = y + this.p.maWidth + (this.p.key ? this.p.keyWidth : 0.0f);
                g.drawLine(agePosition[j], maBase, agePosition[j], maBase - 0.5f);
                g.drawLine(agePosition[j], maBase - 0.5f, movedPositions[j], maBase - 1.0f);
                g.drawLine(movedPositions[j], maBase - 1.0f, movedPositions[j], maBase - 1.5f);
                g.drawStringVertical(ageString[j], movedPositions[j] + g.stringHeightSB() / 2.0f, maBase - 2.0f);
            }
            lastX += this.p.maWidth;
            if (!vertical && !this.p.key) {
                g.drawLine(x, y, x + maxW, y);
            }
        }
        if (this.p.key) {
            float boxWidth;
            float boxHeight;
            float xpos;
            List unitsX = this.scheme.getUnitsX();
            Comparator<IGDUnit> comparator = new Comparator<IGDUnit>(){

                @Override
                public int compare(IGDUnit o1, IGDUnit o2) {
                    if (((PanelIGDScheme)PanelIGDScheme.this).p.useAbrs) {
                        return o1.getAbr().compareTo(o2.getAbr());
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(unitsX, comparator);
            ListIterator lit = unitsX.listIterator();
            while (lit.hasNext()) {
                IGDUnit u = (IGDUnit)lit.next();
                if (!this.p.plotHier[u.getHier() - 1]) {
                    lit.remove();
                    continue;
                }
                if (!(u.getLage() < (double)bp.min) && !(u.getUage() > (double)bp.max)) continue;
                lit.remove();
            }
            float ypos = y;
            if (vertical) {
                xpos = lastX;
                boxHeight = Math.min(cp.fontPanel * 2.0f, (this.block.scaleValue(y + bp.max, BlockProperties.ScaleType.AGE) - this.block.scaleValue(y + bp.min, BlockProperties.ScaleType.AGE)) / (float)unitsX.size());
                boxWidth = this.p.keyWidth;
            } else {
                xpos = x;
                boxWidth = Math.min(cp.fontPanel * 2.0f, maxW / (float)unitsX.size());
                boxHeight = this.p.keyWidth;
            }
            for (IGDUnit unit : unitsX) {
                g.fillRect(xpos, ypos, boxWidth, boxHeight, unit.getColour());
                String s = this.p.useAbrs ? unit.getAbr() : unit.getName();
                s = s + " " + SB.roundToSignificantFigures((double)unit.getUage(), (int)4) + " - " + SB.roundToSignificantFigures((double)unit.getLage(), (int)4);
                this.drawString(g, s, xpos + 0.5f, ypos + 0.5f, boxWidth - 1.0f, boxHeight - 1.0f, cp.font, 0, cp.fontPanel);
                if (vertical) {
                    ypos += boxHeight;
                    continue;
                }
                xpos += boxWidth;
            }
        }
        return lastX;
    }

    private float drawUnitsDepth(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) throws SQLException, SBException {
        if (this.block.interp == null || this.block.interp.getLOC() == null) {
            return x;
        }
        LinkedList[] points = new LinkedList[this.p.getMaxHier()];
        double minAge = this.block.getMinAge();
        double maxAge = this.block.getMaxAge();
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (!this.p.plotHier[i]) continue;
            points[i] = new LinkedList();
        }
        for (IGDUnit unit : this.scheme.getUnits()) {
            if (!this.p.plotHier[unit.getHier() - 1]) continue;
            LinkedList list = points[unit.getHier() - 1];
            if (unit.getUage() <= minAge && unit.getLage() >= maxAge) {
                list.add(new DepthPoint(Math.min(this.block.interp.getLOC().getMaxDepth(), (double)bp.max), unit, null));
                continue;
            }
            boolean upperAge = true;
            for (double bndAge : new double[]{unit.getUage(), unit.getLage()}) {
                if (bndAge > minAge && bndAge < maxAge) {
                    Boolean ageIncreasing = null;
                    for (double depth : this.block.interp.getLOC().getDepths(bndAge)) {
                        if (depth < (double)bp.min || depth > (double)bp.max) continue;
                        ageIncreasing = ageIncreasing == null ? this.block.interp.getLOC().isAgeIncreasing(depth) : Boolean.valueOf(ageIncreasing == false);
                        DepthPoint point = null;
                        for (Object o : list) {
                            DepthPoint dp = (DepthPoint)o;
                            if (!(Math.abs(dp.depth - depth) < 1.0E-5)) continue;
                            point = dp;
                            break;
                        }
                        if (point == null) {
                            point = new DepthPoint(depth);
                            list.add(point);
                        }
                        if (upperAge) {
                            if (ageIncreasing.booleanValue()) {
                                point.setBelow(unit);
                                continue;
                            }
                            point.setAbove(unit);
                            continue;
                        }
                        if (ageIncreasing.booleanValue()) {
                            point.setAbove(unit);
                            continue;
                        }
                        point.setBelow(unit);
                    }
                }
                upperAge = !upperAge;
            }
        }
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (points[i] == null) continue;
            Collections.sort(points[i]);
        }
        g.setFontSize(cp.fontPanel);
        float xpos = x;
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            double blockMinAge;
            LinkedList list = points[i];
            if (list == null) continue;
            if (list.isEmpty()) {
                xpos += this.p.hierWidths[i];
                continue;
            }
            if (((DepthPoint)list.getLast()).below != null) {
                DepthPoint depthPoint = new DepthPoint(Math.min(this.block.interp.getLOC().getMaxDepth(), (double)bp.max), ((DepthPoint)list.getLast()).getBelow(), null);
                list.add(depthPoint);
            }
            float lastY = minAge > (blockMinAge = this.block.interp.getLOC().getAge(bp.min, true)) ? y + this.block.scaleValue((float)minAge, BlockProperties.ScaleType.AGE) : y + this.block.scaleValue(bp.min, bp.scaleType);
            DepthPoint lastPoint = null;
            for (DepthPoint point : list) {
                float ypos = this.block.scaleValue((float)point.depth, BlockProperties.ScaleType.MD) + y;
                if (point.getAbove() != null) {
                    g.fillRect(xpos, lastY, this.p.hierWidths[i], ypos - lastY, point.getAbove().getColour());
                    String name = this.p.useAbrs && point.getAbove().getAbr() != null && !point.getAbove().getAbr().isEmpty() ? point.getAbove().getAbr() : point.getAbove().getName();
                    if (lastPoint != null && lastPoint.getBelow() != null && lastPoint.getBelow() != point.getAbove()) {
                        String addition = this.p.useAbrs && lastPoint.getBelow().getAbr() != null && !lastPoint.getBelow().getAbr().isEmpty() ? lastPoint.getBelow().getAbr() : lastPoint.getBelow().getName();
                        name = addition + " - " + name;
                    }
                    this.drawString(g, name, xpos, lastY, this.p.hierWidths[i], ypos - lastY, cp.font, 0, cp.fontPanel);
                }
                lastY = ypos;
                lastPoint = point;
                g.drawLine(xpos, ypos, xpos + this.p.hierWidths[i], ypos);
            }
            xpos += this.p.hierWidths[i];
        }
        return xpos;
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        try {
            this.drawUnitsAge(g, x, y, bp, cp, false);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        return this.getWidth(bp);
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    String getCaption() {
        return this.scheme.toString();
    }

    private void drawColHeaders(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float total = 0.0f;
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (!this.p.plotHier[i]) continue;
            float xpos = x + total;
            g.setFont(cp.font, 0, cp.fontHeader);
            g.drawStringVertical(IGDIntervalZone.getHierName((int)this.scheme.getIGDType(), (int)(i + 1), (boolean)true), xpos + this.p.hierWidths[i] / 2.0f + cp.fontHeader / 2.0f, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode) - cp.fontHeader);
            total += this.p.hierWidths[i];
        }
    }

    private void drawSubheaders(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (mode == Chart.Mode.NO_HEADER) {
            return;
        }
        float fontSize = cp.fontHeader - 2.0f;
        g.setFont(cp.font, 0, fontSize);
        if (this.p.includeMaScale) {
            g.drawStringVertical("Boundary ages (Ma)", x + this.p.getTotalWidth() + this.p.maWidth / 2.0f + fontSize / 2.0f, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode) - cp.fontHeader);
        }
        if (this.p.key) {
            g.drawStringVertical("Alphabetic Key", x + this.p.getTotalWidth() + (this.p.includeMaScale ? this.p.maWidth : 0.0f) + this.p.keyWidth / 2.0f + fontSize / 2.0f, y + PanelIGDScheme.getPanelHeaderHeight(cp, mode) - cp.fontHeader);
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        if (this.refreshWidth) {
            this.width = this.calcWidth(bp);
            this.refreshWidth = false;
        }
        return this.width;
    }

    float calcWidth(BlockProperties bp) {
        this.p.calcWidth(this.block.getMinAge(), this.block.getMaxAge(), this.scheme);
        float w = this.p.getTotalWidth() + (this.p.includeMaScale ? this.p.maWidth : 0.0f) + (this.p.key ? this.p.keyWidth : 0.0f);
        if (w < 1.0f) {
            return this.p.columnWidth;
        }
        return w;
    }

    @Override
    public PanelIGDSchemeProperties getProperties() {
        return this.p;
    }

    void setProperties(PanelIGDSchemeProperties p) {
        this.p = p;
    }

    @Override
    int getIdentifier() {
        return this.scheme.getID();
    }

    @Override
    public int getType() {
        return 40;
    }

    class DepthPoint
    implements Comparable {
        double depth;
        private IGDUnit above;
        private IGDUnit below;

        DepthPoint(double depth) {
            this.depth = depth;
        }

        DepthPoint(double depth, IGDUnit above, IGDUnit below) {
            this.depth = depth;
            this.above = above;
            this.below = below;
        }

        void setAbove(IGDUnit above) throws SBException {
            this.above = above;
        }

        void setBelow(IGDUnit below) throws SBException {
            this.below = below;
        }

        IGDUnit getAbove() {
            return this.above;
        }

        IGDUnit getBelow() {
            return this.below;
        }

        public int compareTo(Object o) {
            DepthPoint comp = (DepthPoint)o;
            if (comp.depth < this.depth) {
                return 1;
            }
            if (comp.depth > this.depth) {
                return -1;
            }
            return 0;
        }
    }
}

