/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Iterator;
import jsbugs.PanelProperties;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Lastval;
import model2.SBdb;

public class PanelIGDSchemeProperties
implements PanelProperties {
    float columnWidth = 20.0f;
    boolean includeMaScale = true;
    boolean useAbrs = false;
    boolean spanEmptyHiers = true;
    boolean key = false;
    float maWidth = 10.0f;
    float keyWidth = 30.0f;
    final boolean[] plotHier;
    final float[] hierWidths;

    PanelIGDSchemeProperties(IGDScheme scheme, float minAge, float maxAge) {
        int nHier = IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true);
        this.plotHier = new boolean[nHier];
        this.hierWidths = new float[nHier];
        for (int i = 0; i < this.plotHier.length; ++i) {
            this.plotHier[i] = true;
            this.hierWidths[i] = this.columnWidth;
        }
        this.calcWidth(minAge, maxAge, scheme);
    }

    PanelIGDSchemeProperties(PanelIGDSchemeProperties rhs) {
        this.columnWidth = rhs.columnWidth;
        this.includeMaScale = rhs.includeMaScale;
        this.useAbrs = rhs.useAbrs;
        this.plotHier = new boolean[rhs.plotHier.length];
        System.arraycopy(rhs.plotHier, 0, this.plotHier, 0, this.plotHier.length);
        this.hierWidths = new float[rhs.hierWidths.length];
        System.arraycopy(rhs.hierWidths, 0, this.hierWidths, 0, this.hierWidths.length);
        this.spanEmptyHiers = rhs.spanEmptyHiers;
        this.key = rhs.key;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        String prefs = this.getPrefs();
        String hiers = "";
        for (int i = 0; i < this.plotHier.length; ++i) {
            if (!hiers.isEmpty()) {
                hiers = hiers + ",";
            }
            hiers = hiers + (this.plotHier[i] ? 1 : 0);
        }
        prefs = prefs + hiers;
        String widths = "";
        for (int i = 0; i < this.hierWidths.length; ++i) {
            if (!widths.isEmpty()) {
                widths = widths + ",";
            }
            widths = widths + new Float(this.hierWidths[i]).intValue();
        }
        prefs = prefs + "|" + widths;
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + prefs));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.includeMaScale ? 1 : 0), "" + (this.useAbrs ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    public PanelIGDSchemeProperties(IGDScheme scheme, float minAge, float maxAge, String props) {
        int j;
        int i;
        String[] s = props.split("\\|");
        String[] hiers = null;
        String[] widths = null;
        block7: for (i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block7;
                }
                case 1: {
                    this.includeMaScale = Integer.parseInt(s[i]) == 1;
                    continue block7;
                }
                case 2: {
                    this.useAbrs = Integer.parseInt(s[i]) == 1;
                    continue block7;
                }
                case 3: {
                    hiers = s[i].split(",");
                    continue block7;
                }
                case 4: {
                    widths = s[i].split(",");
                }
            }
        }
        if (hiers != null) {
            this.plotHier = new boolean[hiers.length];
            for (j = 0; j < hiers.length; ++j) {
                this.plotHier[j] = Integer.parseInt(hiers[j]) == 1;
            }
        } else {
            this.plotHier = new boolean[IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true)];
            for (i = 0; i < this.plotHier.length; ++i) {
                this.plotHier[i] = true;
            }
        }
        this.hierWidths = new float[this.plotHier.length];
        if (widths != null && widths.length == this.plotHier.length) {
            for (j = 0; j < widths.length; ++j) {
                this.hierWidths[j] = Float.parseFloat(widths[j]);
            }
        } else {
            for (j = 0; j < this.plotHier.length; ++j) {
                this.hierWidths[j] = this.columnWidth;
            }
        }
        this.calcWidth(minAge, maxAge, scheme);
    }

    final void calcWidth(float minAge, float maxAge, IGDScheme scheme) {
        int i;
        int maxHier = IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true);
        if (maxHier != this.plotHier.length) {
            throw new IllegalStateException("Scheme has changed in PanelIGDScheme");
        }
        Iterator it = scheme.getUnitsX().iterator();
        boolean[] hasUnits = new boolean[maxHier];
        for (i = 0; i < maxHier; ++i) {
            hasUnits[i] = false;
        }
        while (it.hasNext()) {
            IGDUnit unit = (IGDUnit)it.next();
            if (!(unit.getLage() > (double)minAge) || !(unit.getUage() < (double)maxAge)) continue;
            hasUnits[unit.getHier() - 1] = true;
        }
        for (i = 0; i < maxHier; ++i) {
            if (hasUnits[i]) continue;
            this.plotHier[i] = false;
        }
    }

    float getTotalWidth() {
        float total = 0.0f;
        for (int i = 0; i < this.plotHier.length; ++i) {
            if (!this.plotHier[i]) continue;
            total += this.hierWidths[i];
        }
        return total;
    }

    int getnHierPlotted() {
        int nHierPlotted = 0;
        for (int i = 0; i < this.plotHier.length; ++i) {
            if (!this.plotHier[i]) continue;
            ++nHierPlotted;
        }
        if (nHierPlotted == 0) {
            nHierPlotted = 1;
        }
        return nHierPlotted;
    }

    int getHier(int hier) {
        int retHier = 0;
        for (int i = 0; i < this.plotHier.length; ++i) {
            if (hier <= i) {
                return retHier;
            }
            if (!this.plotHier[i]) continue;
            ++retHier;
        }
        return retHier;
    }

    int getMaxHier() {
        return this.plotHier.length;
    }
}

