/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.undo.AbstractUndoableEdit;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.LithologyPattern;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.GrainSizeDepth;
import model2.GrainSizeList;
import model2.LithBase;
import model2.LithInterval;
import model2.LithQualifier;
import model2.Lithdesc;
import model2.Lithology;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;

public class PanelIntLith
extends SBPanel
implements Observer {
    private float panelWidth = 40.0f;
    private SBdb db;
    final WellBlock block;
    private LinkedList<LithBase> list = null;
    private boolean drawQualifiers = true;
    private boolean drawGrainSize = false;
    private boolean dunham = true;
    static int nDunham = 6;
    static int nWentworth = 9;
    static float[] wentValue = new float[]{0.0039f, 0.0625f, 0.125f, 0.25f, 0.5f, 1.0f, 2.0f, 4.0f, 64.0f};
    static String[] wentText = new String[]{"Clay", "Silt", "VF snd", "F snd", "M snd.", "C snd.", "VC snd.", "Gran.", "Peb.", "Cobb."};
    static float[] dunhamValue = new float[]{0.025f, 0.2f, 0.8f, 3.2f, 10.0f, 32.0f};
    static String[] dunhamText = new String[]{"Mdstn.", "Wckstn.", "Pckstn.", "Pckstn. (lean)", "Grnstn.", "Ftlstn.", "Rdstn."};

    public PanelIntLith(SBdb db, WellBlock block) {
        this.db = db;
        this.block = block;
        this.init();
    }

    private void init() {
        this.block.well.addObserver((Observer)this);
    }

    private void initLithology() {
        try {
            this.list = new LinkedList();
            this.list.addAll(this.block.well.getLithIntervals());
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float baseDepth;
        float topDepth;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelIntLith.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height)) {
            return x + this.getWidth(bp);
        }
        g.setStroke(0.2f);
        this.initLithology();
        if (this.drawGrainSize) {
            this.drawGrainSize(g, x, y, cp, mode);
        }
        if (this.drawGrainSize) {
            try {
                this.block.well.getGrainSize().load(this.db, this.block.well.getWellID());
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error loading lithology grainsize list: ", (SQLException)sql);
                sql.printStackTrace();
            }
        }
        if (bp == this.block.prop) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.min;
            baseDepth = bp.max;
        }
        PanelIntLith.drawLithology(g, x, y, cp, bp, mode, this.list, this.getPanelWidth(), this.block, this.getQualifiers(), this.drawGrainSize ? this.block.well.getGrainSize() : null, topDepth, baseDepth);
        return x + this.getWidth(bp);
    }

    @Override
    String getCaption() {
        return "Lithology";
    }

    @Override
    String getSubCaption() {
        String lithTitle = null;
        if (this.drawGrainSize) {
            lithTitle = "and Grain Size";
        }
        return lithTitle;
    }

    private void drawGrainSize(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        float yTop = y + PanelIntLith.getPanelHeaderHeight(cp, mode);
        float yBase = yTop + this.block.scaleDepth(this.block.getBaseDepth());
        float tickHeight = 5.0f;
        g.setFont("Ariel", 0, this.panelWidth < 40.0f ? cp.fontTiny : cp.fontSmall);
        g.setStroke(0.2f);
        g.drawLine(x + this.panelWidth, yTop, x + this.panelWidth, yTop - tickHeight);
        g.drawStringVertical(this.dunham ? dunhamText[0] : wentText[0], x + this.panelWidth + g.stringHeightSB() / 2.0f, yTop - tickHeight - 0.5f);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(x + this.panelWidth, yTop, x + this.panelWidth, yBase);
        for (int i = 0; i < (this.dunham ? dunhamValue.length : wentValue.length); ++i) {
            float xpos = x + this.panelWidth + (float)((Math.log10(this.dunham ? (double)dunhamValue[i] : (double)wentValue[i]) + 3.0) * (double)this.panelWidth / 5.0);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(xpos, yTop, xpos, yBase);
            g.setColor(Color.BLACK);
            g.drawLine(xpos, yTop, xpos, yTop - tickHeight);
            g.drawStringVertical(this.dunham ? dunhamText[i + 1] : wentText[i + 1], xpos + g.stringHeightSB() / 2.0f, yTop - tickHeight - 0.5f);
        }
    }

    static void drawLithology(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, List<LithBase> lithList, float columnWidth, WellBlock wellBlock, boolean qualifiers, GrainSizeList gsl, float topDepth, float baseDepth) {
        float colTop = y + PanelIntLith.getPanelHeaderHeight(cp, mode);
        for (LithBase base : lithList) {
            LithQualifier qual;
            float yTop;
            if (base instanceof LithInterval) {
                LithInterval interval = (LithInterval)base;
                if (interval.getTopDepth() > (double)baseDepth) break;
                yTop = colTop + wellBlock.scaleDepth((float)interval.getTopDepth());
                if (interval.getTopDepth() < (double)topDepth) {
                    if (interval.getBaseDepth() < (double)topDepth) continue;
                    yTop = colTop + wellBlock.scaleDepth(topDepth);
                }
                float yBase = colTop + wellBlock.scaleDepth((float)interval.getBaseDepth());
                if (interval.getBaseDepth() > (double)baseDepth) {
                    yBase = colTop + wellBlock.scaleDepth(baseDepth);
                }
                if (yTop > yBase) {
                    float temp = yTop;
                    yTop = yBase;
                    yBase = temp;
                }
                float[] xPoints = new float[]{x, x + columnWidth, x + columnWidth, x};
                float[] yPoints = new float[]{yTop, yTop, yBase, yBase};
                if (gsl != null) {
                    LinkedList<GrainSizeDepth> newDepths = new LinkedList<GrainSizeDepth>();
                    for (GrainSizeDepth GSD : gsl) {
                        if (Math.abs(interval.getTopDepth() - GSD.getDepth()) < 0.001 || Math.abs(interval.getBaseDepth() - GSD.getDepth()) < 0.001 || GSD.getDepth() > interval.getTopDepth() && GSD.getDepth() < interval.getBaseDepth()) {
                            newDepths.add(GSD);
                        }
                        if (!(GSD.getDepth() > interval.getBaseDepth())) continue;
                        break;
                    }
                    if (newDepths.size() > 1) {
                        float[] xPs = new float[newDepths.size() + 2];
                        float[] yPs = new float[newDepths.size() + 2];
                        xPs[0] = xPoints[1];
                        yPs[0] = yPoints[1];
                        for (int i = 1; i < newDepths.size() + 1; ++i) {
                            xPs[i] = x + columnWidth + (float)((Math.log10(((GrainSizeDepth)newDepths.get(i - 1)).getGrainSize()) + 3.0) * (double)columnWidth / 5.0);
                            if (xPs[i] < 0.0f) {
                                xPs[i] = xPs[0];
                            }
                            yPs[i] = y + PanelIntLith.getPanelHeaderHeight(cp, mode) + wellBlock.scaleDepth((float)((GrainSizeDepth)newDepths.get(i - 1)).getDepth());
                        }
                        xPs[newDepths.size() + 1] = xPoints[2];
                        yPs[newDepths.size() + 1] = yPoints[2];
                        g.setColor(interval.getLithology().getBackColour());
                        g.fillPolygon(xPs, yPs, xPs.length);
                        LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, false, false);
                        g.setColor(Color.BLACK);
                        g.setStroke(0.1f);
                        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                        g.drawPolyline(xPs, yPs, xPs.length, true);
                        g.drawLine(xPoints[2], yPoints[2], xPoints[3], yPoints[3]);
                        continue;
                    }
                    LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, true, false);
                    continue;
                }
                if (!g.isVisible(xPoints[0], yPoints[0], xPoints[1] - xPoints[0], yPoints[2] - yPoints[1])) continue;
                LithologyPattern.draw(interval.getLithology(), g, xPoints, yPoints, 4, false, true, false);
                continue;
            }
            if (!qualifiers || (qual = (LithQualifier)base).getTopDepth() < (double)wellBlock.getTopDepth() || qual.getTopDepth() > (double)wellBlock.getBaseDepth()) continue;
            yTop = colTop + wellBlock.scaleDepth((float)qual.getTopDepth());
            float xPos = 0.0f;
            char type = qual.getType();
            switch (type) {
                case 'A': 
                case 'Q': {
                    xPos = x + qual.getXpos() / 100.0f * columnWidth;
                    if (Math.abs(xPos - x) < qual.getLithology().getWidth()) {
                        xPos = x + qual.getLithology().getWidth() / 2.0f;
                    } else if (x + columnWidth - xPos < qual.getLithology().getWidth()) {
                        xPos = x + columnWidth - qual.getLithology().getWidth() / 2.0f;
                    }
                    LithologyPattern.draw(qual.getLithology(), g, xPos, yTop, false, false, false);
                    break;
                }
                case 'S': {
                    int alignment = qual.getAlignment();
                    float width = qual.getXpos();
                    if (width > 100.0f) {
                        width = 100.0f;
                        alignment = 76;
                    }
                    switch (alignment) {
                        case 76: {
                            xPos = x;
                            break;
                        }
                        case 82: {
                            xPos = x + columnWidth - width / 100.0f * columnWidth;
                            break;
                        }
                        case 67: {
                            xPos = x + columnWidth / 2.0f - width / 200.0f * columnWidth;
                            break;
                        }
                    }
                    width = width / 100.0f * columnWidth;
                    LithologyPattern.drawStringer(qual.getLithology(), g, xPos, yTop, width, false, false, false);
                    break;
                }
            }
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.drawGrainSize ? this.getPanelWidth() * 2.0f : this.getPanelWidth();
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        float bracket = this.block.getBracket(1.25f, zoom, depth);
        float width_bracket = 4.0f;
        try {
            LithBase base2;
            Iterator i$ = this.block.well.getLithIntervals().iterator();
            while (i$.hasNext() && !((base2 = (LithBase)i$.next()).getTopDepth() > (double)(depth + bracket))) {
                LithQualifier qual;
                if (!(base2 instanceof LithQualifier) || !(Math.abs((qual = (LithQualifier)base2).getTopDepth() - (double)depth) < (double)bracket)) continue;
                float xpos = x / this.getWidth(bp) * 100.0f;
                switch (Lithdesc.getLithType((char)qual.getType())) {
                    case ACCESSORY: 
                    case QUALIFIER: {
                        if (!(Math.abs(qual.getXpos() - xpos) < width_bracket)) break;
                        return qual;
                    }
                    case STRINGER: {
                        float lhs = 0.0f;
                        switch (qual.getAlignmentType()) {
                            case LEFT: {
                                lhs = 0.0f;
                                break;
                            }
                            case CENTRE: {
                                lhs = 50.0f - qual.getXpos() / 2.0f;
                                break;
                            }
                            case RIGHT: {
                                lhs = 100.0f - qual.getXpos();
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        if (!(xpos > lhs - width_bracket) || !(xpos < lhs + qual.getXpos() + width_bracket)) break;
                        return qual;
                    }
                }
            }
            for (LithBase base2 : this.block.well.getLithIntervals()) {
                LithInterval interval;
                if (!(base2 instanceof LithInterval) || !((double)depth > (interval = (LithInterval)base2).getTopDepth()) || !((double)depth < interval.getBaseDepth())) continue;
                return interval;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        if (depth < this.block.getTopDepth() || depth > this.block.getBaseDepth()) {
            return null;
        }
        String depthString = SB.getDepthString((double)depth, (char)this.block.prop.units, (int)1, (char)this.block.well.getType());
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj != null) {
            if (obj instanceof LithInterval) {
                LithInterval lith = (LithInterval)obj;
                float bracket = this.block.getBracket(1.25f, zoom, depth);
                if (Math.abs(lith.getTopDepth() - (double)depth) < (double)bracket) {
                    return "Bnd: " + SB.getDepthString((double)lith.getTopDepth(), (char)this.block.prop.units, (int)2, (char)this.block.well.getType());
                }
                if (Math.abs(lith.getBaseDepth() - (double)depth) < (double)bracket) {
                    return "Bnd: " + SB.getDepthString((double)lith.getBaseDepth(), (char)this.block.prop.units, (int)2, (char)this.block.well.getType());
                }
                depthString = depthString + " " + lith.toString();
                return depthString;
            }
            if (obj instanceof LithQualifier) {
                depthString = depthString + " " + obj.toString();
                return depthString;
            }
        }
        return depthString;
    }

    Double getBndDepth(float y, float zoom) {
        float depth = this.block.getDepth(y);
        for (LithBase base : this.list) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval lith = (LithInterval)base;
            float bracket = this.block.getBracket(1.25f, zoom, depth);
            if (Math.abs(lith.getTopDepth() - (double)depth) < (double)bracket) {
                return lith.getTopDepth();
            }
            if (!(Math.abs(lith.getBaseDepth() - (double)depth) < (double)bracket)) continue;
            return lith.getBaseDepth();
        }
        return null;
    }

    double getDepth(float y) {
        float depth = this.block.getDepth(y);
        if (depth > this.block.getTopDepth() && depth < this.block.getBaseDepth()) {
            return depth;
        }
        return 0.0;
    }

    public String toString() {
        return "Interpreted Lithology";
    }

    public float getPanelWidth() {
        return this.panelWidth;
    }

    public boolean getQualifiers() {
        return this.drawQualifiers;
    }

    public boolean getGrainSize() {
        return this.drawGrainSize;
    }

    public boolean isDunham() {
        return this.dunham;
    }

    public void setProperties(float panelWidth, boolean qualifiers, boolean grainSize, boolean dunham) {
        this.panelWidth = panelWidth;
        this.drawQualifiers = qualifiers;
        this.drawGrainSize = grainSize;
        this.dunham = dunham;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.block.well && (arg instanceof LithBase || arg == LithBase.class)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    AbstractUndoableEdit insertQualifier(Lithology qual, float xpos, float ypos) throws SBException, SQLException {
        assert (qual.isQual());
        double depth = this.block.getDepth(ypos);
        float x = xpos / this.getPanelWidth() * 100.0f;
        LithQualifier.Builder builder = new LithQualifier.Builder(this.db, depth, qual).xPos(x);
        SbugsCompoundEdit edit = this.block.well.addLithInterval((LithBase.Builder)builder);
        edit.doEdits();
        return edit;
    }

    boolean canInsertInterval(float ypos) {
        double depth = this.block.getDepth(ypos);
        LithInterval lastInterval = null;
        for (LithBase base : this.list) {
            if (!(base instanceof LithInterval)) continue;
            LithInterval interval = (LithInterval)base;
            if (lastInterval == null) {
                lastInterval = interval;
                continue;
            }
            if (depth > lastInterval.getBaseDepth() && depth < interval.getTopDepth()) {
                return true;
            }
            lastInterval = interval;
        }
        return false;
    }

    boolean isWithinInterval(float ypos) {
        double depth = this.block.getDepth(ypos);
        for (LithBase base : this.list) {
            LithInterval interval;
            if (!(base instanceof LithInterval) || !(depth > (interval = (LithInterval)base).getTopDepth()) || !(depth < interval.getBaseDepth())) continue;
            return true;
        }
        return false;
    }
}

