/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Intcom;
import model2.Lastval;
import model2.SBdb;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelIntcoms
extends SBPanel {
    private float panelWidth = 70.0f;
    float fontSize;
    WellBlock block;
    int interpID;
    SBdb sbdb;
    private boolean showDepths = true;
    private boolean shrinkText = false;

    public PanelIntcoms(WellBlock block, int interpID, SBdb sbdb) throws SQLException {
        this.block = block;
        this.interpID = interpID;
        this.sbdb = sbdb;
        this.decodeProperties();
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, this.getWidth(bp), y + PanelIntcoms.getPanelHeaderHeight(p, mode) + this.block.scaleDepth(bp.max))) {
            return x + this.getWidth(bp);
        }
        try {
            WellInterp interp = this.block.well.getInterp(this.interpID);
            Iterator it = interp.getIntcoms().iterator();
            float baseY = y + PanelIntcoms.getPanelHeaderHeight(p, mode);
            g.setStroke(0.2f);
            this.fontSize = p.fontTiny;
            g.setFont(p.font, 0, p.fontTiny);
            while (it.hasNext()) {
                Intcom intcom = (Intcom)it.next();
                if (intcom.getBaseDepth() < (double)this.block.getTopDepth() || intcom.getTopDepth() > (double)this.block.getBaseDepth()) continue;
                float topY = y + PanelIntcoms.getPanelHeaderHeight(p, mode) + (intcom.getTopDepth() > (double)this.block.getTopDepth() ? this.block.scaleDepth((float)intcom.getTopDepth()) : 0.0f);
                if ((double)Math.abs(topY - baseY) > 0.1) {
                    PanelZones.fillGap(g, x, baseY < 0.0f ? y + PanelIntcoms.getPanelHeaderHeight(p, mode) : baseY, x + this.panelWidth, topY);
                    g.setStroke(0.2f);
                    g.setColor(Color.BLACK);
                }
                if (!g.isVisible(x, topY, this.panelWidth, (baseY = y + PanelIntcoms.getPanelHeaderHeight(p, mode) + (intcom.getBaseDepth() > (double)this.block.getBaseDepth() ? this.block.scaleDepth(this.block.getBaseDepth()) : this.block.scaleDepth((float)intcom.getBaseDepth()))) - topY)) continue;
                g.drawLine(x, topY, x + this.panelWidth, topY);
                g.drawLine(x, baseY, x + this.panelWidth, baseY);
                this.plotComment(g, x, topY, baseY, intcom);
            }
            if ((double)Math.abs(y + PanelIntcoms.getPanelHeaderHeight(p, mode) + this.block.scaleDepth(this.block.getBaseDepth()) - baseY) > 0.1) {
                PanelZones.fillGap(g, x, baseY, x + this.panelWidth, y + PanelIntcoms.getPanelHeaderHeight(p, mode) + this.block.scaleDepth(this.block.getBaseDepth()));
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error drawing interval comments panel: ", (Exception)((Object)sbe));
        }
        return x + this.getWidth(bp);
    }

    private void plotComment(SBGraphics g, float x, float topY, float baseY, Intcom intcom) {
        float space;
        String comment = intcom.getComments();
        float pad = 1.5f;
        float width = this.panelWidth - pad * 2.5f;
        float fs = this.fontSize;
        g.setFontSize(fs);
        LinkedList<String> lines = null;
        boolean fits = false;
        float spaceRequired = 0.0f;
        float f = space = this.showDepths ? baseY - topY - pad * 2.0f - g.stringHeight() * 2.0f : baseY - topY - pad * 2.0f;
        while (!fits) {
            lines = new LinkedList<String>();
            if (g.stringWidth(comment) > width) {
                StringTokenizer tokeniser = new StringTokenizer(comment, " ");
                String text = "";
                while (tokeniser.hasMoreTokens()) {
                    boolean tokUsed = false;
                    String tok = tokeniser.nextToken();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (g.stringWidth(stringBuilder.append(text).append(tok).toString()) < width) {
                        text = text + tok + " ";
                        continue;
                    }
                    if (text.trim().isEmpty() || g.stringWidth(text.trim()) > width) {
                        if (text.trim().isEmpty()) {
                            text = tok;
                            tokUsed = true;
                        }
                        while (g.stringWidth(text) > width) {
                            int i = text.length() - 2;
                            String substring = text.substring(0, i);
                            while (g.stringWidth(substring) > width) {
                                substring = text.substring(0, --i);
                            }
                            lines.add(substring);
                            text = text.substring(i, text.length());
                        }
                    }
                    lines.add(text);
                    if (!tokUsed) {
                        text = tok + " ";
                        continue;
                    }
                    text = "";
                }
                lines.add(text);
            } else {
                lines.add(comment);
            }
            spaceRequired = g.stringHeight() * (float)lines.size();
            if (this.shrinkText && space < spaceRequired && fs > 1.0f) {
                fs -= 0.5f;
            } else {
                fits = true;
            }
            g.setFontSize(fs);
        }
        if (this.showDepths) {
            g.setFontSize(2.0f);
            g.drawString(SB.floatString((double)SB.convFromM((double)intcom.getTopDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2).trim(), x + 1.0f, topY + g.stringHeight());
            String baseString = SB.floatString((double)SB.convFromM((double)intcom.getBaseDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2);
            g.drawString(baseString, x + this.panelWidth - g.stringWidth(baseString) - 1.0f, baseY - (g.stringHeight() - g.stringHeightSB()));
        }
        g.setFontSize(fs);
        float yPos = topY + (baseY - topY) / 2.0f;
        yPos = yPos - spaceRequired / 2.0f < (this.showDepths ? topY + pad + g.stringHeight() : topY + pad) ? (this.showDepths ? topY + g.stringHeight() + pad : topY + pad) : (yPos -= spaceRequired / 2.0f);
        float yBase = this.showDepths ? baseY - pad - g.stringHeight() : baseY - pad;
        yPos += g.stringHeightSB();
        for (String line : lines) {
            if (yPos + g.stringHeight() > yBase && !((String)lines.get(lines.size() - 1)).equals(line)) {
                line = line.trim() + "...";
            }
            g.drawString(line, x, yPos, this.panelWidth, 0);
            if (!((yPos += g.stringHeight()) > yBase)) continue;
            break;
        }
    }

    public String toString() {
        String name = "Interval Comments";
        try {
            name = "Interval Comments : " + this.block.well.getInterp(this.interpID).getHeader().getDescription();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error getting Interval Comments title: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        return name;
    }

    @Override
    String getCaption() {
        return "Interval Comments";
    }

    @Override
    String getSubCaption() {
        try {
            return this.block.well.getInterp(this.interpID).getHeader().getDescription();
        }
        catch (SBException sbe) {
            return null;
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y);
        try {
            for (Intcom intcom : this.block.well.getInterp(this.interpID).getIntcoms()) {
                if (!((double)depth > intcom.getTopDepth()) || !((double)depth < intcom.getBaseDepth())) continue;
                return intcom;
            }
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error getting object from PanelIntcoms: ", (Exception)((Object)ex));
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            Intcom intcom = (Intcom)o;
            String top = SB.floatString((double)SB.convFromM((double)intcom.getTopDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2);
            String base = SB.floatString((double)SB.convFromM((double)intcom.getBaseDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2);
            return top + " - " + base;
        }
        return null;
    }

    public void setProperties(float panelWidth, boolean showDepths, boolean shrinkText) {
        this.panelWidth = panelWidth;
        this.showDepths = showDepths;
        this.shrinkText = shrinkText;
        this.encodeProperties();
    }

    public float getPanelWidth() {
        return this.panelWidth;
    }

    public boolean getShowDepths() {
        return this.showDepths;
    }

    public boolean getShrinkText() {
        return this.shrinkText;
    }

    private void encodeProperties() {
        String string = new String();
        String[] props = new String[]{"" + this.panelWidth, "" + (this.showDepths ? 1 : 0), "" + (this.shrinkText ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"PANINTCOM", (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decodeProperties() throws SQLException {
        String params = Lastval.getString((SBdb)this.sbdb, (String)"PANINTCOM");
        if (params.isEmpty()) {
            System.out.println("params is empty: " + params);
            return;
        }
        StringTokenizer tok = new StringTokenizer(params, "|");
        if (tok.hasMoreTokens()) {
            this.panelWidth = Float.parseFloat(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            try {
                this.showDepths = Integer.parseInt(tok.nextToken()) == 1;
            }
            catch (Exception e) {
                this.showDepths = true;
            }
        }
        if (tok.hasMoreTokens()) {
            try {
                this.shrinkText = Integer.parseInt(tok.nextToken()) == 1;
            }
            catch (Exception e) {
                this.shrinkText = false;
            }
        }
    }
}

