/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import jsbugs.BlockProperties;
import jsbugs.ChartProperties;
import jsbugs.PanelProperties;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHdr;
import model2.IGDIntervalZone;

public class PanelKey
extends SBPanelHdr {
    private float height = 50.0f;
    private float colWidth = 30.0f;
    private boolean drawBndKey = true;

    @Override
    float draw(SBGraphics g, float x, float y, float width, ChartProperties cp, BlockProperties bp) {
        float ypos = 0.0f;
        float xpos = x;
        if (this.drawBndKey) {
            if (this.height - ypos < this.getBndKeyHeight(cp)) {
                xpos += this.colWidth;
            }
            this.drawBndKey(g, xpos, y + ypos, cp);
        }
        g.setStroke(0.35f);
        g.drawRect(x, y, width, this.height);
        return this.height;
    }

    @Override
    float getHeight() {
        return this.height;
    }

    public String toString() {
        return "Chart Key";
    }

    private void drawBndKey(SBGraphics g, float xpos, float ypos, ChartProperties cp) {
        float pad = 1.5f;
        float fontSize = cp.fontPanel;
        g.setFont(cp.font, 1, fontSize);
        float bndWidth = 12.0f;
        g.drawString("Boundary Type Key", xpos + 1.5f, ypos += fontSize);
        g.setFont(cp.font, 0, fontSize);
        for (int i = 1; i < 9; ++i) {
            PanelZones.drawBoundary(i, xpos + 1.5f, xpos + bndWidth + 1.5f, ypos += fontSize, g, PanelZones.bndStroke);
            g.drawString(IGDIntervalZone.getBoundary((int)i), xpos + bndWidth + 2.0f, ypos);
        }
    }

    private float getBndKeyHeight(ChartProperties cp) {
        return cp.fontPanel * 8.0f;
    }

    @Override
    public PanelProperties getProperties() {
        return null;
    }

    @Override
    public int getType() {
        return 0;
    }
}

