/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelSequencesProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Markers;
import model2.SBdb;
import model2.SeismicMarker;
import util.SB;

public class PanelMarkers
extends SBPanel {
    WellBlock block;
    SBdb sbdb;
    float width = 30.0f;

    public PanelMarkers(WellBlock block, SBdb sbdb) {
        this.block = block;
        this.sbdb = sbdb;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, this.getWidth(bp), bp.height + PanelMarkers.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        g.setClip(x, y + PanelMarkers.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.prop), this.block.getHeight());
        try {
            Markers markers = this.block.well.getMarkers();
            g.setStroke(PanelSequencesProperties.bndStroke * 2.0f);
            g.setFont(cp.font, 0, cp.fontSmall);
            for (SeismicMarker m : markers.getList()) {
                if (m.getDepth() < (double)this.block.getTopDepth() || m.getDepth() > (double)this.block.getBaseDepth()) continue;
                float yPos = this.block.scaleDepth((float)m.getDepth()) + y + PanelMarkers.getPanelHeaderHeight(cp, mode);
                g.setColor(m.getColour());
                g.drawLine(x, yPos, x + this.width, yPos);
                g.setColor(Color.BLACK);
                g.drawString(m.getName(), x + this.width - 1.0f, yPos - 1.0f, this.width, 2);
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        g.setClip(null);
        return x + this.width;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.width;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float b = 4.0f / zoom;
        float depth = this.block.getDepth(y);
        try {
            Markers markers = this.block.well.getMarkers();
            for (SeismicMarker m : markers.getList()) {
                if (!(m.getDepth() > (double)(depth - b)) || !(m.getDepth() < (double)(depth + b))) continue;
                return m;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof SeismicMarker) {
            SeismicMarker m = (SeismicMarker)o;
            return m.toString() + " (" + SB.getDepthString((double)m.getDepth(), (char)this.block.prop.units, (int)2) + ")";
        }
        return null;
    }

    public String toString() {
        return "Seismic Markers";
    }

    @Override
    String getCaption() {
        return "Markers";
    }
}

