/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.LocationBlock;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import model2.Project;
import model2.TVDList;
import model2.TVDepth;
import model2.Well;
import model2.WellHeader;
import util.SB;

public class PanelProjectLocation
extends SBPanel {
    Project project;
    static final int INNERMARGIN = 40;
    List<Well> wells = new LinkedList<Well>();
    private int wellIndex = -1;
    LocationBlock block;
    float spudX;
    float spudY;
    float width = 0.0f;
    float height = 0.0f;
    float keyWidth = 400.0f;
    static int fontStyle = 0;
    char units = (char)77;
    boolean noOffsets = false;

    PanelProjectLocation(Project project, int wellIndex, LocationBlock block) {
        this.project = project;
        this.wellIndex = wellIndex;
        this.block = block;
        this.init();
    }

    public void setWellIndex(int index) {
        this.wellIndex = index;
        this.createWellList();
    }

    public int getWellIndex() {
        return this.wellIndex;
    }

    public void setUnits(char units) {
        this.units = units;
    }

    public char getUnits() {
        return this.units;
    }

    private void init() {
        this.createWellList();
        this.setOffsets();
    }

    private void setOffsets() {
        double maxE = 0.0;
        double minE = 0.0;
        double maxN = 0.0;
        double minN = 0.0;
        try {
            for (Well well : this.wells) {
                TVDList tvdList = well.getTVDlist(false);
                Iterator it = tvdList.getIterator();
                while (it.hasNext()) {
                    TVDepth tvdepth = (TVDepth)it.next();
                    if (tvdepth.getEast() != null) {
                        double east = tvdepth.getEast();
                        if (east < minE) {
                            minE = east;
                        }
                        if (east > maxE) {
                            maxE = east;
                        }
                    }
                    if (tvdepth.getNorth() == null) continue;
                    double north = tvdepth.getNorth();
                    if (north < minN) {
                        minN = north;
                    }
                    if (!(north > maxN)) continue;
                    maxN = north;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        System.out.println("maxE = " + maxE);
        System.out.println("minE = " + minE);
        System.out.println("maxN = " + maxN);
        System.out.println("minN = " + minN);
        if (maxE == 0.0 && minE == 0.0 && maxN == 0.0 && minN == 0.0) {
            this.noOffsets = true;
        }
        this.width = (float)maxE + (float)Math.abs(minE) + this.keyWidth + 80.0f;
        System.out.println("width: " + this.width);
        this.height = (float)maxN + (float)Math.abs(minN) + 240.0f;
        System.out.println("height: " + this.height);
        this.spudX = (float)Math.abs(minE) + 40.0f;
        System.out.println("spudX: " + this.spudX);
        this.spudY = (float)Math.abs(maxN) + 40.0f;
        System.out.println("spudY: " + this.spudY);
    }

    private void createWellList() {
        System.out.println("creating well list... wellIndex is " + this.wellIndex);
        this.wells.clear();
        if (this.project != null) {
            WellHeader hdr = this.project.getWellAt(this.wellIndex >= 0 ? this.wellIndex : 0).getHeader();
            System.out.println("Well: " + this.project.getWellAt(this.wellIndex));
            double latdec = hdr.getLat_dec() == null ? 0.0 : hdr.getLat_dec();
            double longdec = hdr.getLong_dec() == null ? 0.0 : hdr.getLong_dec();
            double gridx = hdr.getGridX();
            double gridy = hdr.getGridY();
            Iterator it = this.project.getWellIterator();
            try {
                while (it.hasNext()) {
                    Well well = (Well)it.next();
                    System.out.println("Comparing well: " + well);
                    double wellLatDec = well.getHeader().getLat_dec() != null ? well.getHeader().getLat_dec() : 0.0;
                    double d = well.getHeader().getLong_dec() != null ? well.getHeader().getLong_dec() : 0.0;
                    double wellLongDec = d;
                    if (!(Math.abs(Math.abs(wellLongDec) - Math.abs(longdec)) < 0.01) || !(wellLongDec > 0.0 && longdec > 0.0 || wellLongDec < 0.0 && longdec < 0.0) && (wellLongDec != 0.0 || longdec != 0.0) || !(Math.abs(Math.abs(wellLatDec) - Math.abs(latdec)) < 0.01) || !(wellLatDec > 0.0 && latdec > 0.0 || wellLatDec < 0.0 && latdec < 0.0) && (wellLatDec != 0.0 || latdec != 0.0)) continue;
                    if (well.getTVDlist(false) != null && !well.getTVDlist(false).getList().isEmpty()) {
                        this.wells.add(well);
                        System.out.println("adding well: " + well);
                        continue;
                    }
                    System.out.println("Well " + well + " had null or empty TVDList");
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
        if (this.wells.isEmpty()) {
            System.out.println("No wells added to wells list.");
        }
    }

    private void drawWells(SBGraphics g, float x, float y, ChartProperties cp) {
        try {
            float imageLocX = x + this.block.scale(this.spudX);
            float imageLocY = y + this.block.scale(this.spudY);
            float keyY = y + cp.fontPanel + 5.0f;
            Color colour = Color.BLACK;
            int colourInc = 0x1000000 / (this.project.getSize() + 4);
            for (Well well : this.wells) {
                g.setStroke(2.0f);
                g.setColor(colour);
                colour = new Color(colour.getRGB() + colourInc);
                TVDList tvdList = well.getTVDlist(false);
                if (tvdList == null) {
                    System.out.println(well + " had a null TVDList - should not have been added to well list!");
                    continue;
                }
                Iterator it = tvdList.getIterator();
                float lasteast = this.spudX;
                float lastnorth = this.spudY;
                while (it.hasNext()) {
                    TVDepth tvd = (TVDepth)it.next();
                    Double east = tvd.getEast();
                    Double north = tvd.getNorth();
                    if (east == null || north == null) continue;
                    float ePos = east.floatValue() + this.spudX;
                    float nPos = north.floatValue();
                    nPos = nPos > 0.0f ? (nPos *= -1.0f) : Math.abs(nPos);
                    g.drawLine(x + this.block.scale(lasteast), y + this.block.scale(lastnorth), x + this.block.scale(ePos), y + this.block.scale(nPos += this.spudY));
                    lasteast = ePos;
                    lastnorth = nPos;
                }
                g.setFont(cp.font, fontStyle, cp.fontPanel);
                g.drawString("" + well.getWellName(), x + this.block.scale(this.width) - this.block.scale(this.keyWidth) + 5.0f, keyY);
                keyY += cp.fontPanel + 4.0f;
            }
            g.setColor(Color.red);
            g.setStroke(1.0f);
            g.drawLine(x + this.block.scale(this.spudX) - 3.5f, y + this.block.scale(this.spudY), x + this.block.scale(this.spudX) + 3.5f, y + this.block.scale(this.spudY));
            g.drawLine(x + this.block.scale(this.spudX), y + this.block.scale(this.spudY) - 3.5f, x + this.block.scale(this.spudX), y + this.block.scale(this.spudY) + 3.5f);
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    void drawScaleBar(SBGraphics g, float x, float y, ChartProperties cp) {
        float offset = this.block.scale(100.0f);
        float yPos = y + this.block.getHeight() - offset * 1.3f;
        float xPos = x + offset;
        float incr = this.units == 'M' ? 100.0f : SB.convToM((float)200.0f, (char)'F');
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        boolean fill = false;
        for (int i = 0; i < 5; ++i) {
            if (fill) {
                g.fillRect(xPos, yPos, this.block.scale(incr), this.block.scale(incr / 5.0f), Color.BLACK);
            } else {
                g.drawRect(xPos, yPos, this.block.scale(incr), this.block.scale(incr / 5.0f));
            }
            xPos += this.block.scale(incr);
            fill = !fill;
        }
        g.setFont(cp.font, fontStyle, cp.fontPanel);
        String string = "1:" + (int)this.block.scale;
        g.drawStringAngleCentre(string, x + offset + (xPos - (x + offset)) / 2.0f, yPos - g.stringHeight() / 2.0f, 0.0, 0.0, 0.0);
        g.drawStringAngleCentre("0", x + offset, yPos + this.block.scale(incr / 4.0f) + g.stringHeight(), 0.0, 0.0, 0.0);
        g.drawStringAngleCentre((this.units == 'M' ? "500" : "1000") + (this.units == 'M' ? "m" : "ft"), xPos, yPos + this.block.scale(incr / 4.0f) + g.stringHeight(), 0.0, 0.0, 0.0);
    }

    void drawNorthArrow(SBGraphics g, float x, float y) {
        float offset = this.block.scale(120.0f);
        g.setStroke(0.3f);
        Line2D.Float line = new Line2D.Float(x + offset, y + offset, x + offset, y + offset * 2.5f);
        g.drawLine(line);
        g.drawStringAngleCentre("N", x + offset, y + offset - g.stringHeight() / 1.8f, 0.0, 0.0, 0.0);
        g.drawLine(line.x2 - offset / 6.0f, line.y2 - offset / 4.0f, line.x2 + offset / 6.0f, line.y2 - offset / 4.0f);
        g.drawLine(line.x1 - offset / 6.0f, line.y1 + offset / 2.0f, line.x1, line.y1);
        g.drawLine(line.x1 + offset / 6.0f, line.y1 + offset / 2.0f, line.x1, line.y1);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        g.setFont(p.font, fontStyle, p.fontPanel);
        String location = this.getCaption();
        float stringWidth = g.stringWidth(location);
        if (stringWidth >= this.block.scale(this.width)) {
            System.out.println("increasing width");
            this.width = this.unscale(stringWidth + 50.0f);
        }
        g.drawRect(x, y, this.block.scale(this.width), p.getPanelHeaderHeight());
        g.drawStringAngleCentre(location, x + this.block.scale(this.width) / 2.0f, y + p.getPanelHeaderHeight() / 2.0f + g.stringHeight() + 1.0f, 0.0, 0.0, 0.0);
        g.setFont(p.font, fontStyle, p.fontHeader);
        g.drawStringAngleCentre("Project Location Map: " + this.project.getName(), x + this.block.scale(this.width) / 2.0f, y + p.getPanelHeaderHeight() / 2.0f, 0.0, 0.0, 0.0);
        if (!this.noOffsets) {
            g.drawRect(x, y + p.getPanelHeaderHeight(), this.block.scale(this.width) - this.block.scale(this.keyWidth), this.block.scale(this.height));
            g.drawRect(x + (this.block.scale(this.width) - this.block.scale(this.keyWidth)), y + p.getPanelHeaderHeight(), this.block.scale(this.keyWidth), this.block.scale(this.height));
            this.drawScaleBar(g, x, y + p.getPanelHeaderHeight(), p);
            this.drawNorthArrow(g, x, y + p.getPanelHeaderHeight());
            this.drawWells(g, x, y + p.getPanelHeaderHeight(), p);
        } else {
            g.setFont(p.font, fontStyle, p.fontPanel);
            g.drawString("No northings / eastings found in deviation surveys.", x, y + p.getPanelHeaderHeight() + g.stringHeight() * 1.5f);
        }
        float xpos = this.block.scale(this.width);
        return xpos;
    }

    @Override
    String getCaption() {
        WellHeader hdr = !this.wells.isEmpty() ? this.wells.get(0).getHeader() : this.project.getWellAt(this.wellIndex).getHeader();
        return "Spud - Lat: " + hdr.getLat_deg() + "d " + hdr.getLat_min() + "m " + hdr.getLat_sec() + "s " + hdr.getLat_ind() + " Long: " + hdr.getLong_deg() + "d " + hdr.getLong_min() + "m " + hdr.getLong_sec() + "s " + hdr.getLong_ind();
    }

    private float unscale(float f) {
        return f * this.block.scale / 1000.0f;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.width;
    }

    float getHeight(BlockProperties bp) {
        return this.height;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (x < this.block.scale(this.width) - this.block.scale(this.keyWidth)) {
            float east;
            String strg = "";
            float unscaledX = this.unscale(x);
            float unscaledY = this.unscale(y);
            if (unscaledX < this.spudX) {
                east = Math.abs(this.spudX) - unscaledX;
                east *= -1.0f;
            } else {
                east = unscaledX - Math.abs(this.spudX);
            }
            float north = unscaledY > Math.abs(this.spudY) ? (unscaledY - this.spudY) * -1.0f : Math.abs(this.spudY) - unscaledY;
            String ddepth = this.calcDDepth(east, north, zoom);
            strg = strg + (this.units == 'M' ? SB.floatString((float)Math.abs(north), (int)1) : SB.floatString((double)SB.convFromM((double)Math.abs(north), (char)this.units), (int)1));
            strg = strg + (north > 0.0f ? (this.units == 'M' ? " m" : " ft") + " N" : (this.units == 'M' ? " m" : " ft") + " S");
            strg = strg + ", ";
            strg = strg + (this.units == 'M' ? SB.floatString((float)Math.abs(east), (int)1) : SB.floatString((double)SB.convFromM((double)Math.abs(east), (char)this.units), (int)1));
            strg = strg + (east > 0.0f ? (this.units == 'M' ? " m" : " ft") + " E" : (this.units == 'M' ? " m" : " ft") + " W");
            if (!ddepth.isEmpty()) {
                strg = strg + ", " + ddepth;
            }
            return strg;
        }
        return "";
    }

    boolean compareNE(float east1, float east2, float north1, float north2, float bracket) {
        return Math.abs(Math.abs(east1) - Math.abs(east2)) < bracket && (east1 > 0.0f && east2 > 0.0f || east1 < 0.0f && east2 < 0.0f || east1 == 0.0f && east2 == 0.0f) && Math.abs(Math.abs(north1) - Math.abs(north2)) < bracket && (north1 > 0.0f && north2 > 0.0f || north1 < 0.0f && north2 < 0.0f || north1 == 0.0f && north2 == 0.0f);
    }

    String calcDDepth(float east, float north, float zoom) {
        String string = "";
        float bracket = 10.0f / zoom;
        if (this.wells.isEmpty()) {
            return string;
        }
        try {
            for (Well well : this.wells) {
                TVDList list = well.getTVDlist(false);
                if (list == null) continue;
                Iterator it = list.getIterator();
                while (it.hasNext()) {
                    TVDepth tvdepth = (TVDepth)it.next();
                    Double tvdN = tvdepth.getNorth();
                    Double tvdE = tvdepth.getEast();
                    if (tvdN == null || tvdE == null || !this.compareNE(tvdE.floatValue(), east, tvdN.floatValue(), north, bracket)) continue;
                    double ddepth = tvdepth.getDDepth();
                    if (this.units == 'F') {
                        ddepth = SB.convFromM((double)ddepth, (char)this.units);
                    }
                    string = string + well.getWellName() + " DD: " + ddepth + (this.units == 'M' ? "m" : "ft");
                    return string;
                }
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return string;
    }
}

