/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelRangeProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.ImageSet;
import model2.LOC;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelRange
extends SBPanel
implements Observer {
    private static final float BRACKET = 1.0f;
    private float EV_WIDTH = 7.5f;
    private float imgMargin = 0.75f;
    private SBdb sbdb;
    private final SchemeBlock block;
    private PanelRangeProperties p;
    private float panelWidth = 0.0f;
    private LinkedList<EventRange> events = null;
    private LinkedList<GroupRange> groupRanges = null;
    private LinkedList<SBPanel.ChartImage> images = null;

    public PanelRange(SBdb sbdb, SchemeBlock block) {
        this.sbdb = sbdb;
        this.block = block;
        this.setProperties(new PanelRangeProperties(sbdb, block));
    }

    public PanelRange(SBdb sbdb, SchemeBlock block, String prefs) throws SQLException, SBException {
        this.sbdb = sbdb;
        this.block = block;
        this.setProperties(new PanelRangeProperties(sbdb, prefs));
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.p.std == null) {
            return this.panelWidth;
        }
        if (this.events == null) {
            this.createEventList(bp);
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                this.drawSchemeShading(g, x, y, bp, cp, mode);
                if (this.p.showGroupOutlines && this.p.groupGroups) {
                    this.drawGroupOutlines(g, x, y, bp, cp, mode);
                }
                try {
                    this.drawProject(g, x, y, bp, cp, mode);
                    break;
                }
                catch (SQLException sql) {
                    this.handleException(g, x, y, cp, bp, sql);
                }
            }
        }
        float imageYpos = 0.0f;
        for (int i = 0; i < this.events.size(); ++i) {
            float f;
            if (i > 0) {
                g.setStroke(0.1f);
                g.setColor(Color.LIGHT_GRAY);
                float ypos = this.p.set != null ? y + PanelRange.getPanelHeaderHeight(cp, mode) : y + PanelRange.getPanelHeaderHeight(cp, mode) - cp.fontSmall * 2.0f;
                g.drawLine(x + (float)i * this.EV_WIDTH, ypos, x + (float)i * this.EV_WIDTH, this.block.scaleAge(bp.max) + y + PanelRange.getPanelHeaderHeight(cp, mode));
            }
            float f2 = this.drawEvent(g, x + (float)i * this.EV_WIDTH, y, this.events.get(i), cp, bp, mode);
            if (!(f > imageYpos)) continue;
            imageYpos = f2;
        }
        if (this.p.groupGroups) {
            this.drawGroupNames(g, x, y, bp, cp, mode);
        }
        if (this.p.showImages && mode != Chart.Mode.NO_HEADER) {
            this.drawImages(g, x, y, imageYpos, cp, mode);
        }
        return x + this.getWidth(bp);
    }

    @Override
    String getCaption() {
        return "Stratigraphic Range Chart";
    }

    @Override
    String getSubCaption() {
        return "Composite: " + this.p.std.getName() + (this.p.set != null ? ", Group Set: " + this.p.set.getName() : "") + (this.p.project != null ? ", Project: " + this.p.project.getName() : "");
    }

    private float drawEvent(SBGraphics g, float xpos, float y, EventRange eventRange, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        g.setColor(Color.BLACK);
        float c = xpos + this.EV_WIDTH / 2.0f;
        float imagePos = 0.0f;
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                g.setStroke(0.1f);
                float yPos = y + cp.panelCaptionHeight;
                float boxHeight = Math.min(this.EV_WIDTH, 7.5f);
                if (this.p.set != null && eventRange.event.getTaxon() != null) {
                    try {
                        for (TxGroup group : this.p.set.getGroups()) {
                            if (!group.isMember(eventRange.event.getTaxon().getSpecID())) continue;
                            if (this.p.groupGroups) {
                                g.setColor(group.getColour());
                                g.fillRect(xpos, yPos, this.EV_WIDTH, boxHeight);
                                g.setColor(Color.BLACK);
                            } else {
                                g.fillRect(xpos, yPos, this.EV_WIDTH, boxHeight, group.getColour());
                            }
                            yPos += boxHeight;
                        }
                    }
                    catch (SQLException sqle) {
                        this.handleException(g, xpos, y, cp, bp, sqle);
                    }
                }
                imagePos = yPos;
                g.setFont(cp.font, 0, cp.fontSmall);
                g.drawStringVertical(eventRange.event.toString(), c, y + PanelRange.getPanelHeaderHeight(cp, mode) - 2.0f, cp.panelSubHeaderHeight - cp.fontSmall * 1.5f, true, false);
            }
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                g.setStroke(1.0f);
                float barWidth = this.EV_WIDTH / 3.0f;
                Float minPos = null;
                Float maxPos = null;
                if (eventRange.minAge != null) {
                    if ((float)this.p.std.getAge(eventRange.minAge.getCSU()) >= bp.min && (float)this.p.std.getAge(eventRange.minAge.getCSU()) <= bp.max) {
                        minPos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.minAge.getCSU())) + y + PanelRange.getPanelHeaderHeight(cp, mode));
                        g.drawLine(c - barWidth / 2.0f, minPos.floatValue(), c + barWidth / 2.0f, minPos.floatValue());
                        g.drawLine(c, minPos.floatValue(), c, minPos.floatValue() + barWidth / 2.0f);
                    } else if (this.p.std.getAge(eventRange.minAge.getCSU()) < (double)bp.min) {
                        minPos = Float.valueOf(y + PanelRange.getPanelHeaderHeight(cp, mode));
                    }
                }
                if (eventRange.maxAge != null) {
                    if ((float)this.p.std.getAge(eventRange.maxAge.getCSU()) >= bp.min && (float)this.p.std.getAge(eventRange.maxAge.getCSU()) <= bp.max) {
                        maxPos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.maxAge.getCSU())) + y + PanelRange.getPanelHeaderHeight(cp, mode));
                        g.drawLine(c - barWidth / 2.0f, maxPos.floatValue(), c + barWidth / 2.0f, maxPos.floatValue());
                        g.drawLine(c, maxPos.floatValue(), c, maxPos.floatValue() - barWidth / 2.0f);
                    } else if (this.p.std.getAge(eventRange.maxAge.getCSU()) > (double)bp.max) {
                        maxPos = Float.valueOf(this.block.scaleAge(bp.max) + y + PanelRange.getPanelHeaderHeight(cp, mode));
                    }
                }
                if (minPos != null && maxPos != null) {
                    g.drawLine(c, minPos.floatValue(), c, maxPos.floatValue());
                }
                if (eventRange.singleAge == null) break;
                Float singlePos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.singleAge.getCSU())) + y + PanelRange.getPanelHeaderHeight(cp, mode));
                g.drawLine(c - barWidth / 2.0f, singlePos.floatValue(), c + barWidth / 2.0f, singlePos.floatValue());
            }
        }
        return imagePos;
    }

    private void drawImages(SBGraphics g, float x, float y, float yTopImg, ChartProperties cp, Chart.Mode mode) {
        float lastX1 = 0.0f;
        float lastX2 = 0.0f;
        float imgWidth = (this.EV_WIDTH - this.imgMargin) * 2.0f;
        float imgX = 0.0f;
        float imgY = 0.0f;
        g.setFont(cp.font, 0, cp.fontSmall);
        for (int i = 0; i < this.events.size(); ++i) {
            EventRange eventRange = this.events.get(i);
            SBPanel.ChartImage pi = eventRange.image;
            if (eventRange.image == null) continue;
            if (i == 0) {
                imgX = x;
                imgY = yTopImg + this.imgMargin;
                lastX1 = imgWidth;
            } else if (i == this.events.size() - 1) {
                imgX = (float)this.events.size() * this.EV_WIDTH - imgWidth;
                if (imgX >= lastX1) {
                    imgX += x;
                    imgY = yTopImg + this.imgMargin;
                } else if (imgX >= lastX2) {
                    imgX += x;
                    imgY = yTopImg + imgWidth + this.imgMargin * 2.0f;
                } else {
                    System.out.println("No room to plot last range chart image ... reducing");
                    imgX += x;
                    if (lastX1 < lastX2) {
                        imgY = yTopImg + this.imgMargin;
                        imgWidth = (float)this.events.size() * this.EV_WIDTH - lastX1;
                    } else {
                        imgY = yTopImg + imgWidth + this.imgMargin * 2.0f;
                        imgWidth = (float)this.events.size() * this.EV_WIDTH - lastX2;
                    }
                    if (imgWidth < 3.0f) {
                        System.out.println("No room to plot last range chart image!");
                    }
                }
            } else if (pi.origTop - this.EV_WIDTH >= lastX1) {
                imgX = x + (pi.origTop - this.EV_WIDTH) + this.imgMargin;
                imgY = yTopImg + this.imgMargin;
                lastX1 = pi.origTop + this.EV_WIDTH;
            } else if (lastX1 < lastX2) {
                imgX = x + Math.max(lastX1, pi.origTop - this.EV_WIDTH) + this.imgMargin;
                imgY = yTopImg + this.imgMargin;
                lastX1 = imgX - x + imgWidth;
            } else {
                imgX = x + Math.max(lastX2, pi.origTop - this.EV_WIDTH) + this.imgMargin;
                imgY = yTopImg + imgWidth + this.imgMargin * 2.0f;
                lastX2 = imgX - x + imgWidth;
            }
            g.setStroke(0.1f);
            g.setColor(Color.BLACK);
            g.drawImage(pi.image, imgX, imgY, imgWidth, pi.height);
            g.drawRect(imgX, imgY, imgWidth, pi.height);
            g.setStroke(0.3f);
            g.setColor(Color.LIGHT_GRAY);
            float eventNameWidth = g.stringWidth(eventRange.event.toString());
            float DOTWID = 1.2f;
            g.fillEllipse(x + pi.origTop - 0.6f, imgY + pi.height - 0.6f, 1.2f, 1.2f, Color.LIGHT_GRAY);
            g.drawLine(x + pi.origTop, imgY + pi.height, x + pi.origTop, y + PanelRange.getPanelHeaderHeight(cp, mode) - eventNameWidth - 4.0f);
        }
    }

    private void drawProject(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) throws SQLException {
        if (this.p.project == null || this.p.interpID < 0) {
            return;
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                Iterator wellIt = this.p.project.getWellIterator();
                g.setStroke(0.3f);
                float symbolWidth = 0.75f;
                while (wellIt.hasNext()) {
                    WellInterp interp;
                    Well well = (Well)wellIt.next();
                    try {
                        interp = well.getInterp(this.p.interpID);
                    }
                    catch (SBException sbe) {
                        continue;
                    }
                    LOC loc = interp.getLOC();
                    if (loc == null) continue;
                    for (WellEvent evt : interp.getEvents()) {
                        double age;
                        int index = this.getEventIndex(evt.getEvent());
                        if (index < 0 || !((age = loc.getAge(well.getDepth(evt.getSample(), cp.correctDepths, cp.correctCuttings), false)) >= (double)bp.min) || !(age <= (double)bp.max)) continue;
                        float ypos = this.block.scaleAge((float)age) + y + PanelRange.getPanelHeaderHeight(cp, mode);
                        switch (evt.getTypeObj()) {
                            case TOP: {
                                g.setColor(Color.RED);
                                float xpos = x + this.EV_WIDTH * (float)index + this.EV_WIDTH * 0.25f;
                                g.drawLine(xpos - symbolWidth, ypos, xpos + symbolWidth, ypos);
                                g.drawLine(xpos, ypos - symbolWidth, xpos, ypos + symbolWidth);
                                break;
                            }
                            case BASE: {
                                g.setColor(Color.BLUE);
                                float xpos = x + this.EV_WIDTH * (float)index + this.EV_WIDTH * 0.75f - symbolWidth;
                                g.drawEllipse(xpos, ypos - symbolWidth, symbolWidth * 2.0f, symbolWidth * 2.0f);
                                break;
                            }
                            case SINGLE: {
                                g.setColor(Color.DARK_GRAY);
                                float xpos = x + this.EV_WIDTH * (float)index + this.EV_WIDTH * 0.5f;
                                g.drawLine(xpos - symbolWidth, ypos, xpos + symbolWidth, ypos);
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    private void drawGroupOutlines(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) {
        if (this.groupRanges == null) {
            return;
        }
        g.setStroke(0.5f);
        for (GroupRange gr : this.groupRanges) {
            if (!gr.colour.equals(Color.WHITE)) {
                g.setColor(gr.colour);
            } else {
                g.setColor(Color.BLACK);
            }
            float xPos = x + (float)this.events.indexOf(gr.left) * this.EV_WIDTH + 0.25f;
            float width = x + (float)(this.events.indexOf(gr.right) + 1) * this.EV_WIDTH - xPos - 0.25f;
            float yPos = y + this.block.scaleAge((float)(gr.minAge < (double)bp.min ? (double)bp.min : gr.minAge)) + PanelRange.getPanelHeaderHeight(cp, mode);
            float height = y + this.block.scaleAge((float)(gr.maxAge > (double)bp.max ? (double)bp.max : gr.maxAge)) + PanelRange.getPanelHeaderHeight(cp, mode) - yPos;
            g.drawRect(xPos, yPos, width, height);
        }
    }

    private void drawGroupNames(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties p, Chart.Mode mode) {
        if (this.groupRanges == null) {
            return;
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                g.setStroke(0.2f);
                float boxHeight = Math.min(this.EV_WIDTH, 7.5f);
                for (GroupRange gr : this.groupRanges) {
                    g.setColor(Color.WHITE);
                    float xPos = x + (float)this.events.indexOf(gr.left) * this.EV_WIDTH;
                    float width = x + (float)(this.events.indexOf(gr.right) + 1) * this.EV_WIDTH - xPos;
                    float yPos = y + p.panelCaptionHeight + boxHeight - 2.0f;
                    g.drawString(gr.name, xPos, yPos, width, 0);
                    g.setColor(Color.BLACK);
                    g.drawRect(xPos, y + p.panelCaptionHeight, width, boxHeight);
                }
                break;
            }
        }
    }

    private void drawSchemeShading(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) {
        if (this.p.scheme == null) {
            return;
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                for (IGDScheme.ShadeInterval shadeInterval : this.p.scheme.getShadingIntervals(bp.min, bp.max)) {
                    float top = this.block.scaleAge(shadeInterval.getUage()) + y + PanelRange.getPanelHeaderHeight(cp, mode);
                    float base = this.block.scaleAge(shadeInterval.getLage()) + y + PanelRange.getPanelHeaderHeight(cp, mode);
                    Color colour = SB.getLighterColour((Color)shadeInterval.getColour());
                    g.setColor(colour);
                    g.fillRect(x, top, this.getWidth(bp), base - top);
                }
                break;
            }
        }
    }

    float calcPlotPosition(float y, float value, float panelHeaderHeight, BlockProperties bp) {
        return y + (value - bp.min) * bp.scale + panelHeaderHeight;
    }

    double getAge(float ypos, BlockProperties bp) {
        double retval = ypos / bp.scale + bp.min;
        return retval;
    }

    @Override
    float getWidth(BlockProperties bp) {
        if (this.events == null) {
            this.createEventList(bp);
        }
        return this.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.events == null || this.events.isEmpty()) {
            return null;
        }
        double age = this.getAge(y, bp);
        double bracket = this.getAge(y + 1.0f / zoom, bp) - age;
        float xpos = 0.0f;
        for (int i = 0; i < this.events.size(); ++i) {
            if (!(x < (xpos += this.EV_WIDTH))) continue;
            EventRange er = this.events.get(i);
            if (er.minAge != null && this.p.std.getAge(er.minAge.getCSU()) - bracket < age && this.p.std.getAge(er.minAge.getCSU()) + bracket > age) {
                if (er.maxAge != null && er.maxAge.getCSU() < 1.0E-4 && er.minAge.getCSU() < 1.0E-4) {
                    return er.maxAge;
                }
                return er.minAge;
            }
            if (er.maxAge != null && this.p.std.getAge(er.maxAge.getCSU()) - bracket < age && this.p.std.getAge(er.maxAge.getCSU()) + bracket > age) {
                return er.maxAge;
            }
            if (er.singleAge != null && this.p.std.getAge(er.singleAge.getCSU()) - bracket < age && this.p.std.getAge(er.singleAge.getCSU()) + bracket > age) {
                return er.singleAge;
            }
            return er;
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            SBEvent e = null;
            String strg = "";
            if (o instanceof EventRange) {
                EventRange er = (EventRange)o;
                if (this.getAge(y, bp) > (double)bp.min) {
                    e = er.event;
                    strg = strg + er.event.getName() + " (";
                    if (er.minAge != null && er.maxAge != null) {
                        strg = strg + er.minAge.getCSU() + " - " + er.maxAge.getCSU();
                    } else if (er.minAge != null) {
                        strg = strg + CompositeStandardEvent.getEvTypeString((SBEvent.EventType)SBEvent.EventType.TOP) + " " + er.minAge.getCSU();
                    } else if (er.maxAge != null) {
                        strg = strg + CompositeStandardEvent.getEvTypeString((SBEvent.EventType)SBEvent.EventType.BASE) + " " + er.maxAge.getCSU();
                    } else if (er.singleAge != null) {
                        strg = strg + "Single " + er.singleAge.getCSU();
                    }
                    strg = strg + " Ma)";
                    try {
                        strg = strg + "<br>" + this.getUnitAges(er.minAge != null ? er.minAge.getCSU() : (er.singleAge != null ? er.singleAge.getCSU() : -1.0), er.maxAge != null ? er.maxAge.getCSU() : -1.0, false);
                    }
                    catch (SQLException sqle) {
                        strg = strg + sqle.toString();
                    }
                } else {
                    strg = strg + er.event.getName();
                }
            } else if (o instanceof CompositeStandardEvent) {
                CompositeStandardEvent cse = (CompositeStandardEvent)o;
                e = cse.getEvent();
                strg = strg + "<strong>";
                strg = strg + cse.toStringName();
                try {
                    strg = strg + " (" + this.p.std.getAge(cse.getCSU()) + " Ma)</strong><br>" + this.getUnitAges(-1.0, cse.getCSU(), cse.getEvType() == 'F');
                }
                catch (SQLException sqle) {
                    strg = strg + sqle.toString();
                }
            }
            if (e != null && this.p.project != null) {
                try {
                    String wellString = this.getWellEventString(y, e, cp, bp, zoom);
                    if (!wellString.isEmpty()) {
                        if (!strg.isEmpty()) {
                            strg = strg + "<br>";
                        }
                        strg = strg + wellString;
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
            return strg.isEmpty() ? "" : "<html>" + strg + "</html>";
        }
        return "Stratigraphic Range Chart";
    }

    private String getWellEventString(float y, SBEvent e, ChartProperties cp, BlockProperties bp, float zoom) throws SQLException {
        double age = this.getAge(y, bp);
        double bracket = this.getAge(y + 1.0f / zoom, bp) - age;
        String string = "";
        Iterator it = this.p.project.getWellIterator();
        while (it.hasNext()) {
            WellInterp interp;
            Well well = (Well)it.next();
            try {
                interp = well.getInterp(this.p.interpID);
            }
            catch (SBException sbe) {
                continue;
            }
            if (interp.getLOC() == null) continue;
            for (WellEvent event : interp.getEvents()) {
                double evAge;
                if (event.getEvent().getEvID() != e.getEvID() || !((evAge = interp.getLOC().getAge(well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings), false)) >= 0.0) || !(evAge < age + bracket) || !(evAge > age - bracket)) continue;
                if (!string.isEmpty()) {
                    string = string + "<br>";
                }
                string = string + well.getWellName() + " - " + WellEvent.getType((char)event.getCharType()) + " (" + event.getSample() + ")";
            }
        }
        return string;
    }

    String getUnitAges(double csu1, double csu2, boolean top) throws SQLException {
        String strg = "";
        if (this.p.scheme != null) {
            IGDUnit unit;
            if (csu1 > 0.0 && (unit = this.p.scheme.findUnit(csu1, top)) != null) {
                strg = strg + " " + unit.getName();
            }
            if (csu2 > 0.0 && (unit = this.p.scheme.findUnit(csu2, top)) != null) {
                if (!strg.isEmpty()) {
                    strg = strg + " - ";
                }
                strg = strg + unit.getName();
            }
        }
        return strg;
    }

    public UndoableEdit updateEvent(CompositeStandardEvent event, float y, BlockProperties bp, int round) throws SBException, SQLException {
        double prevAge = this.p.std.getAge(event.getCSU());
        Double newAge = SB.round((double)this.getAge(y, bp), (int)round);
        if (newAge == null) {
            return null;
        }
        this.p.std.updateCsu(event, SB.round((double)this.p.std.getCSU(newAge.doubleValue()), (int)round));
        this.sbdb.commit();
        this.p.std.notifyObservers();
        return new EventEdit(event, prevAge);
    }

    public void refreshEvents() {
        if (this.getNEvents() < this.p.std.getEvents().size()) {
            this.createEventList(this.block.prop);
            return;
        }
        for (EventRange er : this.events) {
            er.minAge = this.p.std.getEvent(er.event.getEvID(), SBEvent.EventType.TOP);
            er.maxAge = this.p.std.getEvent(er.event.getEvID(), SBEvent.EventType.BASE);
            er.singleAge = this.p.std.getEvent(er.event.getEvID(), SBEvent.EventType.SINGLE);
            if (er.minAge != null || er.maxAge != null || er.singleAge != null) continue;
            System.out.println("All null for: " + er.event);
        }
    }

    public int getNEvents() {
        int nEvents = 0;
        if (this.events == null || this.events.isEmpty()) {
            return nEvents;
        }
        for (EventRange er : this.events) {
            if (er.minAge != null) {
                ++nEvents;
            }
            if (er.maxAge != null) {
                ++nEvents;
            }
            if (er.singleAge == null) continue;
            ++nEvents;
        }
        return nEvents;
    }

    private int getEventIndex(SBEvent evt) {
        for (int i = 0; i < this.events.size(); ++i) {
            EventRange er = this.events.get(i);
            if (er.event.getEvID() != evt.getEvID()) continue;
            return i;
        }
        return -1;
    }

    void createEventList(BlockProperties bp) {
        if (this.p.std == null || bp == null) {
            return;
        }
        if (this.events == null) {
            this.events = new LinkedList();
        } else {
            this.events.clear();
        }
        boolean sortT = this.p.sortTops == null ? true : this.p.sortTops;
        for (CompositeStandardEvent event : this.p.std.getEventsByCSU(sortT)) {
            if (this.p.set != null && this.p.setExclusive) {
                try {
                    if (event.getEvent().getTaxon() == null || !this.p.set.isMember(event.getEvent().getTaxon().getSpecID())) {
                        continue;
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                catch (SBException ex) {
                    ex.printStackTrace();
                }
            }
            if (event.getEvType() == 'L' || event.getEvType() == 'F') {
                EventRange eventRange = null;
                for (EventRange r : this.events) {
                    if (r.event.getEvID() != event.getEvID()) continue;
                    eventRange = r;
                    break;
                }
                if (eventRange == null) {
                    eventRange = new EventRange(event.getEvent());
                    this.events.add(eventRange);
                }
                if (event.getEvType() == 'F') {
                    eventRange.minAge = event;
                    continue;
                }
                eventRange.maxAge = event;
                continue;
            }
            this.events.add(new EventRange(event.getEvent(), event));
        }
        if (!this.p.showAll) {
            LinkedList<EventRange> toKill = new LinkedList<EventRange>();
            for (EventRange er : this.events) {
                if (er.minAge != null && this.p.std.getAge(er.minAge.getCSU()) >= (double)bp.min && this.p.std.getAge(er.minAge.getCSU()) <= (double)bp.max || er.maxAge != null && this.p.std.getAge(er.maxAge.getCSU()) >= (double)bp.min && this.p.std.getAge(er.maxAge.getCSU()) <= (double)bp.max || er.singleAge != null && this.p.std.getAge(er.singleAge.getCSU()) >= (double)bp.min && this.p.std.getAge(er.singleAge.getCSU()) <= (double)bp.max) continue;
                toKill.add(er);
            }
            for (EventRange kill : toKill) {
                this.events.remove(kill);
            }
        }
        this.panelWidth = (float)this.events.size() * this.EV_WIDTH;
        if (!sortT) {
            Collections.reverse(this.events);
        }
        if (this.p.sortTops == null) {
            Collections.sort(this.events);
        }
        if (this.p.groupGroups) {
            this.groupGroups();
        }
        if (this.p.showImages) {
            this.createImages();
        }
    }

    void createImages() {
        if (this.events == null) {
            return;
        }
        int nEvent = 0;
        for (EventRange eventRange : this.events) {
            try {
                Taxon taxon;
                ImageSet imageSet;
                if (eventRange.event.getTaxon() != null && eventRange.event.getTaxon().hasTypeImage() && (imageSet = (taxon = eventRange.event.getTaxon()).getImageType()) != null) {
                    ImageIcon icon = imageSet.getImage(0).getImage();
                    float imgCol = this.EV_WIDTH * 2.0f - this.imgMargin * 2.0f;
                    float imgHeight = icon.getIconHeight();
                    float imgWidth = icon.getIconWidth();
                    if (imgWidth > imgCol) {
                        imgHeight /= imgWidth / imgCol;
                        imgWidth = imgCol;
                    }
                    eventRange.image = new SBPanel.ChartImage(this, icon, (float)nEvent * this.EV_WIDTH + this.EV_WIDTH / 2.0f, imgWidth, imgHeight);
                }
                ++nEvent;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void groupGroups() {
        if (this.p.set == null) {
            return;
        }
        LinkedList groups = new LinkedList();
        LinkedList<Color> colours = new LinkedList<Color>();
        LinkedList<String> names = new LinkedList<String>();
        try {
            int i = 0;
            for (TxGroup group : this.p.set.getGroups()) {
                LinkedList<EventRange> newList = new LinkedList<EventRange>();
                for (EventRange er : this.events) {
                    if (er.event.getSpecID() <= 0 || !group.isMember(er.event.getSpecID())) continue;
                    newList.add(er);
                }
                if (!newList.isEmpty()) {
                    groups.add(newList);
                    for (EventRange er : newList) {
                        this.events.remove(er);
                    }
                    colours.add(group.getColour());
                    names.add(group.getName());
                }
                ++i;
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
            sql.printStackTrace();
        }
        LinkedList<EventRange> finalList = new LinkedList<EventRange>();
        this.groupRanges = new LinkedList();
        if (this.p.sortTops == null) {
            for (int i = 0; i < groups.size(); ++i) {
                LinkedList groupList = (LinkedList)groups.get(i);
                finalList.addAll(groupList);
                MinMaxAges mm = this.getMinMax(groupList);
                this.groupRanges.add(new GroupRange((EventRange)groupList.getFirst(), (EventRange)groupList.getLast(), (Color)colours.get(i), mm.minAge, mm.maxAge, (String)names.get(i)));
            }
            finalList.addAll(this.events);
        } else {
            LinkedList<InsertList> inserts = new LinkedList<InsertList>();
            for (int i = 0; i < groups.size(); ++i) {
                LinkedList groupList = (LinkedList)groups.get(i);
                EventRange er = this.p.sortTops == null || this.p.sortTops != false ? (EventRange)groupList.getFirst() : (EventRange)groupList.getLast();
                CompositeStandardEvent grpEvt = er.getSort();
                double grpAge = this.p.std.getAge(grpEvt.getCSU());
                int k = 0;
                if (this.events.size() > 0) {
                    while (grpAge > this.p.std.getAge(this.events.get(k).getSort().getCSU()) && ++k <= this.events.size() - 1) {
                    }
                }
                inserts.add(new InsertList(k, groupList));
                MinMaxAges mm = this.getMinMax(groupList);
                this.groupRanges.add(new GroupRange((EventRange)groupList.getFirst(), (EventRange)groupList.getLast(), (Color)colours.get(i), mm.minAge, mm.maxAge, (String)names.get(i)));
            }
            finalList.addAll(this.events);
            int totalAdded = 0;
            Collections.sort(inserts);
            for (InsertList il : inserts) {
                int k = il.insertPoint;
                finalList.addAll(k + totalAdded, il.rangeList);
                totalAdded += il.rangeList.size();
            }
        }
        this.events = finalList;
    }

    private MinMaxAges getMinMax(LinkedList<EventRange> groupList) {
        Double minAge = null;
        Double maxAge = null;
        for (EventRange range : groupList) {
            if (minAge == null || range.getTop().getCSU() < minAge) {
                minAge = range.getTop().getCSU();
            }
            if (maxAge != null && !(range.getBase().getCSU() > maxAge)) continue;
            maxAge = range.getBase().getCSU();
        }
        return new MinMaxAges(minAge, maxAge);
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CompositeStandard) {
            this.refreshEvents();
        } else if (obs instanceof TxGroup && this.p.groupGroups) {
            this.groupGroups();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public CompositeStandard getComposite() {
        return this.p.std;
    }

    final void setProperties(PanelRangeProperties prop) {
        PanelRangeProperties oldProp = this.p;
        this.p = prop;
        if ((double)Math.abs(this.p.evWidth - this.EV_WIDTH) > 0.01 && this.p.evWidth > 0.0f && this.p.evWidth < 100.0f) {
            this.EV_WIDTH = this.p.evWidth;
        }
        if (oldProp != null) {
            if (oldProp.groupGroups != this.p.groupGroups || oldProp.sortTops != this.p.sortTops || oldProp.std != oldProp.std || oldProp.showAll != this.p.showAll || oldProp.setExclusive != this.p.setExclusive || (double)Math.abs(oldProp.evWidth - this.p.evWidth) > 0.01) {
                this.createEventList(this.block.prop);
            }
            if (oldProp.std != null) {
                oldProp.std.deleteObserver((Observer)this);
            }
            if (oldProp.set != null) {
                try {
                    for (TxGroup group : oldProp.set.getGroups()) {
                        group.deleteObserver((Observer)this);
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        if (this.p.std != null) {
            this.p.std.addObserver((Observer)this);
        }
        if (this.p.set != null) {
            try {
                for (TxGroup group : this.p.set.getGroups()) {
                    group.addObserver((Observer)this);
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
    }

    @Override
    public PanelRangeProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 45;
    }

    public String toString() {
        return this.getCaption();
    }

    public class EventEdit
    extends AbstractUndoableEdit {
        CompositeStandardEvent event;
        double age;
        String presentationName = "edit event age";

        public EventEdit(CompositeStandardEvent event, double prevAge) {
            this.event = event;
            this.age = prevAge;
        }

        @Override
        public void undo() {
            try {
                double redoAge = ((PanelRange)PanelRange.this).p.std.getAge(this.event.getCSU());
                ((PanelRange)PanelRange.this).p.std.updateCsu(this.event, ((PanelRange)PanelRange.this).p.std.getCSU(this.age));
                ((PanelRange)PanelRange.this).p.std.notifyObservers();
                this.age = redoAge;
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error undoing composite standard event edit", (SQLException)sql);
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error undoing composite standard event edit", (Exception)((Object)sbe));
                sbe.printStackTrace();
            }
        }

        @Override
        public void redo() {
            try {
                double undoAge = ((PanelRange)PanelRange.this).p.std.getAge(this.event.getCSU());
                ((PanelRange)PanelRange.this).p.std.updateCsu(this.event, ((PanelRange)PanelRange.this).p.std.getCSU(this.age));
                ((PanelRange)PanelRange.this).p.std.notifyObservers();
                this.age = undoAge;
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error redoing composite standard event edit: ", (SQLException)sql);
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error redoing composite standard event edit: ", (Exception)((Object)sbe));
                sbe.printStackTrace();
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return this.presentationName;
        }
    }

    class GroupRange {
        EventRange left;
        EventRange right;
        double minAge;
        double maxAge;
        Color colour;
        String name;

        GroupRange(EventRange left, EventRange right, Color colour, double minAge, double maxAge, String name) {
            this.left = left;
            this.right = right;
            this.colour = colour;
            this.minAge = minAge;
            this.maxAge = maxAge;
            this.name = name;
        }
    }

    class EventRange
    implements Comparable<EventRange> {
        SBEvent event;
        CompositeStandardEvent minAge;
        CompositeStandardEvent maxAge;
        CompositeStandardEvent singleAge;
        SBPanel.ChartImage image;

        EventRange(SBEvent event, CompositeStandardEvent minAge, CompositeStandardEvent maxAge) {
            this.event = event;
            this.minAge = minAge;
            this.maxAge = maxAge;
        }

        EventRange(SBEvent event) {
            this.event = event;
        }

        EventRange(SBEvent event, CompositeStandardEvent minAge, CompositeStandardEvent maxAge, CompositeStandardEvent singleAge) {
            this.event = event;
            this.minAge = minAge;
            this.maxAge = maxAge;
            this.singleAge = singleAge;
        }

        EventRange(SBEvent event, CompositeStandardEvent singleAge) {
            this.event = event;
            this.singleAge = singleAge;
        }

        @Override
        public int compareTo(EventRange rhs) {
            return this.event.getName().compareToIgnoreCase(rhs.event.getName());
        }

        public CompositeStandardEvent getSort() {
            if (((PanelRange)PanelRange.this).p.sortTops == null) {
                if (this.singleAge != null) {
                    return this.singleAge;
                }
                if (this.minAge != null) {
                    return this.minAge;
                }
                return this.maxAge;
            }
            if (this.singleAge != null) {
                return this.singleAge;
            }
            if ((((PanelRange)PanelRange.this).p.sortTops != false ? this.minAge : this.maxAge) != null) {
                return ((PanelRange)PanelRange.this).p.sortTops != false ? this.minAge : this.maxAge;
            }
            return ((PanelRange)PanelRange.this).p.sortTops != false ? this.maxAge : this.minAge;
        }

        public CompositeStandardEvent getTop() {
            if (this.singleAge != null) {
                return this.singleAge;
            }
            if (this.minAge != null) {
                return this.minAge;
            }
            return this.maxAge;
        }

        public CompositeStandardEvent getBase() {
            if (this.singleAge != null) {
                return this.singleAge;
            }
            if (this.maxAge != null) {
                return this.maxAge;
            }
            return this.minAge;
        }
    }

    class InsertList
    implements Comparable<InsertList> {
        int insertPoint;
        LinkedList<EventRange> rangeList;

        InsertList(int i, LinkedList<EventRange> ranges) {
            this.insertPoint = i;
            this.rangeList = ranges;
        }

        @Override
        public int compareTo(InsertList o) {
            if (o.insertPoint < this.insertPoint) {
                return 1;
            }
            if (o.insertPoint > this.insertPoint) {
                return -1;
            }
            if (((PanelRange)PanelRange.this).p.sortTops == null) {
                return o.rangeList.getFirst().event.compareTo((Object)this.rangeList.getFirst().event);
            }
            if (o.rangeList.getFirst().getSort().getCSU() < this.rangeList.getFirst().getSort().getCSU()) {
                return 1;
            }
            if (o.rangeList.getFirst().getSort().getCSU() > this.rangeList.getFirst().getSort().getCSU()) {
                return -1;
            }
            return 0;
        }
    }

    class MinMaxAges {
        double minAge;
        double maxAge;

        MinMaxAges(double minAge, double maxAge) {
            this.minAge = minAge;
            this.maxAge = maxAge;
        }
    }
}

