/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.StringTokenizer;
import jsbugs.PanelProperties;
import jsbugs.SchemeBlock;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.TxGroupSet;
import util.SBException;

public class PanelRangeProperties
implements PanelProperties {
    CompositeStandard std;
    IGDScheme scheme;
    Project project = null;
    int interpID = -1;
    TxGroupSet set = null;
    Boolean sortTops = true;
    boolean groupGroups = false;
    boolean showGroupOutlines = true;
    boolean showAll = false;
    boolean setExclusive = false;
    int colourDensity = 85;
    boolean showImages = false;
    float evWidth = 7.5f;
    final int NPROPS = 16;

    PanelRangeProperties(SBdb sbdb, SchemeBlock block) {
        this.decode(sbdb, block);
    }

    PanelRangeProperties(PanelRangeProperties rhs) {
        this.copy(rhs);
    }

    private void copy(PanelRangeProperties rhs) {
        this.std = rhs.std;
        this.scheme = rhs.scheme;
        this.project = rhs.project;
        this.interpID = rhs.interpID;
        this.sortTops = rhs.sortTops;
        this.set = rhs.set;
        this.groupGroups = rhs.groupGroups;
        this.showGroupOutlines = rhs.showGroupOutlines;
        this.showAll = rhs.showAll;
        this.colourDensity = rhs.colourDensity;
        this.setExclusive = rhs.setExclusive;
        this.showImages = rhs.showImages;
        this.evWidth = rhs.evWidth;
    }

    public void encode(SBdb sbdb, float minAge, float maxAge, float scale) {
        String string = new String();
        String[] props = new String[]{"" + this.std.getStdID(), "" + (this.scheme != null ? this.scheme.getID() : -1), "" + (this.project != null ? this.project.getID() : -1), "" + this.interpID, "" + (this.sortTops == null ? -1 : (this.sortTops != false ? 1 : 0)), "" + (this.set != null ? this.set.getID() : -1), "" + (this.groupGroups ? 1 : 0), "" + (this.showGroupOutlines ? 1 : 0), "" + (this.showAll ? 1 : 0), "" + minAge, "" + maxAge, "" + scale, "" + this.colourDensity, "" + (this.set != null && this.setExclusive ? 1 : 0), "" + (this.showImages ? 1 : 0), "" + this.evWidth};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)sbdb, (String)"RANGEPREF", (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb, SchemeBlock block) {
        try {
            int setID;
            int projectID;
            int schID;
            String params = Lastval.getString((SBdb)sbdb, (String)"RANGEPREF");
            if (params.isEmpty()) {
                System.out.println("RangePanel params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                int stdID = Integer.parseInt(tok.nextToken());
                this.std = sbdb.getCompositeStandard(stdID);
                if (this.std != null) {
                    try {
                        this.std.loadEvents();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (tok.hasMoreTokens() && (schID = Integer.parseInt(tok.nextToken())) >= 0) {
                this.scheme = sbdb.getIGDScheme(schID);
            }
            if (tok.hasMoreTokens() && (projectID = Integer.parseInt(tok.nextToken())) >= 0) {
                this.project = sbdb.getProject(projectID);
            }
            if (tok.hasMoreTokens()) {
                this.interpID = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                int sortTs = Integer.parseInt(tok.nextToken());
                this.sortTops = sortTs == -1 ? null : Boolean.valueOf(sortTs == 1);
            }
            if (tok.hasMoreTokens() && (setID = Integer.parseInt(tok.nextToken())) >= 0) {
                this.set = sbdb.getTxGroupSet(setID);
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.groupGroups = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showGroupOutlines = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showAll = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                block.prop.min = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                block.prop.max = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                block.prop.scale = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.colourDensity = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.setExclusive = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showImages = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.evWidth = Float.parseFloat(tok.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    PanelRangeProperties(SBdb sbdb, String prop) throws SQLException, SBException {
        String[] s = prop.split("\\|");
        block15: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    int stdID = Integer.parseInt(s[i]);
                    this.std = sbdb.getCompositeStandard(stdID);
                    if (this.std != null) {
                        this.std.loadEvents();
                        continue block15;
                    }
                    throw new SBException("No composite for range panel");
                }
                case 1: {
                    int schID = Integer.parseInt(s[i]);
                    if (schID <= 0) continue block15;
                    this.scheme = sbdb.getIGDScheme(schID);
                    continue block15;
                }
                case 2: {
                    int projectID = Integer.parseInt(s[i]);
                    if (projectID < 0) continue block15;
                    this.project = sbdb.getProject(projectID);
                    if (this.project == null) continue block15;
                    this.project.loadWells(sbdb, null);
                    continue block15;
                }
                case 3: {
                    this.interpID = Integer.parseInt(s[i]);
                    continue block15;
                }
                case 4: {
                    int sortTs = Integer.parseInt(s[i]);
                    if (sortTs == -1) {
                        this.sortTops = null;
                        continue block15;
                    }
                    this.sortTops = sortTs == 1;
                    continue block15;
                }
                case 5: {
                    int setID = Integer.parseInt(s[i]);
                    if (setID < 0) continue block15;
                    this.set = sbdb.getTxGroupSet(setID);
                    continue block15;
                }
                case 6: {
                    this.groupGroups = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 7: {
                    this.showGroupOutlines = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 8: {
                    this.showAll = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 9: {
                    this.colourDensity = Integer.parseInt(s[i]);
                    continue block15;
                }
                case 10: {
                    this.setExclusive = Integer.parseInt(s[i]) == 1 && this.set != null;
                    continue block15;
                }
                case 11: {
                    this.showImages = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 12: {
                    this.evWidth = Float.parseFloat(s[i]);
                }
            }
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + this.getPrefs()));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.std.getStdID(), "" + (this.scheme != null ? this.scheme.getID() : -1), "" + (this.project != null ? this.project.getID() : -1), "" + this.interpID, "" + (this.sortTops == null ? -1 : (this.sortTops != false ? 1 : 0)), "" + (this.set != null ? this.set.getID() : -1), "" + (this.groupGroups ? 1 : 0), "" + (this.showGroupOutlines ? 1 : 0), "" + (this.showAll ? 1 : 0), "" + this.colourDensity, "" + (this.set != null && this.setExclusive ? 1 : 0), "" + (this.showImages ? 1 : 0), "" + this.evWidth};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }
}

