/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartObject;
import jsbugs.ChartObjectCompareDepth;
import jsbugs.ChartProperties;
import jsbugs.DrawZone;
import jsbugs.PanelSequences;
import jsbugs.PanelSequencesProperties;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.WellBlock;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.LOC;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Surface;
import model2.TVDList;
import model2.WellInterp;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class PanelSQPicks
extends PanelSequences
implements Observer {
    WellBlock block;
    int interpID;
    int schID;
    private SBdb db;
    LinkedList<DrawZone> units = null;
    LinkedList<DrawZone> disconformities = null;

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && arg instanceof SQPick) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public PanelSQPicks(SBdb db, WellBlock block, int interpID, int schID) throws SQLException, SBException {
        this.block = block;
        this.db = db;
        this.interpID = interpID;
        this.schID = schID;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.p = new PanelSequencesProperties(this.db);
        this.block.well.getInterp(this.interpID).addObserver((Observer)this);
    }

    @Override
    public PanelSequencesProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    int getIdentifier() {
        return this.interpID;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o instanceof SQPick) {
            SQPick pick = (SQPick)o;
            return pick.getName() + "  " + pick.getSample().toString(bp.units) + " " + "Bnd: " + pick.getBnd();
        }
        return null;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float BRACKET = 2.5f / zoom;
        for (ChartObject chartPick : this.chartObjects) {
            float yPos = chartPick.yPos;
            if (!(yPos - BRACKET < y) || !(yPos + BRACKET > y)) continue;
            try {
                if (!(chartPick.getDepth() > (double)bp.min) || !(chartPick.getDepth() < (double)bp.max)) continue;
                return chartPick.o;
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
        return "Sequence picks panel";
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.well.getSampleNearest((double)depth, 2.5f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        String string = "Sequence picks";
        try {
            string = this.schID > 0 ? string + " : " + this.db.getIGDScheme(this.schID) : string + " : All Schemes";
            string = string + " : " + this.block.well.getInterp(this.interpID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelSQPicks.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height + (firstOrOnly ? PanelSQPicks.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        g.setFont(cp.font, 0, cp.fontPanel);
        try {
            float topy;
            if (this.p.drawDisconformities) {
                this.drawDisconformities(g, xpos, y, cp, bp, mode);
                g.setStroke(0.2f);
                g.setFont(cp.font, 0, cp.fontHeader);
                if (firstOrOnly) {
                    if (mode != Chart.Mode.NO_HEADER) {
                        g.drawStringVertical("Disconformities", xpos + this.p.disconfColWidth / 2.0f, y + PanelSQPicks.getPanelHeaderHeight(cp, mode) - cp.fontHeader, cp.panelSubHeaderHeight - cp.fontHeader, true, false);
                    }
                    g.drawLine(xpos + this.p.disconfColWidth, y + PanelSQPicks.getPanelCaptionHeight(cp, mode), xpos + this.p.disconfColWidth, y + bp.height + PanelSQPicks.getPanelHeaderHeight(cp, mode));
                    g.drawLine(xpos, y, xpos, bp.height + PanelSQPicks.getPanelHeaderHeight(cp, mode));
                } else {
                    topy = Math.min(this.block.scaleDepth(bp.min), this.block.scaleDepth(bp.max)) + y + PanelSQPicks.getPanelHeaderHeight(cp, mode);
                    g.drawLine(xpos, topy, xpos, topy + bp.height);
                    g.drawLine(xpos + this.p.disconfColWidth, topy, xpos + this.p.disconfColWidth, topy + bp.height);
                }
                xpos += this.p.disconfColWidth;
            }
            if (this.p.drawUnits) {
                this.drawUnits(g, xpos, y, cp, bp, mode);
                g.setStroke(0.2f);
                g.setFont(cp.font, 0, cp.fontHeader);
                if (firstOrOnly) {
                    if (mode != Chart.Mode.NO_HEADER) {
                        g.drawStringVertical("Units", xpos + this.p.unitsColWidth / 2.0f, y + PanelSQPicks.getPanelHeaderHeight(cp, mode) - cp.fontHeader, cp.panelSubHeaderHeight - cp.fontHeader, true, false);
                    }
                    g.drawLine(xpos + this.p.unitsColWidth, y + PanelSQPicks.getPanelCaptionHeight(cp, mode), xpos + this.p.unitsColWidth, y + bp.height + PanelSQPicks.getPanelHeaderHeight(cp, mode));
                    if (!this.p.drawDisconformities) {
                        g.drawLine(xpos, y, xpos, bp.height + PanelSQPicks.getPanelHeaderHeight(cp, mode));
                    }
                } else {
                    topy = Math.min(this.block.scaleDepth(bp.min), this.block.scaleDepth(bp.max)) + y + PanelSQPicks.getPanelHeaderHeight(cp, mode);
                    g.drawLine(xpos, topy, xpos, topy + bp.height);
                    if (!this.p.drawDisconformities) {
                        g.drawLine(xpos + this.p.unitsColWidth, topy, xpos + this.p.unitsColWidth, topy + bp.height);
                    }
                }
                xpos += this.p.unitsColWidth;
            }
            if (this.p.drawTracts) {
                this.drawPolygons(g, xpos, y, cp, mode, bp, this.chartObjects);
            }
            if (this.block.prop != bp) {
                Integer begin = null;
                int end = 0;
                for (int i = 0; i < this.chartObjects.size(); ++i) {
                    ChartObject pp = (ChartObject)this.chartObjects.get(i);
                    double depth = pp.getDepth();
                    if (!(depth > (double)bp.min) || !(depth <= (double)bp.max)) continue;
                    if (begin == null) {
                        begin = i;
                    }
                    if (i <= end) continue;
                    end = i;
                }
                if (begin != null && end - begin > -1) {
                    this.drawBoundaries(g, xpos, y, cp, mode, this.chartObjects.subList(begin, ++end));
                }
            } else {
                this.drawBoundaries(g, xpos, y, cp, mode, this.chartObjects);
            }
            if (bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01) {
                g.setFont(cp.font, 0, cp.fontHeader);
                g.drawStringVertical("Picks", xpos + this.p.columnWidth / 2.0f, y + PanelSQPicks.getPanelHeaderHeight(cp, mode) - cp.fontHeader, cp.panelSubHeaderHeight - cp.fontHeader, true, false);
            }
            xpos += this.p.columnWidth;
        }
        catch (SQLException se) {
            SB.showStackError((String)"Error", (SQLException)se);
        }
        catch (SBException se) {
            SB.showStackError((String)"Error", (Exception)((Object)se));
        }
        return xpos;
    }

    private void drawPolygons(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp, List<ChartObject> chartObjects) throws SBException, SQLException {
        ChartObject lastPick = null;
        float lastY = y + PanelSQPicks.getPanelHeaderHeight(cp, mode);
        if (bp != this.block.prop) {
            lastY += this.block.scaleDepth(bp.min);
        }
        Surface.SurfaceType lastType = Surface.SurfaceType.SB;
        int lastBnd = 3;
        boolean reachedEnd = false;
        boolean lastPickInAnotherSubBlock = false;
        for (ChartObject chartPick : chartObjects) {
            Color tractColour;
            SQPick pick = (SQPick)chartPick.o;
            float thisY = chartPick.yPos + y + PanelSQPicks.getPanelHeaderHeight(cp, mode);
            double depth = chartPick.getDepth();
            if (bp != this.block.prop && depth < (double)bp.min) {
                lastPick = chartPick;
                lastType = pick.getSurfaceType();
                lastPickInAnotherSubBlock = true;
                continue;
            }
            if (bp != this.block.prop && depth > (double)bp.max) {
                thisY = this.block.scaleDepth(bp.max) + y + PanelSQPicks.getPanelHeaderHeight(cp, mode);
                reachedEnd = true;
            }
            if ((tractColour = this.getTractTypeUnordered(lastPick, chartPick)) == null) {
                if (reachedEnd) break;
                lastPick = chartPick;
                lastY = thisY;
                lastType = pick.getSurfaceType();
                lastBnd = pick.getBndInt();
                continue;
            }
            this.drawPolygon(g, x, lastY, thisY, lastType, pick.getSurfaceType(), lastBnd, pick.getBndInt(), tractColour, reachedEnd, lastPickInAnotherSubBlock);
            if (reachedEnd) break;
            lastPick = chartPick;
            lastY = thisY;
            lastType = pick.getSurfaceType();
            lastBnd = pick.getBndInt();
            lastPickInAnotherSubBlock = false;
        }
    }

    private Color getTractTypeUnordered(ChartObject pick1, ChartObject pick2) throws SBException, SQLException {
        TVDList tvdList;
        Color colour = null;
        if (pick1 == null || pick2 == null) {
            return colour;
        }
        double dd1 = pick1.getDepth();
        double dd2 = pick2.getDepth();
        boolean ordered = false;
        LOC loc = this.block.well.getInterp(this.interpID).getLOC();
        if (loc != null) {
            double age1 = loc.getAge(dd1, false);
            double age2 = loc.getAge(dd2, false);
            if (age1 > 0.0 && age2 > 0.0) {
                if (age1 > age2) {
                    ChartObject temp = pick1;
                    pick1 = pick2;
                    pick2 = temp;
                }
                ordered = true;
            }
        }
        if (!ordered && (tvdList = this.block.well.getTVDlist(false)) != null && !tvdList.getList().isEmpty()) {
            Double tvd1 = tvdList.getTVD(dd1).getTVDepth();
            Double tvd2 = tvdList.getTVD(dd2).getTVDepth();
            if (tvd1 != null && tvd2 != null && tvd1 > tvd2) {
                ChartObject temp = pick1;
                pick1 = pick2;
                pick2 = temp;
            }
        }
        return this.getTractType(pick1, pick2);
    }

    public UndoableEdit updatePick(Sample oldSample, float x, float y, float zoom, ChartProperties cp) throws SBException, SQLException, InvalidFieldException {
        Sample newSample = this.getSample(x, y, zoom, cp);
        if (newSample == null) {
            return null;
        }
        WellInterp interp = this.block.well.getInterp(this.interpID);
        SQPick pick = null;
        for (SQPick p : interp.getSQPicks()) {
            if (p.getSample() != oldSample) continue;
            pick = p;
            break;
        }
        if (pick != null) {
            SQPick temp = interp.addSQPick(this.block.well, newSample, pick.getSurface(), pick.getInfName(), pick.isQuestionable(), pick.getBnd());
            SQPickEdit edit = null;
            if (temp != null) {
                edit = new SQPickEdit(oldSample, newSample, temp);
                interp.deleteSQPick(pick, this.block.well.getWellID());
            }
            this.db.commit();
            interp.notifyObservers((Object)temp);
            return edit;
        }
        return null;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = this.p.columnWidth;
        if (this.p.drawUnits) {
            width += this.p.unitsColWidth;
        }
        if (this.p.drawDisconformities) {
            width += this.p.disconfColWidth;
        }
        return width;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    public void setInterp(int interpID) {
        this.interpID = interpID;
    }

    public void setProperties(PanelSequencesProperties p, int schID) {
        this.p = p;
        this.schID = schID;
    }

    private void drawUnits(SBGraphics g, float xpos, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        if (this.units == null || this.units.isEmpty()) {
            return;
        }
        Font font = new Font(cp.font, 0, (int)cp.fontPanel);
        LinkedList<DrawZone> list = new LinkedList<DrawZone>(this.units);
        if (bp != this.block.prop) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.baseDepth <= bp.min) && !((float)zone.topDepth >= bp.max)) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        PanelZones.drawColumnIntervals(g, xpos, y, font, list, this.p.unitsColWidth, cp, false, false, mode);
        g.setColor(Color.BLACK);
    }

    private void drawDisconformities(SBGraphics g, float xpos, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        if (this.disconformities == null || this.disconformities.isEmpty()) {
            return;
        }
        Font font = new Font(cp.font, 0, (int)cp.fontPanel);
        LinkedList<DrawZone> list = new LinkedList<DrawZone>(this.disconformities);
        if (bp != this.block.prop) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.baseDepth <= bp.min) && !((float)zone.topDepth >= bp.max)) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        PanelZones.drawColumnIntervals(g, xpos, y, font, list, this.p.disconfColWidth, cp, false, false, mode);
        g.setColor(Color.BLACK);
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) {
        System.out.println("PanelSQPicks setting data...");
        try {
            this.chartObjects = new LinkedList();
            for (SQPick pick : this.block.well.getInterp(this.interpID).getSQPicks()) {
                double corrDepth = this.block.well.getDepth(pick.getSample(), cp.correctDepths, cp.correctCuttings);
                if (corrDepth < (double)this.block.getTopDepth() || corrDepth > (double)this.block.getBaseDepth() || this.schID > 0 && pick.getSurface().getSchID() != this.schID) continue;
                float yPos = this.block.scaleDepth((float)corrDepth);
                ChartObject chartPick = new ChartObject(pick, yPos);
                if (Math.abs(corrDepth - pick.getSample().getDepth()) > (double)0.0029f) {
                    chartPick.corrDepth = corrDepth;
                }
                this.chartObjects.add(chartPick);
            }
            Collections.sort(this.chartObjects, new ChartObjectCompareDepth());
            this.units = null;
            if (this.p.drawUnits) {
                LinkedList<IGDScheme> schemes;
                this.units = new LinkedList();
                WellInterp interp = this.block.well.getInterp(this.interpID);
                if (this.schID > 0) {
                    schemes = new LinkedList<IGDScheme>();
                    schemes.add(this.db.getIGDScheme(this.schID));
                } else {
                    schemes = interp.getSequenceSchemes();
                }
                float lastBase = 0.0f;
                double lastDepth = this.block.getTopDepth();
                for (IGDScheme scheme : schemes) {
                    for (IGDUnit unit : scheme.getUnits()) {
                        Surface s1 = scheme.findSurface(unit.getUage(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                        Surface s2 = scheme.findSurface(unit.getLage(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                        if (s1 == null || s2 == null) continue;
                        ChartObject p1 = null;
                        ChartObject p2 = null;
                        for (ChartObject pp : this.chartObjects) {
                            ChartObject basePick;
                            ChartObject topPick;
                            if (((SQPick)pp.o).getSurface().getSchID() != scheme.getID()) continue;
                            if (((SQPick)pp.o).getSurface().getSurfaceID() == s1.getSurfaceID()) {
                                p1 = pp;
                            } else if (((SQPick)pp.o).getSurface().getSurfaceID() == s2.getSurfaceID()) {
                                p2 = pp;
                            }
                            if (p1 == null || p2 == null) continue;
                            if (p1.getDepth() < p2.getDepth()) {
                                topPick = p1;
                                basePick = p2;
                            } else {
                                topPick = p2;
                                basePick = p1;
                            }
                            float yTop = this.block.scaleDepth((float)topPick.getDepth());
                            float yBase = this.block.scaleDepth((float)basePick.getDepth());
                            if ((double)Math.abs(yTop - lastBase) > 0.1) {
                                this.units.add(new DrawZone(lastBase, yTop, null, null, 1, -1, null, null, null, null, lastDepth, topPick.getDepth()));
                            }
                            this.units.add(new DrawZone(yTop, yBase, unit.getColour(), null, ((SQPick)topPick.o).getBndInt(), ((SQPick)basePick.o).getBndInt(), unit.getName(), null, null, null, topPick.getDepth(), basePick.getDepth()));
                            lastBase = yBase;
                            lastDepth = basePick.getDepth();
                            p2 = null;
                            p1 = null;
                        }
                    }
                }
                float baseY = this.block.scaleDepth(this.block.getBaseDepth());
                if ((double)Math.abs(baseY - lastBase) > 0.1) {
                    float tvdMax;
                    this.units.add(new DrawZone(lastBase, baseY, null, null, -1, -1, null, null, null, null, lastDepth, this.block.getBaseDepth()));
                    if (this.block.prop.scaleType == BlockProperties.ScaleType.TVD && (double)Math.abs(baseY - (tvdMax = this.block.scaleTVD(this.block.prop.max))) > 0.1) {
                        this.units.add(new DrawZone(baseY, tvdMax, Color.WHITE, Color.WHITE, 3, 3, "Unknown TVD", null, null, null, -1.0, -1.0));
                    }
                }
                if (sections != null && sections.length > 2) {
                    this.units = PanelZones.divideDrawZones(this.units, sections);
                }
            }
            if (this.p.drawDisconformities) {
                this.setDisconformities();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error setting data in PanelSQPicks", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQLError setting data in PanelSQPicks", (SQLException)sql);
        }
    }

    private void setDisconformities() throws SBException, SQLException {
        this.disconformities = new LinkedList();
        WellInterp interp = this.block.well.getInterp(this.interpID);
        float SAME_SAMPLE_DEPTH = 0.5f;
        float lastPoint = 0.0f;
        double lastDepth = this.block.getTopDepth();
        Object p1 = null;
        Object p2 = null;
        ChartObject lastPick = null;
        String plotName = "";
        for (ChartObject pp : this.chartObjects) {
            SQPick pick = (SQPick)pp.o;
            if (pick.getSurfaceType() != Surface.SurfaceType.CC && pick.getSurfaceType() != Surface.SurfaceType.SB) continue;
            if (lastPick != null) {
                if (Math.abs(lastPick.getDepth() - pp.getDepth()) > (double)SAME_SAMPLE_DEPTH) {
                    float y = this.block.scaleDepth((float)lastPick.getDepth());
                    if ((double)Math.abs(y - lastPoint) > 0.1) {
                        this.disconformities.add(new DrawZone(lastPoint, y, null, null, 1, -1, null, null, null, null, lastDepth, lastPick.getDepth()));
                    }
                    this.disconformities.add(new DrawZone(y, y, Color.white, null, ((SQPick)lastPick.o).getBndInt(), ((SQPick)lastPick.o).getBndInt(), plotName, null, null, null, lastPick.getDepth(), lastPick.getDepth()));
                    lastPoint = y;
                    plotName = pick.getName();
                } else if (!pick.getName().equals(plotName)) {
                    plotName = plotName + " - " + pick.getName();
                }
            } else {
                plotName = pick.getName();
            }
            lastPick = pp;
        }
        if (lastPick != null) {
            float y = this.block.scaleDepth((float)lastPick.getDepth());
            if ((double)Math.abs(y - lastPoint) > 0.1) {
                this.disconformities.add(new DrawZone(lastPoint, y, null, null, 1, -1, null, null, null, null, lastDepth, lastPick.getDepth()));
            }
            this.disconformities.add(new DrawZone(y, y, Color.white, null, ((SQPick)lastPick.o).getBndInt(), ((SQPick)lastPick.o).getBndInt(), plotName, null, null, null, lastPick.getDepth(), lastPick.getDepth()));
            float baseY = this.block.scaleDepth(this.block.getBaseDepth());
            if ((double)Math.abs(baseY - lastPoint) > 0.1) {
                this.disconformities.add(new DrawZone(lastPoint, baseY, null, null, -1, -1, null, null, null, null, lastDepth, this.block.getBaseDepth()));
            }
        }
    }

    @Override
    String getCaption() {
        IGDScheme scheme = null;
        try {
            scheme = this.db.getIGDScheme(this.schID);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error getting scheme in PanelSQPicks", (SQLException)sql);
        }
        return "Sequences : " + (scheme != null ? scheme.toString() : "All Schemes");
    }

    @Override
    String getSubCaption() {
        String interpTitle = null;
        try {
            if (this.interpID >= 0) {
                interpTitle = this.block.well.getInterp(this.interpID).toString();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
        return interpTitle;
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        for (ChartObject chtPick : this.chartObjects) {
            try {
                ++nSamples;
                Sample.insert(samples, (Sample)chtPick.getSample(), (char)this.block.prop.units);
            }
            catch (SBException sbe) {}
        }
        return nSamples;
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        String row = "<td>";
        for (ChartObject chtPick : this.chartObjects) {
            SQPick pick = (SQPick)chtPick.o;
            if (pick.getSample() != sample) continue;
            if (this.p.drawDepths) {
                row = row + sample.toString(this.block.prop.units, false, false) + " ";
            }
            String name = pick.getName();
            if (pick.isQuestionable()) {
                name = "?" + name;
            }
            row = row + name;
            break;
        }
        row = row + "</td>";
        return row;
    }

    @Override
    ChartBlock getBlock() {
        return this.block;
    }

    public class SQPickEdit
    extends AbstractUndoableEdit {
        Sample oldSample;
        Sample newSample;
        SQPick pick;
        String presentationName = "move sequence pick";

        public SQPickEdit(Sample oldSample, Sample newSample, SQPick pick) {
            this.newSample = newSample;
            this.oldSample = oldSample;
            this.pick = pick;
        }

        @Override
        public void undo() {
            try {
                WellInterp interp = PanelSQPicks.this.block.well.getInterp(PanelSQPicks.this.interpID);
                SQPick temp = interp.addSQPick(PanelSQPicks.this.block.well, this.oldSample, this.pick.getSurface(), this.pick.getInfName(), this.pick.isQuestionable(), this.pick.getBnd());
                if (temp != null) {
                    interp.deleteSQPick(this.pick, PanelSQPicks.this.block.well.getWellID());
                    interp.notifyObservers((Object)this.pick);
                    this.pick = temp;
                }
                PanelSQPicks.this.db.commit();
            }
            catch (InvalidFieldException e) {
                SB.showStackError((String)"Error undoing sequence pick edit: ", (Exception)((Object)e));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error undoing sequence pick edit: ", (SQLException)sql);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error undoing sequence pick edit: ", (Exception)((Object)sbe));
            }
        }

        @Override
        public void redo() {
            try {
                WellInterp interp = PanelSQPicks.this.block.well.getInterp(PanelSQPicks.this.interpID);
                SQPick temp = interp.addSQPick(PanelSQPicks.this.block.well, this.newSample, this.pick.getSurface(), this.pick.getInfName(), this.pick.isQuestionable(), this.pick.getBnd());
                if (temp != null) {
                    interp.deleteSQPick(this.pick, PanelSQPicks.this.block.well.getWellID());
                    interp.notifyObservers((Object)this.pick);
                    this.pick = temp;
                }
                PanelSQPicks.this.db.commit();
            }
            catch (InvalidFieldException e) {
                SB.showStackError((String)"Error redoing sequence pick edit: ", (Exception)((Object)e));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error redoing sequence pick edit: ", (SQLException)sql);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error redoing sequence pick edit: ", (Exception)((Object)sbe));
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return this.presentationName;
        }
    }
}

