/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.LithologyPattern;
import jsbugs.PanelSampleLithologyProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithology;
import util.SB;
import util.SBException;

public class PanelSampleLithology
extends SBPanel
implements Observer {
    final SBdb sbdb;
    final WellBlock block;
    float[] samplePosition;
    List<Sample> samples = null;
    ChartProperties cp;
    private PanelSampleLithologyProperties p;

    public PanelSampleLithology(SBdb sbdb, WellBlock block) {
        this.block = block;
        this.sbdb = sbdb;
        this.p = new PanelSampleLithologyProperties();
        this.init();
    }

    public PanelSampleLithology(SBdb sbdb, WellBlock block, String props) {
        this.block = block;
        this.sbdb = sbdb;
        this.p = new PanelSampleLithologyProperties(props);
        this.init();
    }

    private void init() {
        this.block.well.addObserver((Observer)this);
    }

    @Override
    public PanelSampleLithologyProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, x + this.getWidth(bp), y + PanelSampleLithology.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(bp.max))) {
            return x + this.getWidth(bp);
        }
        this.cp = cp;
        g.setStroke(0.1f);
        try {
            this.moveSamplePositions(cp, bp);
            Iterator<Sample> it = this.samples.iterator();
            int i = 0;
            while (it.hasNext()) {
                float ypos1;
                Sample s = it.next();
                float truPos = y + PanelSampleLithology.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)this.block.well.getDepth(s, cp.correctDepths, cp.correctCuttings));
                g.drawLine(x, truPos, x + 1.5f, truPos);
                float ypos = this.samplePosition[i] + y + PanelSampleLithology.getPanelHeaderHeight(cp, mode);
                if (ypos > y + this.block.getHeight() + PanelSampleLithology.getPanelHeaderHeight(cp, mode) - this.p.pattHeight / 2.0f) {
                    ypos = y + this.block.getHeight() + PanelSampleLithology.getPanelHeaderHeight(cp, mode) - this.p.pattHeight;
                }
                if ((ypos1 = ypos - this.p.pattHeight / 2.0f) < y + PanelSampleLithology.getPanelHeaderHeight(cp, mode)) {
                    ypos1 = y + PanelSampleLithology.getPanelHeaderHeight(cp, mode);
                }
                if (g.isVisible(x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight)) {
                    LithologyPattern.drawList(s.getLithology().getLithology(), g, x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight, false, true, false);
                    g.setColor(Color.BLACK);
                    g.setStroke(0.1f);
                    g.drawLine(x + 1.5f, truPos, x + 3.0f, ypos);
                    g.drawRect(x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight);
                }
                ++i;
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        return x + this.getWidth(bp);
    }

    void moveSamplePositions(ChartProperties cp, BlockProperties bp) throws SBException, SQLException {
        float minDepth = bp == this.block.prop ? this.block.getTopDepth() : Math.min(bp.min, bp.max);
        float maxDepth = bp == this.block.prop ? this.block.getBaseDepth() : Math.max(bp.min, bp.max);
        this.samples = new LinkedList<Sample>();
        for (Sample sample : this.block.well.getSamples(cp.correctDepths, cp.correctCuttings)) {
            if (sample.getLithology().getLithology().isEmpty() || !(this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings) >= (double)minDepth) || !(this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings) < (double)maxDepth)) continue;
            this.samples.add(sample);
        }
        this.samplePosition = new float[this.samples.size()];
        int i = 0;
        for (Sample sample : this.samples) {
            this.samplePosition[i++] = this.block.scaleDepth((float)this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings));
        }
        if (this.samples.size() < 2) {
            return;
        }
        float hSampPosition = this.block.scaleDepth(this.block.getTopDepth()) + this.p.pattHeight / 2.0f;
        float lSampPosition = this.block.scaleDepth(this.block.getBaseDepth()) - this.p.pattHeight / 2.0f;
        PanelSampleLithology.moveSamplePositions(this.samples.size(), this.samplePosition, this.p.pattHeight, hSampPosition, lSampPosition);
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Iterator<Sample> it = this.samples.iterator();
        float bracket = this.p.pattHeight / 2.0f;
        try {
            while (it.hasNext()) {
                Sample sample = it.next();
                float ypos = this.block.scaleDepth((float)this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings));
                if (!(y > ypos - bracket) || !(y < ypos + bracket)) continue;
                return sample;
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            Sample s;
            if (o instanceof Sample && (s = (Sample)o).getLithology() != null) {
                return s.toString() + " (" + s.getLithology().toString() + ")";
            }
            return o.toString();
        }
        return null;
    }

    public String toString() {
        return "Sample Lithology";
    }

    @Override
    public String getCaption() {
        return "Sample Lithology";
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.block.well && arg instanceof SampleLithology) {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

