/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelSamplesProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHTML;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.Sample;
import util.SB;
import util.SBException;

public class PanelSamples
extends SBPanelHTML
implements Observer {
    WellBlock block;
    char discID;
    Float sampleWidth = Float.valueOf(30.0f);
    SBdb db;
    private PanelSamplesProperties p;
    private float[] origSamplePosition;
    private float[] samplePosition;
    private String[][] sampleString;
    private Sample[] plotSamples;

    public PanelSamples(SBdb db, WellBlock block) {
        this.block = block;
        this.db = db;
        this.p = new PanelSamplesProperties(db, "SAMPPPREF");
    }

    public PanelSamples(SBdb db, WellBlock block, String props) {
        this.block = block;
        this.db = db;
        this.p = new PanelSamplesProperties(props);
        this.init();
    }

    private void init() {
        this.block.well.addObserver((Observer)this);
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Samples";
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Samples";
    }

    public String toString() {
        return "Samples panel";
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, bp == this.block.prop ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelSamples.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height)) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        g.setStroke(0.1f);
        g.setFont(cp.font, 0, cp.fontSmall);
        try {
            float defaultWidth = this.sampleWidth.floatValue();
            if (this.block.prop != bp) {
                Integer begin = null;
                int end = 0;
                for (int i = 0; i < this.samplePosition.length; ++i) {
                    Sample s = this.plotSamples[i];
                    double sampleDepth = this.block.well.getDepth(s, cp.correctDepths, cp.correctCuttings);
                    if (!(sampleDepth > (double)bp.min) || !(sampleDepth <= (double)bp.max)) continue;
                    if (begin == null) {
                        begin = i;
                    }
                    if (i <= end) continue;
                    end = i;
                }
                if (begin != null && end - begin > 0) {
                    PanelSamples.drawSamples(g, y, xpos, cp, mode, this.p, Arrays.copyOfRange(this.samplePosition, (int)begin, ++end), Arrays.copyOfRange(this.origSamplePosition, (int)begin, end), (String[][])Arrays.copyOfRange(this.sampleString, (int)begin, end), null);
                }
            } else {
                PanelSamples.drawSamples(g, y, xpos, cp, mode, this.p, this.samplePosition, this.origSamplePosition, this.sampleString, null);
            }
            if (mode != Chart.Mode.NO_HEADER && (bp == this.block.prop || (double)Math.abs(this.block.getTopDepth() - bp.min) < 0.01) && (cp.correctDepths || cp.correctCuttings)) {
                boolean b = false;
                for (int i = 0; i < this.samplePosition.length; ++i) {
                    if (!Boolean.valueOf(this.sampleString[i][2]).booleanValue()) continue;
                    b = true;
                    break;
                }
                if (b) {
                    String s = "Displaying core-corrected depths for ";
                    if (cp.correctDepths) {
                        s = s + "CO";
                    }
                    if (cp.correctCuttings) {
                        if (cp.correctDepths) {
                            s = s + ", ";
                        }
                        s = s + "CU";
                    }
                    g.setFontSize(cp.fontTiny);
                    g.drawStringVertical(s, x + cp.fontTiny + 1.0f, y + PanelSamples.getPanelHeaderHeight(cp, mode) - 1.0f, cp.panelSubHeaderHeight, false, false);
                }
            }
            if (this.sampleWidth.floatValue() <= 0.0f) {
                this.sampleWidth = Float.valueOf(defaultWidth);
            }
            xpos += this.sampleWidth.floatValue();
        }
        catch (Exception se) {
            System.out.println("Warning: null sample depth");
            se.printStackTrace();
        }
        return xpos;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = 0.0f;
        return width += this.sampleWidth.floatValue();
    }

    @Override
    String getCaption() {
        return "Samples";
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    static void drawSamples(SBGraphics g, float y, float xpos, ChartProperties cp, Chart.Mode mode, PanelSamplesProperties p, float[] samplePosition, float[] origSamplePosition, String[][] sampleString, Float doubleDogleg) throws SBException {
        if (p == null) {
            p = new PanelSamplesProperties();
        }
        if (samplePosition.length != sampleString.length) {
            throw new SBException("Data has not been set correctly in PanelSamples");
        }
        g.setFont(cp.font, 0, cp.fontSmall);
        for (int i = 0; i < samplePosition.length; ++i) {
            float xposi = xpos;
            float ypos = y + PanelSamples.getPanelHeaderHeight(cp, mode) + origSamplePosition[i];
            g.drawLine(xposi, ypos, xposi += 2.0f, ypos);
            float ypos1 = y + PanelSamples.getPanelHeaderHeight(cp, mode) + samplePosition[i];
            g.drawLine(xposi, ypos, xposi += 2.0f, ypos1);
            float lineLength = p.drawSymbols ? 3.0f : 1.5f;
            g.drawLine(xposi, ypos1, xposi + lineLength, ypos1);
            if (Boolean.valueOf(sampleString[i][2]).booleanValue()) {
                g.drawLine(xposi + 0.5f, ypos1 - 0.5f, xposi + 0.5f, ypos1 + 0.5f);
            }
            if (p.drawSymbols) {
                if (sampleString[i][1].equals("CO")) {
                    g.fillEllipse(xposi + 2.0f, ypos1 - 0.5f, 1.0f, 1.0f, Color.BLACK);
                } else if (sampleString[i][0].equals("SC")) {
                    float[] xp = new float[]{xposi, xposi + 3.0f, xposi + 3.0f};
                    float[] yp = new float[]{ypos1, ypos1 - 0.5f, ypos1 + 0.5f};
                    g.fillPolygon(xp, yp, 3);
                }
            }
            xposi += lineLength;
            g.drawString(sampleString[i][0], xposi += 0.5f, ypos1 + g.stringHeightSB() / 2.0f);
            if (doubleDogleg == null) continue;
            float xposj = xpos + doubleDogleg.floatValue();
            g.drawLine(xposj, ypos, xposj -= 2.0f, ypos);
            g.drawLine(xposj, ypos, xposj -= 2.0f, ypos1);
            g.drawLine(xposi + (g.stringWidth(sampleString[i][0]) + 0.5f), ypos1, xposj, ypos1);
        }
    }

    static String[] getSampleString(Sample sample, ChartProperties cp, WellBlock block, PanelSamplesProperties p) {
        boolean shifted = false;
        String strg = "";
        if (p.drawDepths) {
            Double correctedTop = null;
            Double correctedBase = null;
            if (cp.correctDepths) {
                try {
                    if (Math.abs(sample.getDepth() - block.well.getDepth(sample, true, cp.correctCuttings)) > (double)0.0029f) {
                        correctedTop = sample.getTopDepth() != null ? Double.valueOf(block.well.getCorrectedDepth(sample.getTopDepth().doubleValue())) : null;
                        correctedBase = sample.getBaseDepth() != null ? Double.valueOf(block.well.getCorrectedDepth(sample.getBaseDepth().doubleValue())) : null;
                        shifted = true;
                    }
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error getting shift depth", (Exception)((Object)sbe));
                }
                catch (SQLException sql) {
                    SB.showStackError((String)"SQL Error", (SQLException)sql);
                }
            }
            strg = sample.toString(block.prop.units, !p.drawSymbols, false, !p.drawSymbols, p.drawRange, correctedTop, correctedBase);
            if (shifted && p.drawUnshifted) {
                strg = strg + " (" + sample.toString(block.prop.units, false, false, false, p.drawRange, null, null).trim() + ")";
            }
            if (p.drawSymbols && sample.getType().equals("LOG")) {
                strg = strg + " log";
            }
        }
        if (p.drawLabels && !sample.getLabel().isEmpty()) {
            strg = strg + " " + sample.getLabel();
        }
        return new String[]{strg, sample.getType(), Boolean.valueOf(shifted).toString()};
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        LinkedList<Sample> samples = new LinkedList<Sample>();
        for (Sample sample : this.block.well.getSamples(cp.correctDepths, cp.correctCuttings)) {
            if (!(this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings) >= (double)this.block.getTopDepth()) || !(this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings) <= (double)this.block.getBaseDepth()) || !this.p.useType(sample.getTypeString())) continue;
            samples.add(sample);
        }
        this.samplePosition = new float[samples.size()];
        this.sampleString = new String[samples.size()][2];
        this.plotSamples = new Sample[samples.size()];
        int i = 0;
        Iterator it = samples.iterator();
        float width = 30.0f;
        while (it.hasNext()) {
            Sample sample = (Sample)it.next();
            this.samplePosition[i] = this.block.scaleDepth((float)this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings));
            this.sampleString[i] = PanelSamples.getSampleString(sample, cp, this.block, this.p);
            this.plotSamples[i] = sample;
            float currentSampleWidth = SBGraphics.stringWidth(this.sampleString[i][0], cp.fontSmall) + 8.0f;
            if (currentSampleWidth > width) {
                width = currentSampleWidth + 2.0f;
            }
            ++i;
        }
        this.sampleWidth = Float.valueOf(width);
        this.origSamplePosition = Arrays.copyOf(this.samplePosition, this.samplePosition.length);
        if (samples.size() < 2 || !this.p.drawDepths && !this.p.drawLabels) {
            return;
        }
        PanelSamples.moveSamplePositions(cp, sections, this.block, this.samplePosition, this.plotSamples);
    }

    static void moveSamplePositions(ChartProperties cp, double[][] sections, WellBlock block, float[] samplePosition, Sample[] plotSamples) throws SQLException {
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int j = 0; j < sections.length - 1; ++j) {
                int k;
                for (k = pos; k < samplePosition.length && !(block.well.getDepth(plotSamples[k], cp.correctDepths, cp.correctCuttings) > sections[j + 1][1]); ++k) {
                }
                if (k - pos > 0) {
                    float[] section = Arrays.copyOfRange(samplePosition, pos, k);
                    float pos1 = (float)sections[j][0];
                    float pos2 = (float)sections[j + 1][0];
                    PanelSamples.moveSamplePositions(k - pos, section, cp.fontPanel, Math.min(pos1, pos2) + cp.fontPanel / 1.8f, Math.max(pos1, pos2) - cp.fontPanel / 1.8f);
                    System.arraycopy(section, 0, samplePosition, pos, k - pos);
                }
                pos = k;
            }
        } else {
            float hSampPosition = block.scaleDepth(block.getTopDepth()) + cp.fontPanel / 2.0f;
            float lSampPosition = block.scaleDepth(block.getBaseDepth()) - cp.fontPanel / 2.0f;
            PanelSamples.moveSamplePositions(samplePosition.length, samplePosition, cp.fontPanel, hSampPosition, lSampPosition);
        }
    }

    @Override
    public PanelSamplesProperties getProperties() {
        return this.p;
    }

    void setProperties(PanelSamplesProperties prop) {
        this.p = prop;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Sample) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        for (Sample sample : this.plotSamples) {
            try {
                Sample.insert(samples, (Sample)sample, (char)this.block.prop.units);
            }
            catch (SBException sbe) {
                // empty catch block
            }
        }
        return this.plotSamples.length;
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        String rowString = "<td>";
        Sample sample = samples.get(index);
        for (Sample plotSample : this.plotSamples) {
            if (!plotSample.equals(sample)) continue;
            rowString = rowString + PanelSamples.getSampleString(sample, cp, this.block, this.p)[0];
            break;
        }
        rowString = rowString + "</td>";
        return rowString;
    }

    @Override
    public int getType() {
        return 1;
    }
}

