/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartObject;
import jsbugs.ChartProperties;
import jsbugs.PanelProperties;
import jsbugs.PanelSequencesProperties;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHTML;
import model2.IGDIntervalZone;
import model2.SQPick;
import model2.Sample;
import model2.Surface;
import util.SB;
import util.SBException;

public abstract class PanelSequences
extends SBPanelHTML {
    PanelSequencesProperties p;
    List<ChartObject> chartObjects = new LinkedList<ChartObject>();

    void drawBoundaries(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, List<ChartObject> chartObjects) throws SBException {
        float lastY = y + PanelSequences.getPanelHeaderHeight(cp, mode);
        for (ChartObject obj : chartObjects) {
            String depthString;
            String name;
            int bnd;
            Surface.SurfaceType type;
            if (obj.o instanceof SQPick) {
                SQPick pick = (SQPick)obj.o;
                type = pick.getSurfaceType();
                bnd = pick.getBndInt();
                name = pick.getName();
                if (pick.isQuestionable()) {
                    name = "?" + name;
                }
                depthString = Sample.roundSampleDepth((double)SB.convFromM((double)(obj.corrDepth != null ? obj.corrDepth.doubleValue() : pick.getSample().getDepth()), (char)this.getBlock().prop.units), (String)pick.getSample().getTypeString());
            } else if (obj.o instanceof Surface) {
                Surface surface = (Surface)obj.o;
                type = surface.getType();
                bnd = 3;
                name = surface.getName();
                depthString = SB.floatString((double)surface.getAge(), (int)2);
            } else {
                throw new SBException("Unexpected ChartObject type in PanelSequences");
            }
            float yPick = obj.yPos + y + PanelSequences.getPanelHeaderHeight(cp, mode);
            switch (type) {
                case MFS: {
                    g.setColor(this.p.getHstColour());
                    break;
                }
                case SB: 
                case CC: {
                    g.setColor(this.p.getLstColour());
                    break;
                }
                case TS: {
                    g.setColor(this.p.getTstColour());
                }
            }
            if (IGDIntervalZone.isUnconformableBnd((int)bnd) && type != Surface.SurfaceType.MFS) {
                PanelZones.drawUnconfBoundary(bnd, x, x + this.p.columnWidth / 2.0f, yPick, g, PanelSequencesProperties.bndStroke, true, false, true);
                PanelZones.drawUnconfBoundary(bnd, x + this.p.columnWidth / 2.0f, x + this.p.columnWidth, yPick, g, PanelSequencesProperties.bndStroke, false, true, false);
            } else {
                PanelZones.drawBoundary(bnd, x, x + this.p.columnWidth, yPick, g, PanelSequencesProperties.bndStroke);
            }
            g.setColor(Color.BLACK);
            float padding = 0.3f;
            if (Math.abs(yPick - lastY) > cp.fontSmall) {
                g.setFont(cp.font, obj.o instanceof Surface ? 1 : 0, cp.fontSmall);
                g.drawString(name, x + this.p.columnWidth - g.stringWidth(name) - padding, yPick - PanelSequencesProperties.bndStroke * 3.0f);
                if (this.p.drawDepths && (!(obj.o instanceof Surface) || ((Surface)obj.o).getType() != Surface.SurfaceType.TS)) {
                    g.setFont(cp.font, 0, cp.fontTiny);
                    g.drawString(depthString, x + padding, yPick + cp.fontTiny + padding);
                }
            }
            lastY = yPick;
        }
    }

    Color getTractType(ChartObject o1, ChartObject o2) throws SBException, SQLException {
        Surface.SurfaceType s2type;
        Surface.SurfaceType s1type;
        Color colour = null;
        if (o1 == null || o2 == null) {
            return colour;
        }
        if (o1.o instanceof SQPick) {
            s1type = ((SQPick)o1.o).getSurface().getType();
            s2type = ((SQPick)o2.o).getSurface().getType();
        } else if (o1.o instanceof Surface) {
            s1type = ((Surface)o1.o).getType();
            s2type = ((Surface)o2.o).getType();
        } else {
            throw new SBException("Unexpected item in bagging area");
        }
        if (s1type == Surface.SurfaceType.MFS && s2type == Surface.SurfaceType.MFS) {
            return this.p.getHstColour();
        }
        if (s1type == Surface.SurfaceType.SB && s2type == Surface.SurfaceType.SB) {
            return this.p.getLstColour();
        }
        if (s1type == Surface.SurfaceType.SB && s2type == Surface.SurfaceType.TS) {
            return this.p.getTstColour();
        }
        if (s2type == Surface.SurfaceType.MFS && s1type != Surface.SurfaceType.SB || s2type == Surface.SurfaceType.TS && s1type != Surface.SurfaceType.MFS || (s2type == Surface.SurfaceType.SB || s2type == Surface.SurfaceType.CC) && (s1type == Surface.SurfaceType.SB || s1type == Surface.SurfaceType.CC)) {
            return null;
        }
        if (s2type == Surface.SurfaceType.MFS) {
            colour = this.p.getHstColour();
        } else if (s2type == Surface.SurfaceType.TS) {
            colour = this.p.getTstColour();
        } else if (s1type == Surface.SurfaceType.TS) {
            colour = this.p.getLstColour();
        } else if (s1type == Surface.SurfaceType.MFS) {
            colour = this.p.getTstColour();
        }
        return colour;
    }

    void drawPolygon(SBGraphics g, float x, float lastY, float thisY, Surface.SurfaceType lastType, Surface.SurfaceType thisType, int lastBnd, int thisBnd, Color tractColour, boolean reachedEnd, boolean lastPickInAnotherSubBlock) {
        float thisX;
        GeneralPath path = SBGraphics.createGeneralPath(x + this.p.columnWidth, lastY);
        SBGraphics.appendLine(path, x + this.p.columnWidth, thisY);
        float f = thisX = thisType == Surface.SurfaceType.MFS && !reachedEnd ? x : x + this.p.columnWidth / 2.0f;
        if (!reachedEnd && IGDIntervalZone.isUnconformableBnd((int)thisBnd)) {
            g.appendUnconf(path, x + this.p.columnWidth, thisX, thisY, thisBnd == 5, true, thisType == Surface.SurfaceType.MFS, false);
        } else {
            SBGraphics.appendLine(path, thisX, thisY);
        }
        float lastX = lastType == Surface.SurfaceType.MFS && !lastPickInAnotherSubBlock ? x : x + this.p.columnWidth / 2.0f;
        SBGraphics.appendLine(path, lastX, lastY);
        if (IGDIntervalZone.isUnconformableBnd((int)lastBnd)) {
            g.appendUnconf(path, lastX, x + this.p.columnWidth, lastY, lastBnd == 5, lastType == Surface.SurfaceType.MFS, true, false);
        } else {
            SBGraphics.appendLine(path, lastX, lastY);
        }
        Color shade = new Color(tractColour.getRed(), tractColour.getGreen(), tractColour.getBlue(), 85);
        shade = SB.removeAlpha((Color)shade);
        g.fillShape(path, shade);
    }

    abstract ChartBlock getBlock();

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }
}

