/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import jsbugs.PanelProperties;
import model2.Lastval;
import model2.SBdb;
import util.SB;

public class PanelSequencesProperties
implements PanelProperties,
Observer {
    static float bndStroke = 0.3f;
    float columnWidth = 40.0f;
    float unitsColWidth = 40.0f;
    float disconfColWidth = 40.0f;
    boolean drawDepths = false;
    boolean drawUnits = false;
    boolean drawTracts = true;
    boolean drawDisconformities = false;
    private Color hstColour;
    private Color tstColour;
    private Color lstColour;

    PanelSequencesProperties(SBdb db) {
        this.getColours(db);
        this.decode(db);
        db.addObserver((Observer)this);
    }

    PanelSequencesProperties(String props, SBdb sbdb) {
        this.getColours(sbdb);
        String[] s = props.split("\\|");
        block9: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block9;
                }
                case 1: {
                    this.unitsColWidth = Float.parseFloat(s[i]);
                    continue block9;
                }
                case 2: {
                    this.drawDepths = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 3: {
                    this.drawTracts = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 4: {
                    this.drawUnits = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 5: {
                    this.drawDisconformities = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 6: {
                    this.disconfColWidth = Float.parseFloat(s[i]);
                }
            }
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (arg instanceof Color) {
            this.getColours((SBdb)obs);
        }
    }

    PanelSequencesProperties(PanelSequencesProperties rhs) {
        this.columnWidth = rhs.columnWidth;
        this.unitsColWidth = rhs.unitsColWidth;
        this.drawDepths = rhs.drawDepths;
        this.drawTracts = rhs.drawTracts;
        this.drawUnits = rhs.drawUnits;
        this.hstColour = rhs.hstColour;
        this.tstColour = rhs.tstColour;
        this.lstColour = rhs.lstColour;
        this.drawDisconformities = rhs.drawDisconformities;
        this.disconfColWidth = rhs.disconfColWidth;
    }

    private void getColours(SBdb db) {
        try {
            this.hstColour = db.getCatColour("**HST", Color.RED);
            this.tstColour = db.getCatColour("**TST", Color.GREEN);
            this.lstColour = db.getCatColour("**LST", Color.BLUE);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error getting pick colours", (SQLException)sql);
        }
    }

    void encode(SBdb sbdb) {
        String string = this.getPrefs();
        try {
            Lastval.putString((SBdb)sbdb, (String)"SQPPANPREF", (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + this.getPrefs()));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + this.unitsColWidth, "" + (this.drawDepths ? 1 : 0), "" + (this.drawTracts ? 1 : 0), "" + (this.drawUnits ? 1 : 0), "" + (this.drawDisconformities ? 1 : 0), "" + this.disconfColWidth};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    private void decode(SBdb sbdb) {
        try {
            String params = Lastval.getString((SBdb)sbdb, (String)"SQPPANPREF");
            if (params.isEmpty()) {
                System.out.println("SQPicksPanel params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                this.columnWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.unitsColWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawDepths = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawTracts = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawUnits = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawDisconformities = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.disconfColWidth = Float.parseFloat(tok.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Color getHstColour() {
        return this.hstColour;
    }

    public Color getTstColour() {
        return this.tstColour;
    }

    public Color getLstColour() {
        return this.lstColour;
    }
}

