/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.Iterator;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelSubsidenceProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.LOC;
import model2.Sample;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

@Deprecated
public class PanelSubsidence
extends SBPanel {
    private final WellBlock block;
    private PanelSubsidenceProperties p;

    public PanelSubsidence(PanelSubsidenceProperties p, WellBlock block) {
        this.p = p;
        this.block = block;
    }

    public InterpHdr getInterp() {
        return this.p.interp;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float age = this.getAge(x);
        float depth = this.block.getDepth(y);
        return "(" + SB.floatString((float)age, (int)2) + " Ma) " + SB.floatString((float)depth, (int)3) + " " + this.getUnitAges(age, false);
    }

    String getUnitAges(double age, boolean top) {
        String strg = "";
        if (this.p.getScheme() != null) {
            try {
                IGDUnit unit = this.p.getScheme().findUnit(age, top);
                if (unit != null) {
                    strg = strg + " " + unit.getName();
                }
            }
            catch (SQLException ex) {
                strg = strg + ex.toString();
                ex.printStackTrace();
            }
        }
        return strg;
    }

    float getAge(float xpos) {
        float age = this.p.sBlock.prop.ageLeftToRight ? xpos / this.p.sBlock.prop.scale + this.p.sBlock.prop.min : this.p.sBlock.prop.max - xpos / this.p.sBlock.prop.scale;
        return age;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        try {
            if (this.p.sBlock != null) {
                this.p.sBlock.drawHorz(g, x, y + cp.panelCaptionHeight, cp);
            }
            if (this.p.getScheme() != null) {
                this.p.scheme.loadUnits();
                this.drawSchemeShading(g, cp, x, y + cp.panelCaptionHeight, this.getWidth(bp) - this.p.indexAreaWidth, y + cp.getPanelHeaderHeight(), bp);
            }
            if (this.p.interp != null && this.p.project != null) {
                Color[] colours = this.getColours();
                this.drawLOCs(g, x, y, cp, bp, colours, mode);
            }
            g.setColor(Color.BLACK);
            g.setStroke(0.2f);
            float xRight = x + this.getWidth(bp);
            g.drawLine(xRight - this.p.indexAreaWidth, y + cp.panelCaptionHeight, xRight - this.p.indexAreaWidth, y + bp.height + cp.getPanelHeaderHeight());
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        finally {
            return this.getWidth(bp);
        }
    }

    @Override
    String getCaption() {
        String caption = this.p.project.getName() + " Subsidence";
        if (this.p.getScheme() != null) {
            caption = caption + " : " + this.p.getScheme().toString();
        }
        return caption;
    }

    private void drawSchemeShading(SBGraphics g, ChartProperties cp, float x, float y, float width, float chartY, BlockProperties bp) {
        if (this.p.sBlock == null) {
            return;
        }
        PanelIGDScheme ipanel = null;
        for (SBPanel panel : this.p.sBlock.panels) {
            if (!(panel instanceof PanelIGDScheme)) continue;
            ipanel = (PanelIGDScheme)panel;
            break;
        }
        if (ipanel == null) {
            return;
        }
        int hier = 0;
        for (int i = 0; i < ipanel.getProperties().getMaxHier(); ++i) {
            if (!ipanel.getProperties().plotHier[i]) continue;
            hier = i;
        }
        ++hier;
        for (IGDUnit unit : ipanel.scheme.getUnitsX()) {
            float x2;
            if (!(unit.getLage() > (double)this.p.sBlock.prop.min) || !(unit.getUage() < (double)this.p.sBlock.prop.max) || unit.getHier() != hier) continue;
            float x1 = this.getXPos((float)unit.getUage(), this.p.sBlock.prop);
            if (x1 > (x2 = this.getXPos((float)unit.getLage(), this.p.sBlock.prop))) {
                float temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (x1 < 0.0f) {
                x1 = 0.0f;
            }
            if (x2 > width) {
                x2 = width;
            }
            Color colour = new Color(unit.getColour().getRed(), unit.getColour().getGreen(), unit.getColour().getBlue(), 85);
            g.setColor(colour);
            g.fillRect(x1 += x, chartY, (x2 += x) - x1, bp.height);
        }
    }

    private Color[] getColours() {
        if (this.p.project == null) {
            return null;
        }
        Color[] colours = new Color[this.p.project.getSize()];
        int colourInc = 0x1000000 / (this.p.project.getSize() + 4);
        Color c = null;
        for (int i = 0; i < colours.length; ++i) {
            c = c == null ? Color.BLACK : new Color(c.getRGB() + colourInc);
            colours[i] = c;
        }
        return colours;
    }

    private void drawLOCs(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Color[] colours, Chart.Mode mode) throws SBException, SQLException {
        float symbolSize = 1.3f;
        Iterator it = this.p.project.getWellIterator();
        int index = 0;
        while (it.hasNext()) {
            Well well = (Well)it.next();
            WellInterp wellInterp = well.getInterp(this.p.interp.getInterpID());
            g.setColor(colours[index]);
            if (wellInterp == null) continue;
            float lastX = this.p.sBlock.prop.ageLeftToRight ? 99999.0f : 0.0f;
            float lastY = 0.0f;
            g.setStroke(0.6f);
            float lastDepth = 0.0f;
            float lastAge = 0.0f;
            boolean first = true;
            Rectangle2D.Float boundary = new Rectangle2D.Float(this.p.sBlock.prop.min, this.block.getTopDepth(), this.p.sBlock.prop.max - this.p.sBlock.prop.min, this.block.getBaseDepth() - this.block.getTopDepth());
            LOC locLine = wellInterp.getLOC();
            if (locLine != null) {
                Iterator nit = locLine.getNodeIterator();
                while (nit.hasNext()) {
                    Line2D.Float line;
                    LOC.LOCNode loc = (LOC.LOCNode)nit.next();
                    double TDtvd = well.getTVDlist(false).getTVD(well.getTD()).getTVDepth();
                    double LOCtvd = well.getTVDlist(false).getTVD(loc.getDepth()).getTVDepth();
                    float depth = (float)(TDtvd - LOCtvd);
                    if (!first && boundary.intersectsLine(line = new Line2D.Float(lastAge, lastDepth, (float)loc.getAge(), depth)) && g.clipLine(line, this.p.sBlock.prop.min, this.block.getTopDepth(), this.p.sBlock.prop.max, this.block.getBaseDepth())) {
                        float x1 = this.getXPos(line.x1, this.p.sBlock.prop) + x;
                        float y1 = this.block.scaleDepth(line.y1) + y + cp.getPanelHeaderHeight();
                        float x2 = this.getXPos(line.x2, this.p.sBlock.prop) + x;
                        float y2 = this.block.scaleDepth(line.y2) + y + cp.getPanelHeaderHeight();
                        g.drawLine(x1, y1, x2, y2);
                        if (this.p.sBlock.prop.ageLeftToRight) {
                            if (x1 < lastX || x2 < lastX) {
                                lastX = x2;
                                lastY = y2;
                            }
                        } else if (x1 > lastX || x2 > lastX) {
                            lastX = x2;
                            lastY = y2;
                        }
                    }
                    first = false;
                    lastDepth = depth;
                    lastAge = (float)loc.getAge();
                }
            }
            g.setStroke(0.25f);
            for (WellEvent event : wellInterp.getEvents()) {
                if (!this.p.plotEvent(event)) continue;
                float depth = (float)this.block.well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings);
                depth = well.getTVDlist(false).getTVD((double)depth).getTVDepth().floatValue();
                int evID = event.getEvent().getEvID();
                float age = (float)this.p.cmpStd.getAge(evID, event.getTypeObj());
                if (!(depth <= this.block.getBaseDepth()) || !(depth >= this.block.getTopDepth()) || !(age >= this.p.sBlock.prop.min) || !(age <= this.p.sBlock.prop.max)) continue;
                float yPos = this.block.scaleDepth(depth) + y + PanelSubsidence.getPanelHeaderHeight(cp, mode);
                float xPos = x + this.getXPos(age, this.p.sBlock.prop);
                switch (event.getTypeObj()) {
                    case TOP: {
                        g.drawLine(xPos, yPos - 1.3f, xPos, yPos + 1.3f);
                        g.drawLine(xPos - 1.3f, yPos, xPos + 1.3f, yPos);
                        break;
                    }
                    case BASE: {
                        g.drawEllipse(xPos - 0.65f, yPos - 0.65f, 1.3f, 1.3f);
                        break;
                    }
                    case SINGLE: {
                        g.drawLine(xPos - 1.3f, yPos - 1.3f, xPos + 1.3f, yPos + 1.3f);
                        g.drawEllipse(xPos - 0.65f, yPos - 0.65f, 1.3f, 1.3f);
                    }
                }
            }
            float yHeader = y + cp.getPanelHeaderHeight() + cp.fontPanel;
            g.setFont(cp.font, 0, cp.fontPanel);
            g.drawString("" + (index + 1) + " " + well.getWellName(), x + 5.0f + this.getWidth(bp) - this.p.indexAreaWidth, yHeader);
            yHeader += cp.fontPanel;
            g.drawString("" + (index + 1), lastX + (float)(this.p.sBlock.prop.ageLeftToRight ? -5 : 1), lastY);
        }
    }

    private void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, Color[] colours) throws SBException, SQLException {
        if (this.p.cmpStd == null || this.p.interp == null || this.p.project == null) {
            return;
        }
        float symbolSize = 1.3f;
        g.setStroke(0.25f);
        Iterator wellIterator = this.p.project.getWellIterator();
        int index = -1;
        while (wellIterator.hasNext()) {
            Well well = (Well)wellIterator.next();
            WellInterp wellInterp = well.getInterp(this.p.interp.getInterpID());
            if (wellInterp == null) continue;
            g.setColor(colours[++index]);
        }
    }

    private boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = (this.p.sBlock.prop.max - this.p.sBlock.prop.min) * this.p.sBlock.prop.scale;
        return width += this.p.indexAreaWidth;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    void setData() throws SQLException, SBException {
    }

    @Override
    public PanelSubsidenceProperties getProperties() {
        return this.p;
    }

    public void setProperties(PanelSubsidenceProperties p) {
        this.p = p;
    }
}

