/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelProperties;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SBException;

public class PanelSubsidenceProperties
implements PanelProperties {
    SchemeBlock sBlock = new SchemeBlock();
    CompositeStandard cmpStd;
    IGDScheme scheme;
    InterpHdr interp;
    Project project;
    float indexAreaWidth = 45.0f;
    boolean drawShading = true;

    PanelSubsidenceProperties(PanelSubsidenceProperties rhs) {
        this.interp = rhs.interp;
        this.project = rhs.project;
        this.indexAreaWidth = rhs.indexAreaWidth;
        this.drawShading = rhs.drawShading;
        this.sBlock = rhs.sBlock;
        this.scheme = rhs.scheme;
        this.cmpStd = rhs.cmpStd;
    }

    PanelSubsidenceProperties(SBdb sbdb) {
        this.decode(sbdb);
    }

    public void encode(SBdb sbdb) {
        String string = new String();
        String[] props = new String[]{"" + this.interp.getInterpID(), "" + (this.scheme != null ? this.scheme.getID() : -1), "" + (this.project != null ? this.project.getID() : -1), "" + this.sBlock.prop.min, "" + this.sBlock.prop.max, "" + this.sBlock.prop.scale, "" + (this.sBlock.prop.ageLeftToRight ? 1 : 0), "" + (this.drawShading ? 1 : 0), "" + (this.cmpStd != null ? this.cmpStd.getStdID() : -1)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)sbdb, (String)"SUBSCHPREF", (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb) {
        try {
            int stdID;
            int projectID;
            int schID;
            String params = Lastval.getString((SBdb)sbdb, (String)"SUBSCHPREF");
            if (params.isEmpty()) {
                System.out.println("SubsidencePanel params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                int interpID = Integer.parseInt(tok.nextToken());
                this.interp = sbdb.getInterp(interpID);
            }
            if (tok.hasMoreTokens() && (schID = Integer.parseInt(tok.nextToken())) >= 0) {
                this.scheme = sbdb.getIGDScheme(schID);
                if (this.scheme != null) {
                    this.scheme.loadUnits();
                    this.sBlock.addScheme(this.scheme);
                }
            }
            if (tok.hasMoreTokens() && (projectID = Integer.parseInt(tok.nextToken())) >= 0) {
                this.project = sbdb.getProject(projectID);
            }
            if (tok.hasMoreTokens()) {
                this.sBlock.prop.min = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.sBlock.prop.max = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.sBlock.prop.scale = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.sBlock.prop.ageLeftToRight = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawShading = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens() && (stdID = Integer.parseInt(tok.nextToken())) > 0) {
                this.cmpStd = sbdb.getCompositeStandard(stdID);
                if (this.cmpStd != null) {
                    this.cmpStd.loadEvents();
                    this.sBlock.addCompositeStandard(this.cmpStd, sbdb);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Finished decoding subsidence chart");
    }

    public void setInterp(InterpHdr interp, boolean resetAgeRange) throws SBException, SQLException {
        if (this.interp != interp) {
            this.interp = interp;
        }
        if (interp != null) {
            Iterator it = this.project.getWellIterator();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                well.loadInterps();
                WellInterp wellInterp = well.getAddInterp(interp);
                well.loadInterp(wellInterp);
                if (!resetAgeRange || this.scheme == null) continue;
                float min = (float)wellInterp.getMinAge(this.scheme);
                float max = (float)wellInterp.getMaxAge(this.scheme);
                if (min > 0.0f && min < this.sBlock.prop.min) {
                    this.sBlock.prop.min = min;
                }
                if (!(max > 0.0f) || !(max > this.sBlock.prop.max)) continue;
                this.sBlock.prop.max = max;
            }
        }
    }

    public void setCmpStd(CompositeStandard std, SBdb sbdb) throws SQLException {
        if (this.cmpStd != std) {
            if (std != null) {
                std.loadEvents();
            }
            if (this.sBlock != null) {
                boolean found = false;
                ListIterator it = this.sBlock.panels.listIterator();
                while (it.hasNext()) {
                    SBPanel o = (SBPanel)it.next();
                    if (!(o instanceof PanelCompositeStandard) || ((PanelCompositeStandard)o).cmpStd != this.cmpStd) continue;
                    PanelCompositeStandard p = (PanelCompositeStandard)o;
                    if (std != null) {
                        p.cmpStd = std;
                    } else {
                        it.remove();
                    }
                    found = true;
                }
                if (!found) {
                    this.sBlock.addPanel(new PanelCompositeStandard(std, sbdb, this.sBlock));
                }
            }
            this.cmpStd = std;
        }
    }

    IGDScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(IGDScheme scheme) throws SQLException {
        if (scheme != this.scheme) {
            if (scheme != null) {
                scheme.loadUnits();
            }
            if (this.sBlock != null) {
                if (this.scheme != null) {
                    ListIterator it = this.sBlock.panels.listIterator();
                    while (it.hasNext()) {
                        SBPanel o = (SBPanel)it.next();
                        if (!(o instanceof PanelIGDScheme) || ((PanelIGDScheme)o).scheme != this.scheme) continue;
                        it.remove();
                    }
                }
                if (scheme != null) {
                    this.sBlock.panels.add(new PanelIGDScheme(scheme, this.sBlock));
                }
            }
            this.scheme = scheme;
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean plotEvent(WellEvent e) {
        if (this.sBlock != null) {
            for (SBPanel p : this.sBlock.panels) {
                PanelCompositeStandard pcs;
                if (!(p instanceof PanelCompositeStandard) || (pcs = (PanelCompositeStandard)p).getStd() != this.cmpStd) continue;
                return pcs.getProperties().plotEvent(e.getEvent(), e.getDiscIDTaxon(), e.getTypeObj());
            }
        }
        return this.cmpStd != null;
    }
}

