/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartObject;
import jsbugs.ChartProperties;
import jsbugs.PanelSequences;
import jsbugs.PanelSequencesProperties;
import jsbugs.SBGraphics;
import jsbugs.SchemeBlock;
import model2.IGDScheme;
import model2.Sample;
import model2.Surface;
import util.SBException;

public class PanelSurfaces
extends PanelSequences {
    private IGDScheme scheme;
    SchemeBlock block;

    public PanelSurfaces(IGDScheme scheme, SchemeBlock block) {
        this.scheme = scheme;
        this.block = block;
        this.p = new PanelSequencesProperties(scheme.getDatabase());
    }

    public PanelSurfaces(IGDScheme scheme, SchemeBlock block, String prefs) {
        this.scheme = scheme;
        this.block = block;
        this.p = new PanelSequencesProperties(prefs, scheme.getDatabase());
    }

    public void setProperties(PanelSequencesProperties p) {
        this.p = p;
    }

    IGDScheme getScheme() {
        return this.scheme;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float BRACKET = 2.5f / zoom;
        for (ChartObject chartObject : this.chartObjects) {
            float yPos = chartObject.yPos;
            if (!(yPos - BRACKET < y) || !(yPos + BRACKET > y)) continue;
            return chartObject.o;
        }
        return null;
    }

    public String toString() {
        return "Surfaces " + (this.scheme != null ? " - " + this.scheme.toString() : "");
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof Surface) {
            return ((Surface)o).toString();
        }
        return null;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.columnWidth;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, x + this.p.columnWidth, bp.height)) {
            return x + this.getWidth(bp);
        }
        this.drawSurfaces(g, x, y, cp, bp, mode);
        return x + this.getWidth(bp);
    }

    @Override
    String getCaption() {
        return this.scheme.toString();
    }

    @Override
    String getSubHeader() {
        return "Systems Tracts and Surfaces";
    }

    private void drawSurfaces(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        this.chartObjects.clear();
        if (bp.scaleType != BlockProperties.ScaleType.AGE && (this.block.interp == null || this.block.interp.getLOC() == null)) {
            return;
        }
        double minAge = this.block.getMinAge();
        double maxAge = this.block.getMaxAge();
        Iterator it = null;
        try {
            it = this.scheme.getSurfaces().iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (it.hasNext()) {
            Surface surface = (Surface)it.next();
            float age = (float)surface.getAge();
            if (!((double)age >= minAge) || !((double)age <= maxAge)) continue;
            Float[] positions = this.block.calcPlotPositions(age);
            if (positions == null) {
                System.out.println("it's null!");
                continue;
            }
            Float[] arr$ = positions;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float position = arr$[i$].floatValue();
                this.chartObjects.add(new ChartObject(surface, position));
            }
        }
        Collections.sort(this.chartObjects);
        try {
            if (this.p.drawTracts) {
                this.drawPolygons(g, x, y, cp, mode);
            }
            this.drawBoundaries(g, x, y, cp, mode, this.chartObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawPolygons(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SBException, SQLException {
        ChartObject lastObj = null;
        for (ChartObject obj : this.chartObjects) {
            if (lastObj == null) {
                lastObj = obj;
                continue;
            }
            Color tractColour = this.getTractType(lastObj, obj);
            if (tractColour == null) {
                lastObj = obj;
                continue;
            }
            Surface surface = (Surface)obj.o;
            Surface lastSurface = (Surface)lastObj.o;
            this.drawPolygon(g, x, lastObj.yPos + y + PanelSurfaces.getPanelHeaderHeight(cp, mode), obj.yPos + y + PanelSurfaces.getPanelHeaderHeight(cp, mode), lastSurface.getType(), surface.getType(), 3, 3, tractColour, false, false);
            lastObj = obj;
        }
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        return 0;
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        return null;
    }

    @Override
    ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public int getIdentifier() {
        return this.scheme.getID();
    }
}

