/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartObject;
import jsbugs.ChartObjectCompareDepth;
import jsbugs.ChartProperties;
import jsbugs.DrawZone;
import jsbugs.PanelProperties;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonProperties;
import jsbugs.PanelTaxonPropertiesBase;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SubBlockProperties;
import jsbugs.TickScheme;
import jsbugs.WellBlock;
import model2.AbnScheme;
import model2.Category;
import model2.CompositeStandard;
import model2.Discipline;
import model2.Genus;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.ImageSet;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.TxGroupSet;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelTaxon
extends PanelTaxonBase
implements Observer {
    private PanelTaxonProperties p;
    private static final int PA_COUNT = 5;
    TxGroupSet filter_set = null;
    TxGroup filter_group = null;
    Category filter_cat = null;
    Taxon filter_spec = null;
    boolean includeSubCats = true;
    private int nTracks;
    private int nCurves;
    private float[][][] curveData;
    private String[][] curveLabels;
    Color[][] colours;
    private List<TaxonTrack> tracks = new LinkedList<TaxonTrack>();
    private LinkedList<SBPanel.ChartImage> images;
    private LinkedList<DrawZone> intervals;
    private ChartObject[][] events;
    List<Integer> specTypes = null;

    @Override
    public PanelTaxonProperties getProperties() {
        return this.p;
    }

    @Override
    PanelTaxonPropertiesBase getPanelTaxonProperties() {
        return this.p;
    }

    @Override
    void setProperties(PanelProperties pp) {
        if (pp instanceof PanelTaxonProperties) {
            this.p = (PanelTaxonProperties)pp;
            return;
        }
        throw new IllegalArgumentException("Wrong properties type for PanelTaxon: " + pp);
    }

    private Color getDefaultColour() {
        if (this.p.inheritFilterColour) {
            if (this.filter_cat != null) {
                return this.filter_cat.getColour();
            }
            if (this.filter_group != null) {
                return this.filter_group.getColour();
            }
        }
        return this.p.colour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Observable o, Object arg) {
        try {
            if (o instanceof TaxonOcc && arg instanceof ImageSet) {
                this.updateImage((TaxonOcc)o);
            } else if (o instanceof WellInterp) {
                if (o != this.getBlock().getInterp()) {
                    o.deleteObserver(this);
                    return;
                }
                if (arg == null) {
                    return;
                }
                if (arg instanceof WellEvent || arg.getClass() == Integer.class && ((Integer)arg).equals(20)) {
                    if (!this.p.drawEvents) {
                        return;
                    }
                } else if (arg instanceof IGDIntervalZone) {
                    IGDIntervalZone zone = (IGDIntervalZone)arg;
                    if (zone.getSchID() != this.p.interpSchID) {
                        return;
                    }
                } else {
                    if (arg.getClass() != Integer.class) return;
                    if (this.p.interpSchID <= 0 || this.getDb().getIGDScheme(this.p.interpSchID) == null) return;
                    IGDScheme scheme = this.getDb().getIGDScheme(this.p.interpSchID);
                    if (!((Integer)arg).equals(scheme.getIGDType())) {
                        return;
                    }
                }
            } else if (!(o instanceof TxGroup) && !(o instanceof TxGroupSet)) {
                System.out.println("PanelTaxon rejected update (" + this.getCaption() + "),  obs is: " + o + " and arg is:" + arg);
                return;
            }
            this.setChanged();
            this.notifyObservers();
            return;
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            return;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
            return;
        }
        catch (IOException sbe) {
            SB.showStackError((String)"Error", (Exception)sbe);
        }
    }

    final WellBlock getBlock() {
        return this.parent.getBlock();
    }

    final SBdb getDb() {
        return this.parent.getDb();
    }

    @Override
    TxGroup getFilterGroup() {
        return this.filter_group;
    }

    @Override
    Category getFilterCat() {
        return this.filter_cat;
    }

    @Override
    boolean getIncludeSubCats() {
        return this.includeSubCats;
    }

    @Override
    TxGroupSet getFilterSet() {
        return this.filter_set;
    }

    @Override
    Taxon getFilterSpec() {
        return this.filter_spec;
    }

    PanelTaxon(PanelTaxonGroup parent, PanelTaxonProperties p) {
        super(parent);
        this.p = p == null ? new PanelTaxonProperties(parent.getDb()) : p;
    }

    PanelTaxon(PanelTaxonGroup parent, Discipline discID, LinkedList<Chart.ChartPref> panelProps) throws SBException, SQLException {
        super(parent);
        ListIterator it = panelProps.listIterator();
        String props = null;
        while (it.hasNext()) {
            Chart.ChartPref pref = (Chart.ChartPref)it.next();
            if (!pref.key.endsWith("P")) continue;
            props = pref.value;
            it.remove();
            break;
        }
        if (props != null) {
            this.decode(this.getDb(), props);
        }
        this.p = new PanelTaxonProperties(this.getDb(), discID, panelProps, this.getBlock().well, parent);
    }

    private void decode(SBdb sbdb, String props) throws SQLException {
        String[] s = props.split("\\|");
        block5: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    int ID;
                    int n = ID = s[i].isEmpty() ? 0 : Integer.parseInt(s[i]);
                    if (ID <= 0) continue block5;
                    if (i == 0) {
                        this.filter_set = sbdb.getTxGroupSet(ID);
                        continue block5;
                    }
                    if (i == 1) {
                        this.filter_group = sbdb.getTxGroup(ID);
                        continue block5;
                    }
                    if (i != 2) continue block5;
                    this.filter_spec = sbdb.getTaxon(ID);
                    continue block5;
                }
                case 3: {
                    if (s[i].isEmpty()) continue block5;
                    this.filter_cat = sbdb.getCategory(s[i]);
                    continue block5;
                }
                case 4: {
                    this.includeSubCats = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return o.toString();
        }
        if (o instanceof PanelTaxonObject) {
            PanelTaxonObject pto = (PanelTaxonObject)o;
            if (pto.track.object instanceof Taxon && pto.smpdtl != null) {
                Taxon t = (Taxon)pto.track.object;
                String strg = pto.smpdtl.getOccurString(t);
                if (!strg.isEmpty()) {
                    strg = "<html><b>" + pto.track.name + " " + pto.sample.toString(bp.units) + "  " + pto.smpdtl.getHeader().toString() + " (" + strg + ")</b>";
                }
                if (this.p.drawEvents && this.events != null) {
                    block2: for (int nTrack = 0; nTrack < this.tracks.size(); ++nTrack) {
                        if (this.tracks.get(nTrack) != pto.track || this.events[nTrack] == null) continue;
                        for (ChartObject co : this.events[nTrack]) {
                            try {
                                if (co.getSample() != pto.sample) continue;
                                strg = strg + "<br>" + ((WellEvent)co.o).toString(true, true, false);
                            }
                            catch (SBException sbe) {
                                sbe.printStackTrace();
                            }
                            break block2;
                        }
                    }
                }
                if (!strg.isEmpty()) {
                    return strg + "</html>";
                }
            }
            return pto.track.name + "  " + pto.sample.toString(bp.units);
        }
        if (o instanceof TaxonTrack) {
            TaxonTrack t = (TaxonTrack)o;
            String s = "";
            if (t.hasHeaderData()) {
                s = " (";
                if (t.minAge != null) {
                    s = s + SB.floatString((double)t.minAge, (int)2).trim() + "Ma ";
                }
                if (t.unit1 != null) {
                    s = s + t.unit1;
                }
                if (t.unit2 != null) {
                    s = s + (t.unit1 != null ? " - " : "") + t.unit2;
                }
                if (t.maxAge != null) {
                    s = s + (!s.isEmpty() ? " " : "") + SB.floatString((double)t.maxAge, (int)2).trim() + "Ma";
                }
                s = s + ")";
            }
            s = t.name + s;
            return s;
        }
        if (o instanceof Sample) {
            Sample sample = (Sample)o;
            return sample.toString(bp.units);
        }
        if (o instanceof SBPanel.ChartImage) {
            SBPanel.ChartImage ci = (SBPanel.ChartImage)o;
            TaxonOcc occ = (TaxonOcc)ci.object;
            String retString = occ.getTaxon().toString(false, false, true);
            retString = retString + " (" + occ.toAbnString() + ")";
            return "Image: " + retString;
        }
        assert (false);
        return null;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float xPos = 0.0f;
        Iterator<TaxonTrack> it = this.tracks.iterator();
        TaxonTrack track = null;
        while (it.hasNext()) {
            TaxonTrack t = it.next();
            if (x > xPos && x <= xPos + t.width) {
                track = t;
                break;
            }
            xPos += t.width;
        }
        if (track == null && this.p.showImages && this.images != null) {
            for (SBPanel.ChartImage image : this.images) {
                if (!(y > image.movedTop) || !(y < image.movedTop + image.height)) continue;
                return image;
            }
            return null;
        }
        Smpdtl dtl = this.parent.getSample(y, zoom, bp);
        if (dtl != null && track != null) {
            return new PanelTaxonObject(track, dtl.getSample(), dtl);
        }
        if (track != null) {
            return track;
        }
        return null;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        return x;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, Integer iKey) {
        if (!g.isVisible(x, bp == this.getBlock().prop ? y : this.getBlock().scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelTaxon.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height + (bp == this.getBlock().prop ? PanelTaxon.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        if (this.intervals != null) {
            this.drawIGD(g, xpos, y, cp, bp, mode, this.getTracksWidth());
        }
        if (this.p.grid) {
            this.drawGrid(g, xpos, y, cp, bp, mode);
        }
        xpos = x;
        boolean firstOrOnlyBlock = this.getBlock().prop == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01;
        float lineTop = firstOrOnlyBlock ? y + PanelTaxon.getPanelHeaderHeight(cp, mode) : Math.min(this.getBlock().scaleDepth(bp.min), this.getBlock().scaleDepth(bp.max)) + y + PanelTaxon.getPanelHeaderHeight(cp, mode);
        float lineBase = lineTop + bp.height;
        Iterator<TaxonTrack> it = this.tracks.iterator();
        int nTrack = 0;
        g.setStroke(0.1f);
        g.setFont(cp.font, 0, cp.fontSmall);
        Map<AttributedCharacterIterator.Attribute, Object> atts = PanelTaxon.getAttributes(g);
        while (it.hasNext()) {
            TaxonTrack track = it.next();
            g.setColor(Color.BLACK);
            if (firstOrOnlyBlock && mode != Chart.Mode.NO_HEADER) {
                try {
                    this.drawHeader(g, cp, y, xpos, track, nTrack, atts, iKey);
                    if (iKey != null) {
                        Integer n = iKey;
                        Integer n2 = iKey = Integer.valueOf(iKey + 1);
                    }
                }
                catch (SQLException sql) {
                    System.out.println("Error drawing panel taxon header for track " + track.name);
                    sql.printStackTrace();
                }
            }
            if (this.p.justify == PanelTaxonProperties.Justify.CENTRE && this.p.plot_style != PanelTaxonProperties.Plot.NUMBERS) {
                if (!this.p.abn_style.setSemiQuant()) {
                    g.drawLine(xpos + track.width / 2.0f, lineTop, xpos + track.width / 2.0f, lineBase);
                }
            } else {
                g.drawLine(xpos + track.width, lineTop, xpos + track.width, lineBase);
            }
            this.drawScaleTicks(g, bp, xpos, y + PanelTaxon.getPanelHeaderHeight(cp, mode) + (firstOrOnlyBlock ? 0.0f : this.getBlock().scaleDepth(bp.getNormal() ? bp.min : bp.max)), track.width);
            if (this.p.stratRange && this.p.track_style == PanelTaxonProperties.Track.SINGLE) {
                this.drawStratigraphicRange(g, bp, xpos, y + PanelTaxon.getPanelHeaderHeight(cp, mode), nTrack, track.width, firstSample, lastSample);
            }
            g.setFont(cp.font, 0, cp.fontTiny);
            if (firstSample != lastSample) {
                switch (this.p.plot_style) {
                    case HIST: {
                        this.drawHistograms(g, cp, y + PanelTaxon.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample);
                        break;
                    }
                    case SAWTOOTH: {
                        this.drawSawtooth(g, y + PanelTaxon.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample, true);
                        if (!this.p.sawtoothEnhanced) break;
                    }
                    case CURVE: {
                        this.drawSawtooth(g, y + PanelTaxon.getPanelHeaderHeight(cp, mode), xpos, nTrack, track.width, firstSample, lastSample, false);
                        break;
                    }
                    case NUMBERS: {
                        this.drawLabels(g, xpos, y + PanelTaxon.getPanelHeaderHeight(cp, mode), nTrack, track.width, firstSample, lastSample);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.p.drawEvents && this.events != null && this.p.justify != PanelTaxonProperties.Justify.CENTRE) {
                this.drawEvents(g, xpos, y + PanelTaxon.getPanelHeaderHeight(cp, mode), nTrack, track.width, bp);
            }
            xpos += track.width;
            ++nTrack;
        }
        if (firstOrOnlyBlock) {
            float hdrtextpos = y + cp.panelCaptionHeight + cp.fontSmall;
            if (this.parent.size() > 1) {
                hdrtextpos += this.parent.getInnerPanelCaptionHeight(cp);
            }
            if (this.parent.alphabeticKey()) {
                hdrtextpos += cp.panelSubHeaderHeight / 2.0f;
            }
            g.setFont(cp.font, 0, cp.fontSmall);
            try {
                if (this.p.subgroup != PanelTaxonProperties.SubGroup.NONE) {
                    this.drawSubGroupHeader(g, x, hdrtextpos, cp, bp);
                    hdrtextpos += cp.fontSmall;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                hdrtextpos += cp.fontSmall;
            }
            if (this.p.highlightGroup != null && this.p.group == PanelTaxonProperties.Group.SPEC) {
                g.setColor(this.p.highlightColour);
                g.drawString("Highlighted: " + this.p.highlightGroup.toString(), x + 1.0f, hdrtextpos, this.getWidth(bp), 1);
                g.setColor(Color.BLACK);
                hdrtextpos += cp.fontSmall;
            }
            if (this.p.normaliseWeight) {
                g.drawString("Normalised to " + this.p.normalWeight + "g", x + 1.0f, hdrtextpos);
            }
        }
        try {
            if (this.p.showImages && this.images != null && !this.images.isEmpty()) {
                this.drawImagesPanel(g, y, xpos, bp, cp, mode);
                xpos += this.p.imageWidth;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xpos;
    }

    @Override
    String getCaption() {
        return this.getCaption(true);
    }

    @Override
    String getSubCaption() {
        String hdr = "";
        if (!this.parent.subTypesInCaption()) {
            hdr = hdr + this.getSubTypeHeader();
        }
        if (!this.parent.abnStyleInCaption()) {
            hdr = hdr + this.getAbnHeader();
        }
        return hdr;
    }

    String getAbnHeader() {
        String hdr = "";
        if (this.p.abn_style != PanelTaxonProperties.Abundance.MIX) {
            hdr = hdr + this.p.abn_style.toString();
        }
        switch (this.p.calc_style) {
            case ABS: {
                hdr = hdr + ")";
                break;
            }
            case RELATIVE: {
                if (!hdr.isEmpty()) {
                    hdr = hdr + ", ";
                }
                hdr = hdr + "% panel)";
                break;
            }
            case RELATIVE_OUTER: {
                if (!hdr.isEmpty()) {
                    hdr = hdr + ", ";
                }
                hdr = hdr + "% " + this.parent.getDataDescriptor() + ")";
                break;
            }
            case RICHNESS: {
                if (!hdr.isEmpty()) {
                    hdr = hdr + ", ";
                }
                hdr = hdr + "richness)";
                break;
            }
            case SHANNON: {
                if (!hdr.isEmpty()) {
                    hdr = hdr + ", ";
                }
                hdr = hdr + "diversity)";
            }
        }
        hdr = "(" + hdr;
        if (hdr.trim().length() == 2) {
            hdr = "";
        }
        return hdr;
    }

    String getSubTypeHeader() {
        if (this.p.subTypes != null) {
            try {
                String specType = "";
                for (int i = 0; i < this.p.subTypes.size(); ++i) {
                    specType = i == 0 ? specType + ": " : (i == this.p.subTypes.size() - 1 ? specType + " and " : specType + ", ");
                    specType = specType + this.getDb().getSpecType(((Integer)this.p.subTypes.get(i)).intValue());
                }
                return specType;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    String getDataInclusionDescriptor() {
        String hdr = "";
        if (!(this.p.includeCv && this.p.includeQ && this.p.includeRw && this.p.includeUnqualified)) {
            if (this.p.includeUnqualified) {
                hdr = hdr + "unqualified";
            }
            if (this.p.includeRw) {
                hdr = hdr + (hdr.isEmpty() ? "" : ", ") + "Rw";
            }
            if (this.p.includeQ) {
                hdr = hdr + (hdr.isEmpty() ? "" : ", ") + "?";
            }
            if (this.p.includeCv) {
                hdr = hdr + (hdr.isEmpty() ? "" : ", ") + "Cv";
            }
        }
        if (!hdr.isEmpty()) {
            hdr = "(" + hdr + ")";
        }
        return hdr;
    }

    @Override
    boolean hasFilter() {
        return this.filter_cat != null || this.filter_group != null || this.filter_set != null || this.filter_spec != null;
    }

    private void drawSubGroupHeader(SBGraphics g, float xpos, float ypos, ChartProperties cp, BlockProperties bp) throws SBException, SQLException {
        String strg = "Sub-Groups: ";
        String[] subgroups = this.getSubgroups();
        if (subgroups.length == 1) {
            return;
        }
        Color[] sgColours = new Color[subgroups.length];
        Color colour = !this.p.group.hasColours() ? (this.p.colourSuites ? (this.parent.suites != null && this.parent.suites.size() == 1 ? this.parent.suites.get(0).getColour() : Color.BLACK) : this.getDefaultColour()) : Color.BLACK;
        for (int i = 0; i < subgroups.length; ++i) {
            if (i > 0) {
                strg = strg + ", ";
            }
            strg = strg + subgroups[i];
            sgColours[i] = colour;
            colour = SB.getLighterColour((Color)colour);
        }
        AttributedString attString = new AttributedString(strg);
        attString.addAttributes(PanelTaxon.getAttributes(g), 0, attString.getIterator().getEndIndex());
        for (int j = 0; j < subgroups.length; ++j) {
            try {
                int begin = strg.indexOf(subgroups[j]);
                int end = begin + subgroups[j].length();
                attString.addAttribute(TextAttribute.FOREGROUND, sgColours[j], begin, end);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g.drawString(attString, xpos + 1.0f, ypos, this.getWidth(bp));
    }

    private void drawHeader(SBGraphics g, ChartProperties cp, float y, float xpos, TaxonTrack track, int nTrack, Map<AttributedCharacterIterator.Attribute, Object> atts, Integer iKey) throws SQLException {
        block29: {
            boolean baseIndent;
            int leftIndent;
            block27: {
                float textPos;
                float ref;
                float ageUnit;
                block28: {
                    g.setFont(cp.font, 0, cp.fontSmall);
                    leftIndent = 1;
                    baseIndent = true;
                    if (this.p.track_style != PanelTaxonProperties.Track.SINGLE) break block27;
                    float ageSpace = 0.0f;
                    ageUnit = 8.5f;
                    if (this.p.cmpStdID > 0) {
                        ageSpace += ageUnit * 2.0f;
                    }
                    if (this.p.schID > 0) {
                        ageSpace += ageUnit * 2.0f;
                    }
                    ref = y + cp.panelCaptionHeight + (this.parent.alphabeticKey() ? cp.panelSubHeaderHeight / 2.0f : 0.0f);
                    float refPlus = 0.0f;
                    try {
                        if (this.p.subgroup != PanelTaxonProperties.SubGroup.NONE && this.getSubgroups().length > 1) {
                            refPlus = cp.fontSmall + 1.5f;
                            ref += refPlus;
                        }
                        if (this.parent.size() > 1) {
                            ref += (refPlus += this.parent.getInnerPanelCaptionHeight(cp));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    switch (this.p.justify) {
                        default: {
                            textPos = xpos + cp.fontSmall;
                            break;
                        }
                        case CENTRE: {
                            textPos = xpos + track.width / 2.0f + g.stringHeightSB() / 2.0f;
                            break;
                        }
                        case RIGHT: {
                            textPos = xpos + track.width - (cp.fontSmall - g.stringHeightSB());
                        }
                    }
                    if (track.attName != null) {
                        boolean highlight;
                        float basePos = y + cp.getPanelHeaderHeight() - (float)baseIndent;
                        boolean bl = highlight = this.p.highlightGroup != null && track.object instanceof Taxon && this.p.highlightGroup.isMember(((Taxon)track.object).getSpecID());
                        if (this.p.hdr_cat || iKey != null) {
                            if (highlight) {
                                g.setColor(this.p.highlightColour);
                            }
                            if (iKey != null) {
                                g.drawStringVertical("" + iKey, textPos, basePos);
                                basePos -= 6.0f;
                            }
                            if (this.p.hdr_cat) {
                                g.drawStringVertical(track.getToken(0), textPos, basePos, basePos - ref - ageSpace, false, false);
                                basePos -= 11.0f;
                            }
                            if (highlight) {
                                g.setColor(Color.BLACK);
                            }
                        }
                        g.setFont(cp.font, 2, cp.fontSmall);
                        track.attName.addAttributes(atts, 0, track.attName.getIterator().getEndIndex());
                        if (highlight) {
                            track.attName.addAttribute(TextAttribute.FOREGROUND, this.p.highlightColour);
                        }
                        g.drawStringVertical(track.attName, textPos, basePos, basePos - ref - (track.hasHeaderData() ? ageSpace : 0.0f));
                    } else {
                        float basePos = y + cp.getPanelHeaderHeight() - (float)baseIndent;
                        if (iKey != null) {
                            g.drawStringVertical("" + iKey, textPos, basePos);
                            basePos -= 6.0f;
                        }
                        g.drawStringVertical(track.name, textPos, basePos, cp.panelSubHeaderHeight - (track.hasHeaderData() ? ageSpace + 1.0f + refPlus : 0.0f), false, false);
                    }
                    g.setStroke(0.1f);
                    g.setFont(cp.font, 0, cp.fontSmall);
                    if (track.maxAge != null) {
                        g.drawRect(xpos, ref + ageSpace - ageUnit, track.width, ageUnit);
                        g.drawStringVertical(SB.floatString((double)track.maxAge, (int)1).trim(), textPos, ref + ageSpace, ageUnit, false, true);
                    }
                    if (track.minAge != null) {
                        g.drawRect(xpos, ref, track.width, ageUnit);
                        g.drawStringVertical(SB.floatString((double)track.minAge, (int)1).trim(), textPos, ref + ageUnit, ageUnit, false, true);
                    }
                    if (!(track.unit2 != null ^ track.unit1 != null)) break block28;
                    g.fillRect(xpos, ref + (track.unit2 != null && track.minAge == null ? 0.0f : ageUnit), track.width, track.maxAge == null || track.minAge == null ? ageUnit * 3.0f : ageUnit * 2.0f, track.unit2 != null ? track.col2 : track.col1);
                    g.drawStringVertical(track.unit2 != null ? track.unit2 : track.unit1, textPos, ref + ageSpace - ageUnit, ageUnit * 2.0f, false, true);
                    break block29;
                }
                if (track.unit2 != null) {
                    g.setColor(track.col2);
                    g.fillRect(xpos, ref + ageUnit * 2.0f, track.width, ageUnit);
                    g.setColor(Color.BLACK);
                    g.drawStringVertical(track.unit2, textPos, ref + ageUnit * 3.0f, ageUnit, false, true);
                }
                if (track.unit1 != null) {
                    g.setColor(track.col1);
                    g.fillRect(xpos, ref + ageUnit, track.width, ageUnit);
                    g.setColor(Color.BLACK);
                    g.drawStringVertical(track.unit1, textPos, ref + ageUnit * 2.0f, ageUnit, false, true);
                }
                if (track.unit2 != null && track.unit1 != null) {
                    g.drawStringVertical("-", textPos, ref + ageUnit * 2.0f + g.stringWidth("-") / 2.0f, ageUnit, false, false);
                }
                if (track.unit2 == null && track.unit1 == null) break block29;
                g.drawRect(xpos, ref + ageUnit, track.width, ageUnit * 2.0f);
                break block29;
            }
            float boxHeight = g.stringHeightSB();
            float ypos = y + cp.getPanelHeaderHeight() - (float)baseIndent;
            Color[] fillColours = new Color[track.curveNames.length];
            if (this.p.colourSuites) {
                Color baseColour = this.parent.suites != null && this.parent.suites.size() == 1 ? this.parent.suites.get(0).getColour() : Color.BLACK;
                PanelTaxon.fillColourArray(baseColour, fillColours);
            } else {
                fillColours = this.colours[nTrack];
            }
            for (int i = track.curveNames.length - 1; i > -1; --i) {
                Color fillColour = fillColours[i] == null ? this.getDefaultColour() : fillColours[i];
                g.fillRect(xpos + (float)leftIndent, ypos - boxHeight, boxHeight, boxHeight, fillColour);
                g.drawString(track.curveNames[i], xpos + boxHeight + (float)(leftIndent * 2), ypos, track.width - boxHeight - (float)(leftIndent * 2), 1);
                ypos = (float)((double)ypos - (double)cp.fontSmall * 1.5);
            }
        }
    }

    private void drawHistograms(SBGraphics g, ChartProperties cp, float y, float xpos, int nTrack, float trackWidth, int firstSample, int lastSample) {
        float hHist = 2.5f;
        for (int nSample = firstSample; nSample < lastSample; ++nSample) {
            for (int nCurve = this.nCurves - 1; nCurve > -1; --nCurve) {
                Color c;
                float curveValue = this.curveData[nSample][nTrack][nCurve];
                if (!(curveValue > 0.0f)) continue;
                float ypos = y + this.parent.getSamplePosition(nSample);
                boolean wasCutoff = false;
                if (curveValue > this.p.cutoff) {
                    wasCutoff = true;
                    curveValue = this.p.cutoff;
                }
                Color color = c = this.p.colourSuites ? this.colours[nSample][nCurve] : this.colours[nTrack][nCurve];
                if (c == null) {
                    c = this.getDefaultColour();
                }
                float barWidth = curveValue * this.p.horzScale;
                switch (this.p.justify) {
                    case LEFT: {
                        g.fillRect(xpos, ypos - 1.25f, barWidth, 2.5f, c);
                        break;
                    }
                    case CENTRE: {
                        float centre = xpos + trackWidth / 2.0f;
                        g.fillRect(centre - barWidth / 2.0f, ypos - 1.25f, barWidth, 2.5f, c);
                        break;
                    }
                    case RIGHT: {
                        g.fillRect(xpos + trackWidth - barWidth, ypos - 1.25f, barWidth, 2.5f, c);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (!wasCutoff) continue;
                g.setStroke(0.1f);
                curveValue *= this.p.horzScale;
                float[] ypoints = new float[]{ypos - 2.5f, ypos, ypos + 2.5f};
                switch (this.p.justify) {
                    case LEFT: 
                    case CENTRE: {
                        float[] xpoints = new float[]{xpos + curveValue - 1.0f, xpos + curveValue, xpos + curveValue - 1.0f};
                        g.fillPolygon(xpoints, ypoints, 3, c);
                    }
                }
                switch (this.p.justify) {
                    case CENTRE: 
                    case RIGHT: {
                        float[] xpointsRight = new float[]{xpos + 1.0f, xpos, xpos + 1.0f};
                        g.fillPolygon(xpointsRight, ypoints, 3, c);
                    }
                }
            }
        }
        if (this.p.track_style == PanelTaxonProperties.Track.SINGLE) {
            this.drawLabels(g, xpos, y, nTrack, trackWidth, firstSample, lastSample);
        }
    }

    private void drawSawtooth(SBGraphics g, float y, float xpos, int nTrack, float trackWidth, int firstSample, int lastSample, boolean fill) {
        GeneralPath[] gp = null;
        int enhance = 1;
        if (!fill) {
            gp = new GeneralPath[this.nCurves];
            if (this.p.plot_style == PanelTaxonProperties.Plot.SAWTOOTH) {
                enhance = this.p.sawtoothEnhancement;
            }
        }
        for (int nSample = firstSample; nSample < lastSample; ++nSample) {
            float[] xp = new float[5];
            float[] yp = new float[5];
            float ypos = y + this.parent.getSamplePosition(nSample);
            if (nSample == 0) {
                if (!(this.curveData[nSample][nTrack][0] > 0.0f)) continue;
                float width = this.curveData[nSample][nTrack][0] * this.p.horzScale;
                if (width > this.p.maxWidth) {
                    width = this.p.maxWidth;
                }
                if (!fill) continue;
                switch (this.p.justify) {
                    case LEFT: {
                        g.drawLine(xpos, ypos, xpos + width, ypos);
                        break;
                    }
                    case RIGHT: {
                        g.drawLine(xpos + trackWidth, ypos, xpos + trackWidth - width, ypos);
                        break;
                    }
                    case CENTRE: {
                        g.drawLine(xpos + trackWidth / 2.0f - width / 2.0f, ypos, xpos + trackWidth / 2.0f + width / 2.0f, ypos);
                    }
                }
                continue;
            }
            float yposTop = y + this.parent.getSamplePosition(nSample - 1);
            boolean secondPolygon = false;
            float[] total0 = new float[this.nCurves];
            float[] total1 = new float[this.nCurves];
            for (int i = 0; i < this.nCurves; ++i) {
                total0[i] = this.curveData[nSample - 1][nTrack][i] * (float)enhance;
                total1[i] = this.curveData[nSample][nTrack][i] * (float)enhance;
            }
            float yposTop2 = 0.0f;
            float ypos2 = 0.0f;
            if (ypos - yposTop > this.p.sawtoothCutoff) {
                yposTop = ypos - this.p.sawtoothCutoff / 2.0f;
                yposTop2 = y + this.parent.getSamplePosition(nSample - 1);
                ypos2 = yposTop2 + this.p.sawtoothCutoff / 2.0f;
                secondPolygon = true;
            }
            float pxpos = this.p.justify == PanelTaxonProperties.Justify.CENTRE ? xpos + trackWidth / 2.0f : xpos;
            for (int i = this.nCurves - 1; i > -1; --i) {
                GeneralPath segment;
                float[] newypoints;
                float[] newxpoints;
                Color c = this.colours[nTrack][i];
                if (c == null) {
                    c = this.getDefaultColour();
                }
                if (total1[i] > 0.0f || !secondPolygon && total1[i] == 0.0f && total0[i] > 0.0f) {
                    float topWidth = secondPolygon && total0[i] > 0.0f && Math.abs(total1[i] - total0[i]) > 0.0f ? Math.min(total0[i], total1[i]) + Math.abs(total1[i] - total0[i]) / 2.0f : total0[i];
                    this.setPolygonPoints(xp, yp, pxpos, topWidth, yposTop, total1[i], ypos, trackWidth);
                    if (this.p.justify == PanelTaxonProperties.Justify.CENTRE) {
                        newxpoints = new float[8];
                        newypoints = new float[8];
                        this.centrePolygonPoints(xp, yp, newxpoints, newypoints, pxpos);
                        xp = newxpoints;
                        yp = newypoints;
                    }
                    if (fill) {
                        g.fillPolygon(xp, yp, xp.length, c);
                    } else {
                        segment = SBGraphics.createGeneralPath(xp[1], yp[1]);
                        if (Math.abs(xp[2] - xp[1]) > 0.0f || Math.abs(xp[2] - xp[3]) > 0.0f) {
                            SBGraphics.appendLine(segment, xp[2], yp[2]);
                        }
                        SBGraphics.appendLine(segment, xp[3], yp[3]);
                        if (gp[i] == null) {
                            gp[i] = segment;
                        } else {
                            gp[i].append(segment, false);
                        }
                    }
                }
                if (!secondPolygon || !(total0[i] > 0.0f)) continue;
                float topWidth2 = Math.abs(total1[i] - total0[i]) > 0.0f && total1[i] > 0.0f ? Math.min(total0[i], total1[i]) + Math.abs(total1[i] - total0[i]) / 2.0f : total1[i];
                this.setPolygonPoints(xp, yp, pxpos, total0[i], yposTop2, topWidth2, ypos2, trackWidth);
                if (this.p.justify == PanelTaxonProperties.Justify.CENTRE) {
                    newxpoints = new float[8];
                    newypoints = new float[8];
                    this.centrePolygonPoints(xp, yp, newxpoints, newypoints, pxpos);
                    xp = newxpoints;
                    yp = newypoints;
                }
                if (fill) {
                    g.fillPolygon(xp, yp, xp.length, c);
                    continue;
                }
                segment = SBGraphics.createGeneralPath(xp[1], yp[1]);
                if (Math.abs(xp[2] - xp[1]) > 0.0f || Math.abs(xp[2] - xp[3]) > 0.0f) {
                    SBGraphics.appendLine(segment, xp[2], yp[2]);
                }
                SBGraphics.appendLine(segment, xp[3], yp[3]);
                if (gp[i] == null) {
                    gp[i] = segment;
                    continue;
                }
                gp[i].append(segment, false);
            }
        }
        if (gp != null) {
            if (this.p.plot_style == PanelTaxonProperties.Plot.CURVE) {
                g.setStroke(0.3f, 0, 1);
            } else {
                g.setStroke(0.1f, 0, 1);
            }
            for (int i = 0; i < this.nCurves; ++i) {
                GeneralPath path = gp[i];
                if (path == null) continue;
                Color c = this.colours[nTrack][i];
                if (c == null) {
                    this.getDefaultColour();
                }
                g.setColor(c);
                g.drawShape(path);
            }
        }
        if (this.p.track_style == PanelTaxonProperties.Track.SINGLE) {
            this.drawLabels(g, xpos, y, nTrack, trackWidth, firstSample, lastSample);
        }
    }

    private void setPolygonPoints(float[] xp, float[] yp, float xpos, float topVal, float yposTop, float baseVal, float yposBase, float trackWidth) {
        float cutoff = trackWidth / this.p.horzScale;
        if (this.p.justify == PanelTaxonProperties.Justify.CENTRE) {
            topVal = topVal > cutoff ? cutoff / 2.0f : topVal / 2.0f;
            baseVal = baseVal > cutoff ? cutoff / 2.0f : baseVal / 2.0f;
        }
        yp[0] = yposTop;
        xp[0] = xpos;
        yp[1] = yposTop;
        xp[1] = topVal > cutoff ? xpos + trackWidth : xpos + topVal * this.p.horzScale;
        if (topVal > cutoff && baseVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposTop;
            xp[3] = xpos + trackWidth;
            yp[3] = yposBase;
        } else if (topVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposBase - (yposBase - yposTop) * (trackWidth / (topVal * this.p.horzScale));
            xp[3] = xpos + baseVal * this.p.horzScale;
            yp[3] = yposBase;
        } else if (baseVal > cutoff) {
            xp[2] = xpos + trackWidth;
            yp[2] = yposTop + (yposBase - yposTop) * (trackWidth / (baseVal * this.p.horzScale));
            xp[3] = xpos + trackWidth;
            yp[3] = yposBase;
        } else {
            xp[2] = xpos + topVal * this.p.horzScale;
            yp[2] = yposTop;
            xp[3] = xpos + baseVal * this.p.horzScale;
            yp[3] = yposBase;
        }
        xp[4] = xpos;
        yp[4] = yposBase;
        if (this.p.justify == PanelTaxonProperties.Justify.RIGHT) {
            xp[0] = xp[0] + trackWidth;
            xp[1] = xpos + trackWidth - (xp[1] - xpos);
            xp[2] = xpos + trackWidth - (xp[2] - xpos);
            xp[3] = xpos + trackWidth - (xp[3] - xpos);
            xp[4] = xp[4] + trackWidth;
        }
    }

    private void centrePolygonPoints(float[] xpoints, float[] ypoints, float[] newxpoints, float[] newypoints, float xpos) {
        System.arraycopy(xpoints, 0, newxpoints, 0, 5);
        newxpoints[5] = xpos - (xpoints[3] - xpos);
        newxpoints[6] = xpos - (xpoints[2] - xpos);
        newxpoints[7] = xpos - (xpoints[1] - xpos);
        System.arraycopy(ypoints, 0, newypoints, 0, 5);
        newypoints[5] = ypoints[3];
        newypoints[6] = ypoints[2];
        newypoints[7] = ypoints[1];
    }

    private void drawLabels(SBGraphics g, float xpos, float y, int nTrack, float trackWidth, int firstSample, int lastSample) {
        for (int nSamp = firstSample; nSamp < lastSample; ++nSamp) {
            float x;
            Color c;
            String label = this.curveLabels[nSamp][nTrack];
            if (label == null) continue;
            float ypos = y + this.parent.getSamplePosition(nSamp) + g.stringHeightSB() / 2.0f;
            Color color = c = this.p.colourSuites ? this.colours[nSamp][0] : this.colours[nTrack][0];
            if (c == null) {
                c = this.getDefaultColour();
            }
            g.setColor(this.p.colourLabels ? c : Color.BLACK);
            float data = this.curveData[nSamp][nTrack][this.nCurves - 1];
            float pad = 0.4f;
            switch (this.p.justify) {
                case CENTRE: {
                    if (data > 0.0f && this.p.plot_style != PanelTaxonProperties.Plot.NUMBERS && (g.stringWidth(label) + 0.4f < data * this.p.horzScale || g.stringWidth(label) + 0.4f > trackWidth / 2.0f - data * this.p.horzScale / 2.0f)) {
                        g.setColorContrasting(c);
                        x = xpos + trackWidth / 2.0f - g.stringWidth(label) / 2.0f;
                        break;
                    }
                    if (data == 0.0f || this.p.plot_style == PanelTaxonProperties.Plot.NUMBERS) {
                        x = xpos + trackWidth / 2.0f - g.stringWidth(label) / 2.0f;
                        break;
                    }
                    x = xpos + trackWidth / 2.0f + data * this.p.horzScale / 2.0f + 0.4f;
                    break;
                }
                default: {
                    if (data > this.p.cutoff) {
                        if (this.p.plot_style != PanelTaxonProperties.Plot.CURVE) {
                            g.setColorContrasting(c);
                        }
                        if (this.p.justify == PanelTaxonProperties.Justify.RIGHT) {
                            x = xpos + 0.4f;
                            break;
                        }
                        x = xpos + trackWidth - g.stringWidth(label) - 1.0f;
                        break;
                    }
                    if (data > 0.0f && data * this.p.horzScale + 0.4f + g.stringWidth(label) > trackWidth && g.stringWidth(label) + 0.4f < data * this.p.horzScale) {
                        if (this.p.plot_style != PanelTaxonProperties.Plot.CURVE) {
                            g.setColorContrasting(c);
                        }
                        if (this.p.justify == PanelTaxonProperties.Justify.RIGHT) {
                            x = xpos + trackWidth - data * this.p.horzScale + 0.4f;
                            break;
                        }
                        x = xpos + data * this.p.horzScale - g.stringWidth(label) - 0.4f;
                        break;
                    }
                    x = this.p.justify == PanelTaxonProperties.Justify.RIGHT ? xpos + trackWidth - data * this.p.horzScale - g.stringWidth(label) - 0.4f : xpos + data * this.p.horzScale + 0.4f;
                }
            }
            int fontStyle = g.getFont().getStyle();
            if (label.equalsIgnoreCase("+")) {
                g.setFontStyle(1);
            }
            g.drawString(label, x, ypos);
            g.setFontStyle(fontStyle);
        }
    }

    private void drawEvents(SBGraphics g, float x, float y, int nTrack, float trackWidth, BlockProperties bp) {
        ChartObject[] evs = this.events[nTrack];
        if (evs == null) {
            return;
        }
        g.setColor(Color.BLACK);
        float arrowHeight = 0.8f;
        float indent = 1.0f;
        for (ChartObject co : evs) {
            if (bp != this.getBlock().prop && (!(co.corrDepth >= (double)bp.min) || !(co.corrDepth <= (double)bp.max))) continue;
            boolean left = this.p.justify == PanelTaxonProperties.Justify.RIGHT;
            float xPos = left ? x + 0.1f : x + trackWidth - 0.1f;
            float[] xP = new float[3];
            float[] yP = new float[3];
            yP[0] = y + co.yPos;
            WellEvent ev = (WellEvent)co.o;
            switch (ev.getTypeObj()) {
                case BASE: {
                    yP[1] = yP[0] - 0.8f;
                    yP[2] = yP[0];
                    break;
                }
                case TOP: {
                    yP[1] = yP[0] + 0.8f;
                    yP[2] = yP[0];
                    break;
                }
                case SINGLE: {
                    yP[1] = yP[0] - 0.4f;
                    yP[2] = yP[0] + 0.4f;
                }
            }
            g.drawLine(xPos, yP[0], left ? (xPos = xPos + 1.0f) : (xPos = xPos - 1.0f), yP[0]);
            xP[0] = xP[1] = xPos;
            xP[2] = left ? (xPos = xPos + 2.0f) : (xPos = xPos - 2.0f);
            g.fillPolygon(xP, yP, 3, Color.BLACK);
            if (co.plotName.isEmpty()) continue;
            float stringPos = yP[0];
            switch (ev.getTypeObj()) {
                case TOP: {
                    stringPos += g.stringHeightSB();
                    break;
                }
                case SINGLE: {
                    stringPos += g.stringHeightSB() / 2.0f;
                }
            }
            switch (this.p.justify) {
                case LEFT: 
                case CENTRE: {
                    xPos -= g.stringWidth(co.plotName) + 0.2f;
                    break;
                }
                case RIGHT: {
                    xPos += 0.2f;
                }
            }
            g.drawString(co.plotName, xPos, stringPos);
        }
    }

    private void drawStratigraphicRange(SBGraphics g, BlockProperties bp, float xpos, float y, int nTrack, float trackWidth, int firstSample, int lastSample) {
        TaxonTrack track = this.tracks.get(nTrack);
        if (track.nSampleTop == null || track.nSampleBase == null) {
            return;
        }
        if (track.nSampleBase > -1 && track.nSampleBase < firstSample || track.nSampleTop > -1 && track.nSampleTop >= lastSample) {
            return;
        }
        boolean firstOrOnlySubBlock = true;
        if (bp instanceof SubBlockProperties && (double)Math.abs(this.getBlock().getTopDepth() - bp.min) > 0.01) {
            firstOrOnlySubBlock = false;
        }
        float yTop = track.nSampleTop < 0 || track.nSampleTop < firstSample ? y + (firstOrOnlySubBlock ? 0.0f : this.getBlock().scaleDepth(((SubBlockProperties)bp).normal ? bp.min : bp.max)) : y + this.parent.getSamplePosition(track.nSampleTop);
        float yBase = track.nSampleBase < 0 || track.nSampleBase >= lastSample ? y + bp.height + (firstOrOnlySubBlock ? 0.0f : this.getBlock().scaleDepth(((SubBlockProperties)bp).normal ? bp.min : bp.max)) : y + this.parent.getSamplePosition(track.nSampleBase);
        g.setStroke(0.1f);
        if ((double)Math.abs(yTop - yBase) > 0.01) {
            float barWidth = 0.35f;
            float arrowWidth = 0.8f;
            float arrowHeight = 2.0f;
            if (this.p.justify == PanelTaxonProperties.Justify.CENTRE) {
                float[] ypos;
                float centre = xpos + trackWidth / 2.0f;
                g.fillRect(centre - 0.175f, yTop, 0.35f, yBase - yTop, Color.WHITE);
                float[] x = new float[]{centre - 0.35f, centre + 0.35f, centre + 0.35f + 0.4f, centre - 0.35f - 0.4f};
                if (track.nSampleTop < 0 && firstOrOnlySubBlock) {
                    ypos = new float[]{y, y, y + 2.0f, y + 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
                if (track.nSampleBase < 0 && (bp == this.getBlock().prop || (double)Math.abs(this.getBlock().getBaseDepth() - bp.max) < 0.01)) {
                    ypos = new float[]{yBase, yBase, yBase - 2.0f, yBase - 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
            } else {
                float[] ypos;
                float[] x;
                g.drawRect(xpos, yTop, 0.35f, yBase - yTop);
                if (track.nSampleTop < 0 && firstOrOnlySubBlock) {
                    x = new float[]{xpos, xpos + 0.35f, xpos + 0.35f + 0.8f, xpos};
                    ypos = new float[]{y, y, y + 2.0f, y + 2.0f};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
                if (track.nSampleBase < 0 && (bp == this.getBlock().prop || (double)Math.abs(this.getBlock().getBaseDepth() - bp.max) < 0.01)) {
                    x = new float[]{xpos, xpos + 0.35f + 0.8f, xpos + 0.35f, xpos};
                    ypos = new float[]{yBase - 2.0f, yBase - 2.0f, yBase, yBase};
                    g.fillPolygon(x, ypos, 4, Color.WHITE);
                }
            }
        }
    }

    private void drawIGD(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, float totalWidth) {
        x += 0.1f;
        totalWidth -= 0.2f;
        for (DrawZone i : this.intervals) {
            if (bp != this.getBlock().prop && (!(i.topDepth >= (double)bp.min) || !(i.baseDepth <= (double)bp.max))) continue;
            if (i.lowColour != null) {
                g.paintRect(x, Math.min(i.getYTop(), i.getYBase()) + y + PanelTaxon.getPanelHeaderHeight(cp, mode), totalWidth, Math.abs(i.getYBase() - i.getYTop()), i.uppColour, i.lowColour);
                continue;
            }
            g.setColor(i.uppColour);
            g.fillRect(x, Math.min(i.getYTop(), i.getYBase()) + y + PanelTaxon.getPanelHeaderHeight(cp, mode), totalWidth, Math.abs(i.getYBase() - i.getYTop()));
        }
        g.setColor(Color.BLACK);
    }

    private void drawScaleTicks(SBGraphics g, BlockProperties bp, float xLeft, float ypos, float trackWidth) {
        float tickInt;
        for (tickInt = this.p.maxWidth / this.p.cutoff; tickInt < 1.0f; tickInt *= 10.0f) {
        }
        int i = 1;
        float xpos = xLeft;
        xpos += tickInt;
        while (xpos < xLeft + trackWidth) {
            if (i % 10 == 0) {
                g.drawLine(xpos, ypos, xpos, ypos + 1.0f);
                g.drawLine(xpos, ypos + bp.height, xpos, ypos + bp.height - 1.0f);
            } else if (i % 5 == 0) {
                g.drawLine(xpos, ypos, xpos, ypos + 0.75f);
                g.drawLine(xpos, ypos + bp.height, xpos, ypos + bp.height - 0.75f);
            } else {
                g.drawLine(xpos, ypos, xpos, ypos + 0.5f);
                g.drawLine(xpos, ypos + bp.height, xpos, ypos + bp.height - 0.5f);
            }
            ++i;
            xpos += tickInt;
        }
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = 0.0f;
        if (this.p.showImages && this.images != null && !this.images.isEmpty()) {
            width += this.p.imageWidth;
        }
        return width += this.getTracksWidth();
    }

    private float getTracksWidth() {
        float width = 0.0f;
        for (TaxonTrack track : this.tracks) {
            width += track.width;
        }
        return width;
    }

    private Sample getSampFromPos(int pos) {
        int i = -1;
        try {
            for (Sample samp : this.getBlock().well.getSamples()) {
                for (Smpdtl smpdtl : samp.getAnalyses()) {
                    if (this.parent.useAnalysis(smpdtl, true)) {
                        ++i;
                    }
                    if (i != pos) continue;
                    return samp;
                }
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return null;
    }

    void setDefaultDepthRange() {
        try {
            if (this.getBlock().well.getSamples().size() > 0) {
                this.getBlock().setTopDepth((float)((Sample)this.getBlock().well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.getBlock().setBaseDepth((float)((Sample)this.getBlock().well.getSamples().get(this.getBlock().well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.getBlock().setTopDepth(0.0f);
                this.getBlock().setBaseDepth((float)this.getBlock().well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.getBlock().getHeight();
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        System.out.println("PanelTaxon (" + this.getCaption() + ") setting data...");
        this.getBlock().well.loadAnalyses();
        this.specTypes = null;
        switch (this.p.group) {
            case CAT: {
                this.setDataCat(cp);
                break;
            }
            case GENUS: {
                this.setDataGenus(cp);
                break;
            }
            case GROUP: {
                this.setDataGroup(cp);
                break;
            }
            case SITU: 
            case CONF: 
            case CV: {
                this.setDataBoolean(cp);
                break;
            }
            case SPEC: {
                this.setDataSpecies(cp);
                break;
            }
            case SUBTYPE: {
                this.setDataSubType(cp);
                break;
            }
            case TOTAL: {
                this.setDataTotal(cp);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.p.showImages) {
            this.setDataImages(cp, sections);
        } else {
            this.images = null;
        }
        if (this.p.interpSchID > 0) {
            this.setDataIntervals(cp, sections);
        }
        if (this.getBlock().getInterp() != null) {
            this.getBlock().getInterp().addObserver((Observer)this);
        }
    }

    private void setDataSpecies(ChartProperties cp) throws SQLException, SBException {
        Taxon pref;
        Color[][] tcColours;
        LinkedList taxa = new LinkedList();
        this.getBlock().well.fillTaxonList(taxa, this.parent.getDiscID().getChar(), 0, 0);
        this.getBlock().well.sortTaxonList(taxa, this.parent.getDiscID().getChar(), this.p.sortType);
        LinkedList<Taxon> toRemove = new LinkedList<Taxon>();
        for (Taxon taxon : taxa) {
            if (this.filter_spec != null) {
                if (taxon.getSpecID() == this.filter_spec.getSpecID()) continue;
                toRemove.add(taxon);
                continue;
            }
            if (this.filter_cat != null) {
                if (this.includeSubCats) {
                    if (taxon.getCatMnem().startsWith(this.filter_cat.getMnem())) continue;
                    toRemove.add(taxon);
                    continue;
                }
                if (taxon.getCatMnem().equals(this.filter_cat.getMnem())) continue;
                toRemove.add(taxon);
                continue;
            }
            if (this.filter_group != null) {
                if (this.filter_group.isMember(taxon.getSpecID())) continue;
                toRemove.add(taxon);
                continue;
            }
            if (this.filter_set == null) continue;
            boolean found = false;
            for (TxGroup group : this.filter_set.getGroups()) {
                if (!group.isMember(taxon.getSpecID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(taxon);
        }
        for (Taxon taxon : toRemove) {
            taxa.remove(taxon);
        }
        int n = taxa.size();
        String[] subgroups = this.getSubgroups();
        int m = subgroups.length;
        this.tracks.clear();
        this.events = null;
        if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
            this.nCurves = n;
            this.nTracks = 1;
            tcColours = new Color[this.nTracks][this.nCurves];
            String[] curveNames = new String[n];
            for (int i = 0; i < n; ++i) {
                Taxon t = (Taxon)taxa.get(i);
                String tString = t.toString(this.p.hdr_author);
                if (this.parent.synschID > 0 && (pref = t.getPreferred(this.parent.synschID)) != null) {
                    tString = tString + " (" + pref.toString(this.p.hdr_author) + ")";
                }
                curveNames[i] = tString;
            }
            TaxonTrack track = new TaxonTrack(null, "Species", curveNames, null);
            this.tracks.add(track);
        } else {
            this.nCurves = m;
            this.nTracks = n;
            tcColours = new Color[this.nTracks][this.nCurves];
            Iterator it = taxa.iterator();
            int i = -1;
            while (it.hasNext()) {
                CompositeStandard.AgeRange range;
                Taxon taxon = (Taxon)it.next();
                String tName = taxon.toString(this.p.hdr_author);
                if (this.parent.synschID > 0) {
                    try {
                        pref = taxon.getPreferred(this.parent.synschID);
                        if (pref != null) {
                            tName = tName + "  (";
                            tName = tName + pref.toString(this.p.hdr_author, false);
                            tName = tName + ")";
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AttributedString attString = taxon.toAttributedString(this.p.hdr_author, false, this.parent.synschID > 0 ? Integer.valueOf(this.parent.synschID) : null);
                TaxonTrack track = new TaxonTrack(attString, tName, null, taxon);
                if (this.p.cmpStdID > 0 && (range = this.getDb().getCompositeStandard(this.p.cmpStdID).getAgeRange(taxon)) != null) {
                    track.minAge = range.getMinAge();
                    track.maxAge = range.getMaxAge();
                    this.setTrackUnits(track);
                }
                this.tracks.add(track);
                Color colour = this.p.highlightGroup != null && this.p.highlightGroup.isMember(taxon.getSpecID()) ? this.p.highlightColour : this.getDefaultColour();
                PanelTaxon.fillColourArray(colour, tcColours[++i]);
                if (!this.p.drawEvents || this.getBlock().getInterp() == null || this.getBlock().getInterp().getEvents().isEmpty()) continue;
                LinkedList<ChartObject> trackEvents = new LinkedList<ChartObject>();
                for (WellEvent ev : this.getBlock().getInterp().getEvents()) {
                    double depth;
                    if (ev.getEvent().getSpecID() != taxon.getSpecID() || !((depth = this.getBlock().well.getDepth(ev.getSample(), cp.correctDepths, cp.correctCuttings)) > (double)this.getBlock().getTopDepth()) || !(depth < (double)this.getBlock().getBaseDepth())) continue;
                    ChartObject co = new ChartObject(ev, this.getBlock().scaleDepth((float)depth));
                    String evString = ev.toString(false, false, false);
                    if (evString.contains(taxon.toString(false, false, false))) {
                        evString = evString.replace(taxon.toString(false, false, false), "");
                    }
                    co.plotName = evString.trim();
                    co.corrDepth = depth;
                    trackEvents.add(co);
                }
                if (trackEvents.isEmpty()) continue;
                Collections.sort(trackEvents, new ChartObjectCompareDepth());
                if (this.events == null) {
                    this.events = new ChartObject[this.nTracks][];
                }
                this.events[i] = trackEvents.toArray(new ChartObject[trackEvents.size()]);
            }
        }
        float[][][] sampleData = new float[this.parent.getnSamples()][n][m];
        int[][] tally = new int[this.parent.getnSamples()][n];
        AbnScheme[] abnSchemes = new AbnScheme[this.parent.getnSamples()];
        float[] sampleTotal = new float[this.parent.getnSamples()];
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][n];
        this.colours = this.p.colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : tcColours;
        Iterator sampleIt = this.getBlock().well.getSamples(cp.correctDepths, cp.correctCuttings).iterator();
        int nSample = 0;
        while (sampleIt.hasNext()) {
            Sample sample = (Sample)sampleIt.next();
            Boolean sampleOutsideRange = this.isOutsideBlockRange(sample);
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, false)) continue;
                if (sampleOutsideRange == null) {
                    if (this.p.colourSuites) {
                        PanelTaxon.fillColourArray(smpdtl.getHeader().getColour(), this.colours[nSample]);
                    }
                    abnSchemes[nSample] = this.getDb().getAbnScheme(smpdtl.getHeader().getAbnSchID(), false);
                }
                for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                    if (this.useOcc(fss)) {
                        Iterator taxonIt = taxa.iterator();
                        int j = 0;
                        while (taxonIt.hasNext()) {
                            Taxon t = (Taxon)taxonIt.next();
                            if (fss.getTaxon().getSpecID() == t.getSpecID()) break;
                            ++j;
                        }
                        if (sampleOutsideRange == null) {
                            if (this.p.subgroup != PanelTaxonProperties.SubGroup.CMF) {
                                float count = 0.0f;
                                switch (this.p.abn_style) {
                                    case Q: {
                                        count = (float)fss.getDerivedCount(abnSchemes[nSample], this.p.useSplits ? smpdtl.getCoarse() : 0.0f, this.p.useSplits ? smpdtl.getMedium() : 0.0f, this.p.useSplits ? smpdtl.getFine() : 0.0f);
                                        break;
                                    }
                                    case MIX: {
                                        count = (float)fss.getTotalCount(this.p.useSplits ? smpdtl.getCoarse() : 0.0f, this.p.useSplits ? smpdtl.getMedium() : 0.0f, this.p.useSplits ? smpdtl.getFine() : 0.0f);
                                        break;
                                    }
                                    case SEMIQ: {
                                        if (abnSchemes[nSample] == null) {
                                            throw new IllegalStateException("Abundance scheme null for header: " + smpdtl.getHeader());
                                        }
                                        count = fss.isOutsideCount() ? 0.0f : (float)(abnSchemes[nSample].getIndex(fss.getDerivedCount(abnSchemes[nSample])) + 1);
                                        break;
                                    }
                                    case PA: {
                                        count = fss.isOutsideCount() ? 0.0f : 5.0f;
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                if (this.p.abn_style != PanelTaxonProperties.Abundance.PA) {
                                    if (this.p.normaliseWeight && smpdtl.getWeight() > 0.0029f) {
                                        count *= this.p.normalWeight / smpdtl.getWeight();
                                    }
                                    float[] fArray = sampleData[nSample][j];
                                    int n2 = m > 1 ? this.getSubgroupInt(fss) : 0;
                                    fArray[n2] = fArray[n2] + count;
                                } else {
                                    sampleData[nSample][j][m > 1 ? this.getSubgroupInt((TaxonOcc)fss) : 0] = count;
                                }
                            } else {
                                switch (this.p.abn_style) {
                                    case Q: {
                                        float[] fArray = sampleData[nSample][j];
                                        fArray[0] = fArray[0] + (float)fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.COARSE);
                                        float[] fArray2 = sampleData[nSample][j];
                                        fArray2[1] = fArray2[1] + (float)fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.MEDIUM);
                                        float[] fArray3 = sampleData[nSample][j];
                                        fArray3[2] = fArray3[2] + (float)fss.getDerivedCount(abnSchemes[nSample], TaxonOcc.SizeFraction.FINE);
                                        break;
                                    }
                                    case MIX: {
                                        float[] fArray = sampleData[nSample][j];
                                        fArray[0] = fArray[0] + (float)fss.getCoarse();
                                        float[] fArray4 = sampleData[nSample][j];
                                        fArray4[1] = fArray4[1] + (float)fss.getMedium();
                                        float[] fArray5 = sampleData[nSample][j];
                                        fArray5[2] = fArray5[2] + (float)fss.getFine();
                                        break;
                                    }
                                    default: {
                                        throw new SBException("Attempt to use split-factor sub-grouping for " + this.p.abn_style.toString());
                                    }
                                }
                            }
                            if (!fss.isOutsideCount()) {
                                int[] nArray = tally[nSample];
                                int n3 = j;
                                nArray[n3] = nArray[n3] + 1;
                            }
                            this.setLabel(fss, nSample, j, true, this.p.abn_style == PanelTaxonProperties.Abundance.MIX, true);
                        }
                        if (this.p.track_style == PanelTaxonProperties.Track.SINGLE && !fss.getCaved() && !fss.getReworked()) {
                            this.tracks.get(j).setDataRange(nSample, sampleOutsideRange);
                        }
                    }
                    if (this.p.calc_style != PanelTaxonProperties.Calc.RELATIVE_OUTER || sampleOutsideRange != null || !this.parentUseOcc(fss)) continue;
                    int n4 = nSample;
                    sampleTotal[n4] = sampleTotal[n4] + this.getDerivedCount(fss, smpdtl, abnSchemes[nSample]);
                }
                if (sampleOutsideRange != null) continue;
                ++nSample;
            }
        }
        if (this.p.abn_style.setSemiQuant()) {
            this.setSemiQuant(sampleData, tally, abnSchemes, n);
        }
        this.copySampleData(sampleData, m, cp, sampleTotal, null);
    }

    private void setDataGroup(ChartProperties cp) throws SQLException, SBException {
        int i;
        List<TxGroup> groups;
        if (this.filter_set == null && this.filter_group == null && this.parent.filter_set == null) {
            throw new SBException("Cannot group by taxon group unless filtered by set or group");
        }
        if (this.filter_set != null) {
            groups = this.filter_set.getGroups();
        } else if (this.parent.filter_set != null) {
            groups = this.parent.filter_set.getGroups();
        } else {
            groups = new LinkedList();
            groups.add(this.filter_group);
        }
        int n = groups.size();
        String[] subgroups = this.getSubgroups();
        int m = subgroups.length;
        if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
            this.nCurves = n;
            this.nTracks = 1;
        } else {
            this.nCurves = m;
            this.nTracks = n;
        }
        Color[] tcColours = new Color[n];
        String[] names = new String[n];
        for (i = 0; i < n; ++i) {
            ((TxGroup)groups.get(i)).addObserver((Observer)this);
            tcColours[i] = ((TxGroup)groups.get(i)).getColour();
            names[i] = ((TxGroup)groups.get(i)).getName();
        }
        this.colours = this.p.colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : new Color[this.nTracks][this.nCurves];
        this.tracks.clear();
        for (i = 0; i < this.nTracks; ++i) {
            TaxonTrack newTrack;
            if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
                newTrack = new TaxonTrack(null, "Groups", names, null);
                if (!this.p.colourSuites) {
                    this.colours[i] = tcColours;
                }
            } else {
                newTrack = new TaxonTrack(null, names[i], subgroups, null);
                if (!this.p.colourSuites) {
                    PanelTaxon.fillColourArray(tcColours[i], this.colours[i]);
                }
                if (this.p.cmpStdID > 0) {
                    CompositeStandard std = this.getDb().getCompositeStandard(this.p.cmpStdID);
                    TxGroup group = (TxGroup)groups.get(i);
                    Double minAge = null;
                    Double maxAge = null;
                    for (Taxon t : this.getDb().getTxGroupTaxa(group)) {
                        CompositeStandard.AgeRange r = std.getAgeRange(t);
                        if (r == null) {
                            maxAge = null;
                            minAge = null;
                            break;
                        }
                        if (r.getMinAge() != null) {
                            if (minAge == null || r.getMinAge() < minAge) {
                                minAge = r.getMinAge();
                            }
                            if (maxAge == null || r.getMinAge() > maxAge) {
                                maxAge = r.getMinAge();
                            }
                        }
                        if (r.getMaxAge() == null) continue;
                        if (maxAge == null || r.getMaxAge() > maxAge) {
                            maxAge = r.getMaxAge();
                        }
                        if (minAge != null && !(r.getMaxAge() < minAge)) continue;
                        minAge = r.getMaxAge();
                    }
                    if (minAge != null || maxAge != null) {
                        newTrack.minAge = minAge;
                        newTrack.maxAge = maxAge;
                        this.setTrackUnits(newTrack);
                    }
                }
            }
            this.tracks.add(newTrack);
        }
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][this.nTracks];
        this.fillSampleData(cp, groups.toArray(), m, n);
    }

    private void setDataCat(ChartProperties cp) throws SQLException, SBException {
        LinkedList<Category> cats = new LinkedList<Category>();
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    Category c;
                    if (!this.useOcc(occ) || cats.contains(c = this.getDb().getCategory(occ.getTaxon().getCatMnem()))) continue;
                    cats.add(c);
                }
            }
        }
        int n = cats.size();
        Collections.sort(cats);
        Color[] tcColours = new Color[n];
        Object[] names = new String[n];
        for (int i = 0; i < cats.size(); ++i) {
            tcColours[i] = ((Category)cats.get(i)).getColour();
            names[i] = ((Category)cats.get(i)).getMnem();
        }
        int m = this.setTracks(names, null, tcColours, n);
        this.fillSampleData(cp, names, m, n);
    }

    private void setDataGenus(ChartProperties cp) throws SQLException, SBException {
        LinkedList<Genus> genera = new LinkedList<Genus>();
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    Genus g;
                    if (!this.useOcc(occ) || genera.contains(g = occ.getTaxon().getGenus())) continue;
                    genera.add(g);
                }
            }
        }
        int n = genera.size();
        Collections.sort(genera);
        Color[] tcColours = new Color[n];
        AttributedString[] attNames = new AttributedString[n];
        for (int i = 0; i < genera.size(); ++i) {
            tcColours[i] = this.getDefaultColour();
            attNames[i] = ((Genus)genera.get(i)).toAttributedString(false);
        }
        int m = this.setTracks(genera.toArray(), attNames, tcColours, n);
        this.fillSampleData(cp, genera.toArray(), m, n);
    }

    private void setDataSubType(ChartProperties cp) throws SQLException, SBException {
        LinkedList<String> types = new LinkedList<String>();
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    String type;
                    if (!this.useOcc(occ) || types.contains(type = occ.getSpecTypeString())) continue;
                    types.add(type);
                }
            }
        }
        int n = types.size();
        Collections.sort(types);
        Color[] tcColours = new Color[n];
        Object[] names = new String[n];
        for (int i = 0; i < types.size(); ++i) {
            tcColours[i] = this.getDefaultColour();
            names[i] = (String)types.get(i);
        }
        int m = this.setTracks(names, null, tcColours, n);
        this.fillSampleData(cp, names, m, n);
    }

    private void setDataBoolean(ChartProperties cp) throws SQLException, SBException {
        Object[] curveNames;
        int n = 2;
        Color[] tcColours = new Color[]{new Color(51, 102, 204), new Color(204, 51, 51)};
        switch (this.p.group) {
            case SITU: {
                curveNames = new String[]{"In-situ", "Rw"};
                break;
            }
            case CONF: {
                curveNames = new String[]{"Confident", "Questionable"};
                break;
            }
            case CV: {
                curveNames = new String[]{"Not Caved", "Caved"};
                break;
            }
            default: {
                curveNames = null;
                assert (false);
                break;
            }
        }
        int m = this.setTracks(curveNames, null, tcColours, n);
        this.fillSampleData(cp, curveNames, m, n);
    }

    private void setDataTotal(ChartProperties cp) throws SQLException, SBException {
        int n = 1;
        String trackTitle = PanelTaxonProperties.Group.TOTAL.getTrackAdj() + " " + this.getDataInclusionDescriptor();
        int m = this.setTracks(new String[]{trackTitle}, null, new Color[]{this.getDefaultColour()}, n);
        this.fillSampleData(cp, null, m, n);
    }

    private void fillSampleData(ChartProperties cp, Object[] objects, int m, int n) throws SQLException, SBException {
        assert (objects == null || objects.length == n);
        float[][][] sampleData = new float[this.parent.getnSamples()][n][m];
        float[] sampleTotal = this.p.calc_style == PanelTaxonProperties.Calc.RELATIVE_OUTER ? new float[this.parent.getnSamples()] : null;
        HashMap[][] tally = new HashMap[this.parent.getnSamples()][n];
        AbnScheme[] abnSchemes = new AbnScheme[this.parent.getnSamples()];
        Iterator sampleIt = this.getBlock().well.getSamples(cp.correctDepths, cp.correctCuttings).iterator();
        int nSample = 0;
        while (sampleIt.hasNext()) {
            Sample sample = (Sample)sampleIt.next();
            Boolean sampleOutside = this.isOutsideBlockRange(sample);
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, false)) continue;
                if (sampleOutside == null) {
                    if (this.p.colourSuites) {
                        PanelTaxon.fillColourArray(smpdtl.getHeader().getColour(), this.colours[nSample]);
                    }
                    abnSchemes[nSample] = this.getDb().getAbnScheme(smpdtl.getHeader().getAbnSchID(), false);
                }
                for (TaxonOcc fss : smpdtl.getOccur()) {
                    if (this.useOcc(fss)) {
                        Integer j = null;
                        block0 : switch (this.p.group) {
                            case GROUP: {
                                for (int i = 0; i < n; ++i) {
                                    if (!((TxGroup)objects[i]).isMember(fss.getTaxon().getSpecID())) continue;
                                    j = i;
                                    break block0;
                                }
                                break;
                            }
                            case GENUS: {
                                for (int i = 0; i < n; ++i) {
                                    if (((Genus)objects[i]).getGenID() != fss.getTaxon().getGenID()) continue;
                                    j = i;
                                    break block0;
                                }
                                break;
                            }
                            case CAT: 
                            case SUBTYPE: {
                                String compString = "";
                                switch (this.p.group) {
                                    case CAT: {
                                        compString = fss.getTaxon().getCatMnem();
                                        break;
                                    }
                                    case SUBTYPE: {
                                        compString = fss.getSpecTypeString();
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                                for (int i = 0; i < n; ++i) {
                                    if (!compString.equals(objects[i])) continue;
                                    j = i;
                                    break block0;
                                }
                                break;
                            }
                            case CONF: {
                                j = fss.getQuestionable() ? 1 : 0;
                                break;
                            }
                            case SITU: {
                                j = fss.getReworked() ? 1 : 0;
                                break;
                            }
                            case CV: {
                                j = fss.getCaved() ? 1 : 0;
                                break;
                            }
                            default: {
                                j = 0;
                            }
                        }
                        if (sampleOutside == null) {
                            assert (j != null);
                            this.countOcc(sampleData, nSample, j, m, fss, smpdtl, abnSchemes[nSample], tally);
                            this.setLabel(fss, nSample, j, this.p.group != PanelTaxonProperties.Group.SITU, this.p.abn_style == PanelTaxonProperties.Abundance.MIX, this.p.group != PanelTaxonProperties.Group.CONF);
                        }
                        if (this.p.track_style == PanelTaxonProperties.Track.SINGLE && j != null && !fss.getCaved() && !fss.getReworked()) {
                            this.tracks.get(j).setDataRange(nSample, sampleOutside);
                        }
                    }
                    if (this.p.calc_style != PanelTaxonProperties.Calc.RELATIVE_OUTER || sampleOutside != null || !this.parentUseOcc(fss)) continue;
                    int n2 = nSample;
                    sampleTotal[n2] = sampleTotal[n2] + this.getDerivedCount(fss, smpdtl, abnSchemes[nSample]);
                }
                if (sampleOutside != null) continue;
                ++nSample;
            }
        }
        if (this.p.abn_style.setSemiQuant()) {
            this.setSemiQuant(sampleData, tally, abnSchemes, n);
        }
        this.copySampleData(sampleData, m, cp, sampleTotal, tally);
    }

    private float getDerivedCount(TaxonOcc fss, Smpdtl smpdtl, AbnScheme abnScheme) {
        double derivedCount = fss.getDerivedCount((AbnScheme)(this.p.abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null), this.p.useSplits ? smpdtl.getCoarse() : 0.0f, this.p.useSplits ? smpdtl.getMedium() : 0.0f, this.p.useSplits ? smpdtl.getFine() : 0.0f);
        if (this.p.normaliseWeight && smpdtl.getWeight() > 0.0f) {
            derivedCount *= (double)(this.p.normalWeight / smpdtl.getWeight());
        }
        return (float)derivedCount;
    }

    private void countOcc(float[][][] sampleData, int nSample, int j, int m, TaxonOcc fss, Smpdtl smpdtl, AbnScheme abnScheme, HashMap[][] tally) {
        if (!fss.isOutsideCount() && (this.p.calc_style == PanelTaxonProperties.Calc.SHANNON || this.p.calc_style == PanelTaxonProperties.Calc.RICHNESS || this.p.abn_style.setSemiQuant())) {
            if (tally[nSample][j] == null) {
                tally[nSample][j] = new HashMap();
            }
            if (tally[nSample][j].get(fss.getTaxon()) == null) {
                tally[nSample][j].put(fss.getTaxon(), Float.valueOf(this.getDerivedCount(fss, smpdtl, abnScheme)));
            } else {
                float count = ((Float)tally[nSample][j].get(fss.getTaxon())).floatValue();
                tally[nSample][j].put(fss.getTaxon(), Float.valueOf(count += this.getDerivedCount(fss, smpdtl, abnScheme)));
            }
        }
        switch (this.p.calc_style) {
            case RICHNESS: {
                float[] fArray = sampleData[nSample][j];
                int n = m > 1 ? this.getSubgroupInt(fss) : 0;
                fArray[n] = fArray[n] + 1.0f;
                break;
            }
            case SHANNON: {
                float[] fArray = sampleData[nSample][j];
                fArray[0] = fArray[0] + this.getDerivedCount(fss, smpdtl, abnScheme);
                break;
            }
            default: {
                if (this.p.subgroup != PanelTaxonProperties.SubGroup.CMF) {
                    float[] fArray = sampleData[nSample][j];
                    int n = m > 1 ? this.getSubgroupInt(fss) : 0;
                    fArray[n] = fArray[n] + this.getDerivedCount(fss, smpdtl, abnScheme);
                    break;
                }
                float[] fArray = sampleData[nSample][j];
                fArray[0] = fArray[0] + (float)fss.getDerivedCount((AbnScheme)(this.p.abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null), TaxonOcc.SizeFraction.COARSE);
                float[] fArray2 = sampleData[nSample][j];
                fArray2[1] = fArray2[1] + (float)fss.getDerivedCount((AbnScheme)(this.p.abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null), TaxonOcc.SizeFraction.MEDIUM);
                float[] fArray3 = sampleData[nSample][j];
                fArray3[2] = fArray3[2] + (float)fss.getDerivedCount((AbnScheme)(this.p.abn_style != PanelTaxonProperties.Abundance.MIX ? abnScheme : null), TaxonOcc.SizeFraction.FINE);
            }
        }
    }

    private int setTracks(Object[] objs, AttributedString[] attNames, Color[] tcColours, int n) throws SBException, SQLException {
        assert (objs.length == tcColours.length);
        assert (objs.length == n);
        Object[] objects = Arrays.copyOf(objs, n);
        String[] subgroups = this.getSubgroups();
        int m = subgroups.length;
        if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
            this.nCurves = n;
            this.nTracks = 1;
        } else {
            this.nCurves = m;
            this.nTracks = n;
        }
        this.colours = this.p.colourSuites ? new Color[this.parent.getnSamples()][this.nCurves] : new Color[this.nTracks][this.nCurves];
        String[] names = new String[objects.length];
        for (int j = 0; j < objects.length; ++j) {
            String string = names[j] = objects[j] instanceof Genus ? ((Genus)objects[j]).toString(true) : objects[j].toString();
            if (!(objects[j] instanceof String)) continue;
            objects[j] = null;
        }
        this.tracks.clear();
        for (int i = 0; i < this.nTracks; ++i) {
            TaxonTrack newTrack;
            if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
                newTrack = new TaxonTrack(null, this.p.group.getTrackAdj(), names, null);
                if (!this.p.colourSuites) {
                    this.colours[i] = tcColours;
                }
            } else {
                newTrack = new TaxonTrack(attNames != null ? attNames[i] : null, names[i], subgroups, objects[i]);
                if (!this.p.colourSuites) {
                    PanelTaxon.fillColourArray(tcColours[i], this.colours[i]);
                }
            }
            this.tracks.add(newTrack);
        }
        this.curveData = new float[this.parent.getnSamples()][this.nTracks][this.nCurves];
        this.curveLabels = new String[this.parent.getnSamples()][this.nTracks];
        return m;
    }

    private void setSpecTypes() throws SBException, SQLException {
        if (this.specTypes != null && !this.specTypes.isEmpty()) {
            return;
        }
        this.specTypes = new LinkedList<Integer>();
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    int type;
                    if (!this.useOcc(occ) || this.specTypes.contains(type = occ.getSpecType())) continue;
                    this.specTypes.add(type);
                }
            }
        }
    }

    private static void fillColourArray(Color baseColour, Color[] colourArray) {
        Color colour;
        int c = 0;
        colourArray[c] = colour = baseColour;
        ++c;
        while (c < colourArray.length) {
            colourArray[c] = colour = SB.getLighterColour((Color)colour);
            ++c;
        }
    }

    private String[] getSubgroups() throws SBException, SQLException {
        if (this.p.subgroup.getGroupNames() == null) {
            this.setSpecTypes();
            String[] names = new String[this.specTypes.size()];
            for (int i = 0; i < this.specTypes.size(); ++i) {
                names[i] = this.getDb().getSpecType(this.specTypes.get(i).intValue());
            }
            return names;
        }
        return this.p.subgroup.getGroupNames();
    }

    private int getSubgroupInt(TaxonOcc fss) {
        switch (this.p.subgroup) {
            case SITU: {
                if (fss.getReworked()) {
                    return 1;
                }
                return 0;
            }
            case CONF: {
                if (fss.getQuestionable()) {
                    return 1;
                }
                return 0;
            }
            case SUBTYPE: {
                for (int i = 0; i < this.specTypes.size(); ++i) {
                    if (fss.getSpecType() != this.specTypes.get(i).intValue()) continue;
                    return i;
                }
                return 0;
            }
        }
        return 0;
    }

    private void setSemiQuant(float[][][] sampleData, int[][] tally, AbnScheme[] abnSchemes, int n) throws SBException {
        switch (this.p.abn_style) {
            case SEMIQ: {
                if (abnSchemes == null || abnSchemes.length != sampleData.length) {
                    throw new IllegalArgumentException("Abundance scheme array invalid in setSemiQuant()");
                }
                int maxClasses = 0;
                for (int k = 0; k < this.parent.getnSamples(); ++k) {
                    int nClasses = abnSchemes[k].getNClasses();
                    if (nClasses <= maxClasses) continue;
                    maxClasses = nClasses;
                }
                for (int i = 0; i < this.parent.getnSamples(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (!(sampleData[i][j][0] > 0.0f) || tally[i][j] <= 0) continue;
                        int count = (int)(sampleData[i][j][0] / (float)tally[i][j]);
                        int index = abnSchemes[i].getIndex(count) + 1;
                        sampleData[i][j][0] = index * (maxClasses / abnSchemes[i].getNClasses());
                    }
                }
                break;
            }
            case PA: {
                for (int i = 0; i < this.parent.getnSamples(); ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (tally[i][j] <= 0) continue;
                        sampleData[i][j][0] = 5.0f;
                    }
                }
                break;
            }
        }
    }

    private void setSemiQuant(float[][][] sampleData, HashMap[][] mapTally, AbnScheme[] abnSchemes, int n) throws SBException {
        int[][] tally = new int[mapTally.length][n];
        for (int i = 0; i < mapTally.length; ++i) {
            HashMap[] hashArr = mapTally[i];
            for (int j = 0; j < hashArr.length; ++j) {
                tally[i][j] = hashArr[j] != null ? hashArr[j].size() : 0;
            }
        }
        this.setSemiQuant(sampleData, tally, abnSchemes, n);
    }

    private void setTrackUnits(TaxonTrack track) throws SQLException, SBException {
        IGDUnit unit2;
        if (this.p.schID <= 0) {
            return;
        }
        IGDScheme scheme = this.getDb().getIGDScheme(this.p.schID);
        IGDUnit unit = null;
        if (track.minAge != null && (unit = scheme.findUnit(track.minAge.doubleValue())) != null) {
            track.unit1 = unit.getAbr();
            if (track.unit1 == null || !this.p.schAbrs) {
                track.unit1 = unit.getName();
            }
            track.col1 = unit.getColour();
        }
        if (track.maxAge != null && (unit2 = scheme.findUnit(track.maxAge.doubleValue())) != null && (unit != null && unit2 != unit || unit == null)) {
            track.unit2 = unit2.getAbr();
            if (track.unit2 == null || !this.p.schAbrs) {
                track.unit2 = unit2.getName();
            }
            track.col2 = unit2.getColour();
        }
    }

    private void copySampleData(float[][][] sampleData, int m, ChartProperties cp, float[] trackTotals, HashMap[][] tally) {
        if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
            float maxWidth = 0.0f;
            for (int i = 0; i < this.parent.getnSamples(); ++i) {
                float w = this.copySampleDataCurves(sampleData[i], i, trackTotals != null ? trackTotals[i] : 0.0f);
                if (!(w > maxWidth)) continue;
                maxWidth = w;
            }
            TaxonTrack track = this.tracks.get(0);
            track.width = maxWidth;
        } else {
            sampleData = this.sortTracks(sampleData, tally);
            for (int i = 0; i < this.parent.getnSamples(); ++i) {
                this.copySampleDataTracks(sampleData[i], i, m, trackTotals != null ? trackTotals[i] : 0.0f, tally != null ? tally[i] : null);
            }
            if (this.events != null) {
                this.setTrackWidthEvents(cp);
            }
        }
        if (this.p.clearEmptyTracks) {
            this.clearEmptyTracks();
        }
    }

    private float copySampleDataCurves(float[][] sampleData, int nSample, float sampleTotal) {
        float maxWidth = this.p.minWidth;
        for (int i = 0; i < this.nCurves; ++i) {
            float j = sampleData[i][0];
            if (i > 0) {
                j += this.curveData[nSample][0][i - 1];
            }
            if (i == this.nCurves - 1) {
                if (j < this.p.cutoff) {
                    if (j * this.p.horzScale > maxWidth) {
                        maxWidth = j * this.p.horzScale;
                    }
                } else {
                    maxWidth = this.p.maxWidth;
                }
            }
            this.curveData[nSample][0][i] = j;
        }
        float total = sampleTotal;
        switch (this.p.calc_style) {
            case RELATIVE: {
                total = this.curveData[nSample][0][this.nCurves - 1];
            }
            case RELATIVE_OUTER: {
                maxWidth = this.p.maxWidth;
                for (int i = this.nCurves - 1; i > -1; --i) {
                    if (!(this.curveData[nSample][0][i] > 0.0f)) continue;
                    this.curveData[nSample][0][i] = this.curveData[nSample][0][i] / total * 100.0f;
                }
                break;
            }
        }
        return maxWidth;
    }

    private void copySampleDataTracks(float[][] sampleData, int nSample, int m, float sampleTotalOuter, HashMap[] tally) {
        int k;
        int j;
        float sampletotal = 0.0f;
        if (this.p.calc_style == PanelTaxonProperties.Calc.RELATIVE_OUTER) {
            sampletotal = sampleTotalOuter;
        } else {
            for (j = 0; j < this.nTracks; ++j) {
                for (k = 0; k < m; ++k) {
                    sampletotal += sampleData[j][k];
                }
            }
        }
        switch (this.p.calc_style) {
            case RELATIVE: 
            case RELATIVE_OUTER: {
                float f;
                for (j = 0; j < this.nTracks; ++j) {
                    for (k = 0; k < m; ++k) {
                        f = sampletotal > 0.0f ? sampleData[j][k] / sampletotal * 100.0f : 0.0f;
                        if (k > 0) {
                            f += this.curveData[nSample][j][k - 1];
                        }
                        this.curveData[nSample][j][k] = f;
                        if (!this.p.showAbundance || k != m - 1) continue;
                        if ((double)f > 1.0) {
                            this.curveLabels[nSample][j] = (int)SB.round((double)f, (int)0) + (this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                            continue;
                        }
                        if (!((double)f > 1.0E-4)) continue;
                        this.curveLabels[nSample][j] = ("" + SB.roundToSignificantFigures((double)f, (int)2)).substring(1) + (this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                    }
                }
                break;
            }
            case SHANNON: {
                for (j = 0; j < this.nTracks; ++j) {
                    HashMap counts = tally[j];
                    float diversity = 0.0f;
                    if (counts != null) {
                        double N = sampleData[j][0];
                        Iterator it = counts.values().iterator();
                        double H = 0.0;
                        while (it.hasNext()) {
                            double pi = (double)((Float)it.next()).floatValue() / N;
                            H += pi * Math.log(pi);
                        }
                        diversity = (float)(H *= -1.0);
                    }
                    this.curveData[nSample][j][0] = diversity;
                    if (!this.p.showAbundance || !(diversity > 0.0f)) continue;
                    this.curveLabels[nSample][j] = SB.round((double)diversity, (int)2) + (this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                }
                break;
            }
            default: {
                float f;
                for (j = 0; j < this.nTracks; ++j) {
                    for (k = 0; k < m; ++k) {
                        f = sampleData[j][k];
                        if (k > 0) {
                            f += this.curveData[nSample][j][k - 1];
                        }
                        this.curveData[nSample][j][k] = f;
                        if (!this.p.showAbundance || this.p.abn_style == PanelTaxonProperties.Abundance.PA || k != m - 1 || !(f > 0.0f)) continue;
                        this.curveLabels[nSample][j] = (f < 1.0f ? ("" + SB.roundToSignificantFigures((double)f, (int)2)).substring(1) : "" + (int)f) + (this.curveLabels[nSample][j] != null ? " " + this.curveLabels[nSample][j] : "");
                    }
                }
            }
        }
        for (j = 0; j < this.nTracks; ++j) {
            int labelWidth;
            float maxWidth;
            float curvetotal = 0.0f;
            if (this.p.plot_style != PanelTaxonProperties.Plot.NUMBERS) {
                curvetotal = this.curveData[nSample][j][m - 1];
            }
            if ((maxWidth = (float)(labelWidth = this.curveLabels[nSample][j] != null ? this.curveLabels[nSample][j].length() : 0) + curvetotal * this.p.horzScale + 1.5f) > this.p.maxWidth) {
                maxWidth = this.p.maxWidth;
            }
            TaxonTrack track = this.tracks.get(j);
            if (!(track.width < maxWidth)) continue;
            track.width = maxWidth;
        }
    }

    private void setTrackWidthEvents(ChartProperties cp) {
        for (int i = 0; i < this.nTracks; ++i) {
            TaxonTrack track = this.tracks.get(i);
            if (this.events[i] == null) continue;
            float maxEvWidth = 0.0f;
            for (ChartObject co : this.events[i]) {
                float w;
                if (co.plotName.isEmpty() || !((w = SBGraphics.stringWidth(co.plotName, cp.fontTiny)) > maxEvWidth)) continue;
                maxEvWidth = w;
            }
            track.width += maxEvWidth + 2.3f;
        }
    }

    private void setLabel(TaxonOcc fss, int nSample, int n, boolean useRw, boolean useSubjAbund, boolean useConf) {
        if (!this.p.showFlags) {
            return;
        }
        if (this.p.track_style == PanelTaxonProperties.Track.MULTI) {
            n = 0;
        }
        if (useSubjAbund && fss.getTotalCount() == 0 && fss.getSubAbund().length() > 0) {
            this.curveLabels[nSample][n] = fss.getSubAbund();
        }
        if (!(!fss.isOutsideCount() || fss.getCaved() || useRw && fss.getReworked() || this.curveLabels[nSample][n] != null && this.curveLabels[nSample][n].contains("+"))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n2 = n;
                stringArray[n2] = stringArray[n2] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n3 = n;
            stringArray[n3] = stringArray[n3] + "+";
        }
        if (fss.getReworked() && useRw && this.p.subgroup != PanelTaxonProperties.SubGroup.SITU && (this.curveLabels[nSample][n] == null || !this.curveLabels[nSample][n].contains("Rw"))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n4 = n;
                stringArray[n4] = stringArray[n4] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n5 = n;
            stringArray[n5] = stringArray[n5] + "Rw";
        }
        if (fss.getCaved() && (this.curveLabels[nSample][n] == null || !this.curveLabels[nSample][n].contains("Cv"))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n6 = n;
                stringArray[n6] = stringArray[n6] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n7 = n;
            stringArray[n7] = stringArray[n7] + "Cv";
        }
        if (useConf && fss.getIdentType() == '?' && this.p.subgroup != PanelTaxonProperties.SubGroup.CONF && (this.curveLabels[nSample][n] == null || !this.curveLabels[nSample][n].contains("?"))) {
            if (this.curveLabels[nSample][n] == null) {
                this.curveLabels[nSample][n] = "";
            } else {
                String[] stringArray = this.curveLabels[nSample];
                int n8 = n;
                stringArray[n8] = stringArray[n8] + " ";
            }
            String[] stringArray = this.curveLabels[nSample];
            int n9 = n;
            stringArray[n9] = stringArray[n9] + "?";
        }
    }

    private void clearEmptyTracks() {
        int nTrack;
        int track;
        if (this.p.track_style != PanelTaxonProperties.Track.SINGLE) {
            return;
        }
        LinkedList<Integer> empties = new LinkedList<Integer>();
        for (int nTrack2 = 0; nTrack2 < this.nTracks; ++nTrack2) {
            boolean empty = true;
            block1: for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                for (int nCurve = 0; nCurve < this.nCurves; ++nCurve) {
                    if (!(this.curveData[nSample][nTrack2][nCurve] > 0.0f)) continue;
                    empty = false;
                    break block1;
                }
            }
            if (!empty) continue;
            empties.add(nTrack2);
        }
        if (empties.isEmpty()) {
            return;
        }
        LinkedList<Integer> reallyEmpty = new LinkedList<Integer>();
        for (Integer empty : empties) {
            boolean hasLabel = false;
            for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                if (this.curveLabels[nSample][empty] == null || this.curveLabels[nSample][empty].isEmpty()) continue;
                hasLabel = true;
                break;
            }
            if (hasLabel) continue;
            reallyEmpty.add(empty);
        }
        if (reallyEmpty.isEmpty()) {
            return;
        }
        empties = reallyEmpty;
        LinkedList<TaxonTrack> newTracks = new LinkedList<TaxonTrack>();
        Iterator<TaxonTrack> it = this.tracks.iterator();
        int i = 0;
        while (it.hasNext()) {
            TaxonTrack t = it.next();
            if (!empties.contains(i)) {
                newTracks.add(t);
            }
            ++i;
        }
        this.tracks = newTracks;
        float[][][] newCurveData = new float[this.parent.getnSamples()][this.nTracks - empties.size()][this.nCurves];
        String[][] newCurveLabels = new String[this.parent.getnSamples()][this.nTracks];
        Color[][] newCurveColour = null;
        if (!this.p.colourSuites) {
            newCurveColour = new Color[this.nTracks - empties.size()][this.nCurves];
        }
        for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
            track = 0;
            for (nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                if (empties.contains(nTrack)) continue;
                System.arraycopy(this.curveData[nSample][nTrack], 0, newCurveData[nSample][track], 0, this.nCurves);
                newCurveLabels[nSample][track] = this.curveLabels[nSample][nTrack];
                if (!this.p.colourSuites) {
                    System.arraycopy(this.colours[nTrack], 0, newCurveColour[track], 0, this.nCurves);
                }
                ++track;
            }
        }
        this.nTracks -= empties.size();
        this.curveData = newCurveData;
        this.curveLabels = newCurveLabels;
        if (!this.p.colourSuites) {
            this.colours = newCurveColour;
        }
        if (this.p.drawEvents && this.events != null) {
            ChartObject[][] newEvents = new ChartObject[this.nTracks][];
            track = 0;
            for (nTrack = 0; nTrack < this.nTracks; ++nTrack) {
                if (empties.contains(nTrack)) continue;
                newEvents[track] = this.events[nTrack];
                ++track;
            }
            this.events = newEvents;
        }
    }

    private void drawGrid(SBGraphics g, float xpos, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        double blockTopDepth;
        g.setDashStroke(0.1f, 1.7f);
        g.setColor(Color.LIGHT_GRAY);
        TickScheme scheme = new TickScheme();
        scheme.calcScaleLabels(this.getBlock().getTopDepth(), this.getBlock().getScale(), this.getBlock().prop.units);
        float depth = 0.0f;
        float x2 = xpos + this.getTracksWidth();
        double blockBaseDepth = this.getBlock().prop == bp ? (double)this.getBlock().getBaseDepth() : (double)bp.max;
        double d = blockTopDepth = this.getBlock().prop == bp ? (double)this.getBlock().getTopDepth() : (double)bp.min;
        while ((double)depth < blockTopDepth) {
            depth += scheme.labelInterval;
        }
        while ((double)depth <= blockBaseDepth + (double)0.0029f) {
            float ypos = this.getBlock().scaleDepth(depth) + y + PanelTaxon.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos, ypos, x2, ypos);
            depth += scheme.labelInterval;
        }
        g.setColor(Color.BLACK);
    }

    private void setDataIntervals(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        IGDScheme scheme = this.getDb().getIGDScheme(this.p.interpSchID);
        WellInterp interp = this.getBlock().interp;
        if (scheme != null && interp != null) {
            List list = interp.getIGDList(scheme.getIGDType(), scheme.getID());
            if (list == null) {
                return;
            }
            this.intervals = new LinkedList();
            for (IGDIntervalZone zone : list) {
                float yBase;
                IGDUnit unit;
                if (zone.getUppZone() <= 0 || (unit = scheme.findUnit(zone.getUppZone())) == null) continue;
                double topSampleDepth = this.getBlock().well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseSampleDepth = this.getBlock().well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (!(baseSampleDepth >= (double)this.getBlock().getTopDepth()) || !(topSampleDepth <= (double)this.getBlock().getBaseDepth())) continue;
                double topDepth = Math.max(topSampleDepth, (double)this.getBlock().getTopDepth());
                double baseDepth = Math.min(baseSampleDepth, (double)this.getBlock().getBaseDepth());
                float yTop = this.getBlock().scaleDepth((float)topDepth);
                if (Math.abs(yTop - (yBase = this.getBlock().scaleDepth((float)baseDepth))) < 1.0f) continue;
                DrawZone i = new DrawZone(yTop, yBase, SB.getLighterColour((Color)unit.getColour(), (float)this.p.interpShadingDensity), null, -1, -1, null, null, null, null, topSampleDepth, baseSampleDepth);
                if (zone.getLowZone() > 0 && (unit = scheme.findUnit(zone.getLowZone())) != null) {
                    i.lowColour = SB.getLighterColour((Color)unit.getColour(), (float)this.p.interpShadingDensity);
                }
                i.o = zone;
                this.intervals.add(i);
            }
            if (sections != null) {
                this.intervals = PanelZones.divideDrawZones(this.intervals, sections);
            }
            Collections.sort(this.intervals, new DrawZoneComparator());
        } else {
            this.intervals = null;
        }
    }

    void setDataImages(ChartProperties cp, double[][] sections) throws SBException {
        System.out.println("PanelTaxon setting image data...");
        float width = this.p.imageWidth - this.p.imagePadding;
        LinkedList<SBPanel.ChartImage> newImages = new LinkedList<SBPanel.ChartImage>();
        try {
            Iterator sampleIt = this.getBlock().well.getSamples().iterator();
            int i = 0;
            while (sampleIt.hasNext()) {
                Sample sample = (Sample)sampleIt.next();
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    if (!this.parent.useAnalysis(smpdtl, true)) continue;
                    for (TaxonOcc occ : smpdtl.getOccur()) {
                        if (!occ.hasImageSet() || !this.useOcc(occ) || this.p.filterMkrImages && !occ.isMarker()) continue;
                        double sampleDepth = this.getBlock().well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                        float yPos = this.getBlock().scaleDepth((float)sampleDepth);
                        SBPanel.ChartImage pi = null;
                        if (this.images != null && this.images.size() > i) {
                            if (this.images.get((int)i).object == occ) {
                                pi = this.images.get(i);
                                pi.origTop = yPos;
                                pi.depth = sampleDepth;
                            } else {
                                for (int j = i; j < this.images.size(); ++j) {
                                    TaxonOcc to = (TaxonOcc)this.images.get((int)j).object;
                                    to.deleteObserver((Observer)this);
                                }
                                this.images = null;
                            }
                        }
                        if (pi == null) {
                            ImageIcon icon = occ.getImage().getImage();
                            float imgHeight = icon.getIconHeight();
                            float imgWidth = icon.getIconWidth();
                            if (imgWidth > width) {
                                imgHeight /= imgWidth / width;
                                imgWidth = width;
                            }
                            pi = new SBPanel.ChartImage(this, icon, yPos, imgWidth, imgHeight);
                            pi.object = occ;
                            pi.depth = sampleDepth;
                            occ.getImageSet().clearImages();
                            occ.addObserver((Observer)this);
                        }
                        newImages.add(pi);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SBException("Error setting data in taxon images panel:\n" + e.getMessage());
        }
        this.images = newImages;
        if (this.images.isEmpty()) {
            return;
        }
        float[] symbolSizes = new float[this.images.size()];
        float[] movedPositions = new float[this.images.size()];
        for (int i = 0; i < this.images.size(); ++i) {
            SBPanel.ChartImage pi = this.images.get(i);
            symbolSizes[i] = pi.height + 1.0f + cp.fontTiny;
            movedPositions[i] = pi.origTop - pi.height / 2.0f;
        }
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int j = 0; j < sections.length - 1; ++j) {
                int k;
                for (k = pos; k < movedPositions.length && !(this.images.get((int)k).depth > sections[j + 1][1]); ++k) {
                }
                if (k - pos > 0) {
                    float[] section = Arrays.copyOfRange(movedPositions, pos, k);
                    float pos1 = (float)sections[j][0];
                    float pos2 = (float)sections[j + 1][0];
                    float[] symbolSizesSection = Arrays.copyOfRange(symbolSizes, pos, k);
                    PanelTaxon.moveSamplePositions(k - pos, section, symbolSizesSection, Math.min(pos1, pos2), Math.max(pos1, pos2) - symbolSizesSection[symbolSizesSection.length - 1]);
                    System.arraycopy(section, 0, movedPositions, pos, k - pos);
                }
                pos = k;
            }
        } else {
            float hPosition = this.getBlock().scaleDepth(this.getBlock().getTopDepth());
            float lPosition = this.getBlock().scaleDepth(this.getBlock().getBaseDepth()) - this.images.getLast().height - cp.fontTiny - 2.0f;
            PanelTaxon.moveSamplePositions(this.images.size(), movedPositions, symbolSizes, hPosition, lPosition);
        }
        for (int i = 0; i < this.images.size(); ++i) {
            this.images.get((int)i).movedTop = movedPositions[i];
        }
    }

    void updateImage(TaxonOcc occ) throws SQLException, SBException, IOException {
        System.out.println("PanelTaxon updating image for: " + occ);
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        float width = this.p.imageWidth - this.p.imagePadding;
        for (SBPanel.ChartImage image : this.images) {
            if (image.object != occ) continue;
            ImageIcon icon = occ.getImage().getImage();
            float imgHeight = icon.getIconHeight();
            float imgWidth = icon.getIconWidth();
            if (imgWidth > width) {
                imgHeight /= imgWidth / width;
                imgWidth = width;
            }
            SBPanel.ChartImage newImage = new SBPanel.ChartImage(this, icon, image.origTop, imgWidth, imgHeight);
            newImage.object = occ;
            newImage.movedTop = image.movedTop;
            occ.getImageSet().clearImages();
            int index = this.images.indexOf(image);
            this.images.add(index, newImage);
            this.images.remove(image);
            return;
        }
        System.out.println("TaxonPanel updateImage did not find image to update for occ: " + occ);
    }

    void drawImagesPanel(SBGraphics g, float y, float xpos, BlockProperties bp, ChartProperties cp, Chart.Mode mode) throws SQLException, SBException {
        if (this.images == null || this.images.isEmpty()) {
            return;
        }
        if (bp == this.getBlock().prop || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01) {
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.height + PanelTaxon.getPanelHeaderHeight(cp, mode));
            String subHeader = "Images" + (this.p.filterMkrImages ? " (markers)" : "");
            this.drawSubHeader(g, xpos, xpos + this.p.imageWidth, y, cp, bp, subHeader);
        } else {
            g.drawLine(xpos, y + PanelTaxon.getPanelHeaderHeight(cp, mode) + this.getBlock().scaleDepth(bp.getNormal() ? bp.min : bp.max), xpos, y + bp.height + PanelTaxon.getPanelHeaderHeight(cp, mode) + this.getBlock().scaleDepth(bp.getNormal() ? bp.min : bp.max));
        }
        g.setStroke(0.1f);
        g.setColor(Color.BLACK);
        g.setFontSize(cp.fontTiny);
        float shift = y + PanelTaxon.getPanelHeaderHeight(cp, mode);
        float xincr = this.p.imagePadding / 3.0f;
        for (SBPanel.ChartImage pi : this.images) {
            if (bp instanceof SubBlockProperties && (pi.depth < (double)bp.min || pi.depth > (double)bp.max)) continue;
            float xleft = xpos;
            g.drawLine(xleft, pi.origTop + shift, xleft += xincr, pi.origTop + shift);
            g.drawLine(xleft, pi.origTop + shift, xleft += xincr, pi.movedTop + shift + pi.height / 2.0f);
            g.drawLine(xleft, pi.movedTop + shift + pi.height / 2.0f, xleft += xincr, pi.movedTop + shift + pi.height / 2.0f);
            g.drawImage(pi.image, xleft, pi.movedTop + shift + 0.5f, this.p.imageWidth - this.p.imagePadding, pi.height);
            g.drawRect(xleft, pi.movedTop + shift + 0.5f, this.p.imageWidth - this.p.imagePadding, pi.height);
            float yString = pi.movedTop + shift + pi.height + cp.fontTiny + 0.5f;
            g.drawString(((TaxonOcc)pi.object).toStringNoCat(), xleft, yString, this.p.imageWidth - this.p.imagePadding, 1);
        }
    }

    boolean checkSpecFilter() throws SQLException, SBException {
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl dtl : sample.getAnalyses()) {
                if (!this.parent.useAnalysis(dtl, true)) continue;
                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                    if (occ.getTaxon().getSpecID() != this.filter_spec.getSpecID()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    char getDiscID() {
        return this.parent.getDiscID().getChar();
    }

    private float[][][] sortTracks(float[][][] sampleData, HashMap[][] tally) {
        assert (this.tracks.size() == this.nTracks);
        Object[] trackArr = this.tracks.toArray();
        Collections.sort(this.tracks, new TaxonTrackComparator(this.p.sortType));
        float[][][] newSampleData = new float[this.parent.getnSamples()][this.nTracks][];
        String[][] newCurveLabels = new String[this.parent.getnSamples()][this.nTracks];
        Color[][] newColours = new Color[this.nTracks][];
        ChartObject[][] newEvents = this.events == null ? (ChartObject[][])null : new ChartObject[this.nTracks][];
        HashMap[][] newTally = tally == null ? (HashMap[][])null : new HashMap[this.parent.getnSamples()][this.nTracks];
        block0: for (int b = 0; b < this.nTracks; ++b) {
            TaxonTrack track = this.tracks.get(b);
            for (int a = 0; a < this.nTracks; ++a) {
                if (trackArr[a] != track) continue;
                for (int s = 0; s < this.parent.getnSamples(); ++s) {
                    newSampleData[s][b] = sampleData[s][a];
                    newCurveLabels[s][b] = this.curveLabels[s][a];
                    if (newTally == null) continue;
                    newTally[s][b] = tally[s][a];
                }
                if (!this.p.colourSuites) {
                    newColours[b] = this.colours[a];
                }
                if (newEvents == null) continue block0;
                newEvents[b] = this.events[a];
                continue block0;
            }
        }
        this.curveLabels = newCurveLabels;
        this.events = newEvents;
        if (!this.p.colourSuites) {
            this.colours = newColours;
        }
        if (newTally != null) {
            System.arraycopy(newTally, 0, tally, 0, tally.length);
        }
        return newSampleData;
    }

    @Override
    String getDataProps() {
        String[] data = new String[]{"" + (this.filter_set != null ? this.filter_set.getID() : 0), "" + (this.filter_group != null ? this.filter_group.getID() : 0), "" + (this.filter_spec != null ? this.filter_spec.getSpecID() : 0), "" + (this.filter_cat != null ? this.filter_cat.getMnem() : ""), "" + (this.includeSubCats ? 1 : 0)};
        String props = "";
        for (String string : data) {
            props = props + string + "|";
        }
        return props;
    }

    @Override
    boolean setFilterGroup(TxGroup group) {
        boolean change = false;
        if (group != this.filter_group) {
            change = true;
            this.filter_group = group;
        }
        return change;
    }

    boolean setFilterSpec(Taxon spec) {
        boolean change = false;
        if (spec != this.filter_spec) {
            change = true;
            this.filter_spec = spec;
        }
        return change;
    }

    @Override
    boolean setFilterSet(TxGroupSet set) {
        boolean change = false;
        if (set != this.filter_set) {
            change = true;
            this.filter_set = set;
        }
        return change;
    }

    @Override
    boolean setFilterCat(Category cat, boolean includeSubCats) {
        boolean change = false;
        if (cat != this.filter_cat) {
            change = true;
            this.filter_cat = cat;
        }
        if (this.includeSubCats != includeSubCats) {
            change = true;
            this.includeSubCats = includeSubCats;
        }
        return change;
    }

    Iterator getTrackIterator() {
        return this.tracks.iterator();
    }

    @Override
    int getnTracks() {
        assert (this.nTracks == this.tracks.size());
        return this.tracks.size();
    }

    String getTextTitle(String delim) {
        String titles = "";
        switch (this.p.track_style) {
            case SINGLE: {
                for (TaxonTrack track : this.tracks) {
                    if (!titles.isEmpty()) {
                        titles = titles + delim;
                    }
                    titles = titles + track.name;
                }
                break;
            }
            case MULTI: {
                for (String s : this.tracks.get((int)0).curveNames) {
                    if (!titles.isEmpty()) {
                        titles = titles + delim;
                    }
                    titles = titles + s;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return titles;
    }

    String getText(int nSample, String delim) {
        String text = "";
        switch (this.p.track_style) {
            case SINGLE: {
                for (int i = 0; i < this.nTracks; ++i) {
                    if (i > 0) {
                        text = text + delim;
                    }
                    if (this.p.showAbundance) {
                        if (this.curveLabels[nSample][i] == null) continue;
                        text = text + this.curveLabels[nSample][i];
                        continue;
                    }
                    int nCurve = this.curveData[nSample][i].length - 1;
                    text = text + (this.curveData[nSample][i][nCurve] > 0.0f ? Float.valueOf(this.curveData[nSample][i][nCurve]) : "");
                    if (!this.p.showFlags) continue;
                    text = text + (this.curveLabels[nSample][i] != null ? this.curveLabels[nSample][i] : "");
                }
                break;
            }
            case MULTI: {
                for (int i = 0; i < this.nCurves; ++i) {
                    float val;
                    if (i > 0) {
                        text = text + delim;
                    }
                    if (!(this.curveData[nSample][0][i] > 0.0f) || !((val = this.curveData[nSample][0][i] - (i > 0 ? this.curveData[nSample][0][i - 1] : 0.0f)) > 0.0f)) continue;
                    text = text + val;
                }
                break;
            }
        }
        return text;
    }

    int getNtracks() {
        return this.nTracks;
    }

    int getNcurves() {
        return this.nCurves;
    }

    float[][][] getCurveData() {
        return this.curveData;
    }

    private static class TaxonTrackComparator
    implements Comparator {
        private final int sort;

        TaxonTrackComparator(int sort) {
            this.sort = sort;
        }

        public int compare(Object o1, Object o2) {
            String t1name;
            if (!(o1 instanceof TaxonTrack) || !(o2 instanceof TaxonTrack)) {
                throw new IllegalArgumentException("Unidentified object in Taxon Track Comparator");
            }
            TaxonTrack t1 = (TaxonTrack)o1;
            TaxonTrack t2 = (TaxonTrack)o2;
            String string = t1.object instanceof Taxon ? ((Taxon)t1.object).toString(false, false, false) : (t1name = t1.object instanceof Genus ? ((Genus)t1.object).toString(false) : t1.name);
            String t2name = t2.object instanceof Taxon ? ((Taxon)t2.object).toString(false, false, false) : (t2.object instanceof Genus ? ((Genus)t2.object).toString(false) : t2.name);
            switch (this.sort) {
                case 3: {
                    return t1name.compareTo(t2name);
                }
                case 0: 
                case 1: {
                    if (!t1.hasData() || !t2.hasData()) {
                        if (!t1.hasData() && !t2.hasData()) {
                            return t1.name.compareTo(t2.name);
                        }
                        if (t1.hasData()) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this.sort == 0) {
                        if (t1.nSampleTop < t2.nSampleTop) {
                            return -1;
                        }
                        if (t1.nSampleTop > t2.nSampleTop) {
                            return 1;
                        }
                        if (t1.nSampleBase < t2.nSampleBase) {
                            return -1;
                        }
                        if (t1.nSampleBase > t2.nSampleBase) {
                            return 1;
                        }
                        return t1name.compareTo(t2name);
                    }
                    if (t1.nSampleBase > t2.nSampleBase) {
                        return -1;
                    }
                    if (t1.nSampleBase < t2.nSampleBase) {
                        return 1;
                    }
                    if (t1.nSampleTop > t2.nSampleTop) {
                        return -1;
                    }
                    if (t1.nSampleTop < t2.nSampleTop) {
                        return 1;
                    }
                    return t1name.compareTo(t2name);
                }
            }
            assert (false);
            return 0;
        }
    }

    class TaxonTrack {
        final AttributedString attName;
        final String name;
        final Object object;
        final String[] curveNames;
        float width;
        Double minAge;
        Double maxAge;
        String unit1;
        String unit2;
        Color col1;
        Color col2;
        Integer nSampleTop;
        Integer nSampleBase;

        TaxonTrack(AttributedString attName, String name, String[] curveNames, Object object) {
            this.width = ((PanelTaxon)PanelTaxon.this).p.minWidth;
            this.minAge = null;
            this.maxAge = null;
            this.unit1 = null;
            this.unit2 = null;
            this.col1 = null;
            this.col2 = null;
            if (name == null) {
                name = "";
            }
            this.name = name;
            this.curveNames = curveNames;
            this.attName = attName;
            this.object = object;
        }

        String getToken(int i) {
            StringTokenizer tok = new StringTokenizer(this.name.toString(), "   ");
            String cat = tok.nextToken();
            if (i == 0) {
                return cat;
            }
            String tname = "";
            if (tok.hasMoreTokens()) {
                tname = tok.nextToken();
            }
            while (tok.hasMoreTokens()) {
                tname = tname + " " + tok.nextToken();
            }
            if (i == 1) {
                return tname;
            }
            return "";
        }

        boolean hasHeaderData() {
            return this.minAge != null || this.maxAge != null || this.unit1 != null || this.unit2 != null;
        }

        void setDataRange(int nSample, Boolean outside) {
            if (outside != null) {
                if (outside.booleanValue()) {
                    this.nSampleTop = -1;
                } else {
                    this.nSampleBase = -1;
                }
            } else {
                if (this.nSampleTop == null || nSample < this.nSampleTop) {
                    this.nSampleTop = nSample;
                }
                if (this.nSampleBase == null || nSample > this.nSampleBase) {
                    this.nSampleBase = nSample;
                }
            }
        }

        boolean hasData() {
            return this.nSampleTop != null && this.nSampleBase != null;
        }

        public String toString() {
            return this.name + " (" + this.nSampleTop + " - " + this.nSampleBase + ")";
        }
    }

    private static class DrawZoneComparator
    implements Comparator<DrawZone> {
        private DrawZoneComparator() {
        }

        @Override
        public int compare(DrawZone o1, DrawZone o2) {
            if (o1.o != null && o1.o instanceof IGDIntervalZone && o2.o != null && o2.o instanceof IGDIntervalZone) {
                IGDIntervalZone z1 = (IGDIntervalZone)o1.o;
                IGDIntervalZone z2 = (IGDIntervalZone)o2.o;
                if (z1.getHier() > z2.getHier()) {
                    return 1;
                }
                if (z1.getHier() < z2.getHier()) {
                    return -1;
                }
            }
            return 0;
        }
    }

    class PanelTaxonObject {
        TaxonTrack track;
        Sample sample;
        Smpdtl smpdtl;

        PanelTaxonObject(TaxonTrack track, Sample sample, Smpdtl smpdtl) {
            this.track = track;
            this.sample = sample;
            this.smpdtl = smpdtl;
        }

        Object getObject() {
            return this.track.object;
        }
    }
}

