/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelProperties;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonPropertiesBase;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import model2.Category;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.TxGroupSet;

public abstract class PanelTaxonBase
extends SBPanel
implements Observer {
    final PanelTaxonGroup parent;

    PanelTaxonBase(PanelTaxonGroup parent) {
        this.parent = parent;
    }

    abstract void setProperties(PanelProperties var1);

    abstract PanelTaxonPropertiesBase getPanelTaxonProperties();

    abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, BlockProperties var5, Chart.Mode var6, int var7, int var8, Integer var9);

    abstract int getnTracks();

    abstract boolean hasFilter();

    abstract boolean setFilterGroup(TxGroup var1);

    abstract TxGroup getFilterGroup();

    abstract boolean setFilterCat(Category var1, boolean var2);

    abstract boolean setFilterSet(TxGroupSet var1);

    abstract Category getFilterCat();

    abstract boolean getIncludeSubCats();

    abstract TxGroupSet getFilterSet();

    abstract Taxon getFilterSpec();

    String getCaption(boolean includeSubCaption) {
        String hdr = this.getFilterCat() != null ? this.getFilterCat().getMnem() : (this.getFilterGroup() != null ? this.getFilterGroup().getName() : (this.getFilterSet() != null ? this.getFilterSet().getName() : (this.getFilterSpec() != null ? this.getFilterSpec().toString(false, false) : "all " + this.parent.getDiscID().getAbr(true))));
        if (includeSubCaption) {
            hdr = hdr + this.getSubCaption();
        }
        return hdr;
    }

    public String toString() {
        return this.getCaption(false);
    }

    void drawInnerCaption(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, String caption, String subCaption) {
        float fontSize;
        float ypos = y;
        if (caption != null && !caption.isEmpty()) {
            fontSize = cp.fontHeader - 1.0f;
            g.setFont(cp.font, 1, fontSize);
            g.drawString(caption, x, y + fontSize, this.getWidth(bp), 0);
        }
        if (subCaption != null && !subCaption.isEmpty() && cp.panelCaptionHeight - (ypos - y) > (fontSize = cp.fontHeader - 2.0f)) {
            g.setFont(cp.font, 0, fontSize);
            g.drawString(subCaption, x, y + cp.fontHeader + fontSize, this.getWidth(bp), 0);
        }
    }

    boolean useOcc(TaxonOcc occ) throws SQLException {
        if (!this.parentUseOcc(occ)) {
            return false;
        }
        if (this.getFilterCat() != null) {
            if (this.getIncludeSubCats() ? !occ.getTaxon().getCatMnem().startsWith(this.getFilterCat().getMnem()) : !occ.getTaxon().getCatMnem().equals(this.getFilterCat().getMnem())) {
                return false;
            }
        } else if (this.getFilterSet() != null) {
            boolean found = false;
            for (TxGroup group : this.getFilterSet().getGroups()) {
                if (!group.isMember(occ.getTaxon().getSpecID())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (this.getFilterGroup() != null ? !this.getFilterGroup().isMember(occ.getTaxon().getSpecID()) : this.getFilterSpec() != null && occ.getTaxon().getSpecID() != this.getFilterSpec().getSpecID()) {
            return false;
        }
        PanelTaxonPropertiesBase p = this.getPanelTaxonProperties();
        if (p.subTypes != null && !p.subTypes.contains(occ.getSpecType())) {
            return false;
        }
        boolean include = false;
        if (!occ.isQualified() && p.includeUnqualified) {
            include = true;
        }
        if (occ.getReworked() && p.includeRw) {
            include = true;
        }
        if (occ.getCaved() && p.includeCv) {
            include = true;
        }
        if (occ.getQuestionable() && p.includeQ) {
            include = true;
        }
        return include;
    }

    boolean parentUseOcc(TaxonOcc occ) throws SQLException {
        if (this.parent.filter_set != null) {
            boolean found = false;
            for (TxGroup group : this.parent.filter_set.getGroups()) {
                if (!group.isMember(occ.getTaxon().getSpecID())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    Boolean isOutsideBlockRange(Sample sample) {
        float depth = (float)sample.getDepth();
        if (depth < this.parent.getBlock().getTopDepth()) {
            return true;
        }
        if (depth > this.parent.getBlock().getBaseDepth()) {
            return false;
        }
        return null;
    }

    abstract String getDataProps();

    void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        if (key.length() > 9) {
            throw new IllegalArgumentException("Key too long for PanelTaxonBaseProperties: " + key);
        }
        Lastval.putString((SBdb)sbdb, (String)key, (String)valuePrefix);
        Lastval.putString((SBdb)sbdb, (String)(key + "P"), (String)this.getDataProps());
        this.getPanelTaxonProperties().writeProperties(sbdb, key, valuePrefix);
    }
}

