/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelDendrogram;
import jsbugs.PanelDendrogramProperties;
import jsbugs.PanelProperties;
import jsbugs.PanelSamples;
import jsbugs.PanelSamplesProperties;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonProperties;
import jsbugs.PanelTaxonPropertiesBase;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.AnalystHeader;
import model2.Category;
import model2.Discipline;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.TxGroupSet;
import model2.Well;
import util.SBException;

public class PanelTaxonGroup
extends SBPanel
implements Observer,
PanelProperties {
    private final LinkedList<PanelTaxonBase> panels = new LinkedList();
    private PanelDendrogram panelDendrogram = null;
    private final SBdb db;
    private final WellBlock block;
    private final Discipline discID;
    TxGroupSet filter_set = null;
    List<Sample.SampleType> sampleTypes = null;
    List<AnalystHeader> suites = null;
    PanelTaxonPropertiesBase defaultProperties;
    private int nSamples;
    float[] samplePosition;
    float[] origSamplePosition;
    Boolean[] barren;
    private String[][] sampleString;
    Sample[] plotSamples;
    private String[] analystString;
    private Color[] analystColour;
    private List<Map.Entry<Integer, PanelTaxon.TaxonTrack>> alphabeticKeyList;
    boolean showSamples = true;
    boolean showAnalyst = true;
    float sampleWidth = 0.0f;
    float analystWidth = 15.0f;
    PanelSamplesProperties panelSamplesProperties;
    boolean moveSamplePositions = true;
    boolean alphabeticKey = false;
    int synschID = 0;
    private static final float BRACKET = 2.0f;

    PanelTaxonGroup(SBdb db, WellBlock block, Discipline discID) {
        this.db = db;
        this.block = block;
        this.discID = discID;
        this.panelSamplesProperties = new PanelSamplesProperties(db, "TAXSAMPREF");
        this.init();
    }

    PanelTaxonGroup(SBdb db, WellBlock block, String prop, LinkedList<Chart.ChartPref> panelProps) throws SBException, SQLException {
        this.db = db;
        this.block = block;
        String[] propSplit = prop.split("\\*");
        if (propSplit.length > 0) {
            Discipline disc = Discipline.getDisc((String)propSplit[0]);
            this.discID = disc != null ? disc : Discipline.MICRO;
            if (propSplit.length == 3) {
                this.decode(db, propSplit[2]);
            }
        } else {
            this.discID = Discipline.MICRO;
        }
        ListIterator it = panelProps.listIterator();
        String sampleProps = null;
        while (it.hasNext()) {
            Chart.ChartPref pref = (Chart.ChartPref)it.next();
            if (!pref.key.endsWith("S")) continue;
            sampleProps = pref.value;
            it.remove();
            break;
        }
        this.panelSamplesProperties = sampleProps != null ? new PanelSamplesProperties(sampleProps) : new PanelSamplesProperties(db, "TAXSAMPREF");
        PanelTaxonBase panel = panelProps.size() > 2 ? new PanelTaxon(this, this.discID, panelProps) : new PanelDendrogram(this, panelProps);
        this.defaultProperties = panel.getPanelTaxonProperties();
        this.addPanel(panel);
        this.init();
    }

    private void init() {
        this.block.well.addObserver((Observer)this);
    }

    private void decode(SBdb sbdb, String props) throws SQLException {
        String[] s = props.split("\\|");
        block10: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    int ID;
                    int n = ID = s[i].isEmpty() ? 0 : Integer.parseInt(s[i]);
                    if (ID <= 0 || i != 0) continue block10;
                    this.filter_set = sbdb.getTxGroupSet(ID);
                    continue block10;
                }
                case 1: {
                    if (s[i].isEmpty()) continue block10;
                    this.suites = new LinkedList<AnalystHeader>();
                    String[] hdrStrings = s[i].split(",");
                    HashSet<Integer> hdrIDs = new HashSet<Integer>();
                    for (String strg : hdrStrings) {
                        hdrIDs.add(Integer.parseInt(strg));
                    }
                    List analystHeaders = this.block.well.getAnalystHeaders();
                    for (AnalystHeader hdr : analystHeaders) {
                        if (!hdrIDs.contains(hdr.getAnalyID())) continue;
                        this.suites.add(hdr);
                    }
                    if (!this.suites.isEmpty()) continue block10;
                    this.suites = null;
                    continue block10;
                }
                case 2: {
                    String[] typeStrings;
                    if (s[i].isEmpty()) continue block10;
                    this.sampleTypes = new LinkedList<Sample.SampleType>();
                    for (String strg : typeStrings = s[i].split(",")) {
                        this.sampleTypes.add(Sample.SampleType.valueOf((String)strg));
                    }
                    continue block10;
                }
                case 3: {
                    this.showSamples = this.getBoolean(s[i]);
                    continue block10;
                }
                case 4: {
                    this.showAnalyst = this.getBoolean(s[i]);
                    continue block10;
                }
                case 5: {
                    this.moveSamplePositions = this.getBoolean(s[i]);
                    continue block10;
                }
                case 6: {
                    this.alphabeticKey = this.getBoolean(s[i]);
                    continue block10;
                }
                case 7: {
                    this.synschID = Integer.parseInt(s[i]);
                    if (this.synschID <= 0 || sbdb.getSynSch(this.synschID) != null) continue block10;
                    this.synschID = 0;
                }
            }
        }
    }

    void addPanel(LinkedList<Chart.ChartPref> panelProps) throws SBException, SQLException {
        PanelTaxonBase panel = panelProps.size() > 2 ? new PanelTaxon(this, this.discID, panelProps) : new PanelDendrogram(this, panelProps);
        this.addPanel(panel);
        HashSet<PanelProperties> propSet = new HashSet<PanelProperties>();
        PanelTaxonPropertiesBase defaultProps = null;
        for (PanelTaxonBase p : this.panels) {
            if (propSet.add(p.getProperties())) continue;
            defaultProps = p.getPanelTaxonProperties();
            break;
        }
        if (defaultProps != null) {
            for (PanelTaxonBase p : this.panels) {
                if (p.getProperties() == defaultProps || !p.getProperties().equals(defaultProps)) continue;
                p.setProperties(defaultProps);
            }
            this.defaultProperties = defaultProps;
        }
    }

    void removePanel(PanelTaxonBase panel) {
        this.panels.remove(panel);
    }

    void addDefaultPanel(boolean dendrogram) {
        if (this.panels.isEmpty()) {
            PanelTaxonBase panel = !dendrogram ? new PanelTaxon(this, this.defaultProperties == null ? null : (PanelTaxonProperties)this.defaultProperties) : new PanelDendrogram(this, this.defaultProperties == null ? null : (PanelDendrogramProperties)this.defaultProperties);
            this.addPanel(panel);
        }
    }

    void addGroupPanels(boolean dendrogram) throws SQLException {
        if (!this.panels.isEmpty()) {
            return;
        }
        if (this.filter_set == null) {
            throw new IllegalStateException("Can't add group panels when no filter set selected");
        }
        this.defaultProperties.inheritFilterColours = true;
        for (TxGroup grp : this.filter_set.getGroups()) {
            PanelTaxonBase panel = !dendrogram ? new PanelTaxon(this, this.defaultProperties != null ? (PanelTaxonProperties)this.defaultProperties : null) : new PanelDendrogram(this, this.defaultProperties != null ? (PanelDendrogramProperties)this.defaultProperties : null);
            panel.setFilterGroup(grp);
            grp.addObserver((Observer)panel);
            this.addPanel(panel);
        }
    }

    void addCatPanels(boolean dendrogram) throws SQLException, SBException {
        if (!this.panels.isEmpty()) {
            return;
        }
        LinkedList<Category> cats = new LinkedList<Category>();
        for (Sample sample : this.block.well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    Category c = this.getDb().getCategory(occ.getTaxon().getCatMnem());
                    if (cats.contains(c)) continue;
                    cats.add(c);
                }
            }
        }
        Collections.sort(cats);
        for (Category cat : cats) {
            PanelTaxonBase panel = !dendrogram ? new PanelTaxon(this, this.defaultProperties != null ? (PanelTaxonProperties)this.defaultProperties : null) : new PanelDendrogram(this, this.defaultProperties != null ? (PanelDendrogramProperties)this.defaultProperties : null);
            panel.setFilterCat(cat, true);
            this.addPanel(panel);
        }
        this.defaultProperties.inheritFilterColours = true;
    }

    void clearPanels() {
        for (PanelTaxonBase panel : this.panels) {
            panel.deleteObserver(this);
        }
        this.panels.clear();
    }

    PanelTaxonGroup duplicate() {
        PanelTaxonGroup panelG = new PanelTaxonGroup(this.db, this.block, this.discID);
        for (PanelTaxonBase panel : this.panels) {
            PanelTaxonBase base = panel instanceof PanelTaxon ? new PanelTaxon(panelG, new PanelTaxonProperties(((PanelTaxon)panel).getProperties())) : new PanelDendrogram(panelG, new PanelDendrogramProperties((PanelDendrogramProperties)panel.getPanelTaxonProperties()));
            panelG.addPanel(base);
        }
        return panelG;
    }

    void setDefaultProperties(PanelTaxonPropertiesBase dProp) {
        if (dProp == null) {
            throw new NullPointerException("Attempt to set PanelTaxonGroup default properties to null");
        }
        for (PanelTaxonBase panel : this.panels) {
            if (panel.getProperties() != this.defaultProperties) continue;
            panel.setProperties(dProp);
        }
        this.defaultProperties = dProp;
    }

    final SBdb getDb() {
        return this.db;
    }

    final WellBlock getBlock() {
        return this.block;
    }

    Discipline getDiscID() {
        return this.discID;
    }

    final void addPanel(PanelTaxonBase panel) {
        if (panel != null && !this.panels.contains(panel)) {
            if (this.panels.isEmpty()) {
                this.defaultProperties = panel.getPanelTaxonProperties();
            }
            panel.addObserver(this);
            if (!this.panels.isEmpty() && this.panels.get(0).getClass() != panel.getClass()) {
                throw new IllegalArgumentException("Cannot add " + panel + " to outer panel - wrong type");
            }
            this.panels.add(panel);
        }
    }

    @Override
    int size() {
        return this.panels.size();
    }

    int getnSamples() {
        return this.nSamples;
    }

    boolean alphabeticKey() {
        return this.alphabeticKey && this.alphabeticKeyList != null;
    }

    List<PanelTaxonBase> getPanels() {
        return new LinkedList<PanelTaxonBase>(this.panels);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float xpos = x;
        try {
            boolean firstOrOnlyBlock;
            int firstSample = 0;
            int lastSample = 0;
            if (this.getBlock().prop == bp) {
                firstSample = 0;
                lastSample = this.nSamples;
            } else {
                Integer begin = null;
                int end = 0;
                for (int i = 0; i < this.samplePosition.length; ++i) {
                    Sample s = this.plotSamples[i];
                    double sampleDepth = this.getBlock().well.getDepth(s, cp.correctDepths, cp.correctCuttings);
                    if (!(sampleDepth >= (double)bp.min) || !(sampleDepth <= (double)bp.max)) continue;
                    if (begin == null) {
                        begin = i;
                    }
                    if (i <= end) continue;
                    end = i;
                }
                if (begin != null) {
                    firstSample = begin;
                    lastSample = end + 1;
                }
            }
            if ((firstSample == lastSample || firstSample > lastSample) && firstSample > lastSample) {
                lastSample = firstSample;
            }
            g.setStroke(0.1f);
            g.setFont(cp.font, 0, cp.fontPanel);
            if (this.showSamples) {
                this.drawSamplesPanel(g, xpos, y, cp, bp, mode, firstSample, lastSample);
                xpos += this.sampleWidth;
            }
            if (this.showAnalyst) {
                this.drawAnalystPanel(g, xpos, y, cp, bp, mode, firstSample, lastSample);
                xpos += this.analystWidth;
            }
            Integer iKey = this.alphabeticKey && this.alphabeticKeyList != null ? Integer.valueOf(1) : null;
            float panelPos = xpos;
            for (PanelTaxonBase panel : this.panels) {
                panelPos = panel.draw(g, panelPos, y, cp, bp, mode, firstSample, lastSample, iKey);
                if (iKey == null) continue;
                iKey = iKey + panel.getnTracks();
            }
            float keyHeight = 0.0f;
            if (this.alphabeticKeyList != null && mode != Chart.Mode.NO_HEADER) {
                Map<AttributedCharacterIterator.Attribute, Object> atts = PanelTaxonGroup.getAttributes(g);
                float numHeight = 6.5f;
                keyHeight = cp.panelSubHeaderHeight / 2.0f - (this.panels.size() > 1 ? this.getInnerPanelCaptionHeight(cp) : 0.0f);
                float yposNumber = y + cp.panelCaptionHeight + keyHeight - 1.0f;
                float yposString = yposNumber - numHeight;
                float textPos = xpos + cp.fontSmall;
                g.setFont(cp.font, 0, cp.fontSmall);
                for (Map.Entry<Integer, PanelTaxon.TaxonTrack> e : this.alphabeticKeyList) {
                    g.drawStringVertical("" + e.getKey(), textPos, yposNumber);
                    textPos += cp.fontSmall;
                }
                textPos = xpos + cp.fontSmall;
                for (Map.Entry<Integer, PanelTaxon.TaxonTrack> e : this.alphabeticKeyList) {
                    PanelTaxon.TaxonTrack track = e.getValue();
                    if (track.attName != null) {
                        g.setFont(cp.font, 2, cp.fontSmall);
                        track.attName.addAttributes(atts, 0, track.attName.getIterator().getEndIndex());
                        g.drawStringVertical(track.attName, textPos, yposString, keyHeight - numHeight - 2.0f);
                        g.setFont(cp.font, 0, cp.fontSmall);
                    } else {
                        g.drawStringVertical(track.name, textPos, yposString, keyHeight - numHeight - 2.0f, false, false);
                    }
                    textPos += cp.fontSmall;
                }
            }
            boolean bl = firstOrOnlyBlock = this.block.prop == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01;
            float top = firstOrOnlyBlock ? y + cp.panelCaptionHeight + keyHeight : y + (bp.getNormal() ? this.block.scaleDepth(bp.min) : this.block.scaleDepth(bp.max)) + PanelTaxonGroup.getPanelHeaderHeight(cp, mode);
            if (this.panels.size() > 1) {
                g.setColor(Color.BLACK);
                g.setStroke(0.2f);
                for (PanelTaxonBase panel : this.panels) {
                    float w = panel.getWidth(bp);
                    if (panel.isOutline()) {
                        g.setStroke(0.875f);
                    }
                    g.drawRect(xpos, mode == Chart.Mode.NO_HEADER ? y : top, w, bp.height + (firstOrOnlyBlock ? cp.panelSubHeaderHeight - keyHeight : 0.0f));
                    if (panel.isOutline()) {
                        g.setStroke(0.2f);
                    }
                    if (mode != Chart.Mode.NO_HEADER && firstOrOnlyBlock) {
                        panel.drawInnerCaption(g, xpos, top, cp, bp, panel.getCaption(false), panel.getSubCaption());
                    }
                    xpos += w;
                }
                if (mode != Chart.Mode.NO_HEADER && firstOrOnlyBlock) {
                    g.setStroke(0.2f);
                    float ypos = top + this.getInnerPanelCaptionHeight(cp);
                    g.drawLine(x + (this.showAnalyst ? this.analystWidth : 0.0f) + (this.showSamples ? this.sampleWidth : 0.0f), ypos, xpos, ypos);
                }
            } else {
                if (this.panels.get(0).isOutline()) {
                    g.setStroke(0.875f);
                    g.drawRect(xpos, top, this.panels.get(0).getWidth(bp), bp.height + (firstOrOnlyBlock ? cp.panelSubHeaderHeight - keyHeight : 0.0f));
                    g.setStroke(0.2f);
                }
                if (this.alphabeticKeyList != null) {
                    g.drawLine(x + (this.showAnalyst ? this.analystWidth : 0.0f) + (this.showSamples ? this.sampleWidth : 0.0f), top, x + this.getWidth(bp), top);
                }
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    float getInnerPanelCaptionHeight(ChartProperties cp) {
        return this.abnStyleInCaption() && this.subTypesInCaption() ? cp.fontHeader : cp.panelCaptionHeight;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = 0.0f;
        if (this.showSamples) {
            width += this.sampleWidth;
        }
        if (this.showAnalyst) {
            width += this.analystWidth;
        }
        if (this.panelDendrogram != null) {
            width += this.panelDendrogram.getWidth(bp);
        } else {
            for (PanelTaxonBase panel : this.panels) {
                width += panel.getWidth(bp);
            }
        }
        return width;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float xPos = 0.0f;
        if (this.showSamples) {
            float f;
            xPos += this.sampleWidth;
            if (x < f) {
                return "Samples";
            }
        }
        if (this.showAnalyst) {
            float f;
            xPos += this.analystWidth;
            if (x < f) {
                return "Analysts";
            }
        }
        float lhs = xPos;
        float rhs = xPos;
        if (this.panelDendrogram != null) {
            float f;
            xPos += this.panelDendrogram.getWidth(bp);
            if (x < f) {
                return this.panelDendrogram.getObject(x - lhs, y, cp, bp, zoom);
            }
        } else {
            for (PanelTaxonBase panel : this.panels) {
                float w = panel.getWidth(bp);
                rhs += w;
                if (x > lhs && x <= rhs) {
                    return panel.getObject(x - lhs, y, cp, bp, zoom);
                }
                lhs += w;
            }
        }
        xPos = rhs;
        throw new IllegalArgumentException("Looking for object in wrong panel");
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float xPos = 0.0f;
        if (this.showSamples) {
            float f;
            xPos += this.sampleWidth;
            if (x < f) {
                return "Samples";
            }
        }
        if (this.showAnalyst) {
            float f;
            xPos += this.analystWidth;
            if (x < f) {
                return "Analysts";
            }
        }
        float lhs = xPos;
        float rhs = xPos;
        if (this.panelDendrogram != null) {
            float f;
            xPos += this.panelDendrogram.getWidth(bp);
            if (x < f) {
                return this.panelDendrogram.getTooltip(x - lhs, y, cp, bp, zoom);
            }
        } else {
            for (PanelTaxonBase panel : this.panels) {
                float w = panel.getWidth(bp);
                rhs += w;
                if (x > lhs && x <= rhs) {
                    return panel.getTooltip(x - lhs, y, cp, bp, zoom);
                }
                lhs += w;
            }
        }
        xPos = rhs;
        throw new IllegalArgumentException("Looking for tooltip in wrong panel");
    }

    public String toString() {
        return "Taxa : " + this.getCaption() + (this.getSubCaption(false, false).isEmpty() ? "" : " : " + this.getSubCaption(false, false)) + (this.panels.size() > 1 ? " (" + this.panels.size() + " inner panels)" : "");
    }

    @Override
    String getCaption() {
        if (this.panels.size() == 1 && this.panels.getFirst().hasFilter()) {
            return this.discID.getNoun() + " : " + this.panels.getFirst().getCaption(false);
        }
        return this.discID.getNoun();
    }

    String getSubCaption(boolean includePanels, boolean includeAllString) {
        String hdr = "";
        if (this.filter_set != null) {
            hdr = hdr + this.filter_set.getName();
        } else if (includeAllString) {
            hdr = hdr + "all " + this.discID.getNoun();
        }
        if (this.panels.size() == 1 && this.panels.getFirst().getSubCaption() != null) {
            hdr = hdr + this.panels.getFirst().getSubCaption();
        }
        if (this.suites != null && !this.suites.isEmpty()) {
            if (!hdr.isEmpty()) {
                hdr = hdr + " ";
            }
            hdr = hdr + "by ";
            for (int i = 0; i < this.suites.size(); ++i) {
                if (i > 0) {
                    hdr = hdr + ",";
                }
                hdr = hdr + this.suites.get(i).toString();
            }
        }
        if (includePanels && this.panels.get(0) instanceof PanelTaxon) {
            if (this.subTypesInCaption()) {
                hdr = hdr + ((PanelTaxon)this.panels.get(0)).getSubTypeHeader();
            }
            if (this.abnStyleInCaption()) {
                hdr = hdr + " " + ((PanelTaxon)this.panels.get(0)).getAbnHeader();
            }
        }
        return hdr;
    }

    String getDataDescriptor() {
        String hdr = this.filter_set != null ? this.filter_set.getName() : "all " + this.discID.getAbr(true);
        return hdr;
    }

    @Override
    String getSubCaption() {
        return this.getSubCaption(true, false);
    }

    boolean abnStyleInCaption() {
        if (this.panels.size() > 1 && this.panels.get(0) instanceof PanelTaxon) {
            PanelTaxonProperties.Abundance abn = null;
            PanelTaxonProperties.Calc calc = null;
            for (PanelTaxonBase ptb : this.panels) {
                PanelTaxon p = (PanelTaxon)ptb;
                if (abn == null) {
                    abn = p.getProperties().abn_style;
                    calc = p.getProperties().calc_style;
                    continue;
                }
                if (p.getProperties().abn_style == abn && p.getProperties().calc_style == calc) continue;
                return false;
            }
        }
        return true;
    }

    boolean subTypesInCaption() {
        if (this.panels.size() > 0 && this.panels.get(0) instanceof PanelTaxon) {
            List subTypes = null;
            for (int i = 0; i < this.panels.size(); ++i) {
                PanelTaxon p = (PanelTaxon)this.panels.get(i);
                if (i == 0) {
                    subTypes = p.getProperties().subTypes;
                    continue;
                }
                if (p.getProperties().subTypes == null ^ subTypes == null) {
                    return false;
                }
                if (p.getProperties().subTypes == null || subTypes == null || ((Object)p.getProperties().subTypes).equals(subTypes)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException, IOException {
        System.out.println("PanelTaxonGroup setting data");
        this.setnSamples();
        this.setDataSamples(cp);
        if (this.nSamples > 1) {
            PanelSamples.moveSamplePositions(cp, sections, this.getBlock(), this.samplePosition, this.plotSamples);
        }
        for (PanelTaxonBase panel : this.panels) {
            panel.setData(cp, sections);
        }
        this.setDataAlphabeticKey();
    }

    void setData(ChartProperties cp, double[][] sections, PanelTaxon panel) throws SBException, SQLException {
        System.out.println("PanelTaxonGroup setting data for: " + panel);
        if (this.panels.contains(panel)) {
            panel.setData(cp, sections);
        }
        this.setDataAlphabeticKey();
    }

    private void setnSamples() throws SBException, SQLException {
        this.nSamples = 0;
        for (Sample sample : this.getBlock().well.getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.useAnalysis(smpdtl, true)) continue;
                ++this.nSamples;
            }
        }
        this.samplePosition = new float[this.nSamples];
        this.plotSamples = new Sample[this.nSamples];
        this.analystString = new String[this.nSamples];
        this.analystColour = new Color[this.nSamples];
    }

    void setDataSamples(ChartProperties cp) throws SQLException, SBException {
        assert (this.samplePosition.length == this.nSamples);
        this.barren = new Boolean[this.nSamples];
        LinkedList<Sample> samples = new LinkedList<Sample>();
        Iterator it = this.getBlock().well.getSamples(cp.correctDepths, cp.correctCuttings).iterator();
        int j = 0;
        while (it.hasNext()) {
            Sample sample = (Sample)it.next();
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                if (!this.useAnalysis(smpdtl, true)) continue;
                samples.add(sample);
                this.barren[j] = smpdtl.getBarren();
                this.samplePosition[j] = this.block.scaleDepth((float)this.getBlock().well.getDepth(sample, cp.correctDepths, cp.correctCuttings));
                this.plotSamples[j] = sample;
                this.analystString[j] = smpdtl.getAnalyst() + (smpdtl.getAnalyNo() > 1 ? "/" + smpdtl.getAnalyNo() : "");
                this.analystColour[j] = smpdtl.getHeader().getColour().equals(Color.WHITE) ? Color.BLACK : smpdtl.getHeader().getColour();
                ++j;
            }
        }
        this.sampleString = new String[samples.size()][2];
        int i = 0;
        it = samples.iterator();
        float width = 0.0f;
        while (it.hasNext()) {
            Sample sample = (Sample)it.next();
            this.sampleString[i] = PanelSamples.getSampleString(sample, cp, this.getBlock(), this.panelSamplesProperties);
            float currentSampleWidth = SBGraphics.stringWidth(this.sampleString[i][0], cp.fontSmall) + 8.0f;
            if (currentSampleWidth > width) {
                width = currentSampleWidth + 4.0f;
            }
            ++i;
        }
        this.sampleWidth = width;
        this.origSamplePosition = Arrays.copyOf(this.samplePosition, this.samplePosition.length);
    }

    float getSamplePosition(int i) {
        if (this.moveSamplePositions) {
            return this.samplePosition[i];
        }
        return this.origSamplePosition[i];
    }

    private void setDataAlphabeticKey() {
        if (!this.alphabeticKey) {
            this.alphabeticKeyList = null;
            return;
        }
        HashMap<Integer, PanelTaxon.TaxonTrack> map = new HashMap<Integer, PanelTaxon.TaxonTrack>();
        for (PanelTaxonBase ptb : this.panels) {
            if (!(ptb instanceof PanelTaxon)) continue;
            PanelTaxon panel = (PanelTaxon)ptb;
            if (panel.getProperties().track_style == PanelTaxonProperties.Track.MULTI) continue;
            Iterator it = panel.getTrackIterator();
            while (it.hasNext()) {
                PanelTaxon.TaxonTrack track = (PanelTaxon.TaxonTrack)it.next();
                map.put(map.size() + 1, track);
            }
        }
        if (map.isEmpty()) {
            this.alphabeticKeyList = null;
            return;
        }
        Set entrySet = map.entrySet();
        this.alphabeticKeyList = new LinkedList(entrySet);
        Collections.sort(this.alphabeticKeyList, new Comparator<Map.Entry<Integer, PanelTaxon.TaxonTrack>>(){

            @Override
            public int compare(Map.Entry<Integer, PanelTaxon.TaxonTrack> o1, Map.Entry<Integer, PanelTaxon.TaxonTrack> o2) {
                String o1name = o1.getValue().attName != null ? o1.getValue().getToken(1) : o1.getValue().name;
                String o2name = o2.getValue().attName != null ? o2.getValue().getToken(1) : o2.getValue().name;
                return o1name.compareTo(o2name);
            }
        });
    }

    private void drawSamplesPanel(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int begin, int end) throws SBException, SQLException {
        if (this.getBlock().prop == bp) {
            PanelSamples.drawSamples(g, y, x, cp, mode, this.panelSamplesProperties, this.samplePosition, this.origSamplePosition, this.sampleString, Float.valueOf(this.sampleWidth));
        } else {
            PanelSamples.drawSamples(g, y, x, cp, mode, this.panelSamplesProperties, Arrays.copyOfRange(this.samplePosition, begin, end), Arrays.copyOfRange(this.origSamplePosition, begin, end), (String[][])Arrays.copyOfRange(this.sampleString, begin, end), Float.valueOf(this.sampleWidth));
        }
        float boxsize = 1.0f;
        for (int j = begin; j < end; ++j) {
            if (!this.barren[j].booleanValue()) continue;
            float yPos = y + PanelTaxonGroup.getPanelHeaderHeight(cp, mode) + this.samplePosition[j];
            g.fillRect(x + this.sampleWidth - 2.0f, yPos - 1.0f, 2.0f, 2.0f, Color.BLUE);
        }
        float xpos = x + this.sampleWidth;
        if (mode != Chart.Mode.NO_HEADER && (this.getBlock().prop == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01)) {
            String subHeader = "Samples" + (this.getBlock().prop.units == 'F' ? " (ft)" : " (m)");
            this.drawSubHeader(g, x, xpos, y, cp, bp, subHeader);
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.height + PanelTaxonGroup.getPanelHeaderHeight(cp, mode));
        } else {
            float topy = Math.min(this.getBlock().scaleDepth(bp.min), this.getBlock().scaleDepth(bp.max)) + y + PanelTaxonGroup.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos, topy, xpos, topy + bp.height);
        }
    }

    private void drawAnalystPanel(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample) throws SQLException, SBException {
        g.setFont(cp.font, 0, cp.fontPanel);
        float width = this.analystWidth;
        for (int nSample = 0; nSample < this.nSamples; ++nSample) {
            if (nSample < firstSample || nSample >= lastSample) continue;
            float ypos1 = y + PanelTaxonGroup.getPanelHeaderHeight(cp, mode) + this.samplePosition[nSample];
            g.setColor(this.analystColour[nSample]);
            g.drawString(this.analystString[nSample], x + 1.0f, ypos1 + cp.fontPanel * 2.0f / 5.0f);
            float currentWidth = g.stringWidth(this.analystString[nSample]);
            if (!(currentWidth > width)) continue;
            width = currentWidth + 2.0f;
        }
        this.analystWidth = width;
        float xpos = x + this.analystWidth;
        g.setColor(Color.BLACK);
        if (mode != Chart.Mode.NO_HEADER && (this.getBlock().prop == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.min) < 0.01)) {
            this.drawSubHeader(g, x, xpos, y, cp, bp, "Analyst");
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.height + PanelTaxonGroup.getPanelHeaderHeight(cp, mode));
        } else {
            float topy = Math.min(this.getBlock().scaleDepth(bp.min), this.getBlock().scaleDepth(bp.max)) + y + PanelTaxonGroup.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos, topy, xpos, topy + bp.height);
        }
    }

    PanelTaxonBase getPanel(float x) {
        float lhs = 0.0f;
        if (this.showSamples) {
            float f;
            lhs += this.sampleWidth;
            if (x < f) {
                return null;
            }
        }
        if (this.showAnalyst) {
            float f;
            lhs += this.analystWidth;
            if (x < f) {
                return null;
            }
        }
        float rhs = lhs;
        for (PanelTaxonBase panel : this.panels) {
            float w = panel.getWidth(null);
            rhs += w;
            if (x > lhs && x <= rhs) {
                return panel;
            }
            lhs += w;
        }
        throw new IllegalArgumentException("Looking for TaxonPanel in wrong TaxonPanelGroup");
    }

    Smpdtl getSample(float y, float zoom, BlockProperties bp) {
        assert (this.plotSamples.length == this.samplePosition.length);
        for (int i = 0; i < this.samplePosition.length; ++i) {
            Smpdtl dtl;
            if (!(y > this.samplePosition[i] - 2.0f / zoom) || !(y < this.samplePosition[i] + 2.0f / zoom) || !(this.plotSamples[i].getDepth() >= (double)bp.min) || !(this.plotSamples[i].getDepth() <= (double)bp.max) || (dtl = this.getSmpdtlFromPos(i)) == null) continue;
            return dtl;
        }
        return null;
    }

    private Smpdtl getSmpdtlFromPos(int pos) {
        int i = -1;
        try {
            for (Sample samp : this.getBlock().well.getSamples()) {
                for (Smpdtl smpdtl : samp.getAnalyses()) {
                    if (!this.useAnalysis(smpdtl, true) || ++i != pos) continue;
                    return smpdtl;
                }
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return null;
    }

    boolean useAnalysis(Smpdtl smpdtl, boolean checkSample) {
        if (smpdtl.getDiscID() != this.discID.getChar()) {
            return false;
        }
        Sample sample = smpdtl.getSample();
        if (checkSample && !this.useSampleDepth(sample)) {
            return false;
        }
        if (this.sampleTypes != null && !this.sampleTypes.contains(Sample.SampleType.getType((String)sample.getTypeString()))) {
            return false;
        }
        if (!smpdtl.getBarren() && !smpdtl.isAnalysed()) {
            return false;
        }
        return this.suites == null || this.suites.contains(smpdtl.getHeader());
    }

    boolean useSampleDepth(Sample sample) {
        float depth = (float)sample.getDepth();
        return !(depth < this.getBlock().getTopDepth()) && !(depth > this.getBlock().getBaseDepth());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Observable o, Object arg) {
        System.out.println("PanelTaxonGroup updating (" + this.getCaption() + "),  obs is: " + o + " and arg is:" + arg);
        if (o instanceof Well) {
            if (arg instanceof Sample) {
                Sample sample = (Sample)arg;
                if (!this.useSampleDepth(sample)) {
                    return;
                }
                if (sample.getAnalyses().isEmpty()) {
                    return;
                }
                boolean found = false;
                for (Smpdtl dtl : sample.getAnalyses()) {
                    if (!this.useAnalysis(dtl, false)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            } else if (arg instanceof Smpdtl) {
                if (!this.useAnalysis((Smpdtl)arg, true)) {
                    return;
                }
            } else {
                if (!(arg instanceof AnalystHeader)) return;
                if (((AnalystHeader)arg).getDiscID() != this.discID.getChar() || this.suites != null && !this.suites.contains((AnalystHeader)arg)) {
                    return;
                }
            }
        } else if (o instanceof TxGroup) {
            if (o != this.filter_set) {
                return;
            }
        } else if (o instanceof PanelTaxon) {
            this.setChanged();
            this.notifyObservers(o);
            return;
        }
        this.setChanged();
        this.notifyObservers();
    }

    boolean contains(SBPanel panel) {
        for (PanelTaxonBase p : this.panels) {
            if (p != panel) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    boolean pipe() {
        return true;
    }

    @Override
    public PanelProperties getProperties() {
        return this;
    }

    @Override
    public void setOutline(boolean outline) {
        super.setOutline(outline);
        if (!outline) {
            for (PanelTaxonBase panel : this.panels) {
                panel.setOutline(outline);
            }
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        if (key.length() > 9) {
            throw new IllegalArgumentException("Key too long for PanelTaxonProperties: " + key);
        }
        int panelNo = Integer.parseInt(key.substring(key.length() - 2));
        valuePrefix = valuePrefix + this.discID.getChar() + "*" + panelNo + "*" + this.getPropertiesString();
        --panelNo;
        for (PanelTaxonBase panel : this.panels) {
            String panelNoString = "" + ++panelNo;
            if (panelNoString.length() == 1) {
                panelNoString = "0" + panelNo;
            }
            panel.writeProperties(sbdb, key.substring(0, key.length() - 2) + panelNoString, valuePrefix);
        }
        if (this.showSamples) {
            this.panelSamplesProperties.writeProperties(sbdb, key + "S", "");
        }
    }

    private String getPropertiesString() {
        int i;
        String[] data = new String[8];
        data[0] = "" + (this.filter_set != null ? this.filter_set.getID() : 0);
        if (this.suites != null) {
            String[] suiteStrings = new String[this.suites.size()];
            for (i = 0; i < this.suites.size(); ++i) {
                suiteStrings[i] = "" + this.suites.get(i).getAnalyID();
            }
            data[1] = this.separateWithComma(suiteStrings);
        } else {
            data[1] = "";
        }
        if (this.sampleTypes != null) {
            String[] sampleTypeStrings = new String[this.sampleTypes.size()];
            for (i = 0; i < this.sampleTypes.size(); ++i) {
                sampleTypeStrings[i] = this.sampleTypes.get(i).name();
            }
            data[2] = this.separateWithComma(sampleTypeStrings);
        } else {
            data[2] = "";
        }
        data[3] = "" + (this.showSamples ? 1 : 0);
        data[4] = "" + (this.showAnalyst ? 1 : 0);
        data[5] = "" + (this.moveSamplePositions ? 1 : 0);
        data[6] = "" + (this.alphabeticKey ? 1 : 0);
        data[7] = "" + this.synschID;
        String props = "";
        for (String string : data) {
            props = props + string + "|";
        }
        return props;
    }

    private String separateWithComma(String[] strings) {
        String string = "";
        for (String s : strings) {
            if (!string.isEmpty()) {
                string = string + ",";
            }
            string = string + s;
        }
        return string;
    }

    private boolean getBoolean(String s) {
        return Integer.parseInt(s) == 1;
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void saveText(File file, PanelTaxon inner) throws IOException {
        PanelTaxonBase ptb;
        FileWriter out = new FileWriter(file);
        String delim = ",";
        out.write(this.getCaption() + " " + this.getSubCaption() + "\n");
        String titles = "";
        Iterator i$ = this.panels.iterator();
        while (i$.hasNext() && (ptb = (PanelTaxonBase)i$.next()) instanceof PanelTaxon) {
            PanelTaxon panel = (PanelTaxon)ptb;
            if (!titles.isEmpty()) {
                titles = titles + ",";
            }
            titles = titles + panel.getTextTitle(delim);
        }
        titles = (this.showSamples ? "Sample" + delim : "") + (this.showAnalyst ? "Analyst" + delim : "") + titles;
        out.write(titles + "\n");
        for (int nSample = 0; nSample < this.nSamples; ++nSample) {
            PanelTaxonBase ptb2;
            if (this.showSamples) {
                out.write("" + this.plotSamples[nSample].toString(this.block.prop.units, !this.panelSamplesProperties.drawSymbols, this.panelSamplesProperties.drawLabels) + delim);
            }
            if (this.showAnalyst) {
                out.write("" + this.analystString[nSample] + delim);
            }
            Iterator i$2 = this.panels.iterator();
            while (i$2.hasNext() && (ptb2 = (PanelTaxonBase)i$2.next()) instanceof PanelTaxon) {
                PanelTaxon panel = (PanelTaxon)ptb2;
                if (inner != null && panel != inner) continue;
                out.write(panel.getText(nSample, delim) + delim);
            }
            out.write("\n");
        }
        out.close();
    }
}

