/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jsbugs.Chart;
import jsbugs.InvalidTaxonFieldException;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonPropertiesBase;
import model2.AnalystHeader;
import model2.Discipline;
import model2.Lastval;
import model2.SBdb;
import model2.TxGroup;
import model2.Well;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class PanelTaxonProperties
extends PanelTaxonPropertiesBase {
    Group group = Group.SPEC;
    SubGroup subgroup = SubGroup.NONE;
    Track track_style = Track.SINGLE;
    Calc calc_style = Calc.ABS;
    int sortType = 0;
    Plot plot_style = Plot.HIST;
    Justify justify = Justify.LEFT;
    boolean stratRange = false;
    boolean sawtoothEnhanced = false;
    int sawtoothEnhancement = 5;
    Abundance abn_style = Abundance.MIX;
    boolean showImages = true;
    boolean filterMkrImages = true;
    float imageWidth = 35.0f;
    float imagePadding = 6.0f;
    float cutoff = 100.0f;
    float maxWidth = 40.0f;
    float horzScale = this.maxWidth / this.cutoff;
    float minWidth = 4.0f;
    float sawtoothCutoff = 20.0f;
    boolean showFlags = true;
    boolean showAbundance = true;
    Color colour = Color.RED;
    boolean inheritFilterColour = false;
    boolean colourSuites = false;
    boolean colourLabels = false;
    boolean grid = true;
    boolean clearEmptyTracks = true;
    boolean hdr_cat = true;
    boolean hdr_author = false;
    int cmpStdID = -1;
    int schID = -1;
    boolean schAbrs = true;
    TxGroup highlightGroup = null;
    Color highlightColour = Color.RED;
    int interpSchID = -1;
    float interpShadingDensity = 0.3f;
    boolean drawEvents = false;

    PanelTaxonProperties(SBdb sbdb) {
        this.decode(sbdb);
        this.setScale();
    }

    PanelTaxonProperties(PanelTaxonProperties rhs) {
        super(rhs);
        this.sortType = rhs.sortType;
        this.group = rhs.group;
        this.track_style = rhs.track_style;
        this.calc_style = rhs.calc_style;
        this.plot_style = rhs.plot_style;
        this.justify = rhs.justify;
        this.cutoff = rhs.cutoff;
        this.maxWidth = rhs.maxWidth;
        this.minWidth = rhs.minWidth;
        this.colour = rhs.colour;
        this.colourLabels = rhs.colourLabels;
        this.colourSuites = rhs.colourSuites;
        this.inheritFilterColour = rhs.inheritFilterColour;
        this.abn_style = rhs.abn_style;
        this.showFlags = rhs.showFlags;
        this.subgroup = rhs.subgroup;
        this.hdr_cat = rhs.hdr_cat;
        this.hdr_author = rhs.hdr_author;
        this.schID = rhs.schID;
        this.cmpStdID = rhs.cmpStdID;
        this.schAbrs = rhs.schAbrs;
        this.grid = rhs.grid;
        this.showImages = rhs.showImages;
        this.filterMkrImages = rhs.filterMkrImages;
        this.imageWidth = rhs.imageWidth;
        this.clearEmptyTracks = rhs.clearEmptyTracks;
        this.highlightColour = rhs.highlightColour;
        this.highlightGroup = rhs.highlightGroup;
        this.showAbundance = rhs.showAbundance;
        this.stratRange = rhs.stratRange;
        this.sawtoothEnhanced = rhs.sawtoothEnhanced;
        this.sawtoothEnhancement = rhs.sawtoothEnhancement;
        this.interpSchID = rhs.interpSchID;
        this.interpShadingDensity = rhs.interpShadingDensity;
        this.drawEvents = rhs.drawEvents;
        this.setScale();
    }

    final void setScale() {
        this.horzScale = this.maxWidth / this.cutoff;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        if (key.length() > 9) {
            throw new IllegalArgumentException("Key too long for PanelTaxonProperties: " + key);
        }
        Lastval.putString((SBdb)sbdb, (String)(key + "D"), (String)this.getDataProps());
        Lastval.putString((SBdb)sbdb, (String)(key + "A"), (String)this.getAbnProps());
        Lastval.putString((SBdb)sbdb, (String)(key + "O"), (String)this.getOptionsProps());
    }

    private String getDataProps() {
        String[] data = new String[12];
        data[0] = "";
        data[1] = "";
        data[2] = "";
        data[3] = "";
        data[4] = "";
        data[5] = "";
        data[6] = "";
        if (this.subTypes != null) {
            String[] strings = new String[this.subTypes.size()];
            for (int i = 0; i < this.subTypes.size(); ++i) {
                strings[i] = "" + this.subTypes;
            }
            data[7] = this.separateWithComma(strings);
        } else {
            data[7] = "";
        }
        data[8] = "" + (this.includeRw ? 1 : 0);
        data[9] = "" + (this.includeCv ? 1 : 0);
        data[10] = "" + (this.includeQ ? 1 : 0);
        data[11] = "" + (this.includeUnqualified ? 1 : 0);
        String props = "";
        for (String string : data) {
            props = props + string + "|";
        }
        return props;
    }

    private String getAbnProps() {
        String[] abngroupstyle = new String[]{this.abn_style.name(), "" + (this.useSplits ? 1 : 0), "" + (this.normaliseWeight ? 1 : 0), "" + this.normalWeight, this.group.name(), this.subgroup.name(), this.track_style.name(), this.calc_style.name(), this.plot_style.name(), "" + (this.stratRange ? 1 : 0), "" + (this.sawtoothEnhanced ? 1 : 0), "" + this.sawtoothEnhancement, "" + this.justify.name()};
        String props = "";
        for (String string : abngroupstyle) {
            props = props + string + "|";
        }
        return props;
    }

    private String getOptionsProps() {
        String[] options = new String[]{"" + this.sortType, "" + (this.showImages ? 1 : 0), "" + (this.filterMkrImages ? 1 : 0), "" + this.imageWidth, "" + this.cutoff, "" + this.maxWidth, "" + this.minWidth, SB.getColourString((Color)this.colour), "" + (this.colourSuites ? 1 : 0), "" + (this.colourLabels ? 1 : 0), "", "", "" + (this.showFlags ? 1 : 0), "" + (this.showAbundance ? 1 : 0), "" + (this.clearEmptyTracks ? 1 : 0), "" + (this.grid ? 1 : 0), "" + (this.hdr_cat ? 1 : 0), "" + (this.hdr_author ? 1 : 0), "" + this.cmpStdID, "" + this.schID, "" + (this.schAbrs ? 1 : 0), "" + (this.highlightGroup != null ? Integer.valueOf(this.highlightGroup.getID()) : ""), SB.getColourString((Color)this.highlightColour), "" + this.interpSchID, "" + this.interpShadingDensity, "" + (this.drawEvents ? 1 : 0), "" + (this.inheritFilterColour ? 1 : 0)};
        String props = "";
        for (String string : options) {
            props = props + string + "|";
        }
        return props;
    }

    PanelTaxonProperties(SBdb sbdb, Discipline discID, LinkedList<Chart.ChartPref> props, Well well, PanelTaxonGroup parent) throws SQLException, SBException {
        for (Chart.ChartPref p : props) {
            try {
                if (p.key.endsWith("D")) {
                    this.decodeDataProps(sbdb, p.value, well);
                    continue;
                }
                if (p.key.endsWith("A")) {
                    this.decodeAbnProps(p.value);
                    continue;
                }
                if (p.key.endsWith("O")) {
                    this.decodeOptionProps(sbdb, p.value);
                    continue;
                }
                if (!p.key.endsWith("S")) continue;
            }
            catch (RuntimeException re) {
                System.out.println("Error decoding properties for taxon panel " + p.key);
                re.printStackTrace();
            }
        }
        try {
            this.verify(well, true, parent);
        }
        catch (InvalidFieldException e) {
            throw new SBException("Invlalid field in Panel Taxon: " + e.getMessage());
        }
        this.setScale();
    }

    private void decodeDataProps(SBdb sbdb, String props, Well well) throws SQLException {
        String[] splits = props.split("\\|");
        block12: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    continue block12;
                }
                case 3: {
                    continue block12;
                }
                case 4: {
                    continue block12;
                }
                case 5: {
                    continue block12;
                }
                case 6: {
                    continue block12;
                }
                case 7: {
                    String[] typeStrings;
                    if (splits[i].isEmpty()) continue block12;
                    this.subTypes = new LinkedList();
                    for (String s : typeStrings = splits[i].split(",")) {
                        int ID = Integer.parseInt(s);
                        String specType = sbdb.getSpecType(ID);
                        if (specType == null) continue;
                        this.subTypes.add(ID);
                    }
                    if (!this.subTypes.isEmpty()) continue block12;
                    this.subTypes = null;
                    continue block12;
                }
                case 8: {
                    this.includeRw = this.getBoolean(splits[i]);
                    continue block12;
                }
                case 9: {
                    this.includeCv = this.getBoolean(splits[i]);
                    continue block12;
                }
                case 10: {
                    this.includeQ = this.getBoolean(splits[i]);
                    continue block12;
                }
                case 11: {
                    this.includeUnqualified = this.getBoolean(splits[i]);
                }
            }
        }
    }

    private void decodeAbnProps(String props) {
        String[] splits = props.split("\\|");
        block15: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    this.abn_style = Abundance.valueOf(splits[i]);
                    continue block15;
                }
                case 1: {
                    this.useSplits = this.getBoolean(splits[i]);
                    continue block15;
                }
                case 2: {
                    this.normaliseWeight = this.getBoolean(splits[i]);
                    continue block15;
                }
                case 3: {
                    this.normalWeight = Float.parseFloat(splits[i]);
                    continue block15;
                }
                case 4: {
                    this.group = Group.valueOf(splits[i]);
                    continue block15;
                }
                case 5: {
                    this.subgroup = SubGroup.valueOf(splits[i]);
                    continue block15;
                }
                case 6: {
                    this.track_style = Track.valueOf(splits[i]);
                    continue block15;
                }
                case 7: {
                    this.calc_style = Calc.valueOf(splits[i]);
                    continue block15;
                }
                case 8: {
                    this.plot_style = Plot.valueOf(splits[i]);
                    continue block15;
                }
                case 9: {
                    this.stratRange = this.getBoolean(splits[i]);
                    continue block15;
                }
                case 10: {
                    this.sawtoothEnhanced = this.getBoolean(splits[i]);
                    continue block15;
                }
                case 11: {
                    this.sawtoothEnhancement = Integer.parseInt(splits[i]);
                    continue block15;
                }
                case 12: {
                    this.justify = Justify.valueOf(splits[i]);
                }
            }
        }
    }

    private void decodeOptionProps(SBdb sbdb, String props) throws SQLException, SBException {
        String[] splits = props.split("\\|");
        block27: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    this.sortType = Integer.parseInt(splits[i]);
                    continue block27;
                }
                case 1: {
                    this.showImages = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 2: {
                    this.filterMkrImages = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 3: {
                    this.imageWidth = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 4: {
                    this.cutoff = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 5: {
                    this.maxWidth = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 6: {
                    this.minWidth = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 7: {
                    this.colour = SB.getColour((String)splits[i]);
                    continue block27;
                }
                case 8: {
                    this.colourSuites = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 9: {
                    this.colourLabels = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 10: {
                    continue block27;
                }
                case 11: {
                    continue block27;
                }
                case 12: {
                    this.showFlags = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 13: {
                    this.showAbundance = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 14: {
                    this.clearEmptyTracks = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 15: {
                    this.grid = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 16: {
                    this.hdr_cat = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 17: {
                    this.hdr_author = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 18: 
                case 19: 
                case 21: {
                    if (splits[i].isEmpty()) continue block27;
                    int ID = Integer.parseInt(splits[i]);
                    if (i == 17) {
                        if (sbdb.getCompositeStandard(ID) == null) continue block27;
                        this.cmpStdID = ID;
                        continue block27;
                    }
                    if (i == 18) {
                        if (sbdb.getIGDScheme(ID) == null) continue block27;
                        this.schID = ID;
                        continue block27;
                    }
                    if (i != 20) continue block27;
                    this.highlightGroup = sbdb.getTxGroup(ID);
                    continue block27;
                }
                case 20: {
                    this.schAbrs = this.getBoolean(splits[i]);
                    continue block27;
                }
                case 22: {
                    this.highlightColour = SB.getColour((String)splits[i]);
                    continue block27;
                }
                case 23: {
                    int id = Integer.parseInt(splits[i]);
                    if (sbdb.getIGDScheme(id) == null) continue block27;
                    this.interpSchID = id;
                    continue block27;
                }
                case 24: {
                    this.interpShadingDensity = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 25: {
                    this.drawEvents = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 26: {
                    this.inheritFilterColour = Integer.parseInt(splits[i]) == 1;
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue(), "" + this.abn_style.toString(), "" + (this.plot_style == Plot.CURVE ? Plot.SAWTOOTH.toString() : this.plot_style.toString()), "" + (this.hdr_cat ? 1 : 0), "" + (this.hdr_author ? 1 : 0), "" + (this.grid ? 1 : 0), "" + (this.showImages ? 1 : 0), "" + (this.filterMkrImages ? 1 : 0), "" + this.imageWidth, "" + (this.clearEmptyTracks ? 1 : 0), "" + this.highlightColour.getRed() + "," + this.highlightColour.getGreen() + "," + this.highlightColour.getBlue(), "" + (this.colourSuites ? 1 : 0), "" + (this.colourLabels ? 1 : 0), "" + (this.showAbundance ? 1 : 0), "" + (this.stratRange ? 1 : 0), "" + (this.justify == Justify.CENTRE ? Justify.LEFT.name() : this.justify.name()), "" + this.interpShadingDensity, "" + (this.inheritFilterColour ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    void encode(SBdb sbdb) {
        try {
            Lastval.putString((SBdb)sbdb, (String)"BIOSPPREF", (String)this.getPrefs());
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb) {
        try {
            int b;
            int g;
            int r;
            StringTokenizer tok2;
            String params = Lastval.getString((SBdb)sbdb, (String)"BIOSPPREF");
            if (params.isEmpty()) {
                System.out.println("TaxonPanel params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                tok2 = new StringTokenizer(tok.nextToken(), ",");
                r = 0;
                g = 0;
                b = 0;
                if (tok2.hasMoreTokens()) {
                    r = Integer.parseInt(tok2.nextToken());
                }
                if (tok2.hasMoreTokens()) {
                    g = Integer.parseInt(tok2.nextToken());
                }
                if (tok2.hasMoreTokens()) {
                    b = Integer.parseInt(tok2.nextToken());
                }
                this.colour = new Color(r, g, b);
            }
            if (tok.hasMoreTokens()) {
                try {
                    this.abn_style = Abundance.valueOf(tok.nextToken());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (this.abn_style == Abundance.SEMIQ || this.abn_style == Abundance.PA) {
                    this.abn_style = Abundance.MIX;
                }
            }
            if (tok.hasMoreTokens()) {
                try {
                    this.plot_style = Plot.valueOf(tok.nextToken());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.hdr_cat = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.hdr_author = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.grid = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showImages = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.filterMkrImages = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.imageWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.clearEmptyTracks = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                tok2 = new StringTokenizer(tok.nextToken(), ",");
                r = 0;
                g = 0;
                b = 0;
                if (tok2.hasMoreTokens()) {
                    r = Integer.parseInt(tok2.nextToken());
                }
                if (tok2.hasMoreTokens()) {
                    g = Integer.parseInt(tok2.nextToken());
                }
                if (tok2.hasMoreTokens()) {
                    b = Integer.parseInt(tok2.nextToken());
                }
                this.highlightColour = new Color(r, g, b);
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.colourSuites = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.colourLabels = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.showAbundance = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.stratRange = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.justify = Justify.valueOf(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.interpShadingDensity = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.inheritFilterColour = Integer.parseInt(tok.nextToken()) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String separateWithComma(String[] strings) {
        String string = "";
        for (String s : strings) {
            if (!string.isEmpty()) {
                string = string + ",";
            }
            string = string + s;
        }
        return string;
    }

    private boolean getBoolean(String s) {
        return Integer.parseInt(s) == 1;
    }

    final void verify(Well well, boolean doCorrections, PanelTaxonGroup outerPanel) throws InvalidTaxonFieldException, SQLException, SBException {
        if (this.abn_style == Abundance.SEMIQ) {
            LinkedList<AnalystHeader> notSet = new LinkedList<AnalystHeader>();
            HashSet<Integer> schemeIDs = new HashSet<Integer>();
            for (AnalystHeader hdr : well.getAnalystHeaders()) {
                if (outerPanel.suites != null && (outerPanel.suites == null || !outerPanel.suites.contains(hdr)) || hdr.getDiscID() != outerPanel.getDiscID().getChar()) continue;
                if (hdr.getAbnSchID() <= 0) {
                    notSet.add(hdr);
                    continue;
                }
                schemeIDs.add(hdr.getAbnSchID());
            }
            if (notSet.size() > 0) {
                if (doCorrections) {
                    this.abn_style = Abundance.MIX;
                } else {
                    String msg = "All analysis suites must have an abundance scheme set to plot semi-quant data.\n";
                    msg = msg + "Abundance scheme not set for suite" + (notSet.size() > 1 ? "s:\n" : ":\n");
                    for (AnalystHeader ah : notSet) {
                        msg = msg + ah.toString() + "\n";
                    }
                    msg = msg + "\nSet abundance schemes or use quantitative abundance.\n";
                    throw new InvalidTaxonFieldException(msg, 1);
                }
            }
            if (this.group != Group.SPEC && schemeIDs.size() > 1) {
                if (doCorrections) {
                    this.group = Group.SPEC;
                } else {
                    throw new InvalidTaxonFieldException("All analysis suites must use the same abundance scheme\nwhen grouping is not by species.", 2);
                }
            }
        }
        if (this.abn_style.setSemiQuant) {
            if (this.subgroup != SubGroup.NONE) {
                if (doCorrections) {
                    this.subgroup = SubGroup.NONE;
                } else {
                    throw new InvalidTaxonFieldException("Sub-grouping is not supported for " + this.abn_style.toString() + " diagrams.", 2);
                }
            }
            if (this.plot_style == Plot.NUMBERS) {
                if (doCorrections) {
                    this.plot_style = Plot.HIST;
                } else {
                    throw new InvalidTaxonFieldException("'Numbers only' curve style cannot be used for " + this.abn_style.toString() + " diagrams.", 3);
                }
            }
        }
        if (this.abn_style == Abundance.PA) {
            this.plot_style = Plot.HIST;
            this.calc_style = Calc.ABS;
            this.track_style = Track.SINGLE;
            this.justify = Justify.CENTRE;
        }
        if ((this.justify == Justify.CENTRE || this.plot_style == Plot.NUMBERS || this.calc_style == Calc.SHANNON) && this.track_style == Track.MULTI) {
            this.track_style = Track.SINGLE;
        }
        if (this.plot_style == Plot.NUMBERS) {
            this.showAbundance = true;
        }
        if (this.calc_style == Calc.SHANNON) {
            if (this.subgroup != SubGroup.NONE) {
                if (doCorrections) {
                    this.subgroup = SubGroup.NONE;
                } else {
                    throw new InvalidTaxonFieldException("You cannot use sub-groups in diversity calculation", 3);
                }
            }
            if (this.group == Group.SPEC) {
                if (doCorrections) {
                    this.calc_style = Calc.ABS;
                } else {
                    throw new InvalidTaxonFieldException("You cannot calculate diversity for species", 2);
                }
            }
        }
        if (this.subgroup == SubGroup.CMF) {
            if (this.calc_style == Calc.RICHNESS || this.calc_style == Calc.SHANNON) {
                if (doCorrections) {
                    this.calc_style = Calc.ABS;
                } else {
                    throw new InvalidTaxonFieldException("You cannot sub-group by size fraction and use species richness or diversity calculations.\nChoose absolute or relative abundance calculation.", 3);
                }
            }
            this.useSplits = false;
        }
        if (this.plot_style == Plot.CURVE || this.plot_style == Plot.SAWTOOTH) {
            this.colourSuites = false;
        }
        if (this.plot_style != Plot.SAWTOOTH) {
            this.sawtoothEnhanced = false;
        }
    }

    public String toString() {
        String s = "Panel Taxon Properties";
        return s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PanelTaxonProperties)) {
            return false;
        }
        PanelTaxonProperties rhs = (PanelTaxonProperties)o;
        if (this.sortType != rhs.sortType) {
            return false;
        }
        if (this.includeRw != rhs.includeRw) {
            return false;
        }
        if (this.includeCv != rhs.includeCv) {
            return false;
        }
        if (this.includeQ != rhs.includeQ) {
            return false;
        }
        if (this.includeUnqualified != rhs.includeUnqualified) {
            return false;
        }
        if (this.group != rhs.group) {
            return false;
        }
        if (this.track_style != rhs.track_style) {
            return false;
        }
        if (this.calc_style != rhs.calc_style) {
            return false;
        }
        if (this.plot_style != rhs.plot_style) {
            return false;
        }
        if (this.justify != rhs.justify) {
            return false;
        }
        if (this.cutoff != rhs.cutoff) {
            return false;
        }
        if (this.maxWidth != rhs.maxWidth) {
            return false;
        }
        if (this.minWidth != rhs.minWidth) {
            return false;
        }
        if (!this.colour.equals(rhs.colour)) {
            return false;
        }
        if (this.colourLabels != rhs.colourLabels) {
            return false;
        }
        if (this.colourSuites != rhs.colourSuites) {
            return false;
        }
        if (this.inheritFilterColour != rhs.inheritFilterColour) {
            return false;
        }
        if (this.abn_style != rhs.abn_style) {
            return false;
        }
        if (this.showFlags != rhs.showFlags) {
            return false;
        }
        if (this.subgroup != rhs.subgroup) {
            return false;
        }
        if (this.hdr_cat != rhs.hdr_cat) {
            return false;
        }
        if (this.hdr_author != rhs.hdr_author) {
            return false;
        }
        if (this.schID != rhs.schID) {
            return false;
        }
        if (this.cmpStdID != rhs.cmpStdID) {
            return false;
        }
        if (this.schAbrs != rhs.schAbrs) {
            return false;
        }
        if (this.grid != rhs.grid) {
            return false;
        }
        if (this.showImages != rhs.showImages) {
            return false;
        }
        if (this.filterMkrImages != rhs.filterMkrImages) {
            return false;
        }
        if (this.imageWidth != rhs.imageWidth) {
            return false;
        }
        if (this.clearEmptyTracks != rhs.clearEmptyTracks) {
            return false;
        }
        if (this.useSplits != rhs.useSplits) {
            return false;
        }
        if (this.normaliseWeight != rhs.normaliseWeight) {
            return false;
        }
        if (this.normalWeight != rhs.normalWeight) {
            return false;
        }
        if (!this.highlightColour.equals(rhs.highlightColour)) {
            return false;
        }
        if (this.highlightGroup != rhs.highlightGroup) {
            return false;
        }
        if (this.showAbundance != rhs.showAbundance) {
            return false;
        }
        if (this.stratRange != rhs.stratRange) {
            return false;
        }
        if (this.sawtoothEnhanced != rhs.sawtoothEnhanced) {
            return false;
        }
        if (this.sawtoothEnhancement != rhs.sawtoothEnhancement) {
            return false;
        }
        if (this.subTypes == null ^ rhs.subTypes == null || this.subTypes != null && rhs.subTypes != null && !((Object)this.subTypes).equals(rhs.subTypes)) {
            return false;
        }
        if (this.interpSchID != rhs.interpSchID) {
            return false;
        }
        if (this.interpShadingDensity != rhs.interpShadingDensity) {
            return false;
        }
        return this.drawEvents == rhs.drawEvents;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.subTypes != null ? ((Object)this.subTypes).hashCode() : 0);
        hash = 37 * hash + (this.includeRw ? 1 : 0);
        hash = 37 * hash + (this.includeQ ? 1 : 0);
        hash = 37 * hash + (this.includeCv ? 1 : 0);
        hash = 37 * hash + (this.includeUnqualified ? 1 : 0);
        hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
        hash = 37 * hash + (this.subgroup != null ? this.subgroup.hashCode() : 0);
        hash = 37 * hash + (this.track_style != null ? this.track_style.hashCode() : 0);
        hash = 37 * hash + (this.calc_style != null ? this.calc_style.hashCode() : 0);
        hash = 37 * hash + this.sortType;
        hash = 37 * hash + (this.plot_style != null ? this.plot_style.hashCode() : 0);
        hash = 37 * hash + (this.justify != null ? this.justify.hashCode() : 0);
        hash = 37 * hash + (this.stratRange ? 1 : 0);
        hash = 37 * hash + (this.sawtoothEnhanced ? 1 : 0);
        hash = 37 * hash + this.sawtoothEnhancement;
        hash = 37 * hash + (this.abn_style != null ? this.abn_style.hashCode() : 0);
        hash = 37 * hash + (this.useSplits ? 1 : 0);
        hash = 37 * hash + (this.normaliseWeight ? 1 : 0);
        hash = 37 * hash + Float.floatToIntBits(this.normalWeight);
        hash = 37 * hash + (this.showImages ? 1 : 0);
        hash = 37 * hash + (this.filterMkrImages ? 1 : 0);
        hash = 37 * hash + Float.floatToIntBits(this.imageWidth);
        hash = 37 * hash + Float.floatToIntBits(this.cutoff);
        hash = 37 * hash + Float.floatToIntBits(this.maxWidth);
        hash = 37 * hash + Float.floatToIntBits(this.minWidth);
        hash = 37 * hash + (this.showFlags ? 1 : 0);
        hash = 37 * hash + (this.showAbundance ? 1 : 0);
        hash = 37 * hash + (this.colour != null ? this.colour.hashCode() : 0);
        hash = 37 * hash + (this.colourSuites ? 1 : 0);
        hash = 37 * hash + (this.colourLabels ? 1 : 0);
        hash = 37 * hash + (this.inheritFilterColour ? 1 : 0);
        hash = 37 * hash + (this.grid ? 1 : 0);
        hash = 37 * hash + (this.clearEmptyTracks ? 1 : 0);
        hash = 37 * hash + (this.hdr_cat ? 1 : 0);
        hash = 37 * hash + (this.hdr_author ? 1 : 0);
        hash = 37 * hash + this.cmpStdID;
        hash = 37 * hash + this.schID;
        hash = 37 * hash + (this.schAbrs ? 1 : 0);
        hash = 37 * hash + (this.highlightGroup != null ? this.highlightGroup.hashCode() : 0);
        hash = 37 * hash + (this.highlightColour != null ? this.highlightColour.hashCode() : 0);
        hash = 37 * hash + this.interpSchID;
        hash = 37 * hash + Float.floatToIntBits(this.interpShadingDensity);
        hash = 37 * hash + (this.drawEvents ? 1 : 0);
        return hash;
    }

    static enum Abundance {
        Q("quantitative abundance", false),
        SEMIQ("semi-quantitative abundance", true),
        MIX("quant/semi-quant abundance", false),
        PA("presence/absence", true);

        private final String description;
        private final boolean setSemiQuant;

        private Abundance(String description, boolean setSemiQuant) {
            this.description = description;
            this.setSemiQuant = setSemiQuant;
        }

        public String toString() {
            return this.description;
        }

        public boolean setSemiQuant() {
            return this.setSemiQuant;
        }
    }

    static enum Justify {
        LEFT,
        CENTRE,
        RIGHT;

    }

    static enum Plot {
        HIST,
        SAWTOOTH,
        NUMBERS,
        CURVE;

    }

    static enum Calc {
        ABS,
        RELATIVE,
        RICHNESS,
        SHANNON,
        RELATIVE_OUTER;

    }

    static enum Track {
        SINGLE,
        MULTI;

    }

    static enum SubGroup {
        NONE(new String[]{"No subgroups"}),
        SITU(new String[]{"In-Situ", "Reworked"}),
        CONF(new String[]{"Confident", "Questionable"}),
        CMF(new String[]{"Coarse", "Medium", "Fine"}),
        SUBTYPE(null);

        String[] groupNames;

        private SubGroup(String[] groupNames) {
            this.groupNames = groupNames;
        }

        String[] getGroupNames() {
            return this.groupNames;
        }
    }

    static enum Group {
        TOTAL("Panel Total", false),
        SPEC("Species", false),
        CAT("Categories", true),
        GROUP("Groups", true),
        GENUS("Genera", false),
        SITU("Situation", true),
        SUBTYPE("Sub-Types", false),
        CONF("Confidence", true),
        CV("Caving", true);

        private String trackAdj;
        private boolean hasColours;

        private Group(String trackAdj, boolean hasColours) {
            this.trackAdj = trackAdj;
            this.hasColours = hasColours;
        }

        String getTrackAdj() {
            return this.trackAdj;
        }

        boolean hasColours() {
            return this.hasColours;
        }
    }
}

