/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Iterator;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.TickScheme;
import model2.CompositeStandard;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Sample;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelWellAgeDepth
extends SBPanel {
    Well well;
    WellInterp wellInterp = null;
    float top;
    float base;
    private float horzScale;
    char units = (char)77;
    float width = 0.0f;
    boolean plotEvents = false;
    boolean plotIGDboxes = false;
    CompositeStandard cmpStd = null;
    int schemeHier = 5;
    boolean plotBackgroundIGD = true;
    IGDScheme scheme = null;

    public PanelWellAgeDepth(Well well, WellInterp wellInterp) throws SQLException, SBException {
        this.well = well;
        this.wellInterp = wellInterp;
        well.loadSampleAges(wellInterp);
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getCaption() {
        return null;
    }

    void loadIGD(int igdType) throws SQLException, SBException {
        if (this.well == null) {
            return;
        }
        System.out.println("In WellAgeDepthPanel.loadIGD");
    }

    void setDepthRange(float top, float base, float scale, char units) {
        this.top = top;
        this.base = base;
        this.horzScale = scale / 1000.0f;
        this.units = units;
    }

    float getHorzScale() {
        return this.horzScale * 1000.0f;
    }

    @Override
    float getWidth(BlockProperties bp) {
        this.width = (this.base - this.top) / this.horzScale;
        return this.width;
    }

    boolean drawsFrame() {
        return false;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        int fontStyle = 0;
        g.setFont(p.font, fontStyle, p.fontPanel);
        g.setStroke(0.15f);
        this.drawBackgroundIGD(g, x, y, p.getPanelHeaderHeight(), bp);
        g.setColor(Color.BLACK);
        g.drawRect(x, y, this.width, p.getPanelHeaderHeight() + bp.height);
        g.drawLine(x, y + p.panelCaptionHeight, x + this.width, y + p.panelCaptionHeight);
        g.drawLine(x, y + p.getPanelHeaderHeight(), x + this.width, y + p.getPanelHeaderHeight());
        g.drawStringBox(this.well.getWellName(), x, y, this.width, p.panelCaptionHeight, false);
        this.drawHorzScale(g, p, x, y, p.getPanelHeaderHeight(), p.getPanelHeaderHeight());
        g.setFont(p.font, fontStyle, p.fontTiny);
        g.drawString("Sample depth(" + Character.toLowerCase(this.units) + ") below " + this.well.getHeader().getDatumString(), x + 0.5f, y + p.panelCaptionHeight + 2.0f);
        g.setColor(Color.BLACK);
        try {
            Iterator it = this.well.getSamples().iterator();
            float lastX = -1.0f;
            float lastY = -1.0f;
            float symbolSize = 1.5f;
            float thickLine = 0.32f;
            float thinLine = 0.05f;
            float labelHeight = p.getPanelHeaderHeight() - p.panelSubHeaderHeight / 2.8f;
            g.setStroke(0.1f);
            g.drawLine(x, y + labelHeight, x + this.width, y + labelHeight);
            g.setStroke(0.15f);
            g.setFont(p.font, fontStyle, p.fontTiny);
            while (it.hasNext()) {
                Sample sample = (Sample)it.next();
                if (!(sample.getDepth('M') >= (double)this.top) || !(sample.getDepth('M') <= (double)this.base) || !sample.hasAgeData(this.wellInterp) || !(sample.getAge(this.wellInterp) >= (double)bp.min) || !(sample.getAge(this.wellInterp) <= (double)bp.max) || !(sample.getAge(this.wellInterp) > 0.0)) continue;
                float yPos = this.calcPlotPosition(y, (float)sample.getAge(this.wellInterp), p, bp);
                float xPos = x + ((float)sample.getDepth('M') - this.top) / this.horzScale;
                g.setStroke(thinLine);
                g.fillEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, sample.getType().equals("LOG") ? Color.RED : Color.BLUE);
                if (lastX >= 0.0f) {
                    g.setStroke(thickLine);
                    g.drawLine(lastX, lastY, xPos, yPos);
                }
                lastX = xPos;
                lastY = yPos;
                if (sample.getAgeBelow(this.wellInterp) > sample.getAge(this.wellInterp)) {
                    yPos = this.calcPlotPosition(y, (float)sample.getAgeBelow(this.wellInterp), p, bp);
                    g.setStroke(thinLine);
                    g.fillEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, sample.getType().equals("LOG") ? Color.RED : Color.BLUE);
                    g.setStroke(thickLine);
                    g.drawUnconf(lastX, lastY, xPos, yPos, false, 3.0f);
                    lastY = yPos;
                }
                yPos = y + labelHeight - 1.0f;
                sample.displayUnits = this.units;
                g.setStroke(thinLine);
                g.drawLine(xPos, y + labelHeight, xPos, y + labelHeight - 0.75f);
                g.drawStringVertical(sample.toString().trim(), xPos + 0.6f, yPos);
            }
            this.drawIGDBoxes(g, x, y, p.getPanelHeaderHeight(), bp);
            this.drawEvents(g, x, y, p.getPanelHeaderHeight(), bp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return x + this.width;
    }

    void drawBackgroundIGD(SBGraphics g, float x, float y, float headerHeight, BlockProperties bp) {
        if (!this.plotBackgroundIGD || this.scheme == null) {
            return;
        }
        y += headerHeight;
        try {
            for (IGDUnit unit : this.scheme.getUnits()) {
                if (unit.getHier() != this.schemeHier || !(unit.getLage() > (double)bp.min) || !(unit.getUage() < (double)bp.max)) continue;
                float yTop = y + (Math.max((float)unit.getUage(), bp.min) - bp.min) * bp.scale;
                float yBot = y + (Math.min((float)unit.getLage(), bp.max) - bp.min) * bp.scale;
                Color colour = new Color(unit.getColour().getRed(), unit.getColour().getGreen(), unit.getColour().getBlue(), 85);
                g.setColor(colour);
                g.fillRect(x, yTop, this.width, yBot - yTop, colour);
            }
        }
        catch (Exception e) {
            System.out.println("Exception getting IGD Unit: " + e.getMessage());
        }
    }

    void drawEvents(SBGraphics g, float x, float y, float headerHeight, BlockProperties bp) {
        if (!this.plotEvents) {
            return;
        }
        if (this.well == null || this.cmpStd == null) {
            return;
        }
        float symbolSize = 0.75f;
        g.setColor(Color.RED);
        g.setStroke(0.15f);
        y += headerHeight;
        try {
            for (WellEvent event : this.wellInterp.getEvents()) {
                try {
                    float age;
                    if (!(event.getSample().getDepth('M') >= (double)this.top) || !(event.getSample().getDepth('M') <= (double)this.base) || !((age = (float)this.cmpStd.getAge(event.getEvent().getEvID(), event.getTypeObj())) < bp.max) || !(age > bp.min)) continue;
                    float xpos = x + ((float)event.getSample().getDepth('M') - this.top) / this.horzScale;
                    float ypos = y + (age - bp.min) * bp.scale;
                    if (event.getCharType() == 'F') {
                        g.drawLine(xpos - symbolSize, ypos, xpos + symbolSize, ypos);
                        g.drawLine(xpos, ypos - symbolSize, xpos, ypos + symbolSize);
                        continue;
                    }
                    g.drawEllipse(xpos, ypos, symbolSize * 2.0f, symbolSize * 2.0f);
                }
                catch (Exception e) {
                    System.out.println("Exception in drawEvents: " + e);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in AgeDepthPanel drawEvents: " + e.getMessage());
            e.printStackTrace();
        }
        g.setColor(Color.BLACK);
    }

    void drawIGDBoxes(SBGraphics g, float x, float y, float headerHeight, BlockProperties bp) {
        if (!this.plotIGDboxes || this.scheme == null) {
            return;
        }
        y += headerHeight;
        int igdType = this.scheme.getIGDType();
        try {
            Iterator it = this.wellInterp.getIGDList(igdType, 0).iterator();
            g.setStroke(0.15f);
            while (it.hasNext()) {
                IGDUnit uppUnit;
                IGDIntervalZone zone = (IGDIntervalZone)it.next();
                if (zone.getUppZone() <= 0 || (uppUnit = this.scheme.findUnit(zone.getUppZone())) == null) continue;
                IGDUnit lowUnit = null;
                if (zone.getLowZone() > 0) {
                    lowUnit = this.scheme.findUnit(zone.getLowZone());
                }
                float uppAge = (float)uppUnit.getUage();
                float lowAge = (float)uppUnit.getLage();
                if (lowUnit != null) {
                    lowAge = (float)lowUnit.getLage();
                }
                if (!(uppAge < bp.max) || !(lowAge > bp.min)) continue;
                float yTop = y + (Math.max(uppAge, bp.min) - bp.min) * bp.scale;
                float yBot = y + (Math.min(lowAge, bp.max) - bp.min) * bp.scale;
                float xLeft = x + ((float)zone.getTopSample().getDepth('M') - this.top) / this.horzScale;
                float xRight = x + ((float)zone.getBaseSample().getDepth('M') - this.top) / this.horzScale;
                g.setColor(uppUnit.getColour());
                g.drawRect(xLeft, yTop, xRight - xLeft, yBot - yTop);
            }
        }
        catch (SQLException sbe) {
            System.out.println("Exception from IGD plotting in well panel: " + sbe);
            sbe.printStackTrace();
        }
    }

    void drawHorzScale(SBGraphics g, ChartProperties p, float x, float y, float headerHeight, float subHeaderHeight) {
        float y2;
        float y1;
        float xpos;
        float depth;
        int fontStyle = 0;
        g.setFont(p.font, fontStyle, p.fontTiny);
        TickScheme scheme = new TickScheme();
        scheme.calcScaleLabels(this.top, this.horzScale * 1000.0f, this.units);
        float left = x;
        for (depth = scheme.start; depth > this.top; depth -= scheme.tickInterval) {
            if (!(depth < this.base)) continue;
            xpos = x + (depth - this.top) / this.horzScale;
            y1 = y + headerHeight;
            y2 = y1 - 1.0f;
            g.drawLine(xpos, y1, xpos, y2);
        }
        depth = scheme.start;
        float yPreviousLabel = -9999999.0f;
        while (depth <= this.base + 0.0029f) {
            String buffer = SB.floatString((double)SB.convFromM((double)depth, (char)this.units), (int)scheme.precision).trim();
            xpos = x + (depth - this.top) / this.horzScale;
            y1 = y + headerHeight;
            y2 = y1 - 2.0f;
            g.drawLine(xpos, y1, xpos, y2);
            float w = g.stringWidth(buffer);
            float h = g.stringHeight();
            float ypos = y2;
            if (xpos > yPreviousLabel + h) {
                if ((xpos += 0.3f * h) - h < x) {
                    xpos = x + 0.6f * h;
                }
                g.drawStringVertical(buffer, xpos, ypos - 0.5f);
                yPreviousLabel = xpos;
            }
            float nextDepth = depth + scheme.labelInterval;
            depth += scheme.tickInterval;
            while (depth < nextDepth && depth <= this.base) {
                xpos = x + (depth - this.top) / this.horzScale;
                y1 = y + headerHeight;
                y2 = y1 - 1.0f;
                g.drawLine(xpos, y1, xpos, y2);
                depth += scheme.tickInterval;
            }
            depth = nextDepth;
        }
    }

    float calcPlotPosition(float y, float value, ChartProperties cp, BlockProperties bp) {
        return y + (value - bp.min) * bp.scale + cp.getPanelHeaderHeight();
    }
}

