/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.text.AttributedString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelSequencesProperties;
import jsbugs.PanelWellDepthAgeProperties;
import jsbugs.PanelZones;
import jsbugs.ProjectBlock;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.AbnScheme;
import model2.CompositeStandardEvent;
import model2.Discipline;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.LOC;
import model2.Project;
import model2.SBEvent;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;

public class PanelWellDepthAge
extends SBPanel {
    private PanelWellDepthAgeProperties prop;
    private final WellBlock block;
    private final SBdb db;
    private static final float SNAPDEPTH = 2.0f;
    private static final float BRACKET = 2.0f;
    private static final double AGEBRACKET = 0.1;
    private static final Color deepGreen = new Color(0, 128, 128);
    private static final Color lightGreen = new Color(0, 180, 180);
    private Color hstColour;
    private Color tstColour;
    private Color lstColour;

    public PanelWellDepthAge(SBdb db, WellBlock block, PanelWellDepthAgeProperties prop) throws SQLException {
        this.block = block;
        this.db = db;
        this.prop = prop;
        this.hstColour = db.getCatColour("**HST", Color.RED);
        this.tstColour = db.getCatColour("**TST", Color.GREEN);
        this.lstColour = db.getCatColour("**LST", Color.BLUE);
    }

    PanelWellDepthAge(SBdb db, WellBlock block, String prop, LinkedList<Chart.ChartPref> sBlockPanels, InterpHdr interp, Project project) throws SQLException, SBException {
        this.block = block;
        this.db = db;
        this.prop = new PanelWellDepthAgeProperties(db, prop, sBlockPanels, interp, project);
        this.hstColour = db.getCatColour("**HST", Color.RED);
        this.tstColour = db.getCatColour("**TST", Color.GREEN);
        this.lstColour = db.getCatColour("**LST", Color.BLUE);
    }

    public String toString() {
        ProjectBlock b;
        String s = "";
        if (this.block instanceof ProjectBlock && (b = (ProjectBlock)this.block).getProject() != null) {
            s = b.getProject() + " ";
        }
        switch (this.block.prop.scaleType) {
            case MD: {
                return s + "Depth/Age Plot";
            }
            case TVD: {
                return s + "TVD/Age Plot";
            }
            case SUBSIDENCE: {
                return s + "Subsidence";
            }
        }
        assert (false);
        return "Depth/Age Panel";
    }

    boolean interactive() {
        return this.block.prop.scaleType == BlockProperties.ScaleType.MD;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        String s;
        LOC.LOCNode node;
        Sample sample;
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj instanceof SchemeBlock) {
            return null;
        }
        if (obj instanceof WellEvent) {
            String string = "<html>";
            boolean insertBreak = false;
            for (WellEvent event : this.getEvents(x, ((WellEvent)obj).getSample(), bp, zoom)) {
                if (insertBreak) {
                    string = string + "<br>";
                }
                SBEvent sbEvent = event.getEvent();
                double age = this.getProperties().getCmpStd().getAge(sbEvent.getEvID(), event.getTypeObj());
                string = string + cp.ageFormat.toAgeString(age, 2) + "  Event: " + event.toString();
                insertBreak = true;
            }
            string = string + "</html>";
            return string;
        }
        if (obj instanceof CompositeStandardEvent && (sample = this.getSample(y, zoom, cp)) != null) {
            CompositeStandardEvent[] cse = this.getCmpStdEvent(x, bp, zoom);
            String occString = "";
            for (Smpdtl smpdtl : sample.getAnalyses()) {
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    for (CompositeStandardEvent ev : cse) {
                        if (occ.getSpecID() != ev.getEvent().getSpecID()) continue;
                        occString = occString + occ.toString();
                        occString = occString + "<br>";
                    }
                }
            }
            if (!occString.isEmpty()) {
                String cmpStdString = "<html>";
                cmpStdString = cmpStdString + cp.ageFormat.toAgeString((double)this.getAge(x), 2) + " ";
                cmpStdString = cmpStdString + " (" + sample + ")";
                cmpStdString = cmpStdString + "<br>Occurrence : ";
                cmpStdString = cmpStdString + occString;
                return cmpStdString + "</html>";
            }
            return cp.ageFormat.toAgeString((double)this.getAge(x), 2);
        }
        if (this.getWellInterp() != null && this.getWellInterp().getLOC() != null && (node = this.getLocNode(x, y, zoom)) != null) {
            String locString = "LOC: " + cp.ageFormat.toAgeString(node.getAge(), 2) + " (" + SB.floatString((double)SB.convFromM((double)node.getDepth(), (char)this.block.prop.units), (int)2) + SB.unitAbr((char)this.block.prop.units) + ")";
            return locString;
        }
        String strg = cp.ageFormat.toAgeString((double)this.getAge(x), 2) + " ";
        if (this.block instanceof ProjectBlock && (s = this.getUnitName(this.getAge(x), true)) != null) {
            strg = strg + s + " ";
        }
        strg = strg + "(" + obj.toString() + ")";
        return strg;
    }

    private WellInterp getWellInterp() {
        if (this.block instanceof ProjectBlock) {
            return null;
        }
        WellInterp interp = null;
        if (this.prop.interp != null) {
            try {
                interp = this.block.well.getInterp(this.prop.interp.getInterpID());
            }
            catch (SBException e) {
                e.printStackTrace();
            }
        }
        return interp;
    }

    public UndoableEdit deleteLOCnode(float x, float y, float zoom) throws InvalidFieldException, SQLException, SBException {
        if (this.getWellInterp() == null) {
            throw new InvalidFieldException("No version/composite standard selected");
        }
        Point2D.Float point = this.getLOCorigin(x, y, zoom);
        if (point == null) {
            throw new InvalidFieldException("No node point found near cursor (expand depth/age range if at edge of panel)");
        }
        float SMALL = 1.0E-4f;
        LOC loc = this.getWellInterp().getLOC();
        Iterator nodeIt = loc.getNodeIterator();
        while (nodeIt.hasNext()) {
            LOC.LOCNode locNode = (LOC.LOCNode)nodeIt.next();
            float yN = this.block.scaleDepth((float)locNode.getDepth());
            float xN = this.getXPos((float)locNode.getAge());
            if (!(Math.abs(((Point2D)point).getY() - (double)yN) < (double)SMALL) || !(Math.abs(((Point2D)point).getX() - (double)xN) < (double)SMALL)) continue;
            SbugsCompoundEdit edit = this.getWellInterp().deleteLOCNode(locNode, this.block.well.getWellID());
            this.getWellInterp().notifyObservers((Object)this.getWellInterp().getLOC());
            return edit;
        }
        return null;
    }

    public UndoableEdit updateLOCNodeBnd(float x, float y, int bnd, float zoom) throws SBException, SQLException, InvalidFieldException {
        if (this.getWellInterp() == null) {
            throw new SBException("No version/composite standard selected");
        }
        Point2D.Float node = this.getLOCorigin(x, y, zoom);
        if (node == null) {
            throw new SBException("No node found near cursor.\n(use upper node to select line below, expand depth/age range of chart if at edge of panel)");
        }
        float SMALL = 1.0E-4f;
        boolean done = false;
        LOC loc = this.getWellInterp().getLOC();
        int originalBnd = -1;
        Iterator nodeIt = loc.getNodeIterator();
        while (nodeIt.hasNext()) {
            LOC.LOCNode locNode = (LOC.LOCNode)nodeIt.next();
            float yN = this.block.scaleDepth((float)locNode.getDepth());
            float xN = this.getXPos((float)locNode.getAge());
            if (!(Math.abs(((Point2D)node).getY() - (double)yN) < (double)SMALL) || !(Math.abs(((Point2D)node).getX() - (double)xN) < (double)SMALL)) continue;
            if (locNode.getBnd() == bnd) {
                return null;
            }
            if (IGDIntervalZone.isDisconformableBnd((int)bnd)) {
                if (!nodeIt.hasNext()) {
                    throw new InvalidFieldException("Cannot set disconfirmity at last node");
                }
                LOC.LOCNode nextNode = (LOC.LOCNode)nodeIt.next();
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > 2.0) {
                    throw new InvalidFieldException("Unconformity can only be set between horizontal nodes");
                }
                if (Math.abs(locNode.getDepth() - nextNode.getDepth()) > (double)0.001f) {
                    return this.getWellInterp().updateLOCNode(locNode, nextNode.getDepth(), locNode.getAge(), bnd, this.block.well.getWellID());
                }
            }
            return this.getWellInterp().updateLOCNode(locNode, locNode.getDepth(), locNode.getAge(), bnd, this.block.well.getWellID());
        }
        return null;
    }

    public UndoableEdit addLOCnode(float x, float y, float zoom) throws SQLException, InvalidFieldException {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            throw new InvalidFieldException("Select a version");
        }
        if (wellInterp.getLOC() == null) {
            throw new InvalidFieldException("You must add an LOC first");
        }
        float csu = this.getProperties().isAgeLeftToRight() ? x / this.getProperties().getAgeScale() + this.getProperties().getMinAge() : this.getProperties().getMaxAge() - x / this.getProperties().getAgeScale();
        float depth = this.block.getDepth(y);
        LOC.LOCNodeEdit edit = wellInterp.addLOCNode(3, (double)depth, (double)csu, this.block.well.getWellID());
        wellInterp.notifyObservers((Object)wellInterp.getLOC());
        return edit;
    }

    void addLOC() throws SBException, SQLException, InvalidFieldException {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            throw new InvalidFieldException("No version/composite standard selected");
        }
        LOC loc = wellInterp.getLOC();
        if (loc != null) {
            throw new InvalidFieldException("A Line of Correlation already exists. Extend existing line.");
        }
        wellInterp.addLOC(this.block.well, this.getProperties().getCmpStd(), (double)this.getProperties().getMaxAge(), (double)this.block.getBaseDepth(), (double)this.getProperties().getMinAge(), (double)this.block.getTopDepth());
        this.db.commit();
    }

    public Point2D.Float getLOCorigin(float x, float y, float zoom) {
        if (this.getWellInterp() == null) {
            return null;
        }
        float nearest = 1000.0f;
        Point2D.Float origin = null;
        LOC locLine = this.getWellInterp().getLOC();
        if (locLine != null) {
            Iterator it = locLine.getNodeIterator();
            while (it.hasNext()) {
                float yN;
                LOC.LOCNode loc = (LOC.LOCNode)it.next();
                float xN = this.getXPos((float)loc.getAge());
                float tryNearest = this.isNear(x, xN, y, yN = this.block.scaleDepth((float)loc.getDepth()), nearest, zoom);
                if (!(tryNearest < nearest)) continue;
                nearest = tryNearest;
                origin = new Point2D.Float(xN, yN);
            }
            return origin;
        }
        return null;
    }

    Point2D.Float getNeighbourPoint(float x, float y, boolean before) {
        if (this.getWellInterp() == null) {
            return null;
        }
        float SMALL = 1.0E-4f;
        LOC locLine = this.getWellInterp().getLOC();
        Iterator it = locLine.getNodeIterator();
        LOC.LOCNode previous = null;
        while (it.hasNext()) {
            LOC.LOCNode loc = (LOC.LOCNode)it.next();
            float xN = this.getXPos((float)loc.getAge());
            float yN = this.block.scaleDepth((float)loc.getDepth());
            if (Math.abs(y - yN) < SMALL && Math.abs(x - xN) < SMALL) {
                if (!before) {
                    if (it.hasNext()) {
                        LOC.LOCNode next = (LOC.LOCNode)it.next();
                        return new Point2D.Float(this.getXPos((float)next.getAge()), this.block.scaleDepth((float)next.getDepth()));
                    }
                } else if (previous != null) {
                    return new Point2D.Float(this.getXPos((float)previous.getAge()), this.block.scaleDepth((float)previous.getDepth()));
                }
                return null;
            }
            previous = loc;
        }
        return null;
    }

    private float isNear(float x, float x1, float y, float y1, float nearest, float zoom) {
        if (Math.abs(x - x1) < 2.0f / zoom && Math.abs(y - y1) < 2.0f / zoom && Math.abs(x - x1) + Math.abs(y - y1) < nearest) {
            nearest = Math.abs(x - x1) + Math.abs(y - y1);
        }
        return nearest;
    }

    public UndoableEdit updateLOCNode(Point2D oldPoint, Point2D newPoint, int bnd) throws SQLException, SBException, InvalidFieldException {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return null;
        }
        float age = this.getProperties().isAgeLeftToRight() ? (float)newPoint.getX() / this.getProperties().getAgeScale() + this.getProperties().getMinAge() : this.getProperties().getMaxAge() - (float)newPoint.getX() / this.getProperties().getAgeScale();
        float y = this.block.getDepth((float)newPoint.getY());
        float SMALL = 0.1f;
        LOC locLine = wellInterp.getLOC();
        Iterator it = locLine.getNodeIterator();
        while (it.hasNext()) {
            LOC.LOCNode loc = (LOC.LOCNode)it.next();
            float xN = this.getXPos((float)loc.getAge());
            float yN = this.block.scaleDepth((float)loc.getDepth());
            if (!(Math.abs(oldPoint.getX() - (double)xN) < (double)SMALL) || !(Math.abs(oldPoint.getY() - (double)yN) < (double)SMALL)) continue;
            return wellInterp.updateLOCNode(loc, SB.round((double)y, (int)3), SB.round((double)age, (int)2), bnd > 0 ? bnd : loc.getBnd(), this.block.well.getWellID());
        }
        return null;
    }

    @Override
    public PanelWellDepthAgeProperties getProperties() {
        return this.prop;
    }

    @Override
    public int getType() {
        return 17;
    }

    public void setProperties(PanelWellDepthAgeProperties prop) {
        this.prop = prop;
        for (SBPanel p : this.prop.sBlock.panels) {
            if (!(p instanceof PanelCompositeStandard)) continue;
            PanelCompositeStandard pcs = (PanelCompositeStandard)p;
            pcs.cmpStd = prop.getCmpStd();
            return;
        }
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        CompositeStandardEvent[] cmpStdEvent;
        if (y < 0.0f) {
            return this.prop.sBlock;
        }
        float depth = (float)Math.round(this.block.getDepth(y) * 1000.0f) / 1000.0f;
        Float obj = new Float(SB.convFromM((double)depth, (char)this.block.prop.units));
        if (this.block.well != null) {
            WellEvent event;
            Sample sample = this.getSample(y, zoom, cp);
            if (sample != null) {
                obj = sample;
            }
            if (sample != null && (event = this.getEvent(x, sample, bp, zoom)) != null) {
                return event;
            }
        }
        if ((cmpStdEvent = this.getCmpStdEvent(x, bp, zoom)) != null && cmpStdEvent.length > 0) {
            return cmpStdEvent[0];
        }
        return obj;
    }

    public Sample getSample(float y, float zoom, ChartProperties cp) {
        List samples;
        float depth = (float)Math.round(this.block.getDepth(y) * 1000.0f) / 1000.0f;
        float DEPTH_BRACKET = this.block.getDepth(y + 2.0f / zoom) - depth;
        Sample sample = null;
        try {
            samples = this.block.well.getSamples();
            if (samples == null || samples.isEmpty()) {
                return sample;
            }
        }
        catch (Exception ex) {
            return sample;
        }
        try {
            double minSampDepth = this.block.well.getDepth((Sample)samples.get(0), cp.correctDepths, cp.correctCuttings);
            double maxSampDepth = this.block.well.getDepth((Sample)samples.get(samples.size() - 1), cp.correctDepths, cp.correctCuttings);
            if ((double)depth < minSampDepth - (double)DEPTH_BRACKET || (double)depth > maxSampDepth + (double)DEPTH_BRACKET) {
                return sample;
            }
        }
        catch (Exception e) {
            return sample;
        }
        float distance = 1000.0f;
        for (Sample s : samples) {
            try {
                double sDepth = this.block.well.getDepth(s, cp.correctDepths, cp.correctCuttings);
                if (sDepth >= (double)(depth - DEPTH_BRACKET) && sDepth <= (double)(depth + DEPTH_BRACKET)) {
                    if (!(Math.abs(sDepth - (double)depth) < (double)distance)) continue;
                    distance = Math.abs((float)sDepth - depth);
                    sample = s;
                    continue;
                }
                if (!(sDepth > (double)(depth + DEPTH_BRACKET))) continue;
                break;
            }
            catch (Exception e) {
                System.out.println("Exception in getSample loop of PanelWellDepth.getObject: " + e.getMessage());
            }
        }
        return sample;
    }

    private WellEvent getEvent(float x, Sample sample, BlockProperties bp, float zoom) {
        List<WellEvent> events = this.getEvents(x, sample, bp, zoom);
        if (events != null) {
            return events.get(0);
        }
        return null;
    }

    private LOC.LOCNode getLocNode(float x, float y, float zoom) {
        if (this.getProperties().getCmpStd() != null) {
            float zoomBracket = 2.0f / zoom;
            float depth = (float)Math.round(this.block.getDepth(y) * 1000.0f) / 1000.0f;
            float DEPTH_BRACKET = this.block.getDepth(y + 2.0f / zoom) - depth;
            Iterator it = this.getWellInterp().getLOC().getNodeIterator();
            while (it.hasNext()) {
                LOC.LOCNode node = (LOC.LOCNode)it.next();
                float xPos = this.getXPos((float)this.getProperties().getCmpStd().getAge(node.getAge()));
                if (!(x > xPos - zoomBracket) || !(x < xPos + zoomBracket) || !((double)depth < node.getDepth() + (double)DEPTH_BRACKET) || !((double)depth > node.getDepth() - (double)DEPTH_BRACKET)) continue;
                return node;
            }
        }
        return null;
    }

    String getUnitName(double age, boolean top) {
        if (this.prop.getScheme() != null) {
            try {
                IGDUnit unit = this.prop.getScheme().findUnit(age, top);
                if (unit != null) {
                    return " " + unit.getName();
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private List<WellEvent> getEvents(float x, Sample sample, BlockProperties bp, float zoom) {
        if (!this.prop.drawEvents) {
            return null;
        }
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return null;
        }
        if (this.getProperties().getCmpStd() == null) {
            return null;
        }
        float zoomBracket = 2.0f / zoom;
        List wellEvents = wellInterp.getEvents();
        List events = this.getProperties().getCmpStd().getEventsByCSU(this.getProperties().isAgeLeftToRight());
        LinkedList<WellEvent> returnedEvents = null;
        WellEvent nearest = null;
        float distance = 1000.0f;
        block0: for (WellEvent event : wellEvents) {
            if (event.getSample() != sample) continue;
            for (CompositeStandardEvent csEvent : events) {
                float xPos = this.getXPos((float)this.getProperties().getCmpStd().getAge(csEvent.getCSU()));
                if (x > xPos - zoomBracket && x < xPos + zoomBracket && csEvent.getEvent() == event.getEvent() && csEvent.getEvType() == event.getCharType() && Math.abs(xPos - x) < distance) {
                    distance = Math.abs(xPos - x);
                    nearest = event;
                    if (returnedEvents == null) {
                        returnedEvents = new LinkedList<WellEvent>();
                    }
                    returnedEvents.add(event);
                }
                if (!(xPos - zoomBracket > x)) continue;
                continue block0;
            }
        }
        if (returnedEvents != null && returnedEvents.size() > 1) {
            returnedEvents.remove(nearest);
            returnedEvents.add(0, nearest);
        }
        return returnedEvents;
    }

    private CompositeStandardEvent[] getCmpStdEvent(float x, BlockProperties bp, float zoom) {
        if (this.getProperties().getCmpStd() == null) {
            return null;
        }
        double age = this.getAge(x);
        if (!(age <= this.prop.getCmpStd().getMaxAge()) || !(age >= this.prop.getCmpStd().getMinAge())) {
            return null;
        }
        LinkedList<CompositeStandardEvent> events = new LinkedList<CompositeStandardEvent>();
        double zoomBracket = 0.1 / (double)zoom;
        for (CompositeStandardEvent e : this.getProperties().getCmpStd().getEventsByCSU(true)) {
            double eage = this.getProperties().getCmpStd().getAge(e.getCSU());
            if (age < eage + zoomBracket && age > eage - zoomBracket) {
                events.add(e);
            }
            if (!(eage > age + zoomBracket)) continue;
            break;
        }
        return events.toArray(new CompositeStandardEvent[events.size()]);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        try {
            Color[] colours = null;
            if (this.block instanceof ProjectBlock) {
                colours = this.getColours();
            }
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    float ypos = y + cp.panelCaptionHeight;
                    if (this.block instanceof ProjectBlock || this.prop.drawLOCAlternatives) {
                        ypos += this.drawKey(g, x, ypos, cp, bp, colours);
                    }
                    if (this.prop.sBlock != null) {
                        this.prop.sBlock.drawHorz(g, x, ypos, cp);
                        ypos += this.prop.sBlock.getWidth();
                    }
                    if (this.prop.pBlock != null) {
                        this.prop.pBlock.drawHorz(g, x, ypos, cp);
                    }
                }
                case NO_HEADER: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (mode) {
                case NORMAL: 
                case NO_HEADER: {
                    if (this.prop.drawZones) {
                        this.drawIGD(g, x, y, cp, bp, mode);
                    }
                    if (this.prop.drawSQPicks) {
                        this.drawSQPicks(g, x, y, cp, bp, mode);
                    }
                    if (this.prop.drawLOCAlternatives) {
                        this.drawAltCurves(g, x, y, cp, mode);
                    }
                    if (this.prop.drawLOCs) {
                        this.drawLOC(g, x, y, cp, mode, colours);
                    }
                    if (this.getProperties().drawSampleAges) {
                        this.drawSampleAges(g, x, y, cp, bp, mode);
                    }
                    if (this.getProperties().drawEvents) {
                        this.drawEvents(g, x, y, cp, bp, mode, colours);
                    }
                    if (this.getProperties().drawOccs) {
                        this.drawOccurrences(g, x, y, cp, bp, mode);
                    }
                }
                case HEADER_ONLY: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    @Override
    String getCaption() {
        return this.toString();
    }

    @Override
    String getSubCaption() {
        String subcap = "";
        if (this.prop.interp != null) {
            subcap = subcap + this.prop.interp.toString();
        }
        if (this.prop.getCmpStd() != null) {
            if (!subcap.isEmpty()) {
                subcap = subcap + ", ";
            }
            subcap = subcap + "Composite: " + this.prop.getCmpStd().getName();
        }
        if (this.prop.getScheme() != null) {
            if (!subcap.isEmpty()) {
                subcap = subcap + ", ";
            }
            subcap = subcap + "Scheme: " + this.prop.getScheme().toString();
        }
        if (this.prop.getEnvPanel() != null) {
            String envString = "";
            if (!subcap.isEmpty()) {
                envString = envString + ", ";
            }
            try {
                envString = envString + "Palaeoenvironments: " + this.db.getEnvScheme(this.prop.getEnvPanel().getSchemeID());
                subcap = subcap + envString;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return subcap != null ? subcap : null;
    }

    private float drawKey(SBGraphics g, float x, float ypos, ChartProperties cp, BlockProperties bp, Color[] wellColours) {
        ypos += cp.fontSmall;
        String strg = "Showing " + (this.block.prop.scaleType == BlockProperties.ScaleType.SUBSIDENCE ? "subsidence" : "depth/age") + " curves for ";
        LinkedList<String> strings = new LinkedList<String>();
        LinkedList<Color> colours = new LinkedList<Color>();
        if (this.block instanceof ProjectBlock) {
            strg = strg + " wells: ";
            Iterator wellIterator = ((ProjectBlock)this.block).getProject().getWellIterator();
            int i = 0;
            while (wellIterator.hasNext()) {
                Well well = (Well)wellIterator.next();
                strings.add(well.getWellName());
                colours.add(wellColours[i]);
                ++i;
            }
        } else {
            strg = strg + " versions: ";
            if (this.prop.interp != null) {
                Iterator it = this.block.well.getInterpIterator();
                while (it.hasNext()) {
                    WellInterp interp = (WellInterp)it.next();
                    if (interp.getLOC() == null || interp.getHeader() == this.prop.interp) continue;
                    strings.add(interp.getHeader().getDescription());
                    colours.add(SB.getLighterColour((Color)interp.getLOC().getColour()));
                }
            }
        }
        if (strings.isEmpty()) {
            return 0.0f;
        }
        g.setFontSize(cp.fontSmall);
        assert (strings.size() == colours.size());
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                strg = strg + ", ";
            }
            strg = strg + (String)strings.get(i);
        }
        AttributedString attString = new AttributedString(strg);
        attString.addAttributes(PanelWellDepthAge.getAttributes(g), 0, attString.getIterator().getEndIndex());
        for (int j = 0; j < strings.size(); ++j) {
            int begin = strg.indexOf((String)strings.get(j));
            int end = begin + ((String)strings.get(j)).length();
            attString.addAttribute(TextAttribute.FOREGROUND, colours.get(j), begin, end);
        }
        g.drawString(attString, x + 1.0f, ypos, this.getWidth(bp));
        return cp.fontSmall + 2.0f;
    }

    float getHeaderHeight(ChartProperties cp) {
        return this.getKeyHeight(cp) + this.prop.getHeaderHeight();
    }

    private float getKeyHeight(ChartProperties cp) {
        float keyHeight = 0.0f;
        if (this.prop.drawLOCAlternatives && this.prop.interp != null) {
            Iterator it = this.block.well.getInterpIterator();
            while (it.hasNext()) {
                WellInterp interp = (WellInterp)it.next();
                if (interp.getHeader() == this.prop.interp || interp.getLOC() == null) continue;
                keyHeight += cp.fontSmall + 2.0f;
                break;
            }
        } else if (this.block instanceof ProjectBlock) {
            keyHeight += cp.fontSmall + 2.0f;
        }
        return keyHeight;
    }

    private void drawSampleAges(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        WellInterp wellInterp = this.getWellInterp();
        if (wellInterp == null) {
            return;
        }
        float symbolSize = 1.0f;
        float thickLine = 0.32f;
        float thinLine = 0.05f;
        float endLine = symbolSize * 1.5f;
        Color logSampleColour = deepGreen;
        Color sampleColour = lightGreen;
        try {
            for (Sample o : this.block.well.getSamples()) {
                float barxPos;
                Sample sample = o;
                if (!(sample.getDepth() >= (double)this.block.getTopDepth()) || !(sample.getDepth() <= (double)this.block.getBaseDepth()) || !sample.hasAgeData(wellInterp) || !(sample.getAge(wellInterp) >= (double)this.prop.getMinAge()) || !(sample.getAge(wellInterp) <= (double)this.prop.getMaxAge()) || !(sample.getAge(wellInterp) > 0.0)) continue;
                float yPos = this.block.scaleDepth((float)sample.getDepth()) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                float xPos = x + this.getXPos((float)sample.getAge(wellInterp));
                int interpID = wellInterp.getHeader().getInterpID();
                if (sample.getAgeErrorMinus(interpID) != null && sample.getAgeErrorMinus(interpID).floatValue() != 0.0f) {
                    g.setStroke(thickLine);
                    g.setColor(sample.getType().equals("LOG") ? logSampleColour : sampleColour);
                    barxPos = x + this.getXPos((float)sample.getAge(wellInterp) - sample.getAgeErrorMinus(interpID).floatValue());
                    g.drawLine(xPos, yPos, barxPos, yPos);
                    g.drawLine(barxPos, yPos + endLine / 2.0f, barxPos, yPos - endLine / 2.0f);
                }
                if (sample.getAgeErrorPlus(interpID) != null && sample.getAgeErrorPlus(interpID).floatValue() != 0.0f) {
                    g.setStroke(thickLine);
                    g.setColor(sample.getType().equals("LOG") ? logSampleColour : sampleColour);
                    barxPos = x + this.getXPos((float)sample.getAge(wellInterp) + sample.getAgeErrorPlus(interpID).floatValue());
                    g.drawLine(xPos, yPos, barxPos, yPos);
                    g.drawLine(barxPos, yPos + endLine / 2.0f, barxPos, yPos - endLine / 2.0f);
                }
                if (sample.getAgeBelow(wellInterp) > sample.getAge(wellInterp)) {
                    float xPos2 = x + this.getXPos((float)sample.getAgeBelow(wellInterp));
                    g.setStroke(thinLine);
                    g.fillEllipse(xPos2 - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, sample.getType().equals("LOG") ? logSampleColour : sampleColour);
                    g.setStroke(thinLine);
                    g.setColor(Color.LIGHT_GRAY);
                    GeneralPath gp = SBGraphics.createGeneralPath(xPos, yPos);
                    g.appendUnconf(gp, xPos, xPos2, yPos, false, false, false, false);
                    g.drawShape(gp);
                }
                g.setColor(sample.getType().equals("LOG") ? logSampleColour : sampleColour);
                g.setStroke(thinLine);
                g.fillEllipse(xPos - symbolSize / 2.0f, yPos - symbolSize / 2.0f, symbolSize, symbolSize, null);
            }
        }
        catch (Exception e) {
            System.out.println("Exception getting drawing sample ages: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void drawOccurrences(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SBException, SQLException {
        if (this.block instanceof ProjectBlock) {
            return;
        }
        float meanSymbolSize = 0.3f;
        if (this.prop.getCmpStd() != null) {
            g.setStroke(0.2f);
            g.setColor(Color.BLACK);
            for (Discipline disc : Discipline.values()) {
                List analyses = this.block.well.getAnalyses(disc, null, 0);
                for (Smpdtl smpdtl : analyses) {
                    float depth = (float)this.block.well.getDepth(smpdtl.getSample(), cp.correctDepths, cp.correctCuttings);
                    if (!(depth <= this.block.getBaseDepth()) || !(depth >= this.block.getTopDepth())) continue;
                    float yPos = this.block.scaleDepth(depth) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                    for (TaxonOcc fss : smpdtl.getOccurUnsorted()) {
                        float baseAge;
                        float topAge;
                        if (!this.getProperties().includeCvRw && (fss.getCaved() || fss.getReworked())) continue;
                        if (fss.getCaved() || fss.getReworked()) {
                            g.setColor(Color.LIGHT_GRAY);
                        } else {
                            g.setColor(Color.DARK_GRAY);
                        }
                        float symbolSize = 0.3f;
                        if (smpdtl.getHeader().getAbnSchID() > 0) {
                            AbnScheme abnScheme = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), false);
                            int nClasses = abnScheme.getNClasses();
                            int entry = 0;
                            entry = fss.getTotalCount() > 0 ? abnScheme.getIndex(fss.getTotalCount()) : (!fss.isOutsideCount() ? abnScheme.getIndex(fss.getSubAbund()) : 1);
                            symbolSize = 0.3f * (float)entry * 2.0f / 3.0f;
                        }
                        if ((topAge = (float)this.getProperties().getCmpStd().getSpecAge(fss.getSpecID(), SBEvent.EventType.TOP)) > 0.0f && topAge >= this.prop.getMinAge() && topAge <= this.prop.getMaxAge()) {
                            if (topAge < this.getProperties().getMinAge()) {
                                topAge = this.getProperties().getMinAge();
                            }
                            float xPosTop = this.getXPos(topAge);
                            g.drawLine((xPosTop += x) - symbolSize, yPos, xPosTop + symbolSize, yPos);
                            g.drawLine(xPosTop, yPos - symbolSize, xPosTop, yPos + symbolSize);
                        }
                        if (!((baseAge = (float)this.getProperties().getCmpStd().getSpecAge(fss.getSpecID(), SBEvent.EventType.BASE)) > 0.0f) || !(baseAge >= this.prop.getMinAge()) || !(baseAge <= this.prop.getMaxAge())) continue;
                        if (baseAge > this.getProperties().getMaxAge()) {
                            baseAge = this.getProperties().getMaxAge();
                        }
                        float xPosBase = this.getXPos(baseAge);
                        g.drawEllipse((xPosBase += x) - 0.5f * symbolSize, yPos - 0.5f * symbolSize, symbolSize, symbolSize);
                    }
                }
            }
        }
    }

    private void drawAltCurves(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SQLException {
        if (this.getWellInterp() != null) {
            Iterator it = this.block.well.getInterpIterator();
            while (it.hasNext()) {
                WellInterp interp = (WellInterp)it.next();
                if (interp.getHeader() == this.prop.interp || interp.getLOC() == null) continue;
                Color c = interp.getLOC().getColour();
                c = SB.getLighterColour((Color)c);
                this.drawCurve(g, x, y, cp, mode, this.block.well, interp.getLOC(), true, c);
            }
        }
    }

    private void drawLOC(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, Color[] colours) throws SQLException, SBException {
        if (this.block instanceof ProjectBlock) {
            Iterator wellIterator = ((ProjectBlock)this.block).getProject().getWellIterator();
            int i = 0;
            while (wellIterator.hasNext()) {
                WellInterp interp;
                Well well = (Well)wellIterator.next();
                if (!well.hasInterpLoaded(this.prop.getInterpID()) || (interp = well.getInterp(this.prop.getInterpID())).getLOC() == null) continue;
                this.drawCurve(g, x, y, cp, mode, well, interp.getLOC(), false, colours[i]);
                ++i;
            }
        } else if (this.getWellInterp() != null && this.getWellInterp().getLOC() != null) {
            this.drawCurve(g, x, y, cp, mode, this.block.well, this.getWellInterp().getLOC(), false, this.getWellInterp().getLOC().getColour());
        }
    }

    private void drawCurve(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, Well well, LOC locLine, boolean basic, Color colour) throws SQLException {
        if (locLine != null) {
            float symbolSize = basic ? 0.5f : 0.75f;
            g.setColor(colour);
            g.setFontSize(cp.fontSmall);
            if (locLine != null) {
                GeneralPath gp = null;
                LinkedList<Point2D.Float> nodePoints = new LinkedList<Point2D.Float>();
                Iterator it = locLine.getNodeIterator();
                Rectangle2D.Float boundary = new Rectangle2D.Float(this.getProperties().getMinAge(), this.block.getTopDepth(), this.prop.getMaxAge() - this.prop.getMinAge(), this.block.getBaseDepth() - this.block.getTopDepth());
                float lastDepth = 0.0f;
                float lastAge = 0.0f;
                int bnd = 0;
                LOC.LOCNode lastNode = null;
                while (it.hasNext()) {
                    Line2D.Float line;
                    LOC.LOCNode loc = (LOC.LOCNode)it.next();
                    double d = loc.getDepth();
                    if (lastNode != null && boundary.intersectsLine(line = new Line2D.Float(lastAge, lastDepth, (float)loc.getAge(), (float)d)) && g.clipLine(line, this.prop.getMinAge(), this.block.getTopDepth(), this.prop.getMaxAge(), this.block.getBaseDepth())) {
                        float x1 = this.getXPos(line.x1) + x;
                        float x2 = this.getXPos(line.x2) + x;
                        float y1 = this.block.scaleDepth(line.y1, well) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                        float y2 = this.block.scaleDepth(line.y2, well) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                        if (gp == null) {
                            gp = SBGraphics.createGeneralPath(x1, y1);
                        }
                        if (bnd == 1) {
                            g.setDotStroke(locLine.getLineWidth());
                        } else if (bnd == 2) {
                            g.setDashStroke(locLine.getLineWidth());
                        }
                        Shape s = g.appendBnd(gp, bnd, x1, x2, y1, y2);
                        if (s != null) {
                            g.fillShape(s, g.getColor());
                        }
                        if (!(this.block instanceof ProjectBlock)) {
                            if (lastAge >= this.getProperties().getMinAge() && lastDepth >= this.block.getTopDepth()) {
                                nodePoints.add(new Point2D.Float(x1, y1));
                            }
                            if ((float)loc.getAge() <= this.getProperties().getMaxAge() && (float)loc.getDepth() <= this.block.getBaseDepth()) {
                                nodePoints.add(new Point2D.Float(x2, y2));
                            }
                            if (!basic && this.prop.drawRates) {
                                String string = this.getWellInterp().getLOC().getRateString(lastNode, this.block.prop.units, cp.ageFormat);
                                g.drawString(string, new Point2D.Float(x1, y1), new Point2D.Float(x2, y2));
                            }
                        }
                    }
                    lastNode = loc;
                    lastDepth = (float)d;
                    lastAge = (float)loc.getAge();
                    bnd = loc.getBnd();
                }
                if (gp != null) {
                    g.setStroke(basic ? locLine.getLineWidth() / 2.0f : locLine.getLineWidth());
                    g.drawShape(gp);
                }
                if (!nodePoints.isEmpty()) {
                    for (Point2D point2D : nodePoints) {
                        g.fillEllipse((float)point2D.getX() - symbolSize / 2.0f, (float)point2D.getY() - symbolSize / 2.0f, symbolSize, symbolSize, locLine.getColour());
                    }
                }
            }
        }
    }

    void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, Color[] colours) throws SQLException, SBException {
        if (this.block instanceof ProjectBlock) {
            this.prop.useCatColours = false;
            Iterator wellIterator = ((ProjectBlock)this.block).getProject().getWellIterator();
            int i = -1;
            while (wellIterator.hasNext()) {
                Well well = (Well)wellIterator.next();
                if (!well.hasInterpLoaded(this.prop.getInterpID())) continue;
                this.drawEvents(g, x, y, cp, bp, mode, well, true, colours[++i]);
            }
        } else {
            this.drawEvents(g, x, y, cp, bp, mode, this.block.well, false, Color.BLACK);
        }
    }

    void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, Well well, boolean basic, Color colour) throws SQLException, SBException {
        float symbolSize = 1.3f;
        Color baseEventColour = colour;
        Color topEventColour = colour;
        if (this.prop.interp != null && this.getProperties().getCmpStd() != null) {
            g.setStroke(0.25f);
            g.setFontSize(cp.fontTiny);
            WellInterp interp = well.getInterp(this.prop.interp.getInterpID());
            interp.loadEvents(well);
            List events = interp.getEvents();
            for (Object o : events) {
                WellEvent event = (WellEvent)o;
                if (!this.prop.plotEvent(event)) continue;
                double depth = (float)well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings);
                int evID = event.getEvent().getEvID();
                float age = (float)this.getProperties().getCmpStd().getAge(evID, event.getTypeObj());
                if (!(depth <= (double)this.block.getBaseDepth()) || !(depth >= (double)this.block.getTopDepth()) || !(age >= this.getProperties().getMinAge()) || !(age <= this.getProperties().getMaxAge())) continue;
                float xPos = x + this.getXPos(age);
                float yPos = this.block.scaleDepth((float)depth, well) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                if (!basic && this.prop.drawEventLines) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.setDashStroke(0.15f);
                    g.drawLine(xPos, yPos, xPos, y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode));
                    if (this.getProperties().isAgeLeftToRight()) {
                        g.drawLine(xPos, yPos, x, yPos);
                    } else {
                        g.drawLine(xPos, yPos, x + this.getWidth(bp), yPos);
                    }
                }
                if (this.prop.useCatColours) {
                    if (event.getEvent().getTaxon() != null) {
                        baseEventColour = topEventColour = this.db.getCatColour(event.getEvent().getTaxon().getCatMnem(), topEventColour);
                    } else {
                        topEventColour = baseEventColour = Color.BLACK;
                    }
                }
                switch (event.getTypeObj()) {
                    case TOP: {
                        int index;
                        g.setColor(topEventColour);
                        g.setStroke(0.4f);
                        g.drawLine(xPos, yPos - 1.3f, xPos, yPos + 1.3f);
                        g.drawLine(xPos - 1.3f, yPos, xPos + 1.3f, yPos);
                        if (basic || !this.prop.drawErrorBars) break;
                        Sample prevSample = null;
                        for (index = this.block.well.getSamples().indexOf(event.getSample()) - 1; index >= 0 && (prevSample = (Sample)this.block.well.getSamples().get(index)).getType().equals("LOG"); --index) {
                        }
                        if (prevSample == null) break;
                        g.setColor(topEventColour);
                        g.setStroke(0.25f);
                        boolean overPlot = false;
                        if (prevSample.getDepth() < (double)this.block.getTopDepth()) {
                            overPlot = true;
                        }
                        float prevYPos = this.block.scaleDepth(overPlot ? this.block.getTopDepth() : (float)prevSample.getDepth()) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                        g.drawLine(xPos, prevYPos, xPos, yPos);
                        if (overPlot) break;
                        g.drawLine(xPos - 0.65f, prevYPos, xPos + 0.65f, prevYPos);
                        break;
                    }
                    case BASE: {
                        int index;
                        g.setColor(baseEventColour);
                        g.setStroke(0.4f);
                        g.drawEllipse(xPos - 0.65f, yPos - 0.65f, 1.3f, 1.3f);
                        if (basic || !this.getProperties().drawErrorBars) break;
                        Sample nextSample = null;
                        for (index = this.block.well.getSamples().indexOf(event.getSample()) + 1; index >= 0 && index < this.block.well.getSamples().size() && (nextSample = (Sample)this.block.well.getSamples().get(index)).getType().equals("LOG"); ++index) {
                        }
                        if (nextSample == null) break;
                        g.setColor(baseEventColour);
                        g.setStroke(0.25f);
                        float nextYPos = this.block.scaleDepth((float)nextSample.getDepth()) + y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
                        g.drawLine(xPos, nextYPos, xPos, yPos);
                        g.drawLine(xPos - 0.65f, nextYPos, xPos + 0.65f, nextYPos);
                        break;
                    }
                    case SINGLE: {
                        g.setColor(topEventColour);
                        g.setStroke(0.4f);
                        g.drawLine(xPos - 1.3f, yPos - 1.3f, xPos + 1.3f, yPos + 1.3f);
                        g.drawEllipse(xPos - 0.65f, yPos - 0.65f, 1.3f, 1.3f);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (!this.prop.drawEventQualifiers || event.getQualifier() == null || event.getQualifier().length() <= 0) continue;
                g.drawString(event.getQualifier(), xPos + 1.3f, yPos - 0.65f);
            }
        }
    }

    private void drawIGD(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) throws SQLException, SBException {
        block15: {
            block14: {
                if (this.prop.getScheme() == null) {
                    return;
                }
                if (!(this.block instanceof ProjectBlock) || !this.prop.drawShading) break block14;
                for (IGDScheme.ShadeInterval shadeInterval : this.prop.getScheme().getShadingIntervals(this.prop.sBlock.prop.min, this.prop.sBlock.prop.max)) {
                    float x1 = this.getXPos(shadeInterval.getUage(), this.prop.sBlock.prop);
                    float x2 = this.getXPos(shadeInterval.getLage(), this.prop.sBlock.prop);
                    g.setColor(shadeInterval.getColour());
                    Color colour = SB.getLighterColour((Color)shadeInterval.getColour());
                    g.fillRect(x1 + x, y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode), x2 - x1, bp.height, colour);
                }
                break block15;
            }
            if (!this.prop.drawZones || this.getWellInterp() == null) break block15;
            float panelRight = this.getXPos(this.prop.isAgeLeftToRight() ? this.prop.getMaxAge() : this.prop.getMinAge());
            g.setStroke(0.2f);
            LinkedList<Color> colours = new LinkedList<Color>();
            LinkedList<Rectangle2D.Float> rects = new LinkedList<Rectangle2D.Float>();
            LinkedList<String> names = new LinkedList<String>();
            List zones = this.getWellInterp().getIGDList(this.prop.getScheme().getIGDType(), this.getProperties().getScheme().getID(), 1, IGDIntervalZone.getNHier((int)this.prop.getScheme().getIGDType(), (boolean)true));
            for (IGDIntervalZone zone : zones) {
                Color lighter;
                float xright;
                float xleft;
                if (zone.getSchID() != this.prop.getScheme().getID()) continue;
                double topDepth = this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseDepth = this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (baseDepth < (double)this.block.getTopDepth() || topDepth > (double)this.block.getBaseDepth()) continue;
                if ((double)this.block.getTopDepth() > topDepth) {
                    topDepth = this.block.getTopDepth();
                }
                if (baseDepth > (double)this.block.getBaseDepth()) {
                    baseDepth = this.block.getBaseDepth();
                }
                float ytop = y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)topDepth);
                float ybase = y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)baseDepth);
                IGDUnit unit = this.prop.getScheme().findUnit(zone.getUppZone());
                if (unit != null) {
                    xleft = this.getXPos((float)(this.prop.isAgeLeftToRight() ? unit.getUage() : unit.getLage()));
                    xright = this.getXPos((float)(this.prop.isAgeLeftToRight() ? unit.getLage() : unit.getUage()));
                    if (!(xright < 0.0f) && !(xleft > panelRight)) {
                        xright = Math.min(xright, panelRight) + x;
                        xleft = Math.max(xleft, 0.0f) + x;
                        names.add((zone.isQUzone() ? "?" : "") + (zone.getUppInf().isEmpty() ? unit.getName() : zone.getUppInf()));
                        rects.add(new Rectangle2D.Float(xleft, ytop, xright - xleft, ybase - ytop));
                        colours.add(unit.getColour().equals(Color.WHITE) ? Color.lightGray : unit.getColour());
                        if (this.prop.drawShading) {
                            g.setColor(unit.getColour());
                            lighter = SB.getLighterColour((Color)unit.getColour());
                            g.fillRect(xleft, y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode), xright - xleft, ytop - y - PanelWellDepthAge.getPanelHeaderHeight(cp, mode), lighter);
                            if (this.prop.isAgeLeftToRight()) {
                                g.fillRect(x, ytop, xleft - x, ybase - ytop, lighter);
                            } else {
                                g.fillRect(xright, ytop, x + panelRight - xright, ybase - ytop, lighter);
                            }
                        }
                    }
                }
                if (zone.getLowZone() <= 0 || (unit = this.prop.getScheme().findUnit(zone.getLowZone())) == null) continue;
                xleft = this.getXPos((float)(this.prop.isAgeLeftToRight() ? unit.getUage() : unit.getLage()));
                xright = this.getXPos((float)(this.prop.isAgeLeftToRight() ? unit.getLage() : unit.getUage()));
                if (xright < 0.0f || xleft > panelRight) continue;
                xright = Math.min(xright, panelRight) + x;
                xleft = Math.max(xleft, 0.0f) + x;
                colours.add(unit.getColour().equals(Color.WHITE) ? Color.lightGray : unit.getColour());
                rects.add(new Rectangle2D.Float(xleft, ytop, xright - xleft, ybase - ytop));
                names.add((zone.isQLzone() ? "?" : "") + (zone.getLowInf().isEmpty() ? unit.getName() : zone.getLowInf()));
                if (!this.prop.drawShading) continue;
                g.setColor(unit.getColour());
                lighter = SB.getLighterColour((Color)unit.getColour());
                g.fillRect(xleft, y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode), xright - xleft, ytop - y - PanelWellDepthAge.getPanelHeaderHeight(cp, mode), lighter);
                if (this.prop.isAgeLeftToRight()) {
                    g.fillRect(x, ytop, xleft - x, ybase - ytop, lighter);
                    continue;
                }
                g.fillRect(xright, ytop, x + panelRight - xright, ybase - ytop, lighter);
            }
            assert (colours.size() == rects.size());
            assert (names.size() == rects.size());
            for (int i = 0; i < rects.size(); ++i) {
                Color c = (Color)colours.get(i);
                Rectangle2D r = (Rectangle2D)rects.get(i);
                g.setColor(c);
                g.fillRect((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), (Color)colours.get(i));
                g.setColor(Color.BLACK);
                this.drawString(g, (String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), cp.font, 0, cp.fontPanel);
                if (g.drawStringBox((String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), false)) continue;
                g.drawStringBox((String)names.get(i), (float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight(), true);
            }
        }
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    void drawSQPicks(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.getWellInterp() == null) {
            return;
        }
        float yTop = y + PanelWellDepthAge.getPanelHeaderHeight(cp, mode);
        for (SQPick pick : this.getWellInterp().getSQPicks()) {
            double depth;
            try {
                depth = this.block.well.getDepth(pick.getSample(), cp.correctDepths, cp.correctCuttings);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
                depth = pick.getSample().getDepth();
            }
            float yPos = this.block.scaleDepth((float)depth) + yTop;
            double age = pick.getSurface().getAge();
            if (!(age > (double)this.getProperties().getMinAge()) || !(age < (double)this.getProperties().getMaxAge())) continue;
            float xPos = x + this.getXPos((float)age);
            switch (pick.getSurfaceType()) {
                case MFS: {
                    g.setColor(this.hstColour);
                    break;
                }
                case SB: 
                case CC: {
                    g.setColor(this.lstColour);
                    break;
                }
                case TS: {
                    g.setColor(this.tstColour);
                }
            }
            g.setStroke(PanelSequencesProperties.bndStroke * 0.5f);
            if (pick.getBndInt() == 4 || pick.getBndInt() == 5) {
                GeneralPath p = SBGraphics.createGeneralPath(x + this.getWidth(bp), yPos);
                Shape q = g.appendUnconf(p, x + this.getWidth(bp), xPos, yPos, pick.getBndInt() == 5, true, true, false);
                g.drawShape(p);
                if (q != null) {
                    g.drawShape(q);
                }
            } else {
                PanelZones.drawBoundary(pick.getBndInt(), xPos, x + this.getWidth(bp), yPos, g, PanelSequencesProperties.bndStroke * 0.5f);
            }
            g.setStroke(PanelSequencesProperties.bndStroke * 0.5f);
            g.drawLine(xPos, yPos, xPos, yTop);
        }
    }

    private float getXPos(float age) {
        float xpos = this.prop.isAgeLeftToRight() ? (age - this.prop.getMinAge()) * this.prop.getAgeScale() : (this.prop.getMaxAge() - age) * this.prop.getAgeScale();
        return xpos;
    }

    float getAge(float xpos) {
        float age = this.prop.isAgeLeftToRight() ? xpos / this.prop.getAgeScale() + this.prop.getMinAge() : this.prop.getMaxAge() - xpos / this.prop.getAgeScale();
        return age;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = (this.prop.getMaxAge() - this.prop.getMinAge()) * this.prop.getAgeScale();
        return width;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    @Override
    boolean pipe() {
        return false;
    }

    private Color[] getColours() {
        Project project = ((ProjectBlock)this.block).getProject();
        if (project == null) {
            return null;
        }
        Color[] colours = new Color[project.getSize()];
        float inc = 1.0f / (float)colours.length;
        float hue = 0.0f;
        float saturation = 0.8f;
        float brightness = 0.8f;
        for (int i = 0; i < colours.length; ++i) {
            colours[i] = Color.getHSBColor(hue, saturation, brightness);
            hue += inc;
        }
        return colours;
    }
}

