/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.PanelAgeCurve;
import jsbugs.PanelAgeScale;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEnv;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelProperties;
import jsbugs.ProjectBlock;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.AgeCurve;
import model2.CompositeStandard;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.WellEvent;
import util.SBException;

public class PanelWellDepthAgeProperties
implements PanelProperties {
    private IGDScheme scheme;
    private CompositeStandard cmpStd = null;
    InterpHdr interp;
    boolean drawLOCs = true;
    boolean drawSampleAges = true;
    boolean drawRates = false;
    boolean drawLOCAlternatives = false;
    boolean drawEvents = true;
    boolean drawOccs = true;
    boolean includeCvRw = false;
    boolean useCatColours = true;
    boolean drawErrorBars = true;
    boolean drawEventQualifiers = true;
    boolean drawZones = true;
    boolean drawShading = true;
    boolean drawEventLines = true;
    boolean drawSQPicks = false;
    SchemeBlock sBlock;
    ProjectBlock pBlock;
    private static final String PREFSTRING = "DAPANPREF";
    private static final String SUBPREFSTRING = "SUBPANPREF";

    public PanelWellDepthAgeProperties(SBdb sbdb, boolean subsidence) {
        this.sBlock = new SchemeBlock();
        this.decode(sbdb, subsidence ? SUBPREFSTRING : PREFSTRING);
    }

    public PanelWellDepthAgeProperties(PanelWellDepthAgeProperties rhs) {
        if (rhs != null) {
            this.cmpStd = rhs.cmpStd;
            this.scheme = rhs.scheme;
            this.interp = rhs.interp;
            this.drawEvents = rhs.drawEvents;
            this.drawOccs = rhs.drawOccs;
            this.includeCvRw = rhs.includeCvRw;
            this.drawLOCs = rhs.drawLOCs;
            this.drawLOCAlternatives = rhs.drawLOCAlternatives;
            this.drawZones = rhs.drawZones;
            this.drawShading = rhs.drawShading;
            this.drawEventLines = rhs.drawEventLines;
            this.drawSampleAges = rhs.drawSampleAges;
            this.drawSQPicks = rhs.drawSQPicks;
            this.drawErrorBars = rhs.drawErrorBars;
            this.drawEventQualifiers = rhs.drawEventQualifiers;
            this.useCatColours = rhs.useCatColours;
            this.drawRates = rhs.drawRates;
            this.sBlock = rhs.sBlock;
            this.pBlock = rhs.pBlock;
        } else {
            this.sBlock = new SchemeBlock();
        }
    }

    public void encode(SBdb sbdb, boolean subsidence) {
        String string = new String();
        String[] props = new String[]{"" + (this.sBlock.prop.ageLeftToRight ? 1 : 0), "" + (this.drawLOCs ? 1 : 0), "" + (this.drawSampleAges ? 1 : 0), "" + (this.drawEvents ? 1 : 0), "" + (this.drawOccs ? 1 : 0), "" + (this.drawShading ? 1 : 0), "" + (this.drawZones ? 1 : 0), "" + (this.drawEventLines ? 1 : 0), "" + (this.scheme != null ? this.scheme.getID() : -1), "" + (this.includeCvRw ? 1 : 0), "" + (this.drawErrorBars ? 1 : 0), "" + (this.drawSQPicks ? 1 : 0), "" + (this.drawRates ? 1 : 0), "" + (this.drawEventQualifiers ? 1 : 0), "" + (this.useCatColours ? 1 : 0), "" + (this.drawLOCAlternatives ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)sbdb, (String)PREFSTRING, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb sbdb, String prefString) {
        try {
            int token;
            String params = Lastval.getString((SBdb)sbdb, (String)prefString);
            if (params.isEmpty()) {
                System.out.println("Decoding depth/age panel properties: params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                boolean bl = this.sBlock.prop.ageLeftToRight = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawLOCs = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawSampleAges = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawEvents = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawOccs = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawShading = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawZones = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawEventLines = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens() && (token = Integer.parseInt(tok.nextToken())) >= 0) {
                this.scheme = sbdb.getIGDScheme(token);
                if (this.scheme != null) {
                    this.scheme.loadUnits();
                }
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.includeCvRw = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawErrorBars = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawSQPicks = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawRates = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawEventQualifiers = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.useCatColours = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.drawLOCAlternatives = Integer.parseInt(tok.nextToken()) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean plotEvent(WellEvent e) throws SQLException {
        if (this.sBlock != null) {
            for (SBPanel p : this.sBlock.panels) {
                if (!(p instanceof PanelCompositeStandard)) continue;
                PanelCompositeStandard pcs = (PanelCompositeStandard)p;
                return pcs.getProperties().plotEvent(e.getEvent(), e.getDiscIDTaxon(), e.getTypeObj());
            }
        }
        return true;
    }

    public void setCmpStd(CompositeStandard std, SBdb sbdb) throws SQLException {
        if (this.cmpStd != std) {
            if (std != null) {
                std.loadEvents();
            }
            if (this.sBlock != null) {
                boolean found = false;
                ListIterator it = this.sBlock.panels.listIterator();
                while (it.hasNext()) {
                    SBPanel o = (SBPanel)it.next();
                    if (!(o instanceof PanelCompositeStandard) || ((PanelCompositeStandard)o).cmpStd != this.cmpStd) continue;
                    PanelCompositeStandard p = (PanelCompositeStandard)o;
                    if (std != null) {
                        p.cmpStd = std;
                    } else {
                        it.remove();
                    }
                    found = true;
                }
                if (!found) {
                    this.sBlock.addPanel(new PanelCompositeStandard(std, sbdb, this.sBlock));
                }
            }
            this.cmpStd = std;
        }
    }

    public void setScheme(IGDScheme scheme) throws SQLException {
        if (scheme != this.scheme) {
            if (scheme != null) {
                scheme.loadUnits();
            }
            if (this.sBlock != null) {
                if (this.scheme != null) {
                    ListIterator it = this.sBlock.panels.listIterator();
                    while (it.hasNext()) {
                        SBPanel o = (SBPanel)it.next();
                        if (!(o instanceof PanelIGDScheme) || ((PanelIGDScheme)o).scheme != this.scheme) continue;
                        it.remove();
                    }
                }
                if (scheme != null) {
                    this.sBlock.panels.add(new PanelIGDScheme(scheme, this.sBlock));
                }
            }
            this.scheme = scheme;
        }
    }

    public CompositeStandard getCmpStd() {
        return this.cmpStd;
    }

    public void setSBlockAgeRange(float min, float max) {
        this.sBlock.prop.min = min;
        this.sBlock.prop.max = max;
    }

    public float getMinAge() {
        return this.sBlock.prop.min;
    }

    public float getMaxAge() {
        return this.sBlock.prop.max;
    }

    public float getAgeScale() {
        return this.sBlock.prop.scale;
    }

    public boolean isAgeLeftToRight() {
        return this.sBlock.prop.ageLeftToRight;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        if (key.length() > 9) {
            throw new IllegalArgumentException("Key too long for PanelWellDepthAgeProperties: " + key);
        }
        Lastval.putString((SBdb)sbdb, (String)(key + "S"), (String)this.sBlock.prop.getProperties());
        int panelNo = 0;
        LinkedList storePanels = new LinkedList();
        storePanels.addAll(this.sBlock.panels);
        if (this.pBlock != null) {
            storePanels.addAll(this.pBlock.panels);
        }
        for (SBPanel panel : storePanels) {
            String prefix = panel.getType() + "^";
            if (panel.getIdentifier() >= 0) {
                prefix = prefix + "#" + panel.getIdentifier() + "#";
                if (panel.getIdentifier2() >= 0) {
                    prefix = prefix + panel.getIdentifier2() + "#";
                }
            }
            panel.getProperties().writeProperties(sbdb, key + panelNo, prefix);
            if (panelNo == 9) {
                System.out.println("WARNING: too many scheme header panels to store in preferences");
                break;
            }
            ++panelNo;
        }
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + this.getPrefs()));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + (this.scheme != null ? this.scheme.getID() : -1), "" + (this.drawLOCs ? 1 : 0), "" + (this.drawSampleAges ? 1 : 0), "" + (this.drawEvents ? 1 : 0), "" + (this.drawOccs ? 1 : 0), "" + (this.drawShading ? 1 : 0), "" + (this.drawZones ? 1 : 0), "" + (this.drawEventLines ? 1 : 0), "" + (this.includeCvRw ? 1 : 0), "" + (this.drawErrorBars ? 1 : 0), "" + (this.drawSQPicks ? 1 : 0), "" + (this.drawRates ? 1 : 0), "" + (this.drawEventQualifiers ? 1 : 0), "" + (this.useCatColours ? 1 : 0), "" + (this.drawLOCAlternatives ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    PanelWellDepthAgeProperties(SBdb sbdb, String prop, LinkedList<Chart.ChartPref> sBlockPanels, InterpHdr interp, Project project) throws SQLException, SBException {
        this.interp = interp;
        String[] s = prop.split("\\|");
        block26: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    int schID = Integer.parseInt(s[i]);
                    this.scheme = sbdb.getIGDScheme(schID);
                    continue block26;
                }
                case 1: {
                    this.drawLOCs = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 2: {
                    this.drawSampleAges = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 3: {
                    this.drawEvents = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 4: {
                    this.drawOccs = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 5: {
                    this.drawShading = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 6: {
                    this.drawZones = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 7: {
                    this.drawEventLines = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 8: {
                    this.includeCvRw = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 9: {
                    this.drawErrorBars = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 10: {
                    this.drawSQPicks = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 11: {
                    this.drawRates = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 12: {
                    this.drawEventQualifiers = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 13: {
                    this.useCatColours = Integer.parseInt(s[i]) == 1;
                    continue block26;
                }
                case 14: {
                    this.drawLOCAlternatives = Integer.parseInt(s[i]) == 1;
                }
            }
        }
        BlockProperties bp = null;
        for (int i = 0; i < sBlockPanels.size(); ++i) {
            if (!sBlockPanels.get((int)i).key.endsWith("S")) continue;
            bp = new BlockProperties(sBlockPanels.get((int)i).value);
            sBlockPanels.remove(i);
            break;
        }
        this.sBlock = bp != null ? new SchemeBlock(bp) : new SchemeBlock();
        block28: for (Chart.ChartPref p : sBlockPanels) {
            String[] t = p.value.split("\\^");
            assert (t.length == 2);
            int panelType = Integer.parseInt(t[0]);
            int identifier = -1;
            int identifier2 = -1;
            if (t[1].contains("#")) {
                t[1] = t[1].substring(1);
                String[] u = t[1].split("#");
                identifier = Integer.parseInt(u[0]);
                t[1] = u[1];
                if (u.length > 2) {
                    identifier2 = Integer.parseInt(u[1]);
                    t[1] = u[2];
                }
            }
            switch (panelType) {
                case 40: {
                    IGDScheme sch = sbdb.getIGDScheme(identifier);
                    if (sch == null) continue block28;
                    this.sBlock.addPanel(new PanelIGDScheme(sch, this.sBlock, t[1]));
                    continue block28;
                }
                case 42: {
                    CompositeStandard std = sbdb.getCompositeStandard(identifier);
                    if (std == null) continue block28;
                    std.loadEvents();
                    this.sBlock.addPanel(new PanelCompositeStandard(std, sbdb, this.sBlock, t[1]));
                    this.cmpStd = std;
                    continue block28;
                }
                case 41: {
                    try {
                        AgeCurve curve = sbdb.getAgeCurve(identifier);
                        this.sBlock.addPanel(new PanelAgeCurve(this.sBlock, curve, t[1]));
                    }
                    catch (SBException sbe) {}
                    continue block28;
                }
                case 43: {
                    this.sBlock.addPanel(new PanelAgeScale(this.sBlock, false, t[1]));
                    continue block28;
                }
                case 15: {
                    if (project == null || sbdb.getEnvScheme(identifier2) == null) continue block28;
                    this.pBlock = new ProjectBlock(project, sbdb, this.sBlock.prop);
                    this.pBlock.addPanel(new PanelEnv(this.pBlock, identifier, identifier2, sbdb));
                    continue block28;
                }
            }
            System.out.println("Unrecognised panel: " + p.key + " " + p.value);
        }
    }

    public IGDScheme getScheme() {
        return this.scheme;
    }

    int getMaxHier() {
        if (this.scheme == null) {
            return 0;
        }
        for (SBPanel panel : this.sBlock.panels) {
            if (!(panel instanceof PanelIGDScheme) || ((PanelIGDScheme)panel).getScheme() != this.scheme) continue;
            PanelIGDScheme iPanel = (PanelIGDScheme)panel;
            int hier = 0;
            for (int i = 0; i < iPanel.getProperties().getMaxHier(); ++i) {
                if (!iPanel.getProperties().plotHier[i]) continue;
                hier = i;
            }
            return hier + 1;
        }
        return IGDIntervalZone.getNHier((int)this.scheme.getIGDType(), (boolean)false);
    }

    public int getInterpID() {
        if (this.interp == null) {
            return -1;
        }
        return this.interp.getInterpID();
    }

    float getHeaderHeight() {
        float height = this.sBlock.getWidth();
        if (this.pBlock != null) {
            height += this.pBlock.getWidth();
        }
        return height;
    }

    PanelEnv getEnvPanel() {
        if (this.pBlock != null) {
            for (SBPanel panel : this.pBlock.panels) {
                if (!(panel instanceof PanelEnv)) continue;
                return (PanelEnv)panel;
            }
        }
        return null;
    }
}

