/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import jsbugs.BlockProperties;
import jsbugs.ChartProperties;
import jsbugs.PanelWellHeaderProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHdr;
import jsbugs.WellBlock;
import model2.Well;

public class PanelWellHeader
extends SBPanelHdr {
    private final WellBlock block;
    private BufferedImage image;
    private PanelWellHeaderProperties p;

    PanelWellHeader(WellBlock block) {
        this.block = block;
        this.p = new PanelWellHeaderProperties();
    }

    PanelWellHeader(WellBlock block, String props) {
        this.block = block;
        this.p = new PanelWellHeaderProperties(props);
    }

    @Override
    float draw(final SBGraphics g, float x, float y, float width, ChartProperties cp, BlockProperties bp) {
        String descrip;
        Well well = this.block.well;
        float pad = cp.fontHeader;
        float titleSize = cp.fontHeader * 3.0f;
        float fontSize = cp.fontHeader - 2.0f;
        g.setColor(Color.black);
        g.setFont(cp.font, 1, titleSize);
        float ypos = y + titleSize;
        g.drawString(well.getWellName(), x + (this.p.centreName ? 0.0f : pad), this.p.centreName ? y + this.p.height / 2.0f + g.stringHeightSB() / 2.0f : ypos, width, this.p.centreName ? 0 : 1);
        float wellNameWidth = g.stringWidth(well.getWellName());
        float h = this.p.height - ((ypos += pad) - y);
        final float lineHeight = fontSize + 1.0f;
        LinkedList<TextItem> items = new LinkedList<TextItem>();
        if (this.p.wellCode) {
            items.add(new TextItem("Well Code", well.getWellCode()));
        }
        if (this.p.operator && !well.getHeader().getOper().isEmpty()) {
            items.add(new TextItem("Operator", well.getHeader().getOper()));
        }
        if (this.p.spud && well.getHeader().getSpud() != null) {
            items.add(new TextItem("Spudded", DateFormat.getDateInstance(2).format(well.getHeader().getSpud())));
        }
        if (this.p.spud && well.getHeader().getComp() != null) {
            items.add(new TextItem("Completed", DateFormat.getDateInstance(2).format(well.getHeader().getComp())));
        }
        if (this.p.location && well.getHeader().getLat_dec() != null && well.getHeader().getLong_dec() != null) {
            String value = well.getHeader().getLatString(this.p.decimalLocation);
            value = value + " " + well.getHeader().getLongString(this.p.decimalLocation);
            items.add(new TextItem("Location", value));
        }
        if (this.p.scale) {
            items.add(new TextItem("Scale", "1:" + (int)bp.scale));
        }
        if (cp.chartGenDate != null) {
            items.add(new TextItem("Chart date", DateFormat.getDateInstance(2).format(cp.chartGenDate)));
        }
        float colTop = ypos;
        float xposItem = x + pad;
        if (this.p.centreName || h - pad < lineHeight) {
            colTop = y + titleSize - g.stringHeightSB();
            if (wellNameWidth + pad > width) {
                return y + this.p.height;
            }
            if (!this.p.centreName) {
                xposItem += wellNameWidth + pad;
            }
        }
        float yposItem = colTop;
        g.setFont(cp.font, 0, fontSize);
        String sep = " : ";
        final float sepWidth = g.stringWidth(" : ");
        class ColumnWriter {
            ColumnWriter() {
            }

            void write(LinkedList<TextItem> column, float xcol, float ycol, float tWidth) {
                for (TextItem i : column) {
                    g.drawString(i.title, xcol, ycol += lineHeight);
                    g.drawString(" : ", xcol + tWidth, ycol);
                    g.drawString(i.value, xcol + tWidth + sepWidth, ycol);
                }
            }
        }
        ColumnWriter writer = new ColumnWriter();
        LinkedList<TextItem> column = new LinkedList<TextItem>();
        float titleWidth = 0.0f;
        float valueWidth = 0.0f;
        Iterator it = items.iterator();
        while (it.hasNext()) {
            if ((yposItem += lineHeight) - ypos > h - pad) {
                if (!column.isEmpty()) {
                    writer.write(column, xposItem, colTop, titleWidth);
                }
                yposItem = colTop + lineHeight;
                column.clear();
                titleWidth = 0.0f;
                valueWidth = 0.0f;
                if ((xposItem += titleWidth + valueWidth + sepWidth + pad) - x > width) break;
            }
            TextItem item = (TextItem)it.next();
            column.add(item);
            if (item.getTitleWidth(g) > titleWidth) {
                titleWidth = item.getTitleWidth(g);
            }
            if (!(item.getValueWidth(g) > valueWidth)) continue;
            valueWidth = item.getValueWidth(g);
        }
        if (!column.isEmpty()) {
            writer.write(column, xposItem, colTop, titleWidth);
            xposItem += titleWidth + valueWidth + sepWidth + pad;
        }
        float imgwidth = 0.0f;
        if (this.p.logo) {
            File file;
            if (this.image == null && (file = new File("logo.jpg")).exists()) {
                try {
                    this.image = ImageIO.read(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.image != null) {
                float padding = 5.0f;
                float availHeight = this.p.height - padding * 2.0f;
                float imgheight = this.image.getHeight();
                imgwidth = this.image.getWidth();
                if (imgheight > availHeight) {
                    imgwidth /= imgheight / availHeight;
                    imgheight = availHeight;
                }
                g.drawImage(this.image, x + width - imgwidth - padding, y + padding, imgwidth, imgheight);
            }
        }
        if (this.p.comments && (descrip = well.getHeader().getDescrip()) != null && !descrip.isEmpty()) {
            float commentHeight = this.p.height - (colTop - y) - pad;
            float commentWidth = this.p.centreName ? x + width / 2.0f - wellNameWidth / 2.0f - xposItem - pad : x + width - xposItem - imgwidth - pad;
            commentWidth = Math.min(commentWidth, 100.0f);
            g.drawStringBox(descrip, xposItem, colTop, commentWidth, commentHeight, 1);
        }
        if (this.p.border) {
            g.setStroke(0.35f);
            g.drawRect(x, y, width, this.p.height);
        }
        return y + this.p.height;
    }

    @Override
    float getHeight() {
        return this.p.height;
    }

    public String toString() {
        return "Well Header";
    }

    @Override
    public PanelWellHeaderProperties getProperties() {
        return this.p;
    }

    public void setProperties(PanelWellHeaderProperties p) {
        this.p = p;
    }

    @Override
    public int getType() {
        return 46;
    }

    private static class TextItem {
        final String title;
        final String value;
        private Float titleWidth;
        private Float valueWidth;

        TextItem(String title, String value) {
            this.title = title;
            this.value = value;
        }

        float getTitleWidth(SBGraphics g) {
            if (this.titleWidth == null) {
                this.titleWidth = Float.valueOf(g.stringWidth(this.title));
            }
            return this.titleWidth.floatValue();
        }

        float getValueWidth(SBGraphics g) {
            if (this.valueWidth == null) {
                this.valueWidth = Float.valueOf(g.stringWidth(this.value));
            }
            return this.valueWidth.floatValue();
        }

        float getWidth(SBGraphics g) {
            return this.getTitleWidth(g) + this.getValueWidth(g);
        }
    }
}

