/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import jsbugs.BlockProperties;
import jsbugs.ChartProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHdr;
import jsbugs.WellBlock;

public class PanelWellName
extends SBPanelHdr {
    float height = 10.0f;
    WellBlock block;

    PanelWellName(WellBlock block) {
        this.block = block;
    }

    @Override
    float draw(SBGraphics g, float x, float y, float width, ChartProperties p, BlockProperties bp) {
        if (this.block.well == null) {
            return y;
        }
        String wellName = this.block.well.getWellName();
        float lineHeight = y + this.height * 0.33f;
        g.setFont(p.font, 1, p.fontHeader);
        g.drawString(this.block.well.getWellName(), x, lineHeight + g.stringHeightSB() / 2.0f, width, 0);
        g.setStroke(0.35f);
        float stringWidth = g.stringWidth(wellName);
        float pad = 2.5f;
        g.drawLine(x, lineHeight, x + width / 2.0f - stringWidth / 2.0f - pad, lineHeight);
        g.drawLine(x + width / 2.0f + stringWidth / 2.0f + pad, lineHeight, x + width, lineHeight);
        g.drawLine(x, lineHeight, x, y + this.height - 3.0f);
        g.drawLine(x + width, lineHeight, x + width, y + this.height - 3.0f);
        return y + this.height;
    }

    @Override
    float getHeight() {
        return this.height;
    }

    public String toString() {
        return "Well Name Panel";
    }

    @Override
    public int getType() {
        return 47;
    }
}

