/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelWellVSProperties;
import jsbugs.PanelWirelineLog;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.TickScheme;
import jsbugs.WellBlock;
import model2.Curve;
import model2.Fault;
import model2.IGDColMap;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.SBdb;
import model2.Sample;
import model2.TVDList;
import model2.TVDepth;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;
import util.TextStroke;

public class PanelWellVS
extends SBPanel {
    WellBlock block;
    private SBdb sbdb;
    private PanelWellVSProperties p;
    private WellInterp wellInterp;
    private LinkedList<OffsetNode> nodeList = new LinkedList();
    private LinkedList<OffsetNode> nodeListPlan = new LinkedList();
    private LinkedList<SamplePoint> sampleDepths;
    Double lastNodeDepth = null;
    Point2D.Float lastNodePoint = null;
    Point2D.Float predictPoint = null;
    TVDList tvdList = null;
    TVDList tvdListPlan = null;
    static final float DEPTH_BRACKET = 2.0f;
    private static final float eventSymbolSize = 3.2f;
    ChartProperties cp;
    float xorigin;
    float yorigin;

    PanelWellVS(SBdb db, WellBlock block, int interpID) throws SQLException, SBException {
        this(db, block, interpID, new PanelWellVSProperties(db));
        this.p.scaleVS = block.prop.scale;
    }

    PanelWellVS(SBdb sbdb, WellBlock block, int interpID, String prop) throws SQLException, SBException {
        this(sbdb, block, interpID, new PanelWellVSProperties(sbdb, prop));
    }

    private PanelWellVS(SBdb db, WellBlock block, int interpID, PanelWellVSProperties p) throws SQLException, SBException {
        this.block = block;
        this.sbdb = db;
        if (interpID >= 0) {
            this.wellInterp = block.well.getInterp(interpID);
        }
        this.p = p;
        this.checkProperties();
        this.tvdList = block.well.getTVDlist(false);
        this.tvdListPlan = block.well.getTVDlist(true);
    }

    private void checkProperties() throws SBException, SQLException {
        PanelWellVSProperties.LogInfo[] infos;
        if (this.wellInterp == null || !this.wellInterp.hasData(this.p.igdType)) {
            this.p.igdType = -1;
        }
        for (PanelWellVSProperties.LogInfo info : infos = new PanelWellVSProperties.LogInfo[]{this.p.logInfo1, this.p.logInfo2}) {
            if (info.logDef == null) continue;
            boolean foundCurve = false;
            for (Curve curve : this.block.well.getCurves().getCurves()) {
                if (!curve.getAbr().equals(info.logDef.getAbr())) continue;
                foundCurve = true;
                break;
            }
            if (foundCurve) continue;
            info.logDef = null;
        }
    }

    void setProperties(PanelWellVSProperties p) {
        if (p != null) {
            this.p = p;
        }
    }

    PanelWellVSProperties getProps() {
        return this.p;
    }

    @Override
    public PanelWellVSProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 44;
    }

    void setInterp(WellInterp interp) {
        if (this.wellInterp != interp) {
            this.wellInterp = interp;
        }
    }

    WellInterp getInterp() {
        return this.wellInterp;
    }

    void setHorzScale(float scale) {
        if (scale > 0.0f) {
            this.p.scaleVS = scale;
        }
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object obj = this.getObject(x, y, cp, bp, zoom);
        String strg = obj.toString();
        return strg;
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        System.out.println("PanelWellVs setting data...");
        this.xorigin = 0.0f;
        this.yorigin = 0.0f;
        this.cp = cp;
        this.createNodeList(this.p.igdType, this.wellInterp != null ? this.wellInterp.getHeader().getInterpID() : -1, this.p.schID, false, cp);
        if (this.p.drawPlan) {
            this.createNodeList(-1, -1, -1, true, cp);
        }
        this.createSampleList(cp);
    }

    private void createSampleList(ChartProperties cp) throws SQLException, SBException {
        TVDepth tvd;
        double corrDepth;
        Sample sample;
        if (this.tvdList == null || this.tvdList.getSize() == 0) {
            return;
        }
        LinkedHashMap<Integer, SamplePoint> sampleMap = new LinkedHashMap<Integer, SamplePoint>();
        if (this.wellInterp != null) {
            if (this.p.drawFaults) {
                for (Fault fault : this.wellInterp.getFaults()) {
                    sample = fault.getSample();
                    corrDepth = this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                    tvd = this.tvdList.getTVD(corrDepth);
                    if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.prop.min) || !(tvd.getTVDepth() < (double)this.block.prop.max) || !(tvd.getVS() > (double)this.p.minVS) || !(tvd.getVS() < (double)this.p.maxVS)) continue;
                    sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth(), false, null, null)), sample, corrDepth, fault));
                }
            }
            if (this.p.drawEvents) {
                for (WellEvent event : this.wellInterp.getEvents()) {
                    sample = event.getSample();
                    if (((HashMap)sampleMap).get(sample.getSampID()) != null) {
                        ((SamplePoint)((HashMap)sampleMap).get(sample.getSampID())).addObject(event);
                        continue;
                    }
                    corrDepth = this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                    tvd = this.tvdList.getTVD(corrDepth);
                    if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.prop.min) || !(tvd.getTVDepth() < (double)this.block.prop.max) || !(tvd.getVS() > (double)this.p.minVS) || !(tvd.getVS() < (double)this.p.maxVS)) continue;
                    sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth(), false, null, null)), sample, corrDepth, event));
                }
            }
        }
        Iterator it = this.block.well.getSamples().iterator();
        if (this.block.well.getSamples().size() > 0) {
            Sample baseSample = (Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1);
            while (it.hasNext()) {
                sample = (Sample)it.next();
                if (((HashMap)sampleMap).get(sample.getSampID()) != null) {
                    if (sample != baseSample) continue;
                    ((SamplePoint)((HashMap)sampleMap).get(sample.getSampID())).addObject(sample);
                    continue;
                }
                corrDepth = this.block.well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                tvd = this.tvdList.getTVD(corrDepth);
                if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.prop.min) || !(tvd.getTVDepth() < (double)this.block.prop.max) || !(tvd.getVS() > (double)this.p.minVS) || !(tvd.getVS() < (double)this.p.maxVS)) continue;
                sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth(), false, null, null)), sample, corrDepth, sample == baseSample ? sample : null));
            }
        }
        if (sampleMap.isEmpty()) {
            this.sampleDepths = null;
        } else {
            this.sampleDepths = new LinkedList();
            this.sampleDepths.addAll(((HashMap)sampleMap).values());
            Collections.sort(this.sampleDepths);
        }
    }

    double calcDDepth(Point2D.Float p, float zoom, ChartProperties cp, Chart.Mode mode) {
        if (this.nodeList.isEmpty()) {
            return 0.0;
        }
        float vs = this.getVSfromPoint(p.x);
        OffsetNode n1 = null;
        OffsetNode n2 = null;
        OffsetNode lastNode = null;
        for (OffsetNode node : this.nodeList) {
            if (lastNode != null && (double)vs >= lastNode.vs && (double)vs < node.vs) {
                n1 = lastNode;
                n2 = node;
                break;
            }
            lastNode = node;
        }
        double ddepth = 0.0;
        double bracket = 1.0f / zoom;
        if (n1 != null && n2 != null) {
            Point2D.Float n1p = new Point2D.Float(this.getVSPoint(n1.ddepth, false), this.getTVDPoint(n1.ddepth, false, cp, mode));
            Point2D.Float n2p = new Point2D.Float(this.getVSPoint(n2.ddepth, false), this.getTVDPoint(n2.ddepth, false, cp, mode));
            Line2D.Float line = new Line2D.Float(n1p.x, n1p.y, n2p.x, n2p.y);
            if (line.ptLineDist(p) < bracket) {
                ddepth = (double)this.getDDepthfromPoints(n1p, p) + n1.ddepth;
            }
        }
        return ddepth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "PanelWellVS";
    }

    @Override
    float draw(SBGraphics g, float xorigin, float yorigin, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.block.prop.scaleType != BlockProperties.ScaleType.TVD) {
            return xorigin;
        }
        this.xorigin = xorigin;
        this.yorigin = yorigin;
        this.cp = cp;
        float xpos = xorigin + this.getWidth(bp);
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        try {
            g.setClip(xorigin, yorigin + PanelWellVS.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.prop), this.block.getHeight());
            this.drawHorzScale(g, cp, xorigin, yorigin + PanelWellVS.getPanelHeaderHeight(cp, mode), this.block.getHeight());
            if (this.p.drawPlan) {
                this.drawCurve(g, xorigin, yorigin, true, cp, mode);
            }
            if (this.p.drawUnitNames) {
                this.drawUnitNames(g, cp, mode);
            }
            this.drawCurve(g, xorigin, yorigin, false, cp, mode);
            if (this.p.drawSamples) {
                this.drawSamples(g, xorigin, yorigin, cp, mode);
            }
            if (this.p.drawFaults) {
                this.drawFaults(g, xorigin, yorigin, cp, mode);
            }
            this.drawBaseSample(g, xorigin, yorigin, cp, mode);
            if (this.predictPoint != null) {
                this.drawPredictPoint(g, yorigin, cp, mode);
            }
            if (this.p.logInfo1.logDef != null) {
                this.drawLog(g, this.p.logInfo1, cp, mode);
            }
            if (this.p.logInfo2.logDef != null) {
                this.drawLog(g, this.p.logInfo2, cp, mode);
            }
            g.setColor(Color.LIGHT_GRAY);
            g.setDashStroke(0.4f);
            if (this.tvdList.getSize() != 0 && this.tvdList.getMaxVS() < (double)this.p.maxVS) {
                float lastx = this.getVSPoint(this.tvdList.get(this.tvdList.getSize() - 1).getDDepth(), false);
                g.drawLine(lastx, yorigin + PanelWellVS.getPanelHeaderHeight(cp, mode), lastx, this.block.getHeight() + PanelWellVS.getPanelHeaderHeight(cp, mode) + cp.margin);
                g.setFont(cp.font, 1, cp.fontSmall);
                g.drawStringVertical("** Deviation survey ends here **", lastx - 1.5f, this.block.getHeight() + PanelWellVS.getPanelHeaderHeight(cp, mode) + cp.margin - 2.5f);
            }
            if (this.p.drawEvents) {
                this.drawEvents(g, xorigin, yorigin, cp, mode);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in WellVS panel drawing: " + ex.getMessage());
            ex.printStackTrace();
        }
        g.setClip(null);
        return xpos;
    }

    @Override
    String getCaption() {
        return "Horizontal Length";
    }

    @Override
    String getSubCaption() {
        String subCaption = null;
        if (this.p.igdType >= 0 && this.wellInterp != null && this.p.drawIGD) {
            try {
                IGDColMap colmap = this.block.well.getInterp(this.wellInterp.getHeader().getInterpID()).getColMap(this.block.well.getWellID(), this.p.igdType);
                int column = this.p.col > 0 ? this.p.col : colmap.getSize();
                subCaption = "showing " + IGDInterval.getIGDName((int)this.p.igdType) + " (" + colmap.getColTitle(column) + ") ";
            }
            catch (Exception e) {
                System.out.println("Error getting column title for panelWellVS header");
            }
        }
        if (this.wellInterp != null && this.p.drawEvents && !this.wellInterp.getEvents().isEmpty()) {
            subCaption = subCaption == null ? "showing " : subCaption + "and ";
            subCaption = subCaption + "events ";
        }
        if (this.p.logInfo1.logDef != null || this.p.logInfo2.logDef != null) {
            if (subCaption == null) {
                subCaption = "";
            }
            subCaption = subCaption + "with ";
            if (this.p.logInfo1.logDef != null) {
                subCaption = subCaption + this.p.logInfo1.logDef.getTitle() + " " + this.p.logInfo1.logDef.getUnits();
                if (this.p.logInfo2.logDef != null) {
                    subCaption = subCaption + " and ";
                }
            }
            if (this.p.logInfo2.logDef != null) {
                subCaption = subCaption + this.p.logInfo2.logDef.getTitle() + " " + this.p.logInfo2.logDef.getUnits();
            }
        }
        return subCaption;
    }

    private void createNodeList(int igdType, int interpID, int schID, boolean plan, ChartProperties cp) throws SBException, SQLException {
        String name;
        if (plan) {
            this.nodeListPlan.clear();
        } else {
            this.nodeList.clear();
        }
        if (igdType >= 0 && interpID >= 0 && this.p.drawIGD && !plan) {
            IGDColMap colmap = this.block.well.getInterp(interpID).getColMap(this.block.well.getWellID(), igdType);
            int column = this.p.col > 0 ? this.p.col : colmap.getSize();
            for (IGDIntervalZone zone : this.block.well.getInterp(interpID).getIGDList(igdType, schID, colmap.getMinhier(column), colmap.getMaxhier(column))) {
                if (zone.getTopID() == zone.getBaseID()) continue;
                double topddepth = this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseddepth = this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (baseddepth <= this.tvdList.getTopDD()) continue;
                if (topddepth >= this.tvdList.getBaseDD()) break;
                if (baseddepth > this.tvdList.getBaseDD()) {
                    baseddepth = this.tvdList.getBaseDD();
                }
                if (topddepth < this.tvdList.getTopDD()) {
                    topddepth = this.tvdList.getTopDD();
                }
                String name2 = zone.toString(this.p.useAbrs);
                if (this.nodeList.isEmpty() || Math.abs(this.nodeList.getLast().ddepth - topddepth) > 0.001) {
                    this.nodeList.add(new OffsetNode(this.p.plainColor, name2, topddepth, this.tvdList.getTVD(topddepth).getTVDepth() != null ? this.tvdList.getTVD(topddepth).getTVDepth() : 0.0, this.tvdList.getTVD(topddepth).getVS() != null ? this.tvdList.getTVD(topddepth).getVS() : 0.0, null));
                } else {
                    this.nodeList.getLast().appendName(name2);
                }
                TVDepth tvD = this.tvdList.getTVD(baseddepth);
                this.nodeList.add(new OffsetNode(zone.getUnitColour(true) != null ? zone.getUnitColour(true) : this.p.plainColor, name2, baseddepth, tvD.getTVDepth() != null ? tvD.getTVDepth() : 0.0, tvD.getVS() != null ? tvD.getVS() : 0.0, zone.getUnitColour(false)));
            }
            int nextIndex = 0;
            ListIterator it2 = this.tvdList.getListIterator();
            while (it2.hasNext()) {
                OffsetNode newNode;
                TVDepth tvdnode = (TVDepth)it2.next();
                double ddepth = tvdnode.getDDepth();
                if (nextIndex <= this.nodeList.size() - 1) {
                    if (ddepth > this.nodeList.get((int)nextIndex).ddepth) {
                        ++nextIndex;
                        it2.previous();
                        continue;
                    }
                    if (Math.abs(this.nodeList.get((int)nextIndex).ddepth - ddepth) < 0.001) {
                        ++nextIndex;
                        continue;
                    }
                    newNode = new OffsetNode(this.nodeList.get((int)nextIndex).colour, "", ddepth, tvdnode.getTVDepth() != null ? tvdnode.getTVDepth() : 0.0, tvdnode.getVS() != null ? tvdnode.getVS() : 0.0, this.nodeList.get((int)nextIndex).colour2);
                    this.nodeList.add(nextIndex, newNode);
                    ++nextIndex;
                    continue;
                }
                if (tvdnode.getTVDepth() != null && tvdnode.getVS() != null) {
                    newNode = new OffsetNode(this.p.plainColor, "", ddepth, tvdnode.getTVDepth(), tvdnode.getVS(), null);
                    this.nodeList.add(newNode);
                }
                ++nextIndex;
            }
        } else {
            this.createSimpleNodeList(plan);
        }
        if (!plan && this.tvdList.getSize() != 0 && !this.nodeList.isEmpty()) {
            this.lastNodeDepth = this.nodeList.getLast().ddepth;
        }
        Iterator it = plan ? this.nodeListPlan.iterator() : this.nodeList.iterator();
        OffsetNode removedBefore = null;
        OffsetNode removedAfter = null;
        while (it.hasNext()) {
            OffsetNode checkNode = (OffsetNode)it.next();
            if (checkNode.vs < (double)this.p.minVS) {
                it.remove();
                removedBefore = checkNode;
                continue;
            }
            if (checkNode.vs > (double)this.p.maxVS) {
                it.remove();
                removedAfter = checkNode;
                continue;
            }
            if (!(checkNode.tvd < (double)this.block.prop.min) && !(checkNode.tvd > (double)this.block.prop.max)) continue;
            it.remove();
        }
        if (removedBefore != null) {
            TVDepth newDepth = this.tvdList.getTVDepth(this.p.minVS > 0.0f ? (double)this.p.minVS : 0.0);
            name = "";
            if (!this.nodeList.get((int)0).colour.equals(this.p.plainColor)) {
                for (int i = 0; name.isEmpty() && i < this.nodeList.size(); ++i) {
                    name = this.nodeList.get(i).getSubName(true);
                }
            }
            OffsetNode node = new OffsetNode(this.nodeList.get((int)0).colour, name, newDepth.getDDepth(), newDepth.getTVDepth(), newDepth.getVS(), removedBefore.colour2);
            this.nodeList.add(0, node);
        }
        if (removedAfter != null) {
            TVDepth newDepth = this.tvdList.getTVDepth((double)this.p.maxVS);
            name = "";
            if (!this.nodeList.getLast().colour.equals(this.p.plainColor)) {
                for (int i = this.nodeList.size() - 1; name.isEmpty() && i > -1; --i) {
                    name = this.nodeList.get(i).getSubName(false);
                }
            }
            OffsetNode node = new OffsetNode(removedAfter.colour, name, newDepth.getDDepth(), newDepth.getTVDepth(), newDepth.getVS(), removedAfter.colour2);
            this.nodeList.add(node);
        }
    }

    private void createSimpleNodeList(boolean plan) {
        TVDList tvds = plan ? this.tvdListPlan : this.tvdList;
        LinkedList<OffsetNode> nodes = plan ? this.nodeListPlan : this.nodeList;
        Iterator it = tvds.getIterator();
        while (it.hasNext()) {
            TVDepth tvd = (TVDepth)it.next();
            if (tvd.getVS() == null) continue;
            OffsetNode newNode = new OffsetNode(this.p.plainColor, "", tvd.getDDepth(), tvd.getTVDepth(), tvd.getVS(), null);
            nodes.add(newNode);
        }
    }

    private void drawCurve(SBGraphics g, float x, float y, boolean plan, ChartProperties cp, Chart.Mode mode) {
        ListIterator it;
        ListIterator listIterator = it = plan ? this.nodeListPlan.listIterator() : this.nodeList.listIterator();
        if (!it.hasNext()) {
            return;
        }
        float lastX = -1.0f;
        float lastY = -1.0f;
        GeneralPath gp = null;
        GeneralPath gp2 = null;
        Color lastColour = null;
        Color lastColour2 = null;
        do {
            OffsetNode node = (OffsetNode)it.next();
            y = this.getTVDPoint(node.tvd, cp, mode);
            x = this.getVSPoint(node.vs);
            if (gp != null) {
                if (node.getDrawingColour() != lastColour || !it.hasNext()) {
                    if (plan) {
                        g.setColor(this.p.plainColorPlan);
                        g.setStroke(this.p.curveWeightPlan);
                    } else {
                        g.setColor(lastColour);
                        g.setStroke(lastColour.equals(this.p.plainColor) ? this.p.curveWeight / 2.0f : this.p.curveWeight);
                    }
                    if (!it.hasNext()) {
                        SBGraphics.appendLine(gp, x, y);
                    }
                    g.drawShape(gp);
                    gp = SBGraphics.createGeneralPath(lastX, lastY);
                    if (gp2 != null) {
                        g.setStroke(this.p.curveWeight / 2.0f);
                        g.setColor(lastColour2);
                        g.drawShape(gp2);
                        gp2 = null;
                    }
                }
                SBGraphics.appendLine(gp, x, y);
                if (node.colour2 != null) {
                    Point2D.Float a = new Point2D.Float(x, y);
                    Point2D.Float b = new Point2D.Float(lastX, lastY);
                    Point2D.Float ap = PanelWellVS.getPerpendicularPoint(a, b, this.p.curveWeight / 4.0f, true, true);
                    if (gp2 == null) {
                        Point2D.Float bp = PanelWellVS.getPerpendicularPoint(a, b, this.p.curveWeight / 4.0f, false, true);
                        gp2 = SBGraphics.createGeneralPath(bp.x, bp.y);
                    }
                    SBGraphics.appendLine(gp2, ap.x, ap.y);
                }
            } else {
                gp = SBGraphics.createGeneralPath(x, y);
            }
            lastY = y;
            lastX = x;
            lastColour = node.getDrawingColour();
            lastColour2 = node.colour2;
        } while (it.hasNext());
    }

    void drawPredictPoint(SBGraphics g, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.lastNodeDepth == null) {
            return;
        }
        float nodediam = 1.5f;
        g.setColor(Color.BLACK);
        g.setStroke(3.0f);
        g.setColor(this.p.plainColor);
        g.setStroke(this.p.curveWeight / 1.5f);
        this.lastNodePoint = new Point2D.Float(this.getVSPoint(this.lastNodeDepth, false), this.getTVDPoint(this.lastNodeDepth, false, cp, mode));
        float predictY = this.predictPoint.y + y + PanelWellVS.getPanelHeaderHeight(cp, mode);
        g.drawLine(this.lastNodePoint.x, this.lastNodePoint.y, (float)this.predictPoint.getX(), predictY);
        g.fillEllipse((float)this.predictPoint.getX() - nodediam / 2.0f, predictY - nodediam / 2.0f, nodediam, nodediam, Color.BLACK);
        g.fillEllipse(this.lastNodePoint.x - nodediam / 2.0f, this.lastNodePoint.y - nodediam / 2.0f, nodediam, nodediam, Color.BLACK);
        g.setColor(Color.BLACK);
        g.setFont(cp.font, 0, cp.fontSmall);
        Point2D.Float equiv = new Point2D.Float(this.predictPoint.x, predictY);
        g.drawString("VS: " + this.getVSfromPoint(this.predictPoint.x), (float)this.predictPoint.getX() + 4.0f, predictY - 8.0f);
        g.drawString("Incl: " + this.getInclfromPoints(this.lastNodePoint, equiv, true), (float)this.predictPoint.getX() + 4.0f, predictY - 4.0f);
        g.drawString("DD: " + (this.getDDepthfromPoints(this.lastNodePoint, equiv) + (float)this.nodeList.getLast().ddepth), (float)this.predictPoint.getX() + 4.0f, predictY);
        g.drawString("TVD: " + this.getTVDfromPoint(this.predictPoint.y), (float)this.predictPoint.getX() + 4.0f, predictY + 4.0f);
    }

    public boolean setPredictPoint(Point2D.Float mmPoint) {
        if (mmPoint == null) {
            this.predictPoint = null;
            return true;
        }
        if (mmPoint.getX() < (double)this.getVSPoint(this.tvdList.get(this.tvdList.getSize() - 1).getDDepth(), false)) {
            return false;
        }
        this.predictPoint = mmPoint;
        return true;
    }

    private void drawUnitNames(SBGraphics g, ChartProperties cp, Chart.Mode mode) {
        float strokeWidth = 0.4f;
        g.setColor(Color.DARK_GRAY);
        g.setStroke(0.4f, 2, 0);
        g.setFont(cp.font, 1, cp.fontPanel);
        GeneralPath gp = null;
        String currentUnitName = null;
        float length = 6.0f;
        Point2D.Float prevNodePoint = null;
        for (OffsetNode node : this.nodeList) {
            Point2D.Float nodePoint = new Point2D.Float(this.getVSPoint(node.ddepth, false), this.getTVDPoint(node.ddepth, false, cp, mode));
            if (prevNodePoint == null) {
                prevNodePoint = nodePoint;
                if (node.name.isEmpty()) continue;
                currentUnitName = node.name;
                continue;
            }
            Point2D.Float a = PanelWellVS.getPerpendicularPoint(prevNodePoint, nodePoint, 6.0f, false, true);
            if (gp == null) {
                Point2D.Float useThis;
                if (currentUnitName != null) {
                    a = PanelWellVS.getPerpendicularPoint(prevNodePoint, nodePoint, 6.0f, true, true);
                    useThis = prevNodePoint;
                } else {
                    currentUnitName = node.name.isEmpty() ? null : node.name;
                    useThis = nodePoint;
                }
                if (currentUnitName != null || !node.name.isEmpty()) {
                    gp = SBGraphics.createGeneralPath(a.x, a.y);
                    g.drawLine(useThis.x, useThis.y, a.x, a.y);
                }
            } else if (node.name.isEmpty()) {
                SBGraphics.appendLine(gp, a.x, a.y);
            } else if (node.name.startsWith(currentUnitName)) {
                SBGraphics.appendLine(gp, a.x, a.y);
                g.drawLine(nodePoint.x, nodePoint.y, a.x, a.y);
                TextStroke textStroke = new TextStroke(currentUnitName, g.getFont(), false, false, 40.0f);
                BasicStroke stroke = g.getStroke();
                g.setStroke((Stroke)textStroke);
                g.drawShape(gp);
                g.setStroke(stroke);
                gp = null;
                currentUnitName = null;
                if (node.name.contains("^")) {
                    gp = SBGraphics.createGeneralPath(a.x, a.y);
                    currentUnitName = node.name.substring(node.name.indexOf(94) + 1);
                }
            }
            prevNodePoint = nodePoint;
        }
    }

    private static Point2D.Float getPerpendicularPoint(Point2D.Float A, Point2D.Float B, float length, boolean fromA, boolean leftSide) {
        float dy2;
        float dx2;
        float dx = B.x - A.x;
        float dy = B.y - A.y;
        double scale = (double)length / Math.sqrt(dx * dx + dy * dy);
        if (leftSide) {
            dx2 = (float)((double)dy * scale);
            dy2 = (float)((double)(-dx) * scale);
        } else {
            dx2 = (float)((double)(-dy) * scale);
            dy2 = (float)((double)dx * scale);
        }
        return new Point2D.Float((fromA ? A.x : B.x) + dx2, (fromA ? A.y : B.y) + dy2);
    }

    private void setLogStroke(SBGraphics g, int penStyle, float weight) {
        switch (penStyle) {
            case 0: {
                g.setStroke(weight);
                break;
            }
            case 1: {
                g.setDotStroke(0.1f);
                break;
            }
            case 2: {
                g.setDashStroke(weight);
                break;
            }
        }
    }

    private void drawLog(SBGraphics g, PanelWellVSProperties.LogInfo logInfo, ChartProperties cp, Chart.Mode mode) throws SQLException {
        ListIterator itn = this.nodeList.listIterator();
        OffsetNode node1 = null;
        int size = 10000;
        float[] xPoints = new float[10000];
        float[] yPoints = new float[10000];
        this.setLogStroke(g, logInfo.logDef.getPenStyle(), logInfo.logDef.getPenWidth());
        g.setColor(logInfo.logDef.getLineColour());
        LinkedList<Curve> curves = new LinkedList<Curve>();
        for (Curve curve : this.block.well.getCurves().getCurves()) {
            if (!curve.getAbr().equals(logInfo.logDef.getAbr())) continue;
            curves.add(curve);
        }
        for (Curve trace : curves) {
            ListIterator itt = trace.getTrace().listIterator();
            Point2D.Float lastValp = null;
            while (itn.hasNext() && itt.hasNext()) {
                OffsetNode node2 = (OffsetNode)itn.next();
                if (node1 != null && node2 != null) {
                    float n1vs = this.getVSPoint(node1.ddepth, false);
                    float n1tvd = this.getTVDPoint(node1.ddepth, false, cp, mode);
                    float n2vs = this.getVSPoint(node2.ddepth, false);
                    float n2tvd = this.getTVDPoint(node2.ddepth, false, cp, mode);
                    double angle = this.getInclfromPoints(new Point2D.Float(n1vs, n1tvd), new Point2D.Float(n2vs, n2tvd), false);
                    if (logInfo.logScaleLine && (double)Math.abs(logInfo.logColWidth / 2.0f - logInfo.logTraceOffset) > 0.01) {
                        boolean left = logInfo.logTraceOffset < logInfo.logColWidth / 2.0f;
                        float length = left ? logInfo.logColWidth / 2.0f - logInfo.logTraceOffset : logInfo.logTraceOffset - logInfo.logColWidth / 2.0f;
                        g.setColor(Color.LIGHT_GRAY);
                        g.setStroke(0.1f);
                        Point2D.Float a = new Point2D.Float(n1vs, n1tvd);
                        Point2D.Float b = new Point2D.Float(n2vs, n2tvd);
                        Point2D.Float ap = PanelWellVS.getPerpendicularPoint(a, b, length, true, left);
                        Point2D.Float bp = PanelWellVS.getPerpendicularPoint(a, b, length, false, left);
                        g.drawLine(ap.x, ap.y, bp.x, bp.y);
                        g.setColor(logInfo.logDef.getLineColour());
                        this.setLogStroke(g, logInfo.logDef.getPenStyle(), logInfo.logDef.getPenWidth());
                    }
                    double scale = (double)this.getLineLength(new Line2D.Float(n1vs, n1tvd, n2vs, n2tvd)) / (node2.ddepth - node1.ddepth);
                    boolean finished = false;
                    int i = 0;
                    while (itt.hasNext()) {
                        if (finished) {
                            itt.previous();
                            break;
                        }
                        Curve.CurveValue val = (Curve.CurveValue)itt.next();
                        if (val.getDepth() + logInfo.logShift < node1.ddepth) continue;
                        float yPoint = (float)((val.getDepth() + logInfo.logShift - node1.ddepth) * scale) + n1tvd;
                        float offset = n1vs - logInfo.logTraceOffset + PanelWirelineLog.scaleValue(val.getValue(), logInfo.logDef.getMinval(), logInfo.logDef.getMaxval(), logInfo.logDef.isAsLog(), logInfo.logColWidth);
                        if (i == 0 && lastValp != null) {
                            yPoints[0] = n1tvd;
                            xPoints[0] = (offset - lastValp.x) / (yPoint - lastValp.y) * (n1tvd - lastValp.y) + lastValp.x;
                            ++i;
                        }
                        if (val.getDepth() + logInfo.logShift >= node2.ddepth) {
                            if (i != 0) {
                                float xval = xPoints[i - 1];
                                float newyPoint = (float)((node2.ddepth - node1.ddepth) * scale) + n1tvd;
                                offset = (offset - xval) / (yPoint - yPoints[i - 1]) * (newyPoint - yPoints[i - 1]) + xval;
                                yPoint = newyPoint;
                            }
                            if (i != 0) {
                                lastValp = new Point2D.Float(offset, yPoint);
                            }
                            finished = true;
                        }
                        xPoints[i] = offset;
                        yPoints[i] = yPoint;
                        if (++i <= 9999) continue;
                        System.out.println("Breaking out of log drawing loop");
                        break;
                    }
                    if (i > 0) {
                        g.rotate(-angle, n1vs, n1tvd);
                        g.drawPolyline(xPoints, yPoints, i, false);
                        g.rotate(angle, n1vs, n1tvd);
                    }
                }
                node1 = node2;
            }
        }
    }

    private float getLineLength(Line2D line) {
        double lengthd = Math.sqrt(Math.pow(Math.abs(line.getX1() - line.getX2()), 2.0) + Math.pow(Math.abs(line.getY1() - line.getY2()), 2.0));
        float length = (float)lengthd;
        return length;
    }

    private void drawSamples(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.sampleDepths == null) {
            return;
        }
        g.setStroke(0.4f);
        g.setColor(Color.BLACK);
        float f = 2.0f;
        for (SamplePoint sp : this.sampleDepths) {
            if (this.p.drawFaults && sp.getInstanceOf(Fault.class) != null) continue;
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + PanelWellVS.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos - 2.0f, ypos, xpos + 2.0f, ypos);
            g.drawLine(xpos, ypos - 2.0f, xpos, ypos + 2.0f);
        }
    }

    private void drawBaseSample(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        SamplePoint sp = this.sampleDepths.getLast();
        if (sp.getInstanceOf(Sample.class) != null) {
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + PanelWellVS.getPanelHeaderHeight(cp, mode);
            g.setStroke(0.3f);
            g.setColor(Color.BLACK);
            g.drawLine(xpos, ypos - 4.0f, xpos, ypos + 4.0f);
            g.setFont(cp.font, 0, cp.fontSmall);
            g.drawString("Base sample: " + sp.sample.toString(), xpos + 1.0f, ypos - 2.0f);
        }
    }

    private void drawFaults(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SBException, SQLException {
        if (this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        g.setStroke(0.5f, 1, 1);
        g.setColor(Color.BLACK);
        g.setFont(cp.font, 0, cp.fontSmall);
        for (SamplePoint sp : this.sampleDepths) {
            if (sp.getInstanceOf(Fault.class) == null) continue;
            Fault fault = (Fault)sp.getInstanceOf(Fault.class);
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + PanelWellVS.getPanelHeaderHeight(cp, mode);
            double faultThrow = fault.getThrow();
            g.drawLine(xpos + 1.0f, ypos - 4.0f, xpos + 1.0f, ypos + 4.0f);
            g.drawLine(xpos - 1.0f, ypos + 4.0f, xpos - 1.0f, ypos - 4.0f);
            if (faultThrow > 0.0) {
                g.drawLine(xpos + 1.0f, ypos + 4.0f, xpos + 3.0f, ypos + 2.0f);
                g.drawLine(xpos - 1.0f, ypos - 4.0f, xpos - 3.0f, ypos - 2.0f);
            } else {
                g.drawLine(xpos + 1.0f, ypos - 4.0f, xpos + 3.0f, ypos - 2.0f);
                g.drawLine(xpos - 1.0f, ypos + 4.0f, xpos - 3.0f, ypos + 2.0f);
            }
            g.drawStringBox("" + faultThrow, xpos - 4.0f, ypos - 11.0f, 8.0f, 8.0f, false);
        }
    }

    private void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SQLException {
        if (this.wellInterp == null || this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        g.setStroke(this.p.curveWeight / 3.3f);
        LinkedHashMap<String, Integer> evtKeys = new LinkedHashMap<String, Integer>();
        Integer keyIndex = 1;
        block4: for (SamplePoint sp : this.sampleDepths) {
            Object index;
            Color topEventColour;
            if (sp.getInstanceOf(WellEvent.class) == null) continue;
            WellEvent event = (WellEvent)sp.getInstanceOf(WellEvent.class);
            float xPos = x + sp.point.x;
            float yPos = y + sp.point.y + PanelWellVS.getPanelHeaderHeight(cp, mode);
            Color baseEventColour = event.getEvent().getTaxon() != null ? (topEventColour = this.sbdb.getCatColour(event.getEvent().getTaxon().getCatMnem(), Color.BLACK)) : (topEventColour = Color.BLACK);
            if (event.getCharType() == 'F') {
                g.setColor(topEventColour);
                g.drawLine(xPos, yPos - 3.2f, xPos, yPos + 3.2f);
                g.drawLine(xPos - 3.2f, yPos, xPos + 3.2f, yPos);
            } else if (event.getCharType() == 'L') {
                g.setColor(baseEventColour);
                g.drawEllipse(xPos - 1.6f, yPos - 1.6f, 3.2f, 3.2f);
            } else {
                g.setColor(topEventColour);
                g.drawLine(xPos - 3.2f, yPos - 3.2f, xPos + 3.2f, yPos + 3.2f);
                g.drawEllipse(xPos - 1.6f, yPos - 1.6f, 3.2f, 3.2f);
            }
            switch (this.p.eventLabelStyle) {
                default: {
                    continue block4;
                }
                case 0: {
                    g.setColor(Color.BLACK);
                    g.setFont(cp.font, 0, cp.fontTiny);
                    g.drawString(event.toString(false, true, true), xPos + 1.6f, yPos - 1.6f);
                    continue block4;
                }
                case 2: 
            }
            g.setFont(cp.font, 1, cp.fontTiny);
            if (evtKeys.containsKey(event.getEvent().getEvID() + "|" + event.getCharType())) {
                index = "" + ((HashMap)evtKeys).get(event.getEvent().getEvID() + "|" + event.getCharType());
                g.drawString((String)index, xPos + 1.6f, yPos - 1.6f);
                continue;
            }
            g.drawString(keyIndex + "", xPos + 1.6f, yPos - 1.6f);
            evtKeys.put(event.getEvent().getEvID() + "|" + event.getCharType(), keyIndex);
            index = keyIndex;
            Integer n = keyIndex = Integer.valueOf(keyIndex + 1);
        }
        if (!evtKeys.isEmpty()) {
            g.setFont(cp.font, 1, cp.fontSmall);
            LinkedHashMap<Integer, String> evtKeysIndex = new LinkedHashMap<Integer, String>();
            for (Map.Entry e : ((HashMap)evtKeys).entrySet()) {
                Integer index = (Integer)e.getValue();
                String key = (String)e.getKey();
                evtKeysIndex.put(index, WellEvent.getType((char)key.charAt(key.length() - 1)) + " " + this.sbdb.getSBEvent(Integer.parseInt(key.substring(0, key.indexOf("|")))).toString());
            }
            float width = 0.0f;
            for (int i = 1; i <= evtKeysIndex.size(); ++i) {
                float stringsize = g.stringWidth((String)((HashMap)evtKeysIndex).get(i));
                if (!(stringsize > width)) continue;
                width = stringsize;
            }
            float pad = cp.fontSmall * 2.25f;
            float height = (float)(evtKeysIndex.size() + 2) * pad;
            g.setColor(Color.BLACK);
            g.setStroke(0.2f);
            g.fillRect(x + this.getWidth(null) - (width += cp.fontSmall * 3.0f), y + PanelWellVS.getPanelHeaderHeight(cp, mode), width, height, Color.WHITE);
            g.setFont(cp.font, 1, cp.fontSmall * 1.2f);
            float yPos = y + PanelWellVS.getPanelHeaderHeight(cp, mode) + pad;
            String title = "Events Key";
            g.drawString(title, x + this.getWidth(null) - width / 2.0f - g.stringWidth(title) / 2.0f, yPos);
            yPos = (float)((double)yPos + (double)pad * 1.5);
            g.setFont(cp.font, 0, cp.fontSmall);
            for (int i = 1; i <= evtKeysIndex.size(); ++i) {
                g.drawString(i + "  " + (String)((HashMap)evtKeysIndex).get(i), x + this.getWidth(null) - width + pad / 2.0f, yPos);
                yPos += pad;
            }
        }
    }

    void drawHorzScale(SBGraphics g, ChartProperties cp, float x, float y, float height) {
        float y2;
        float y1;
        float xpos;
        float depth;
        g.setFont(cp.font, 0, cp.fontSmall);
        g.setColor(Color.BLACK);
        TickScheme tickScheme = new TickScheme();
        tickScheme.calcScaleLabels(this.p.minVS, this.p.scaleVS, this.block.prop.units);
        float left = x;
        g.setStroke(0.2f);
        for (depth = tickScheme.start; depth > this.p.minVS; depth -= tickScheme.tickInterval) {
            if (!(depth < this.p.maxVS)) continue;
            xpos = x + this.scaleVS(depth);
            y1 = y + height;
            y2 = y1 - 1.0f;
            g.drawLine(xpos, y1, xpos, y2);
        }
        depth = tickScheme.start;
        float yPreviousLabel = -9999999.0f;
        while (depth <= this.p.maxVS + 0.0029f) {
            String buffer = SB.floatString((double)SB.convFromM((double)depth, (char)this.block.prop.units), (int)tickScheme.precision).trim();
            xpos = x + this.scaleVS(depth);
            y1 = y + height;
            y2 = y1 - 2.0f;
            g.drawLine(xpos, y1, xpos, y2);
            float w = g.stringWidth(buffer);
            float h = g.stringHeight();
            float ypos = y2;
            y1 = y + height;
            if (this.p.drawGridLines) {
                g.setStroke(0.1f);
                g.setColor(Color.GRAY);
                g.drawLine(xpos, y1, xpos, y);
                g.setStroke(0.2f);
            }
            if (xpos > yPreviousLabel + h) {
                if ((xpos += 0.3f * h) - h < x) {
                    xpos = x + 0.6f * h;
                }
                g.setColor(Color.BLACK);
                g.drawStringVertical(buffer, xpos, ypos - 0.5f);
                yPreviousLabel = xpos;
            }
            g.setColor(Color.BLACK);
            float nextDepth = depth + tickScheme.labelInterval;
            depth += tickScheme.tickInterval;
            while (depth < nextDepth && depth <= this.p.maxVS) {
                xpos = x + this.scaleVS(depth);
                y1 = y + height;
                y2 = y1 - 1.0f;
                g.drawLine(xpos, y1, xpos, y2);
                depth += tickScheme.tickInterval;
            }
            depth = nextDepth;
        }
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = (this.p.maxVS - this.p.minVS) * 1000.0f / this.p.scaleVS;
        return width;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    private float scaleVS(float floatValue) {
        return (floatValue - this.p.minVS) * 1000.0f / this.p.scaleVS;
    }

    void setVS(float minVS, float maxVS, boolean extra) {
        this.p.minVS = minVS;
        this.p.maxVS = maxVS;
        if (extra && Math.abs((double)maxVS - this.tvdList.getMaxVS()) < 0.1) {
            this.p.maxVS += 200.0f;
        }
        System.out.println("In PanelWellVS minVS=" + minVS + " maxVS=" + maxVS);
    }

    float getVSPoint(double depth, boolean plan) {
        TVDList list = plan ? this.tvdListPlan : this.tvdList;
        Double vs = list.getTVD(depth).getVS();
        if (vs != null) {
            return this.getVSPoint(vs);
        }
        return 0.0f;
    }

    float getVSPoint(double vs) {
        return this.scaleVS((float)vs) + this.xorigin;
    }

    private float getTVDPoint(double depth, boolean plan, ChartProperties cp, Chart.Mode mode) {
        TVDList list = plan ? this.tvdListPlan : this.tvdList;
        float tvd = list.getTVD(depth).getTVDepth().floatValue();
        return this.getTVDPoint(tvd, cp, mode);
    }

    private float getTVDPoint(double tvd, ChartProperties cp, Chart.Mode mode) {
        float f = this.yorigin + this.block.scaleTVD(tvd);
        if (cp == null || mode == null) {
            return f;
        }
        return f + PanelWellVS.getPanelHeaderHeight(cp, mode);
    }

    float getTVDfromPoint(float y) {
        float tvd = this.block.getDepth(y);
        tvd = (float)Math.round(tvd * 100.0f) / 100.0f;
        return tvd;
    }

    float getVSfromPoint(float x) {
        x = (x - this.xorigin) * this.p.scaleVS / 1000.0f + this.p.minVS;
        x = (float)Math.round(x * 100.0f) / 100.0f;
        return x;
    }

    float getDDepthfromPoints(Point2D.Float p1, Point2D.Float p2) {
        float x = p2.x - p1.x;
        float y = p2.y - p1.y;
        x = x * this.p.scaleVS / 1000.0f;
        y = y * this.block.getScale() / 1000.0f;
        float z = (float)Math.sqrt(x * x + y * y);
        z = (float)Math.round(z * 100.0f) / 100.0f;
        return z;
    }

    float getInclfromPoints(Point2D.Float p1, Point2D.Float p2, boolean degrees) {
        float i;
        float x = p2.x - p1.x;
        float y = p2.y - p1.y;
        x = x * this.p.scaleVS / 1000.0f;
        x = Math.abs(x);
        y = y * this.block.getScale() / 1000.0f;
        y = Math.abs(y);
        if (p1.y >= p2.y) {
            i = (float)Math.atan(y / x);
            i = (float)((double)i + 1.5707963267948966);
        } else {
            i = (float)Math.atan(x / y);
        }
        if (degrees) {
            i = (float)Math.toDegrees(i);
            i = (float)Math.round(i * 100.0f) / 100.0f;
        }
        return i;
    }

    void addPredictNode(Point2D.Float point, ChartProperties cp, Chart.Mode mode) {
        try {
            this.lastNodePoint = new Point2D.Float(this.getVSPoint(this.lastNodeDepth, false), this.getTVDPoint(this.lastNodeDepth, false, cp, mode));
            double ddepth = (double)this.getDDepthfromPoints(this.lastNodePoint, this.predictPoint) + this.nodeList.getLast().ddepth;
            double tvd = this.getTVDfromPoint(this.predictPoint.y);
            double vs = this.getVSfromPoint(this.predictPoint.x);
            float incl = this.getInclfromPoints(this.lastNodePoint, this.predictPoint, true);
            TVDepth tvdepth = new TVDepth(ddepth, Double.valueOf(tvd), Float.valueOf(incl), null, Double.valueOf(vs), null, null);
            this.tvdList.add(tvdepth, this.block.well.getWellID());
            this.sbdb.commit();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        this.setPredictPoint(null);
    }

    @Override
    boolean pipe() {
        return false;
    }

    public String toString() {
        return "Horizontal Length";
    }

    public static Point2D.Float calcDefaultVSRange(WellBlock block) throws SQLException {
        Double minVSd = block.well.getTVDlist(false).getMinVS();
        float minVS = minVSd.floatValue();
        Double maxVSd = block.well.getTVDlist(false).getMaxVS();
        float maxVS = maxVSd.floatValue();
        if (block.well.getTVDlist(true) != null) {
            Double planmin = block.well.getTVDlist(true).getMinVS();
            float planminf = planmin.floatValue();
            Double planmax = block.well.getTVDlist(true).getMaxVS();
            float planmaxf = planmax.floatValue();
            if (planmaxf > maxVS) {
                maxVS = planmaxf;
            }
            if (planminf < minVS) {
                minVS = planminf;
            }
        }
        return new Point2D.Float(minVS, maxVS);
    }

    private static class SamplePoint
    implements Comparable<SamplePoint> {
        final Point2D.Float point;
        final Sample sample;
        final HashSet<Object> objects = new HashSet();
        final double ddepth;

        SamplePoint(Point2D.Float point, Sample sample, double ddepth, Object ... obj) {
            if (sample == null) {
                throw new IllegalArgumentException("Creating sample point with null sample in TVD Offset Panel");
            }
            this.point = point;
            this.sample = sample;
            this.ddepth = ddepth;
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] == null) continue;
                this.objects.add(obj[i]);
            }
        }

        void addObject(Object object) {
            this.objects.add(object);
        }

        @Override
        public int compareTo(SamplePoint o) {
            if (this.point.x == o.point.x) {
                return 0;
            }
            if (this.point.x < o.point.x) {
                return -1;
            }
            return 1;
        }

        Object getInstanceOf(Class c) {
            for (Object o : this.objects) {
                if (o.getClass() != c) continue;
                return o;
            }
            return null;
        }
    }

    private static class OffsetNode {
        final double tvd;
        final double vs;
        final double ddepth;
        final Color colour;
        final Color colour2;
        String name;

        OffsetNode(Color colour, String name, double ddepth, double tvd, double vs, Color colour2) {
            this.colour = colour;
            this.colour2 = colour2;
            this.ddepth = ddepth;
            this.tvd = tvd;
            this.vs = vs;
            if (name == null) {
                name = "";
            }
            this.name = name.trim();
        }

        void appendName(String toAppend) {
            if (this.name == null) {
                this.name = "";
            } else if (!this.name.isEmpty()) {
                this.name = this.name + "^";
            }
            this.name = this.name + toAppend;
        }

        Color getDrawingColour() {
            if (this.colour.equals(Color.WHITE)) {
                return Color.LIGHT_GRAY;
            }
            return this.colour;
        }

        String getSubName(boolean first) {
            if (!this.name.isEmpty()) {
                if (this.name.contains("^")) {
                    if (first) {
                        return this.name.substring(0, this.name.indexOf("^"));
                    }
                    return this.name.substring(this.name.indexOf("^") + 1);
                }
                return this.name;
            }
            return "";
        }

        public String toString() {
            return "DD: " + this.ddepth + " TVD: " + this.tvd + " VS: " + this.vs + " NAME: " + this.name;
        }
    }
}

