/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.StringTokenizer;
import jsbugs.PanelProperties;
import model2.IGDScheme;
import model2.Lastval;
import model2.LogDef;
import model2.SBdb;
import util.SBException;

public class PanelWellVSProperties
implements PanelProperties {
    private static String KEY = "PANWELLVSP";
    private int motherID = 0;
    float curveWeight = 3.0f;
    float curveWeightPlan = 1.5f;
    Color plainColor = Color.DARK_GRAY;
    Color plainColorPlan = Color.LIGHT_GRAY;
    float minVS = 0.0f;
    float maxVS = 0.0f;
    float scaleVS = 2000.0f;
    boolean drawSamples = false;
    boolean drawFaults = false;
    boolean drawPlan = false;
    boolean drawGridLines = true;
    boolean drawIGD = false;
    int igdType = -1;
    int schID = -1;
    int col = -1;
    boolean drawUnitNames = false;
    boolean useAbrs = false;
    boolean drawEvents = false;
    static final int EVTLBL_HORZ = 0;
    static final int EVTLBL_NONE = 1;
    static final int EVTLBL_KEY = 2;
    int eventLabelStyle = 2;
    LogInfo logInfo1 = new LogInfo();
    LogInfo logInfo2 = new LogInfo();

    PanelWellVSProperties(SBdb sbdb) {
        this.decode(sbdb);
    }

    PanelWellVSProperties(PanelWellVSProperties rhs) {
        this.curveWeight = rhs.curveWeight;
        this.curveWeightPlan = rhs.curveWeightPlan;
        this.plainColor = rhs.plainColor;
        this.plainColorPlan = rhs.plainColorPlan;
        this.minVS = rhs.minVS;
        this.maxVS = rhs.maxVS;
        this.scaleVS = rhs.scaleVS;
        this.drawSamples = rhs.drawSamples;
        this.drawFaults = rhs.drawFaults;
        this.drawPlan = rhs.drawPlan;
        this.drawGridLines = rhs.drawGridLines;
        this.drawIGD = rhs.drawIGD;
        this.igdType = rhs.igdType;
        this.schID = rhs.schID;
        this.col = rhs.col;
        this.drawUnitNames = rhs.drawUnitNames;
        this.useAbrs = rhs.useAbrs;
        this.logInfo1 = new LogInfo(rhs.logInfo1);
        this.logInfo2 = new LogInfo(rhs.logInfo2);
        this.drawEvents = rhs.drawEvents;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        String prefs = this.getPrefs();
        String[] props = new String[]{"" + this.minVS, "" + this.maxVS, "" + this.scaleVS, "" + this.motherID};
        for (String prop : props) {
            prefs = prefs + prop + "|";
        }
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + prefs));
    }

    @Override
    public String getPrefs() {
        String string = "";
        String[] props = new String[]{"" + this.igdType, "" + this.schID, "" + (this.drawSamples ? 1 : 0), "" + (this.drawFaults ? 1 : 0), "" + (this.drawIGD ? 1 : 0), "" + (this.drawPlan ? 1 : 0), "" + (this.drawUnitNames ? 1 : 0), "" + (this.useAbrs ? 1 : 0), "" + this.col, "" + this.logInfo1.logColWidth, "" + this.logInfo1.logTraceOffset, "" + (this.logInfo1.logScaleLine ? 1 : 0), this.logInfo1.logDef != null ? this.logInfo1.logDef.getAbr() : "0", "" + this.logInfo2.logColWidth, "" + this.logInfo2.logTraceOffset, "" + (this.logInfo2.logScaleLine ? 1 : 0), this.logInfo2.logDef != null ? this.logInfo2.logDef.getAbr() : "0", "" + (this.drawEvents ? 1 : 0), "" + this.eventLabelStyle, "" + (this.drawGridLines ? 1 : 0), "" + this.curveWeight};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    void encode(SBdb sbdb) {
        String string = this.getPrefs();
        try {
            Lastval.putString((SBdb)sbdb, (String)KEY, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final void decode(SBdb sbdb) {
        try {
            String abr;
            String params = Lastval.getString((SBdb)sbdb, (String)KEY);
            if (params.isEmpty()) {
                System.out.println("params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                this.igdType = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.schID = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawSamples = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawFaults = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawIGD = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawPlan = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawUnitNames = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.useAbrs = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.col = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.logInfo1 = new LogInfo();
                this.logInfo1.logColWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.logInfo1.logTraceOffset = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.logInfo1.logScaleLine = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens() && !(abr = tok.nextToken()).equals("0")) {
                try {
                    this.logInfo1.logDef = new LogDef((LogDef)sbdb.getLogDef().get(abr));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (tok.hasMoreTokens()) {
                this.logInfo2 = new LogInfo();
                this.logInfo2.logColWidth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.logInfo2.logTraceOffset = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.logInfo2.logScaleLine = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens() && !(abr = tok.nextToken()).equals("0")) {
                try {
                    this.logInfo2.logDef = new LogDef((LogDef)sbdb.getLogDef().get(abr));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawEvents = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.eventLabelStyle = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.drawGridLines = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.curveWeight = Float.parseFloat(tok.nextToken());
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    PanelWellVSProperties(SBdb sbdb, String prop) throws SQLException, SBException {
        String[] splits = prop.split("\\|");
        IGDScheme scheme = null;
        block27: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    this.igdType = Integer.parseInt(splits[i]);
                    continue block27;
                }
                case 1: {
                    int schemeID = Integer.parseInt(splits[i]);
                    scheme = sbdb.getIGDScheme(schemeID);
                    continue block27;
                }
                case 2: {
                    this.drawSamples = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 3: {
                    this.drawFaults = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 4: {
                    this.drawIGD = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 5: {
                    this.drawPlan = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 6: {
                    this.drawUnitNames = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 7: {
                    this.useAbrs = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 8: {
                    this.col = Integer.parseInt(splits[i]);
                    continue block27;
                }
                case 9: {
                    this.logInfo1 = new LogInfo();
                    this.logInfo1.logColWidth = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 10: {
                    this.logInfo1.logTraceOffset = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 11: {
                    this.logInfo1.logScaleLine = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 12: {
                    LogDef orig;
                    if (splits[i].equals("0") || (orig = (LogDef)sbdb.getLogDef().get(splits[i])) == null) continue block27;
                    this.logInfo1.logDef = new LogDef(orig);
                    continue block27;
                }
                case 13: {
                    this.logInfo2 = new LogInfo();
                    this.logInfo2.logColWidth = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 14: {
                    this.logInfo2.logTraceOffset = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 15: {
                    this.logInfo2.logScaleLine = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 16: {
                    LogDef orig;
                    if (splits[i].equals("0") || (orig = (LogDef)sbdb.getLogDef().get(splits[i])) == null) continue block27;
                    this.logInfo2.logDef = new LogDef(orig);
                    continue block27;
                }
                case 17: {
                    this.drawEvents = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 18: {
                    this.eventLabelStyle = Integer.parseInt(splits[i]);
                    continue block27;
                }
                case 19: {
                    this.drawGridLines = Integer.parseInt(splits[i]) == 1;
                    continue block27;
                }
                case 20: {
                    this.curveWeight = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 21: {
                    this.minVS = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 22: {
                    this.maxVS = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 23: {
                    this.scaleVS = Float.parseFloat(splits[i]);
                    continue block27;
                }
                case 24: {
                    this.motherID = Integer.parseInt(splits[i]);
                }
            }
        }
        if (this.igdType < 1 || this.igdType == 4 && scheme == null) {
            this.drawUnitNames = false;
            this.drawIGD = false;
        } else if (scheme != null) {
            this.schID = scheme.getID();
        }
    }

    int getMotherID() {
        return this.motherID;
    }

    void setMotherID(int motherID) {
        this.motherID = motherID;
    }

    class LogInfo {
        LogDef logDef;
        double logShift = 0.0;
        float logColWidth = 40.0f;
        float logTraceOffset = 40.0f;
        boolean logScaleLine = true;

        LogInfo() {
        }

        LogInfo(LogInfo rhs) {
            this.logShift = rhs.logShift;
            this.logColWidth = rhs.logColWidth;
            this.logTraceOffset = rhs.logTraceOffset;
            this.logScaleLine = rhs.logScaleLine;
            if (rhs.logDef != null) {
                this.logDef = new LogDef(rhs.logDef);
            }
        }
    }
}

