/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelIntLith;
import jsbugs.PanelWirelineLogProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Curve;
import model2.LithBase;
import model2.LithInterval;
import model2.LogDef;
import model2.SBdb;
import util.SB;
import util.SBException;

public class PanelWirelineLog
extends SBPanel {
    WellBlock block;
    private SBdb db;
    private PanelWirelineLogProperties p;
    private final float traceHdrHeight = 10.0f;
    private final float defaultWeight = 0.1f;
    private final float dotWeight = 0.1f;
    private List<LithBase> lithList = null;

    public PanelWirelineLog(WellBlock block, SBdb db) {
        this.block = block;
        this.db = db;
        this.p = new PanelWirelineLogProperties();
        this.initCurves();
    }

    PanelWirelineLog(WellBlock block, SBdb db, String props, LinkedList<Chart.ChartPref> traces) {
        this.block = block;
        this.db = db;
        this.p = new PanelWirelineLogProperties(props, traces);
    }

    public PanelWirelineLog(WellBlock block, SBdb db, String[] abrs) {
        this.block = block;
        this.db = db;
        this.p = new PanelWirelineLogProperties();
        this.initCurves(abrs);
    }

    private void initCurves() {
        try {
            List wellTraces = this.block.well.getCurves().getCurves();
            for (Curve wellTrace : wellTraces) {
                String abr = wellTrace.getAbr();
                LogDef orig = (LogDef)this.db.getLogDef().get(abr);
                LogDef newLogDef = new LogDef(orig);
                this.p.defs.put(abr, newLogDef);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    private void initCurves(String[] abrs) {
        try {
            for (int i = 0; i < abrs.length; ++i) {
                String abr = abrs[i];
                LogDef orig = (LogDef)this.db.getLogDef().get(abr);
                LogDef newLogDef = new LogDef(orig);
                this.p.defs.put(abr, newLogDef);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    private void initLithology() {
        try {
            this.lithList = new LinkedList<LithBase>();
            for (LithBase interval : this.block.well.getLithIntervals()) {
                if (!(interval instanceof LithInterval)) continue;
                this.lithList.add(interval);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    public List<Curve> getTraces() throws SQLException {
        LinkedList<Curve> traces = new LinkedList<Curve>();
        List wellTraces = this.block.well.getCurves().getCurves();
        for (Curve wellTrace : wellTraces) {
            if (!this.p.defs.containsKey(wellTrace.getAbr())) continue;
            traces.add(wellTrace);
        }
        return traces;
    }

    public void setColumnWidth(float width) {
        this.p.columnWidth = width > 10.0f ? width : 10.0f;
    }

    public float getColumnWidth() {
        return this.p.columnWidth;
    }

    public double getShift() {
        return this.p.logShift;
    }

    public void setShift(double shift) {
        this.p.logShift = shift;
    }

    public boolean getDrawDepthGuides() {
        return this.p.drawDepthGuides;
    }

    public void setDrawDepthGuides(boolean draw) {
        this.p.drawDepthGuides = draw;
    }

    public void setDepthGuideInterval(int interval) {
        this.p.depthGuideInterval = interval;
    }

    public int getDepthGuideInterval() {
        return this.p.depthGuideInterval;
    }

    @Override
    public PanelWirelineLogProperties getProperties() {
        return this.p;
    }

    void setProperties(PanelWirelineLogProperties p) {
        this.p = p;
    }

    @Override
    public int getType() {
        return 23;
    }

    void drawTraceLine(SBGraphics g, Curve curve, float x, float y, ChartProperties cp, Chart.Mode mode, LogDef def, WellBlock wellBlock, float topDepth, float baseDepth, double shift) throws SQLException {
        int size = curve.getTrace().size();
        float[] xPoints = new float[size + 1];
        float[] yPoints = new float[size + 1];
        boolean onRightWrap = false;
        boolean onLeftWrap = false;
        boolean wrap = def.getWrapTrace();
        boolean logScale = def.isAsLog();
        Iterator it = curve.getTrace().iterator();
        int penStyle = def.getPenStyle();
        float weight = def.getPenWidth();
        PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
        boolean finished = false;
        int i = 0;
        while (it.hasNext() && !finished) {
            Curve.CurveValue val = (Curve.CurveValue)it.next();
            if (val.getDepth() + shift < (double)topDepth) continue;
            float depth = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode) + wellBlock.scaleDepth((float)val.getDepth() + (float)shift);
            float value = x + PanelWirelineLog.scaleValue(val.getValue(), def.getMinval(), def.getMaxval(), logScale, this.p.columnWidth);
            if (val.getDepth() + shift > (double)baseDepth) {
                if (i != 0) {
                    float xval = xPoints[i - 1];
                    if (onLeftWrap) {
                        xval += this.p.columnWidth;
                    } else if (onRightWrap) {
                        xval -= this.p.columnWidth;
                    }
                    float blockDepth = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode) + wellBlock.scaleDepth(baseDepth);
                    value = (value - xval) / (depth - yPoints[i - 1]) * (blockDepth - yPoints[i - 1]) + xval;
                    depth = blockDepth;
                }
                finished = true;
            }
            if (value > x + this.p.columnWidth) {
                if (!onRightWrap) {
                    if (i != 0) {
                        if (onLeftWrap) {
                            xPoints[i] = x + this.p.columnWidth;
                            yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                            if (wrap) {
                                PanelWirelineLog.setStroke(g, penStyle, true, weight, 0.1f);
                                g.drawPolyline(xPoints, yPoints, i + 1, true);
                                PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
                            }
                            onLeftWrap = false;
                            Point2D.Float p1 = new Point2D.Float(x, yPoints[i]);
                            yPoints[i] = (depth - yPoints[i]) / (value - x) * (x + this.p.columnWidth - x) + yPoints[i];
                            Point2D.Float p2 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                            g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        } else {
                            xPoints[i] = x + this.p.columnWidth;
                            yPoints[i] = (depth - yPoints[i - 1]) / (value - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                            g.drawPolyline(xPoints, yPoints, i + 1, true);
                        }
                    }
                    onRightWrap = true;
                    xPoints[0] = x;
                    yPoints[0] = i == 0 ? depth : yPoints[i];
                    i = 1;
                }
                xPoints[i] = (value -= this.p.columnWidth) > x + this.p.columnWidth ? x + this.p.columnWidth : value;
                yPoints[i] = depth;
                ++i;
                continue;
            }
            if (value < x) {
                if (!onLeftWrap) {
                    if (i != 0) {
                        if (onRightWrap) {
                            xPoints[i] = x;
                            yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value + this.p.columnWidth) * (xPoints[i - 1] + this.p.columnWidth - (x + this.p.columnWidth)) + yPoints[i - 1];
                            if (wrap) {
                                PanelWirelineLog.setStroke(g, penStyle, true, weight, 0.1f);
                                g.drawPolyline(xPoints, yPoints, i + 1, true);
                                PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
                            }
                            onRightWrap = false;
                            Point2D.Float p1 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                            yPoints[i] = (depth - yPoints[i]) / (x + this.p.columnWidth - value) * (x + this.p.columnWidth - x) + yPoints[i];
                            Point2D.Float p2 = new Point2D.Float(x, yPoints[i]);
                            g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        } else {
                            xPoints[i] = x;
                            yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                            g.drawPolyline(xPoints, yPoints, i + 1, true);
                        }
                    }
                    onLeftWrap = true;
                    xPoints[0] = x + this.p.columnWidth;
                    yPoints[0] = i == 0 ? depth : yPoints[i];
                    i = 1;
                }
                xPoints[i] = (value += this.p.columnWidth) < x ? x : value;
                yPoints[i] = depth;
                ++i;
                continue;
            }
            if (onRightWrap) {
                onRightWrap = false;
                xPoints[i] = x;
                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] + this.p.columnWidth - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                if (wrap) {
                    PanelWirelineLog.setStroke(g, penStyle, true, weight, 0.1f);
                    g.drawPolyline(xPoints, yPoints, i + 1, true);
                    PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
                }
                xPoints[0] = x + this.p.columnWidth;
                yPoints[0] = yPoints[i];
                i = 1;
            }
            if (onLeftWrap) {
                onLeftWrap = false;
                xPoints[i] = x + this.p.columnWidth;
                yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                if (wrap) {
                    PanelWirelineLog.setStroke(g, penStyle, true, weight, 0.1f);
                    g.drawPolyline(xPoints, yPoints, i + 1, true);
                    PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
                }
                xPoints[0] = x;
                yPoints[0] = yPoints[i];
                i = 1;
            }
            xPoints[i] = value;
            if (!wrap) {
                if (xPoints[i] < x) {
                    xPoints[i] = x;
                } else if (xPoints[i] > x + this.p.columnWidth) {
                    xPoints[i] = x + this.p.columnWidth;
                }
            }
            yPoints[i] = depth;
            ++i;
        }
        if (onLeftWrap || onRightWrap) {
            PanelWirelineLog.setStroke(g, penStyle, true, weight, 0.1f);
        } else {
            PanelWirelineLog.setStroke(g, penStyle, false, weight, 0.1f);
        }
        if (wrap || !onLeftWrap && !onRightWrap) {
            g.drawPolyline(xPoints, yPoints, i, true);
        }
    }

    private void drawTraceFilled(SBGraphics g, Chart.Mode mode, Curve curve, float x, float y, float minval, float maxval, boolean logScale, ChartProperties cp, boolean fillLeft, Color fillColour, boolean wrap, float topDepth, float baseDepth) throws SQLException {
        int size = curve.getTrace().size() + 10;
        boolean onLeftWrap = false;
        boolean onRightWrap = false;
        boolean finished = false;
        g.setColor(fillColour);
        float[] xPoints = new float[size];
        float[] yPoints = new float[size];
        ListIterator it = curve.getTrace().listIterator();
        int i = 0;
        boolean first = true;
        while (it.hasNext() && !finished) {
            Curve.CurveValue val = (Curve.CurveValue)it.next();
            if (val.getDepth() + this.p.logShift < (double)topDepth) continue;
            float depth = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)val.getDepth() + (float)this.p.logShift);
            float value = x + PanelWirelineLog.scaleValue(val.getValue(), minval, maxval, logScale, this.p.columnWidth);
            if (val.getDepth() + this.p.logShift > (double)baseDepth) {
                if (i != 0) {
                    float xval = xPoints[i - 1];
                    if (onLeftWrap) {
                        xval += this.p.columnWidth;
                    } else if (onRightWrap) {
                        xval -= this.p.columnWidth;
                    }
                    float blockDepth = cp.margin + PanelWirelineLog.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(baseDepth);
                    value = (value - xval) / (depth - yPoints[i - 1]) * (blockDepth - yPoints[i - 1]) + xval;
                    depth = blockDepth;
                }
                finished = true;
            }
            if (first) {
                yPoints[0] = depth;
                if (value > x && value < x + this.p.columnWidth || value < x) {
                    xPoints[0] = x;
                } else if (value > x + this.p.columnWidth) {
                    xPoints[0] = x + this.p.columnWidth;
                }
                ++i;
                first = false;
            }
            if (wrap) {
                float[] triY;
                float[] triX;
                if (value > x + this.p.columnWidth) {
                    if (!onRightWrap) {
                        if (i != 0) {
                            if (onLeftWrap) {
                                xPoints[i] = x + this.p.columnWidth;
                                yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                                if (fillLeft) {
                                    g.fillPolygon(xPoints, yPoints, i + 1);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                                }
                                onLeftWrap = false;
                                Point2D.Float p1 = new Point2D.Float(x, yPoints[i]);
                                yPoints[i] = (depth - yPoints[i]) / (value - x) * (x + this.p.columnWidth - x) + yPoints[i];
                                Point2D.Float p2 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                                triX = new float[]{p1.x, p2.x, fillLeft ? p1.x : p2.x};
                                triY = new float[]{p1.y, p2.y, fillLeft ? p2.y : p2.x};
                                g.fillPolygon(triX, triY, 3);
                            } else {
                                xPoints[i] = x + this.p.columnWidth;
                                yPoints[i] = (depth - yPoints[i - 1]) / (value - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x;
                                    yPoints[i + 1] = yPoints[i];
                                    g.fillPolygon(xPoints, yPoints, i + 2);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 2, fillColour);
                                }
                            }
                        }
                        onRightWrap = true;
                        xPoints[0] = x;
                        yPoints[0] = i == 0 ? depth : yPoints[i];
                        i = 1;
                    }
                    xPoints[i] = (value -= this.p.columnWidth) > x + this.p.columnWidth ? x + this.p.columnWidth : value;
                    yPoints[i] = depth;
                    ++i;
                    continue;
                }
                if (value < x) {
                    if (!onLeftWrap) {
                        if (i != 0) {
                            if (onRightWrap) {
                                xPoints[i] = x;
                                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value + this.p.columnWidth) * (xPoints[i - 1] + this.p.columnWidth - (x + this.p.columnWidth)) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3);
                                } else {
                                    g.fillPolygon(xPoints, yPoints, i + 1, fillColour);
                                }
                                onRightWrap = false;
                                Point2D.Float p1 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                                yPoints[i] = (depth - yPoints[i]) / (x + this.p.columnWidth - value) * (x + this.p.columnWidth - x) + yPoints[i];
                                Point2D.Float p2 = new Point2D.Float(x, yPoints[i]);
                                triX = new float[]{p1.x, p2.x, fillLeft ? p2.x : p1.x};
                                triY = new float[]{p1.y, p2.y, fillLeft ? p1.y : p2.y};
                                g.fillPolygon(triX, triY, 3);
                            } else {
                                xPoints[i] = x;
                                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x;
                                    yPoints[i + 1] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 2);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                                }
                            }
                        }
                        onLeftWrap = true;
                        xPoints[0] = x + this.p.columnWidth;
                        yPoints[0] = i == 0 ? depth : yPoints[i];
                        i = 1;
                    }
                    xPoints[i] = (value += this.p.columnWidth) < x ? x : value;
                    yPoints[i] = depth;
                    ++i;
                    continue;
                }
                if (onRightWrap) {
                    onRightWrap = false;
                    xPoints[i] = x;
                    yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] + this.p.columnWidth - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                    if (fillLeft) {
                        xPoints[i + 1] = x + this.p.columnWidth;
                        yPoints[i + 1] = yPoints[i];
                        xPoints[i + 2] = x + this.p.columnWidth;
                        yPoints[i + 2] = yPoints[0];
                        g.fillPolygon(xPoints, yPoints, i + 3);
                    } else {
                        g.fillPolygon(xPoints, yPoints, i + 1, fillColour);
                    }
                    xPoints[0] = x + this.p.columnWidth;
                    yPoints[0] = yPoints[i];
                    i = 1;
                }
                if (onLeftWrap) {
                    onLeftWrap = false;
                    xPoints[i] = x + this.p.columnWidth;
                    yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                    if (fillLeft) {
                        g.fillPolygon(xPoints, yPoints, i + 1);
                    } else {
                        xPoints[i + 1] = x;
                        yPoints[i + 1] = yPoints[i];
                        xPoints[i + 2] = x;
                        yPoints[i + 2] = yPoints[0];
                        g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                    }
                    xPoints[0] = x;
                    yPoints[0] = yPoints[i];
                    i = 1;
                }
            }
            xPoints[i] = value;
            if (!wrap) {
                if (xPoints[i] < x) {
                    xPoints[i] = x;
                } else if (xPoints[i] > x + this.p.columnWidth) {
                    xPoints[i] = x + this.p.columnWidth;
                }
            }
            yPoints[i] = depth;
            ++i;
        }
        yPoints[i] = yPoints[i - 1];
        yPoints[i + 1] = yPoints[0];
        if (!onLeftWrap && !onRightWrap) {
            xPoints[i] = fillLeft ? x : x + this.p.columnWidth;
            xPoints[i + 1] = fillLeft ? x : x + this.p.columnWidth;
            g.fillPolygon(xPoints, yPoints, i + 2);
        } else if (onLeftWrap || onRightWrap) {
            xPoints[i] = fillLeft ? x + this.p.columnWidth : x;
            xPoints[i + 1] = fillLeft ? x + this.p.columnWidth : x;
            g.fillPolygon(xPoints, yPoints, i + 2, fillColour);
        }
    }

    private void drawTrace(SBGraphics g, LogDef def, Curve curve, ChartProperties cp, Chart.Mode mode, float x, float y, Color lineColour, BlockProperties bp) throws SQLException {
        float baseDepth;
        float topDepth;
        g.setColor(lineColour);
        int style = def.getTraceStyle();
        if (bp == this.block.prop) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.min;
            baseDepth = bp.max;
        }
        switch (style) {
            case 0: {
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift);
                break;
            }
            case 3: {
                this.drawTraceSymbols(g, curve, x, y, cp, mode, def, topDepth, baseDepth);
                break;
            }
            case 4: {
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift);
                this.drawTraceSymbols(g, curve, x, y, cp, mode, def, topDepth, baseDepth);
                break;
            }
            case 1: {
                if (this.p.drawLithology || !def.getBackColour().equals(Color.WHITE)) {
                    this.drawTraceFilled(g, mode, curve, x, y, def.getMinval(), def.getMaxval(), def.isAsLog(), cp, true, def.getBackColour(), def.getWrapTrace(), topDepth, baseDepth);
                }
                if (def.getLineColour().equals(def.getBackColour())) break;
                g.setColor(def.getLineColour());
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift);
                break;
            }
            case 2: {
                if (this.p.drawLithology || !def.getBackColour().equals(Color.WHITE)) {
                    this.drawTraceFilled(g, mode, curve, x, y, def.getMinval(), def.getMaxval(), def.isAsLog(), cp, false, def.getBackColour(), def.getWrapTrace(), topDepth, baseDepth);
                }
                if (def.getLineColour().equals(def.getBackColour())) break;
                g.setColor(def.getLineColour());
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift);
                break;
            }
        }
    }

    private void drawTraceSymbols(SBGraphics g, Curve curve, float x, float y, ChartProperties cp, Chart.Mode mode, LogDef logDef, float topDepth, float baseDepth) throws SQLException {
        g.setColor(logDef.getLineColour());
        g.setStroke(logDef.getPenWidth());
        ListIterator it = curve.getTrace().listIterator();
        Float lastY = null;
        float symbolSize = 1.3f;
        int symbol = logDef.getSymbol();
        while (it.hasNext()) {
            Curve.CurveValue val = (Curve.CurveValue)it.next();
            if (val.getDepth() + this.p.logShift < (double)topDepth) continue;
            if (val.getDepth() + this.p.logShift > (double)baseDepth) break;
            float yPos = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)val.getDepth() + (float)this.p.logShift);
            float xPos = x + PanelWirelineLog.scaleValue(val.getValue(), logDef.getMinval(), logDef.getMaxval(), logDef.isAsLog(), this.p.columnWidth);
            if (lastY != null && Math.abs(lastY.floatValue() - yPos) < symbolSize / 3.0f) continue;
            if (xPos > x && xPos < x + this.p.columnWidth) {
                PanelWirelineLog.drawSymbol(g, xPos, yPos, symbol, symbolSize);
            }
            lastY = Float.valueOf(yPos);
        }
    }

    static void drawSymbol(SBGraphics g, float xPos, float yPos, int symbol, float symbolSize) {
        switch (symbol) {
            case 0: {
                float[] x = new float[]{xPos, xPos + symbolSize, xPos - symbolSize};
                float[] y = new float[]{yPos - symbolSize, yPos + symbolSize, yPos + symbolSize};
                g.fillPolygon(x, y, 3);
                break;
            }
            case 1: {
                g.fillEllipse(xPos - symbolSize, yPos - symbolSize, symbolSize * 2.0f, symbolSize * 2.0f, null);
                break;
            }
            case 3: {
                float[] x = new float[]{xPos, xPos + symbolSize, xPos, xPos - symbolSize};
                float[] y = new float[]{yPos - symbolSize, yPos, yPos + symbolSize, yPos};
                g.fillPolygon(x, y, 4);
                break;
            }
            case 5: {
                g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
                g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
                break;
            }
            case 4: {
                g.drawLine(xPos - symbolSize, yPos - symbolSize, xPos + symbolSize, yPos + symbolSize);
                g.drawLine(xPos + symbolSize, yPos - symbolSize, xPos - symbolSize, yPos + symbolSize);
                break;
            }
            case 6: {
                g.drawLine(xPos - symbolSize, yPos - symbolSize, xPos + symbolSize, yPos + symbolSize);
                g.drawLine(xPos + symbolSize, yPos - symbolSize, xPos - symbolSize, yPos + symbolSize);
                g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
                g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
                break;
            }
            case 2: {
                g.fillRect(xPos - symbolSize, yPos - symbolSize, symbolSize * 2.0f, symbolSize * 2.0f);
            }
        }
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float baseDepth;
        float topDepth;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelWirelineLog.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height)) {
            return x + this.getWidth(bp);
        }
        float hdrYpos = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode) - 10.0f;
        if (this.p.drawDepthGuides) {
            this.drawDepthGuides(g, x, y, cp, bp, mode);
        }
        if (this.p.drawVerticalGrid && !this.p.gridAbr.isEmpty()) {
            LogDef def = this.p.defs.get(this.p.gridAbr);
            this.drawVerticalGrid(g, x, y, cp, mode, bp, def.getMinval(), def.getMaxval(), def.isAsLog());
        }
        if (bp == this.block.prop) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.min;
            baseDepth = bp.max;
        }
        if (this.p.drawLithology) {
            this.initLithology();
            PanelIntLith.drawLithology(g, x, y, cp, bp, mode, this.lithList, this.p.columnWidth, this.block, false, null, topDepth, baseDepth);
        }
        try {
            for (LogDef def : this.p.defs.values()) {
                Color lineColour = def.getLineColour() != null ? def.getLineColour() : Color.BLACK;
                g.setColor(lineColour);
                float weight = def.getPenWidth() != 0.0f ? def.getPenWidth() : 0.1f;
                g.setStroke(weight);
                for (Curve trace : this.block.well.getCurves().getCurves()) {
                    if (!trace.getAbr().equals(def.getAbr())) continue;
                    this.drawTrace(g, def, trace, cp, mode, x, y, lineColour, bp);
                }
                if (mode == Chart.Mode.NO_HEADER || bp != this.block.prop && !((double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01)) continue;
                float minval = def.getMinval();
                float maxval = def.getMaxval();
                String tracetitle = def.getTitle();
                String units = def.getUnits();
                Color hdrColour = def.getLineColour();
                g.setColor(hdrColour);
                if (def.getTraceStyle() == 1 || def.getTraceStyle() == 2) {
                    g.fillRect(x, hdrYpos, this.p.columnWidth, 1.5f, def.getBackColour());
                } else {
                    g.drawLine(x, hdrYpos, x + this.p.columnWidth, hdrYpos);
                }
                g.setFont(cp.font, 1, cp.fontSmall);
                g.setColor(Color.BLACK);
                g.drawString(tracetitle, x, hdrYpos - cp.fontTiny * 1.75f, this.getWidth(bp), 0);
                g.setFont(cp.font, 0, cp.fontTiny);
                g.drawString(units, x, hdrYpos - cp.fontTiny / 2.0f, this.getWidth(bp), 0);
                int dp = this.getLogDp(minval, maxval);
                g.drawString(SB.floatString((float)minval, (int)dp).trim(), x + 0.7f, hdrYpos - cp.fontTiny / 2.0f);
                String maxstrg = "" + SB.floatString((float)maxval, (int)dp);
                g.drawString(maxstrg, x + this.p.columnWidth - g.stringWidth(maxstrg) - 0.7f, hdrYpos - cp.fontTiny / 2.0f);
                hdrYpos -= 10.0f;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        return x + this.p.columnWidth;
    }

    private int getLogDp(float minval, float maxval) {
        return (int)Math.max(Math.max(0.0, 2.0 - Math.log10(Math.abs(minval) > 0.0f ? (double)Math.abs(minval) : 100.0)), (double)((int)Math.max(0.0, 2.0 - Math.log10(Math.abs(maxval) > 0.0f ? (double)Math.abs(maxval) : 100.0))));
    }

    @Override
    String getCaption() {
        return "Wireline Logs";
    }

    @Override
    String getSubCaption() {
        String lithTitle = null;
        if (this.p.drawLithology) {
            lithTitle = "with Lithology";
        }
        return lithTitle;
    }

    private void drawDepthGuides(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float topDepth;
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(0.1f);
        int startDepth = this.p.depthGuideInterval;
        float f = topDepth = bp == this.block.prop ? this.block.getTopDepth() : bp.min;
        while ((float)startDepth < topDepth) {
            startDepth += this.p.depthGuideInterval;
        }
        float hdr = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode);
        float yPos = hdr + this.block.scaleDepth(startDepth);
        float baseDepth = this.block.getBaseDepth();
        while (yPos < bp.height + PanelWirelineLog.getPanelHeaderHeight(cp, mode) && (float)startDepth < baseDepth) {
            g.drawLine(x, yPos, x + this.p.columnWidth, yPos);
            yPos = hdr + this.block.scaleDepth(startDepth += this.p.depthGuideInterval);
        }
    }

    private void drawVerticalGrid(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp, float minval, float maxval, boolean aslog) {
        float top = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode);
        float base = top + bp.height;
        float right = x + this.p.columnWidth;
        if (!aslog) {
            float scaleWidth = Math.abs(maxval - minval);
            if ((double)scaleWidth < 1.0E-4) {
                return;
            }
            float intervalWidth = this.sign(maxval - minval) * this.CalcGridInterval(maxval, minval);
            int nInts = (int)Math.floor(scaleWidth / Math.abs(intervalWidth));
            float xScale = this.p.columnWidth / (this.sign(maxval - minval) * scaleWidth);
            for (int i = 0; i < nInts + 1; ++i) {
                float xval = intervalWidth * (float)i;
                float x1 = x + xval * xScale;
                if (!this.InRange(x1, x, right)) continue;
                g.drawLine(x1, top, x1, base);
            }
        } else {
            float xInc;
            int intVal;
            if (minval == 0.0f) {
                return;
            }
            if ((double)Math.abs(maxval - minval) < 1.0E-4) {
                return;
            }
            float logmin = (float)Math.log10(minval);
            float logmax = (float)Math.log10(maxval);
            float xScale = this.p.columnWidth / (logmax - logmin);
            int nIter = 0;
            if (logmin < 0.0f) {
                intVal = 0;
                while (intVal <= 0) {
                    intVal = (int)((double)minval * Math.pow(10.0, ++nIter));
                }
                xInc = (float)(1.0 / Math.pow(10.0, nIter));
            } else {
                intVal = 1;
                while (intVal > 0) {
                    intVal = (int)((double)minval / Math.pow(10.0, ++nIter));
                }
                xInc = (float)Math.pow(10.0, nIter - 1);
            }
            float logVal = minval;
            while (logVal < maxval) {
                float x1 = (float)((double)x + (double)xScale * (Math.log10(logVal += xInc) - (double)logmin));
                g.drawLine(x1, top, x1, base);
                if (!((double)logVal / ((double)xInc * 10.0) > 0.0)) continue;
                xInc = (float)((double)xInc * 10.0);
            }
        }
    }

    float sign(float x) {
        float t = 1.0f;
        if ((double)x < 0.0) {
            t = -1.0f;
        }
        return t;
    }

    float CalcGridInterval(float xmin, float xmax) {
        float dx = 2000.0f;
        float xWidth = Math.abs(xmax - xmin);
        dx = 2000.0f;
        if ((double)xWidth <= 20000.0) {
            dx = 1000.0f;
        }
        if ((double)xWidth <= 1000.0) {
            dx = 200.0f;
        }
        if ((double)xWidth <= 600.0) {
            dx = 150.0f;
        }
        if ((double)xWidth <= 500.0) {
            dx = 100.0f;
        }
        if ((double)xWidth <= 300.0) {
            dx = 50.0f;
        }
        if ((double)xWidth <= 100.0) {
            dx = 20.0f;
        }
        if ((double)xWidth <= 60.0) {
            dx = 15.0f;
        }
        if ((double)xWidth <= 50.0) {
            dx = 10.0f;
        }
        if ((double)xWidth <= 30.0) {
            dx = 5.0f;
        }
        if ((double)xWidth <= 10.0) {
            dx = 2.0f;
        }
        if ((double)xWidth <= 6.0) {
            dx = 1.5f;
        }
        if ((double)xWidth <= 5.0) {
            dx = 1.0f;
        }
        if ((double)xWidth <= 3.0) {
            dx = 1.5f;
        }
        if ((double)xWidth <= 1.0) {
            dx = 0.25f;
        }
        return dx;
    }

    boolean InRange(float xval, float x1, float x2) {
        boolean isOK = false;
        float xmin = Math.min(x1, x2);
        float xmax = Math.max(x1, x2);
        if (xval <= xmax && xval >= xmin) {
            isOK = true;
        }
        return isOK;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.columnWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Wireline Log Panel";
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.block.getDepth(y) < this.block.getTopDepth() || this.block.getDepth(y) > this.block.getBaseDepth()) {
            return null;
        }
        return SB.getDepthString((double)this.block.getDepth(y), (char)this.block.prop.units, (int)2);
    }

    static void setStroke(SBGraphics g, int style, boolean wrapping, float weight, float dotWeigh) {
        if (!wrapping) {
            switch (style) {
                case 0: {
                    g.setStroke(weight);
                    return;
                }
                case 2: {
                    g.setDashStroke(weight);
                    return;
                }
                case 1: {
                    g.setDotStroke(dotWeigh);
                    return;
                }
            }
            return;
        }
        switch (style) {
            case 0: 
            case 2: {
                g.setDotStroke(dotWeigh);
                return;
            }
            case 1: {
                g.setDashStroke(weight);
                return;
            }
        }
    }

    static float scaleValue(double value, float minVal, float maxVal, boolean logScale, float colWidth) {
        double retval;
        float scale;
        boolean leftRightIncrease;
        float lhs = minVal;
        float rhs = maxVal;
        float range = Math.max(minVal, maxVal) - Math.min(minVal, maxVal);
        boolean bl = leftRightIncrease = minVal < maxVal;
        if (!logScale) {
            scale = colWidth / range;
            retval = value * (double)scale;
        } else {
            scale = colWidth / (float)Math.log10(range);
            retval = (float)Math.log10(value) * scale;
            lhs = (float)Math.log10(lhs);
        }
        retval = leftRightIncrease ? (retval += (double)((0.0f - lhs) * scale)) : (double)(lhs * scale) - retval;
        return (float)retval;
    }

    public String toString() {
        String string = "Wireline Logs";
        if (this.p.defs != null) {
            string = string + " - ";
            boolean first = true;
            for (LogDef def : this.p.defs.values()) {
                if (!first) {
                    string = string + ", ";
                }
                first = false;
                string = string + def.getAbr();
            }
        }
        return string;
    }
}

