/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import jsbugs.Chart;
import jsbugs.PanelProperties;
import model2.Lastval;
import model2.LogDef;
import model2.SBdb;

public class PanelWirelineLogProperties
implements PanelProperties {
    float columnWidth = 40.0f;
    boolean drawDepthGuides = true;
    int depthGuideInterval = 100;
    boolean drawLithology = false;
    double logShift = 0.0;
    boolean drawVerticalGrid = false;
    String gridAbr = "";
    LinkedHashMap<String, LogDef> defs = new LinkedHashMap(16, 0.75f, true);

    PanelWirelineLogProperties() {
    }

    PanelWirelineLogProperties(PanelWirelineLogProperties rhs) {
        this.columnWidth = rhs.columnWidth;
        this.drawDepthGuides = rhs.drawDepthGuides;
        this.depthGuideInterval = rhs.depthGuideInterval;
        this.drawLithology = rhs.drawLithology;
        this.logShift = rhs.logShift;
        this.drawVerticalGrid = rhs.drawVerticalGrid;
        this.gridAbr = rhs.gridAbr;
        for (LogDef def : rhs.defs.values()) {
            this.defs.put(def.getAbr(), new LogDef(def));
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        int traceNo = 0;
        for (LogDef def : this.defs.values()) {
            String logKey = key + traceNo;
            String tracePref = def.getProperties();
            Lastval.putString((SBdb)sbdb, (String)logKey, (String)tracePref);
            if (traceNo == 9) {
                System.out.println("WARNING: too many log traces to store in preferences");
                break;
            }
            ++traceNo;
        }
        String prefs = this.getPrefs();
        String[] props = new String[]{"" + (this.drawLithology ? 1 : 0), "" + this.logShift, "" + (this.drawVerticalGrid ? 1 : 0), this.gridAbr};
        for (String prop : props) {
            prefs = prefs + prop + "|";
        }
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + prefs));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.drawDepthGuides ? 1 : 0), "" + this.depthGuideInterval};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    PanelWirelineLogProperties(String props, LinkedList<Chart.ChartPref> traces) {
        String[] s = props.split("\\|");
        block9: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block9;
                }
                case 1: {
                    this.drawDepthGuides = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 2: {
                    this.depthGuideInterval = Integer.parseInt(s[i]);
                    continue block9;
                }
                case 3: {
                    this.drawLithology = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 4: {
                    this.logShift = Double.parseDouble(s[i]);
                    continue block9;
                }
                case 5: {
                    this.drawVerticalGrid = Integer.parseInt(s[i]) == 1;
                    continue block9;
                }
                case 6: {
                    this.gridAbr = s[i];
                }
            }
        }
        for (Chart.ChartPref trace : traces) {
            LogDef logDef = new LogDef(trace.value);
            this.defs.put(logDef.getAbr(), logDef);
        }
    }

    void setColumnWidth(float w) {
        if (w < 10.0f) {
            w = 10.0f;
        } else if (w > 200.0f) {
            w = 200.0f;
        }
        this.columnWidth = w;
    }

    void setShift(double s) {
        if (s < -200.0) {
            s = -200.0;
        } else if (s > 200.0) {
            s = 200.0;
        }
        this.logShift = s;
    }

    void setGridAbr(String abr) {
        if (this.defs.get(abr) != null) {
            this.gridAbr = abr;
        }
    }
}

