/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.DrawZone;
import jsbugs.PanelZonesProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHTML;
import jsbugs.WellBlock;
import model2.IGDColMap;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import model2.Sample;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelZones
extends SBPanelHTML
implements Observer {
    WellBlock block;
    int interpID;
    int igdType;
    SBdb db;
    private PanelZonesProperties p;
    public static float HATCH_SIZE = 1.0f;
    public static final String BND_PREFIX = "Bnd: ";
    static float bndStroke = 0.15f;
    private static float smallZoneExpansion = 2.5f;
    private LinkedList<LinkedList<DrawZone>> drawZones;
    private String[] colTitles;

    public PanelZones(SBdb db, WellBlock block, int igdType, int interpID) throws SBException, SQLException {
        this.block = block;
        this.db = db;
        this.igdType = igdType;
        this.interpID = interpID;
        this.init(null);
    }

    public PanelZones(SBdb db, WellBlock block, int igdType, int interpID, String props) throws SBException, SQLException {
        this.block = block;
        this.db = db;
        this.igdType = igdType;
        this.interpID = interpID;
        this.init(props);
    }

    private void init(String props) throws SBException, SQLException {
        this.block.well.getInterp(this.interpID).addObserver((Observer)this);
        IGDColMap colmap = this.block.well.getAddInterp(this.db.getInterp(this.interpID)).getColMap(this.block.well.getWellID(), this.igdType);
        this.p = props == null ? new PanelZonesProperties(this.db, colmap) : new PanelZonesProperties(this.db, colmap, props);
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String toString() {
        String string = "Intervals";
        try {
            string = string + " : " + IGDInterval.getIGDName((int)this.igdType) + " : " + this.block.well.getInterp(this.interpID);
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        return string;
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.well.getSampleNearest((double)depth, 2.5f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error getting sample", (Exception)ex);
            return null;
        }
    }

    public Sample getBoundarySample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        float depthBracket = this.block.getDepth(y + 2.5f / zoom) - depth;
        try {
            for (IGDIntervalZone zone : this.block.well.getInterp(this.interpID).getIGDList(this.igdType)) {
                if (Math.abs(this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings) - (double)depth) < (double)depthBracket) {
                    return zone.getTopSample();
                }
                if (!(Math.abs(this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings) - (double)depth) < (double)depthBracket)) continue;
                return zone.getBaseSample();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    List<IGDIntervalZone> getIGDList() throws SBException, SQLException {
        WellInterp wellInterp = this.block.well.getInterp(this.interpID);
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        return wellInterp.getIGDList(this.igdType);
    }

    List<IGDIntervalZone> getIGDList(int column) throws SBException, SQLException {
        WellInterp wellInterp = this.block.well.getInterp(this.interpID);
        IGDColMap colmap = this.block.well.getInterp(this.interpID).getColMap(this.block.well.getWellID(), this.igdType);
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        if (colmap != null) {
            return wellInterp.getIGDList(this.igdType, 0, colmap.getMinhier(column), colmap.getMaxhier(column));
        }
        throw new SBException("Colmap is null in PanelZones");
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.drawZones == null || this.drawZones.isEmpty()) {
            return null;
        }
        float depth = this.block.getDepth(y, bp);
        float depthBracket = this.block.getBracket(2.5f, zoom, depth);
        float smallZoneBracket = this.block.getDepth(y + smallZoneExpansion) - depth;
        float BRACKET = 2.5f / zoom;
        float SMALL_BRACKET = smallZoneExpansion / zoom;
        float xpos = 0.0f;
        for (LinkedList linkedList : this.drawZones) {
            if (!(x < (xpos += this.p.columnWidth))) continue;
            for (DrawZone zone : linkedList) {
                if (zone.o == null) continue;
                float bracket = BRACKET;
                float toppos = bp.getNormal() ? zone.getYTop() : zone.getYBase();
                float basepos = bp.getNormal() ? zone.getYBase() : zone.getYTop();
                boolean small = PanelZones.getSmall(zone.getYTop(), zone.getYBase());
                if (small) {
                    bracket += SMALL_BRACKET;
                }
                if (!(y > toppos - bracket) || !(y < basepos + bracket) || bp != this.block.prop && ((double)depth > zone.baseDepth || (double)depth < zone.topDepth)) continue;
                if (zone.o != null) {
                    IGDIntervalZone z = (IGDIntervalZone)zone.o;
                    double d = zone.topDepth - (double)depthBracket;
                    float f = small ? smallZoneBracket : 0.0f;
                    if (d - (double)f < (double)depth) {
                        double d2 = zone.topDepth + (double)depthBracket;
                        float f2 = small ? smallZoneBracket : 0.0f;
                        if (d2 - (double)f2 > (double)depth) {
                            return BND_PREFIX + z.getTopSample().toString(bp.units) + " " + z.getTopBnd();
                        }
                    }
                    double d3 = zone.baseDepth - (double)depthBracket;
                    float f3 = small ? smallZoneBracket : 0.0f;
                    if (d3 + (double)f3 < (double)depth) {
                        double d4 = zone.baseDepth + (double)depthBracket;
                        float f4 = small ? smallZoneBracket : 0.0f;
                        if (d4 + (double)f4 > (double)depth) {
                            return BND_PREFIX + z.getBaseSample().toString(bp.units) + " " + z.getBaseBnd();
                        }
                    }
                }
                return zone.o;
            }
        }
        return null;
    }

    String getPanelTitle() throws SQLException {
        return IGDIntervalZone.getIGDName((int)this.igdType);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelZones.getPanelHeaderHeight(cp, mode), (float)this.drawZones.size() * this.p.columnWidth, bp.height + (firstOrOnly ? PanelZones.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        float xpos = x;
        g.setFont(cp.font, 0, cp.fontPanel);
        g.setColor(Color.BLACK);
        try {
            Float lastxpos = null;
            for (int column = 0; column < this.drawZones.size(); ++column) {
                float newxpos = this.drawColumn(g, xpos, y, cp, mode, bp, column, true);
                g.setFont(cp.font, 0, cp.fontHeader);
                if (mode != Chart.Mode.NO_HEADER && (bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01)) {
                    g.drawStringVertical(this.colTitles[column], xpos + this.p.columnWidth / 2.0f, y + PanelZones.getPanelHeaderHeight(cp, mode) - cp.fontHeader, cp.panelSubHeaderHeight - cp.fontHeader, true, false);
                    if (lastxpos != null) {
                        g.drawLine(lastxpos.floatValue(), y + PanelZones.getPanelCaptionHeight(cp, mode), lastxpos.floatValue(), y + PanelZones.getPanelCaptionHeight(cp, mode) + bp.height + PanelZones.getPanelSubHeaderHeight(cp, mode));
                    }
                } else if (lastxpos != null) {
                    float topy = Math.min(this.block.scaleDepth(bp.min), this.block.scaleDepth(bp.max)) + y + PanelZones.getPanelHeaderHeight(cp, mode);
                    g.drawLine(lastxpos.floatValue(), topy, lastxpos.floatValue(), topy + bp.height);
                }
                lastxpos = Float.valueOf(newxpos);
                xpos = lastxpos.floatValue();
            }
        }
        catch (SQLException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        return x + this.getWidth(bp);
    }

    @Override
    String getCaption() {
        try {
            return this.getPanelTitle();
        }
        catch (SQLException sql) {
            return "Zones";
        }
    }

    @Override
    String getSubCaption() {
        try {
            return this.db.getInterp(this.interpID).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    float drawColumn(SBGraphics g, float xpos, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp, int column, boolean showSampleGaps) throws SBException, SQLException {
        Font font = new Font(cp.font, 0, (int)cp.fontPanel);
        LinkedList<DrawZone> list = new LinkedList<DrawZone>((Collection)this.drawZones.get(column));
        if (bp != this.block.prop) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.baseDepth <= bp.min) && !((float)zone.topDepth >= bp.max)) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        PanelZones.drawColumnIntervals(g, xpos, y, font, list, this.p.columnWidth, cp, this.p.drawBndDepths, this.p.vertPref, mode);
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        return xpos += this.p.columnWidth;
    }

    static void drawColumnIntervals(SBGraphics g, float xpos, float y, Font font, List<DrawZone> intervalList, float columnWidth, ChartProperties cp, boolean drawBndDepths, boolean vertPref, Chart.Mode mode) {
        if (intervalList.size() == 1) {
            // empty if block
        }
        LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
        for (DrawZone zone : intervalList) {
            if (zone.uppColour != null) continue;
            float topVal = Math.min(zone.getYTop(), zone.getYBase()) + PanelZones.getPanelHeaderHeight(cp, mode) + y;
            float baseVal = Math.max(zone.getYTop(), zone.getYBase()) + PanelZones.getPanelHeaderHeight(cp, mode) + y;
            PanelZones.fillGap(g, xpos, topVal, xpos + columnWidth, baseVal);
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            if (PanelZones.getSmall(zone.getYTop(), zone.getYBase()) || IGDIntervalZone.isUnconformableBnd((int)zone.topBnd) || IGDIntervalZone.isUnconformableBnd((int)zone.baseBnd)) continue;
            PanelZones.drawInterval(g, xpos, y, zone, font, columnWidth, cp, mode, drawBndDepths, vertPref);
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            if (PanelZones.getSmall(zone.getYTop(), zone.getYBase()) || zone.topBnd != 4 && zone.topBnd != 5 && zone.baseBnd != 4 && zone.baseBnd != 5) continue;
            PanelZones.drawInterval(g, xpos, y, zone, font, columnWidth, cp, mode, drawBndDepths, vertPref);
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            PanelZones.drawInterval(g, xpos, y, zone, font, columnWidth, cp, mode, drawBndDepths, vertPref);
        }
    }

    private static void drawInterval(SBGraphics g, float xpos, float y, DrawZone zone, Font font, float columnWidth, ChartProperties cp, Chart.Mode mode, boolean drawBndDepths, boolean vertPref) {
        boolean small = PanelZones.getSmall(zone.getYTop(), zone.getYBase());
        float indent = 1.75f;
        float leftX = small ? xpos + indent : xpos;
        float topY = (small ? zone.getYTop() - smallZoneExpansion : zone.getYTop()) + y + PanelZones.getPanelHeaderHeight(cp, mode);
        float trueTop = zone.getYTop() + y + PanelZones.getPanelHeaderHeight(cp, mode);
        float rightX = small ? xpos + columnWidth - indent : xpos + columnWidth;
        float baseY = (small ? zone.getYBase() + smallZoneExpansion : zone.getYBase()) + y + PanelZones.getPanelHeaderHeight(cp, mode);
        float trueBase = zone.getYBase() + y + PanelZones.getPanelHeaderHeight(cp, mode);
        GeneralPath path = SBGraphics.createGeneralPath(xpos, trueTop);
        if (small) {
            SBGraphics.appendLine(path, xpos, trueTop, leftX, topY);
        }
        if (zone.topBnd != 4 && zone.topBnd != 5) {
            SBGraphics.appendLine(path, leftX, topY, rightX, topY);
        } else {
            g.appendUnconf(path, leftX, rightX, topY, zone.topBnd == 5, true, true, false);
        }
        if (small) {
            SBGraphics.appendLine(path, rightX, topY, xpos + columnWidth, trueTop);
        }
        SBGraphics.appendLine(path, xpos + columnWidth, trueTop, xpos + columnWidth, trueBase);
        if (small) {
            SBGraphics.appendLine(path, xpos + columnWidth, trueBase, rightX, baseY);
        }
        if (zone.baseBnd != 4 && zone.baseBnd != 5) {
            SBGraphics.appendLine(path, rightX, baseY, leftX, baseY);
        } else {
            g.appendUnconf(path, rightX, leftX, baseY, zone.baseBnd == 5, true, true, false);
        }
        if (small) {
            SBGraphics.appendLine(path, leftX, baseY, xpos, trueBase);
        }
        SBGraphics.appendLine(path, xpos, trueBase, xpos, trueTop);
        g.fillShape(path, zone.uppColour);
        if (zone.lowColour != null && zone.lowColour != zone.uppColour) {
            float f = columnWidth * 0.05f;
            float[] yPoints = new float[]{topY - f, topY - f, baseY + f, baseY + f};
            float[] xPoints = new float[]{xpos + columnWidth - f, xpos + columnWidth, xpos + columnWidth, xpos + f};
            BasicStroke stroke = g.getStroke();
            g.setStroke(0.0f);
            g.setClip(path);
            g.setColor(zone.lowColour);
            g.fillPolygon(xPoints, yPoints, 4);
            g.setClip(null);
            g.setStroke(stroke);
            g.setColor(Color.BLACK);
        }
        g.setColor(Color.BLACK);
        g.setStroke(bndStroke);
        if (small) {
            g.drawLine(xpos, trueTop, leftX, topY);
            g.drawLine(rightX, topY, xpos + columnWidth, trueTop);
            g.drawLine(xpos + columnWidth, trueBase, rightX, baseY);
            g.drawLine(leftX, baseY, xpos, trueBase);
        } else {
            g.drawLine(xpos + columnWidth, trueTop, xpos + columnWidth, trueBase);
            g.drawLine(xpos, trueBase, xpos, trueTop);
        }
        PanelZones.drawBoundary(zone.topBnd, leftX, rightX, topY, g, bndStroke);
        PanelZones.drawBoundary(zone.baseBnd, leftX, rightX, baseY, g, bndStroke);
        float padding = small ? 0.0f : 0.3f;
        g.setFont(font.getFontName(), font.getStyle(), font.getSize());
        if (!g.drawStringBox(zone.horzName, zone.vertName, leftX + padding, Math.min(topY, baseY), rightX - leftX - padding * 2.0f, Math.abs(baseY - topY), vertPref, true, 4)) {
            g.drawString(zone.horzName, leftX + padding, Math.min(topY, baseY) + Math.abs(topY - baseY) / 2.0f + g.stringHeightSB() / 2.0f, rightX - leftX - padding * 2.0f, 0);
        }
        if (drawBndDepths && !small) {
            float fontSize = Math.min(2.0f, Math.abs(trueBase - trueTop) - 2.0f * padding);
            g.setFont(font.getFontName(), font.getStyle(), fontSize);
            if (zone.topDepthString != null) {
                g.drawString(zone.topDepthString, xpos + padding, trueTop + (trueTop < trueBase ? fontSize + padding : padding * -2.5f));
            }
            if (zone.baseDepthString != null) {
                g.drawString(zone.baseDepthString, xpos + columnWidth - g.stringWidth(zone.baseDepthString) - padding, trueBase + (trueTop < trueBase ? padding * -2.5f : fontSize + padding));
            }
        }
    }

    static void drawBoundary(int type, float leftX, float rightX, float ypos, SBGraphics g, float stroke) {
        float h = 1.75f;
        switch (type) {
            case 3: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 2: {
                g.setDashStroke(stroke, 5.5f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 1: {
                g.setDashStroke(stroke, 2.0f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 4: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                g.appendUnconf(p, leftX, rightX, ypos, false, true, true, false);
                g.drawShape(p);
                break;
            }
            case 5: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                Shape s = g.appendUnconf(p, leftX, rightX, ypos, true, true, true, false);
                g.drawShape(p);
                g.fillShape(s, g.getColor());
                break;
            }
            case 6: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w1 = 0.8f;
                g.setStroke(stroke * 1.5f);
                g.drawLine(leftX + (rightX - leftX) / 2.0f, ypos, leftX + (rightX - leftX) / 2.0f, ypos - h);
                g.fillEllipse(leftX + (rightX - leftX) / 2.0f - w1 / 2.0f, ypos - h, w1, w1, Color.BLACK);
                g.setStroke(stroke);
                break;
            }
            case 7: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w2 = 0.8f;
                g.setStroke(stroke * 1.5f);
                g.drawLine(leftX + (rightX - leftX) / 2.0f, ypos, leftX + (rightX - leftX) / 2.0f, ypos - h);
                g.fillEllipse(leftX + (rightX - leftX) / 2.0f - w2 / 2.0f, ypos - h, w2, w2, Color.BLACK);
                Font font = g.getFont();
                g.setFont(font.getName(), font.getStyle(), 2.2f);
                g.drawString("?", leftX + (rightX - leftX) / 2.0f - 2.2f, ypos - 0.25f);
                g.setFont(font);
                g.setStroke(stroke);
                break;
            }
            case 8: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w = 3.5f;
                float h1 = h * 0.4f;
                g.fillRect(leftX + (rightX - leftX) / 2.0f - w / 2.0f, ypos - h1, w, h1);
                break;
            }
        }
    }

    static void drawUnconfBoundary(int type, float leftX, float rightX, float ypos, SBGraphics g, float stroke, boolean flatStart, boolean flatEnd, boolean forceUp) {
        switch (type) {
            case 4: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                g.appendUnconf(p, leftX, rightX, ypos, false, flatStart, flatEnd, forceUp);
                g.drawShape(p);
                break;
            }
            case 5: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                Shape s = g.appendUnconf(p, leftX, rightX, ypos, true, flatStart, flatEnd, forceUp);
                g.drawShape(p);
                g.fillShape(s, g.getColor());
                break;
            }
        }
    }

    static boolean getSmall(float yTop, float yBase) {
        return Math.abs(yBase - yTop) < 2.0f;
    }

    public static boolean fillGap(SBGraphics g, float x, float y, float xRight, float yBot) {
        if ((double)(yBot - y) < 0.01 || (double)(xRight - x) < 0.01) {
            return false;
        }
        g.setStroke(0.05f);
        g.setColor(Color.CYAN);
        while (x < xRight) {
            g.drawLine(x += HATCH_SIZE, y, x, yBot);
        }
        return true;
    }

    @Override
    float getWidth(BlockProperties bp) {
        float width = 0.0f;
        try {
            IGDColMap colmap = this.block.well.getInterp(this.interpID).getColMap(this.block.well.getWellID(), this.igdType);
            for (int column = 1; column <= colmap.getSize(); ++column) {
                if (this.getIGDList(column).isEmpty() || !this.p.plotCols[column - 1]) continue;
                width += this.p.columnWidth;
            }
        }
        catch (Exception se) {
            System.out.println("Exception getting column map in PanelZones.getWidth: " + se.getMessage());
            se.printStackTrace();
        }
        if (width == 0.0f) {
            width += this.p.columnWidth;
        }
        return width;
    }

    private String roundSampleDepth(double corrDepth, String type) throws SBException {
        String depth = Sample.roundSampleDepth((double)corrDepth, (String)type);
        if (this.block.well.getHeader().getType() == 'O') {
            if ((depth = depth.trim()).charAt(0) == '-') {
                depth = depth.substring(1);
            } else if (!(depth.equals("0.0") || depth.equals("0") || depth.equals("0.00"))) {
                depth = "-" + depth;
            }
        }
        return depth;
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        IGDColMap colmap = this.block.well.getAddInterp(this.db.getInterp(this.interpID)).getColMap(this.block.well.getWellID(), this.igdType);
        this.drawZones = new LinkedList();
        LinkedList<String> titles = new LinkedList<String>();
        if (this.getIGDList().isEmpty()) {
            this.block.well.getInterp(this.interpID).loadZones(this.igdType, this.block.well);
        }
        for (int column = 1; column <= colmap.getSize(); ++column) {
            if (this.getIGDList(column).isEmpty() || !this.p.plotCols[column - 1]) continue;
            ListIterator<IGDIntervalZone> it = this.getIGDList(column).listIterator();
            LinkedList<DrawZone> intervalList = new LinkedList<DrawZone>();
            float lastBot = 0.0f;
            double lastBaseDepth = 0.0;
            while (it.hasNext()) {
                IGDIntervalZone zone = it.next();
                double topSampleDepth = this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseSampleDepth = this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (!(baseSampleDepth >= (double)this.block.getTopDepth()) || !(topSampleDepth <= (double)this.block.getBaseDepth())) continue;
                double topDepth = Math.max(topSampleDepth, (double)this.block.getTopDepth());
                double baseDepth = Math.min(baseSampleDepth, (double)this.block.getBaseDepth());
                float yTop = this.block.scaleDepth((float)topDepth);
                float yBot = this.block.scaleDepth((float)baseDepth);
                Color colour = Color.WHITE;
                IGDScheme scheme = this.db.getIGDScheme(zone.getSchID());
                if (zone.getUppZone() > 0 && this.p.useColours) {
                    scheme.loadUnits();
                    IGDUnit unit = scheme.findUnit(zone.getUppZone());
                    if (unit != null) {
                        colour = unit.getColour();
                    }
                }
                Color colour2 = null;
                if (zone.getLowZone() > 0 && this.p.useColours) {
                    scheme.loadUnits();
                    IGDUnit unit = scheme.findUnit(zone.getLowZone());
                    if (unit != null) {
                        colour2 = unit.getColour();
                    }
                }
                double baseSampleDepthDisplayUnits = SB.convFromM((double)baseSampleDepth, (char)this.block.prop.units);
                double topSampleDepthDisplayUnits = SB.convFromM((double)topSampleDepth, (char)this.block.prop.units);
                String baseString = null;
                if (it.hasNext()) {
                    IGDIntervalZone nextZone = it.next();
                    if (nextZone.getTopSample() != zone.getBaseSample()) {
                        baseString = this.roundSampleDepth(baseSampleDepthDisplayUnits, zone.getBaseSample().getTypeString());
                    }
                    it.previous();
                } else {
                    baseString = this.roundSampleDepth(baseSampleDepthDisplayUnits, zone.getBaseSample().getTypeString());
                }
                DrawZone drawZone = new DrawZone(yTop, yBot, colour, colour2, zone.getTopBndInt(), zone.getBaseBndInt(), zone.toString(this.p.useAbrs), zone.toVertString(this.p.useAbrs), this.roundSampleDepth(topSampleDepthDisplayUnits, zone.getTopSample().getTypeString()), baseString, topSampleDepth, baseSampleDepth);
                drawZone.o = zone;
                intervalList.add(drawZone);
                if ((double)Math.abs(yTop - lastBot) > 0.1) {
                    intervalList.add(new DrawZone(lastBot, yTop, null, null, -1, -1, null, null, null, null, lastBaseDepth, topSampleDepth));
                }
                lastBot = yBot;
                lastBaseDepth = baseSampleDepth;
            }
            float baseY = this.block.scaleDepth(this.block.getBaseDepth());
            if (lastBot == 0.0f) {
                lastBot = this.block.scaleDepth(this.block.getTopDepth());
                lastBaseDepth = this.block.getTopDepth();
            }
            if ((double)Math.abs(baseY - lastBot) > 0.1) {
                float tvdMax;
                intervalList.add(new DrawZone(lastBot, baseY, null, null, -1, -1, null, null, null, null, lastBaseDepth, this.block.getBaseDepth()));
                if (this.block.prop.scaleType == BlockProperties.ScaleType.TVD && (double)Math.abs(baseY - (tvdMax = this.block.scaleTVD(this.block.prop.max))) > 0.1) {
                    intervalList.add(new DrawZone(baseY, tvdMax, Color.WHITE, Color.WHITE, 3, 3, "Unknown TVD", null, null, null, -1.0, -1.0));
                }
            }
            if (sections != null && sections.length > 2) {
                intervalList = PanelZones.divideDrawZones(intervalList, sections);
            }
            this.drawZones.add(intervalList);
            titles.add(colmap.getColTitle(column));
        }
        this.colTitles = titles.toArray(new String[this.drawZones.size()]);
    }

    static LinkedList<DrawZone> divideDrawZones(LinkedList<DrawZone> intervalList, double[][] sections) {
        LinkedList<DrawZone> modList = new LinkedList<DrawZone>();
        boolean ypos = false;
        boolean ddepth = true;
        for (int j = 1; j < sections.length; ++j) {
            if (Math.abs(sections[j - 1][1] - sections[j][1]) < 0.001) continue;
            for (int k = 0; k < intervalList.size(); ++k) {
                DrawZone dZone = intervalList.get(k);
                if (dZone.baseDepth < sections[j - 1][1] || dZone.topDepth > sections[j][1]) continue;
                if (dZone.topDepth >= sections[j - 1][1] && dZone.baseDepth <= sections[j][1]) {
                    if (Math.abs(dZone.topDepth - sections[j - 1][1]) < 0.01) {
                        dZone.setYTop((float)sections[j - 1][0]);
                    }
                    if (Math.abs(dZone.baseDepth - sections[j][1]) < 0.01) {
                        dZone.setYBase((float)sections[j][0]);
                    }
                    modList.add(dZone);
                    continue;
                }
                if (dZone.topDepth < sections[j - 1][1] && dZone.baseDepth > sections[j][1]) {
                    modList.add(new DrawZone(dZone, (float)sections[j - 1][0], (float)sections[j][0], sections[j - 1][1], sections[j][1]));
                    continue;
                }
                if (dZone.baseDepth > sections[j][1]) {
                    DrawZone newZone = new DrawZone(dZone, dZone.getYTop(), (float)sections[j][0], dZone.topDepth, sections[j][1]);
                    modList.add(newZone);
                    continue;
                }
                modList.add(new DrawZone(dZone, (float)sections[j - 1][0], dZone.getYBase(), sections[j - 1][1], dZone.baseDepth));
            }
        }
        return modList;
    }

    void setDefaultDepthRange() {
        try {
            if (this.block.well.getSamples().size() > 0) {
                this.block.setTopDepth((float)((Sample)this.block.well.getSamples().get(0)).getDepth('M') - 20.0f);
                this.block.setBaseDepth((float)((Sample)this.block.well.getSamples().get(this.block.well.getSamples().size() - 1)).getDepth('M') + 20.0f);
            } else {
                this.block.setTopDepth(0.0f);
                this.block.setBaseDepth((float)this.block.well.getTD());
            }
        }
        catch (Exception se) {
            System.out.println("Warning: top or base sample has null depth");
        }
        this.block.getHeight();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && (arg instanceof IGDIntervalZone && ((IGDIntervalZone)arg).getIGDType() == this.igdType || arg instanceof Integer && (Integer)arg == this.igdType || arg instanceof IGDColMap)) {
            if (arg instanceof IGDColMap) {
                try {
                    this.p.setColumns((IGDColMap)arg);
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    public PanelZonesProperties getProperties() {
        return this.p;
    }

    void setProperties(PanelZonesProperties p) {
        this.p = p;
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        try {
            IGDColMap colmap = this.block.well.getAddInterp(this.db.getInterp(this.interpID)).getColMap(this.block.well.getWellID(), this.igdType);
            if (this.getIGDList().isEmpty()) {
                this.block.well.getInterp(this.interpID).loadZones(this.igdType, this.block.well);
            }
            for (int column = 1; column <= colmap.getSize(); ++column) {
                if (this.getIGDList(column).isEmpty() || !this.p.plotCols[column - 1]) continue;
                ListIterator<IGDIntervalZone> it = this.getIGDList(column).listIterator();
                while (it.hasNext()) {
                    IGDIntervalZone zone = it.next();
                    double topSampleDepth = this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    double baseSampleDepth = this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                    if (!(baseSampleDepth >= (double)this.block.getTopDepth()) || !(topSampleDepth <= (double)this.block.getBaseDepth())) continue;
                    try {
                        ++nSamples;
                        Sample.insert(samples, (Sample)zone.getTopSample(), (char)this.block.prop.units);
                    }
                    catch (SBException sbe) {
                        // empty catch block
                    }
                    if (zone.getTopSample().equals(zone.getBaseSample())) continue;
                    try {
                        ++nSamples;
                        Sample.insert(samples, (Sample)zone.getBaseSample(), (char)this.block.prop.units);
                    }
                    catch (SBException sbe) {}
                }
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return nSamples;
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        String rowString = "";
        Sample sample = samples.get(index);
        try {
            IGDColMap colmap = this.block.well.getAddInterp(this.db.getInterp(this.interpID)).getColMap(this.block.well.getWellID(), this.igdType);
            if (this.getIGDList().isEmpty()) {
                this.block.well.getInterp(this.interpID).loadZones(this.igdType, this.block.well);
            }
            for (int column = 1; column <= colmap.getSize(); ++column) {
                if (this.getIGDList(column).isEmpty() || !this.p.plotCols[column - 1]) continue;
                String colString = "";
                ListIterator<IGDIntervalZone> it = this.getIGDList(column).listIterator();
                boolean inZone = false;
                while (it.hasNext() && !inZone) {
                    IGDIntervalZone zone = it.next();
                    double topSampleDepth = this.block.well.getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    double baseSampleDepth = this.block.well.getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                    if (!(baseSampleDepth >= (double)this.block.getTopDepth()) || !(topSampleDepth <= (double)this.block.getBaseDepth())) continue;
                    if (zone.getTopSample().equals(sample)) {
                        if (!colString.isEmpty()) {
                            colString = colString.substring(0, colString.lastIndexOf("<")) + "<br>";
                            colString = colString + (this.p.drawBndDepths ? zone.getTopSample().toString(this.block.prop.units, false, false) + (zone.isSpotZone() ? "" : " - " + zone.getBaseSample().toString(this.block.prop.units, false, false)) + "<br>" : "");
                            colString = colString + zone.toString(this.p.useAbrs) + "</td>";
                            break;
                        }
                        Color colour = Color.WHITE;
                        IGDScheme scheme = this.db.getIGDScheme(zone.getSchID());
                        if (zone.getUppZone() > 0 && this.p.useColours) {
                            scheme.loadUnits();
                            IGDUnit unit = scheme.findUnit(zone.getUppZone());
                            if (unit != null) {
                                colour = unit.getColour();
                            }
                        }
                        colString = colour != Color.WHITE ? colString + "<td bgcolor=" + PanelZones.getHexColour(colour) : colString + "<td";
                        if (zone.isSpotZone()) {
                            colString = colString + ">";
                        } else {
                            int rowSpan = 0;
                            Sample nextSample = null;
                            ListIterator<Sample> sampleIt = samples.listIterator(index);
                            while (sampleIt.hasNext() && (nextSample == null || nextSample != zone.getBaseSample())) {
                                nextSample = (Sample)sampleIt.next();
                                ++rowSpan;
                            }
                            colString = colString + " " + PanelZones.getHTMLRowspan(rowSpan - 1) + ">";
                        }
                        colString = colString + (this.p.drawBndDepths ? zone.getTopSample().toString(this.block.prop.units, false, false) + (zone.isSpotZone() ? "" : " - " + zone.getBaseSample().toString(this.block.prop.units, false, false)) + "<br>" : "");
                        colString = colString + zone.toString(this.p.useAbrs) + "</td>";
                        continue;
                    }
                    if (samples.indexOf(zone.getTopSample()) >= index || samples.indexOf(zone.getBaseSample()) <= index) continue;
                    inZone = true;
                    break;
                }
                if (colString.isEmpty() && !inZone) {
                    colString = colString + "<td></td>";
                }
                rowString = rowString + colString;
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return rowString;
    }

    @Override
    int getColSpan() {
        return this.colTitles.length;
    }

    @Override
    String getSubCaptionString() {
        if (this.colTitles.length > 1) {
            return "<th colspan=\"" + this.colTitles.length + "\">" + this.getSubCaption() + "</th>";
        }
        return super.getSubCaptionString();
    }

    @Override
    String getSubHeaderString() {
        String hdrs = "";
        for (int i = 0; i < this.colTitles.length; ++i) {
            hdrs = hdrs + "<td>" + this.colTitles[i] + "</td>";
        }
        return hdrs;
    }

    @Override
    public int getType() {
        try {
            return IGDInterval.igdType2dType((int)this.igdType);
        }
        catch (SBException sbe) {
            return -1;
        }
    }

    @Override
    int getIdentifier() {
        return this.interpID;
    }

    public int getSchID() {
        return 0;
    }
}

