/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.StringTokenizer;
import jsbugs.PanelProperties;
import model2.IGDColMap;
import model2.Lastval;
import model2.SBdb;
import util.SB;
import util.SBException;

public class PanelZonesProperties
implements PanelProperties {
    private static final String KEY = "PANZONESP";
    boolean[] plotCols;
    float columnWidth = 40.0f;
    boolean drawBndDepths = true;
    boolean useAbrs = false;
    boolean useColours = true;
    boolean vertPref = false;

    PanelZonesProperties(SBdb sbdb, IGDColMap map) {
        try {
            this.decode(sbdb);
            this.setColumns(map);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    final void setColumns(IGDColMap map) throws SBException {
        if (this.plotCols == null) {
            this.plotCols = new boolean[map.getSize()];
            for (int i = 0; i < this.plotCols.length; ++i) {
                this.plotCols[i] = true;
            }
        } else if (map.getSize() != this.plotCols.length) {
            boolean[] temp = new boolean[map.getSize()];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = i < this.plotCols.length ? this.plotCols[i] : true;
            }
            this.plotCols = temp;
        }
    }

    PanelZonesProperties(PanelZonesProperties rhs) {
        this.plotCols = rhs.plotCols;
        this.columnWidth = rhs.columnWidth;
        this.drawBndDepths = rhs.drawBndDepths;
        this.useAbrs = rhs.useAbrs;
        this.useColours = rhs.useColours;
        this.vertPref = rhs.vertPref;
    }

    private void decode(SBdb sbdb) throws SQLException {
        String params = Lastval.getString((SBdb)sbdb, (String)KEY);
        if (params.isEmpty()) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(params, "|");
        if (tok.hasMoreTokens()) {
            this.columnWidth = Float.parseFloat(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            boolean bl = this.drawBndDepths = Integer.parseInt(tok.nextToken()) == 1;
        }
        if (tok.hasMoreTokens()) {
            boolean bl = this.useAbrs = Integer.parseInt(tok.nextToken()) == 1;
        }
        if (tok.hasMoreTokens()) {
            boolean bl = this.useColours = Integer.parseInt(tok.nextToken()) == 1;
        }
        if (tok.hasMoreTokens()) {
            this.vertPref = Integer.parseInt(tok.nextToken()) == 1;
        }
    }

    void encode(SBdb sbdb) {
        try {
            Lastval.putString((SBdb)sbdb, (String)KEY, (String)this.getPrefs());
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        String string = valuePrefix + this.getPrefs();
        String hiers = "";
        for (int i = 0; i < this.plotCols.length; ++i) {
            if (!hiers.isEmpty()) {
                hiers = hiers + ",";
            }
            hiers = hiers + (this.plotCols[i] ? 1 : 0);
        }
        string = string + hiers;
        Lastval.putString((SBdb)sbdb, (String)key, (String)string);
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.drawBndDepths ? 1 : 0), "" + (this.useAbrs ? 1 : 0), "" + (this.useColours ? 1 : 0), "" + (this.vertPref ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    PanelZonesProperties(SBdb sbdb, IGDColMap map, String prefs) throws SBException {
        String[] s = prefs.split("\\|");
        block8: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block8;
                }
                case 1: {
                    this.drawBndDepths = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 2: {
                    this.useAbrs = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 3: {
                    this.useColours = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 4: {
                    this.vertPref = Integer.parseInt(s[i]) == 1;
                    continue block8;
                }
                case 5: {
                    String[] cols = s[i].split(",");
                    this.plotCols = new boolean[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        this.plotCols[j] = Integer.parseInt(cols[j]) == 1;
                    }
                    continue block8;
                }
            }
        }
        if (this.plotCols == null) {
            this.setColumns(map);
        }
    }
}

