/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;
import javax.swing.JPanel;
import jsbugs.SBPrint;

public class PrintJPanel
extends JPanel
implements Printable {
    List<? extends SBPrint> prints;
    private int pages = 0;
    private int viewPage = 0;
    int width;
    int height;
    double marginLeft;
    double marginRight;
    double marginTop;
    double marginBottom;
    Paper paper;

    public PrintJPanel(List<? extends SBPrint> prints, PageFormat pf) {
        this.prints = prints;
        this.calcnPages(pf);
        this.setDimensions(pf);
    }

    public void setViewPage(int page) {
        this.viewPage = page;
    }

    public void calcnPages(PageFormat pf) {
        this.pages = 0;
        if (pf != null) {
            for (SBPrint sBPrint : this.prints) {
                this.pages += sBPrint.getnPages((int)pf.getImageableHeight(), (int)pf.getImageableWidth());
            }
        }
    }

    public int getPages() {
        return this.pages;
    }

    public void setDimensions(PageFormat pf) {
        this.width = (int)pf.getImageableWidth();
        this.height = (int)pf.getImageableHeight();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int imageWidth = (int)pf.getImageableWidth();
        int imageHeight = (int)pf.getImageableHeight();
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        this.calcnPages(pf);
        if (pageIndex >= this.pages) {
            return 1;
        }
        Point p = this.getItem(pageIndex);
        this.prints.get(p.x).draw(g, 1, 1, imageWidth - 1, imageHeight - 1, p.y);
        return 0;
    }

    private Point getItem(int pageIndex) {
        int item = 0;
        int page = 0;
        for (SBPrint sBPrint : this.prints) {
            int nPages = sBPrint.getnPages(this.height, this.width);
            for (int i = 0; i <= nPages - 1; ++i) {
                if (page == pageIndex) {
                    return new Point(item, i);
                }
                ++page;
            }
            ++item;
        }
        return new Point(-1, -1);
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle thisVisibleRect = this.getVisibleRect();
        g.setColor(Color.WHITE);
        g.fillRect(thisVisibleRect.x, thisVisibleRect.y, thisVisibleRect.width, thisVisibleRect.height);
        int margin = 5;
        g.setColor(Color.BLACK);
        Point p = this.getItem(this.viewPage);
        this.prints.get(p.x).draw(g, thisVisibleRect.x + margin, thisVisibleRect.y + margin, this.width, this.height, p.y);
    }
}

