/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Iterator;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelDepth;
import jsbugs.PanelEnv;
import jsbugs.PanelWellDepthAge;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Project;
import model2.SBdb;

public class ProjectBlock
extends WellBlock {
    private Project project;

    public ProjectBlock(Project project, SBdb sbdb, BlockProperties bp) {
        super(null, sbdb);
        this.project = project;
        if (bp != null) {
            this.prop = bp;
        }
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode) {
        return this.drawPanels(g, x, y, p, mode);
    }

    @Override
    void addPanel(SBPanel panel) {
        if (!(panel instanceof PanelWellDepthAge || panel instanceof PanelDepth || panel instanceof PanelEnv)) {
            throw new IllegalArgumentException("Attempt to add invalid panel type to ProjectBlock.");
        }
        super.addPanel(panel);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    String getPrefKey(int temp_id) {
        return ProjectBlock.getPrefKey(this.project.getID(), temp_id);
    }

    @Override
    char getWellType() {
        return this.project.getWellAt(0).getType();
    }

    @Override
    public float getTopDepth() {
        return this.prop.min;
    }

    @Override
    public float getBaseDepth() {
        return this.prop.max;
    }

    float drawHorz(SBGraphics g, float x, float y, ChartProperties p) {
        this.getHeight();
        Iterator it = this.panels.iterator();
        float yPos = y;
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            yPos += panel.drawHorz(g, x, yPos, p, this.prop);
        }
        return x;
    }
}

