/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import model2.SBEvent;
import model2.Taxon;
import util.SB;

class SBEventsTableModel
extends AbstractTableModel {
    private List<SBEvent> events = null;
    static final int COLTYPE = 0;
    static final int COLNAME = 1;
    static final int COLTAXON = 2;
    static final int COLDISC = 3;
    static final int COLGENERATE = 4;
    static String[] columnHeaders = new String[]{"Type", "Name", "Taxon", "Disc.", "Use to gen. top/base?"};
    static int[] columnWidths = new int[]{30, 180, 180, 30, 20};

    SBEventsTableModel() {
    }

    void setEvents(List<SBEvent> events) {
        Collections.sort(events);
        this.events = events;
    }

    List<SBEvent> getEvents() {
        return this.events;
    }

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    public void setSize(int i) {
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.events == null) {
            return;
        }
        SBEvent event = this.events.get(row);
        switch (col) {
            default: {
                return;
            }
            case 4: 
        }
        if (event.getTaxon() != null) {
            try {
                event.setGenerate(((Boolean)obj).booleanValue());
                this.events.get(row).getDatabase().commit();
            }
            catch (SBEvent.GenerateUniqueException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Update generate flag", 2);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.events.get(row).getDatabase());
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return "";
        }
        try {
            switch (col) {
                default: {
                    return "";
                }
                case 0: {
                    if (this.events.get(row).isSingle()) {
                        return "Single";
                    }
                    return "Paired";
                }
                case 1: {
                    return this.events.get(row).getName();
                }
                case 2: {
                    return this.events.get(row).getTaxon();
                }
                case 3: {
                    return this.events.get(row).getTaxon() != null ? this.events.get(row).getTaxon().getDisc().getAbr(true) : "";
                }
                case 4: 
            }
            return this.events.get(row).isGenerate();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 2: {
                return Taxon.class;
            }
            case 4: 
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        switch (c) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            columnModel.getColumn(i).setHeaderValue(columnHeaders[i]);
            columnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
    }
}

