/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import model2.IGDIntervalZone;
import org.apache.fop.svg.PDFGraphics2D;
import util.TextStroke;

public class SBGraphics {
    private static boolean DEBUG = false;
    static final float scale = 100.0f;
    Graphics2D g;
    Rectangle visibleRect = null;
    Rectangle2D.Float visibleRectMM = null;
    Shape clip = null;
    static final int ALIGN_CENTRE = 0;
    static final int ALIGN_LEFT = 1;
    static final int ALIGN_RIGHT = 2;

    public SBGraphics(Graphics2D g, Rectangle visibleRect, boolean antialias, boolean onScreen) {
        this.g = g;
        this.visibleRect = visibleRect;
        if (visibleRect != null) {
            this.visibleRectMM = new Rectangle2D.Float((float)visibleRect.x / SBGraphics.getScale(), (float)visibleRect.y / SBGraphics.getScale(), (float)visibleRect.width / SBGraphics.getScale(), (float)visibleRect.height / SBGraphics.getScale());
        }
        if (antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private static float getScale() {
        return 100.0f;
    }

    void setColor(Color color) {
        this.g.setColor(color);
    }

    void setColorContrasting(Color baseColor) {
        int newRed = 255 - baseColor.getRed();
        int newGreen = 255 - baseColor.getGreen();
        int newBlue = 255 - baseColor.getBlue();
        this.g.setColor(new Color(newRed, newGreen, newBlue));
    }

    Color getColor() {
        return this.g.getColor();
    }

    void setFont(String name, int style, float size) {
        this.g.setFont(new Font(name, style, (int)(size * SBGraphics.getScale())));
    }

    void setFontSize(float size) {
        Font font = this.getFont();
        this.g.setFont(new Font(font.getName(), font.getStyle(), (int)(size * SBGraphics.getScale())));
    }

    void setFontStyle(int style) {
        this.g.setFont(this.getFont().deriveFont(style));
    }

    void setFont(Font font) {
        this.g.setFont(font);
    }

    Font getFont() {
        return this.g.getFont();
    }

    boolean clipLine(Line2D.Float line, float left, float top, float right, float base) {
        boolean drawline = this.clipLine2(line, left, base, right, top);
        if (drawline) {
            float tempX1 = line.x1;
            float tempY1 = line.y1;
            line.x1 = line.x2;
            line.y1 = line.y2;
            line.x2 = tempX1;
            line.y2 = tempY1;
            drawline = this.clipLine2(line, left, base, right, top);
            if (drawline) {
                tempX1 = line.x1;
                tempY1 = line.y1;
                line.x1 = line.x2;
                line.y1 = line.y2;
                line.x2 = tempX1;
                line.y2 = tempY1;
            }
        }
        return drawline;
    }

    boolean clipLine2(Line2D.Float line, float tx1, float ty1, float tx2, float ty2) {
        float dy;
        float dx;
        float m;
        float left = Math.min(tx1, tx2);
        float right = Math.max(tx1, tx2);
        float top = Math.min(ty1, ty2);
        float base = Math.max(ty1, ty2);
        if (line.x1 < left) {
            if (line.x2 < left) {
                return false;
            }
            m = line.x2 != line.x1 ? (line.y2 - line.y1) / (line.x2 - line.x1) : 0.0f;
            line.y1 += m * (left - line.x1);
            line.x1 = left;
        }
        if (line.x1 > right) {
            if (line.x2 > right) {
                return false;
            }
            m = line.x2 != line.x1 ? (line.y2 - line.y1) / (line.x2 - line.x1) : 0.0f;
            line.y1 += m * (right - line.x1);
            line.x1 = right;
        }
        if (line.y1 < top) {
            if (line.y2 < top) {
                return false;
            }
            dx = line.x2 - line.x1;
            dy = line.y2 - line.y1;
            line.x1 += dx / dy * (top - line.y1);
            line.y1 = top;
        }
        if (line.y1 > base) {
            if (line.y2 > base) {
                return false;
            }
            dx = line.x2 - line.x1;
            dy = line.y2 - line.y1;
            line.x1 += dx / dy * (base - line.y1);
            line.y1 = base;
        }
        return true;
    }

    static void appendLine(GeneralPath p, float x1, float y1, float x2, float y2) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        p.lineTo(ix1, iy1);
        p.lineTo(ix2, iy2);
    }

    static void appendLine(GeneralPath p, float x, float y) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.lineTo(ix, iy);
    }

    static void appendMove(GeneralPath p, float x, float y) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.moveTo(ix, iy);
    }

    void appendEllipse(GeneralPath p, float x, float y, float w, float h, boolean connect) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iw = (int)(w * SBGraphics.getScale());
        int ih = (int)(h * SBGraphics.getScale());
        p.append(new Ellipse2D.Float(ix, iy, iw, ih), connect);
    }

    void appendRect(GeneralPath p, float x, float y, float w, float h, boolean connect) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iw = (int)(w * SBGraphics.getScale());
        int ih = (int)(h * SBGraphics.getScale());
        p.append(new Rectangle2D.Float(ix, iy, iw, ih), connect);
    }

    void drawLine(float x1, float y1, float x2, float y2) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(Math.min(ix1, ix2), Math.min(iy1, iy2), Math.abs(ix2 - ix1) + 1, Math.abs(iy2 - iy1) + 1))) {
            this.g.drawLine(ix1, iy1, ix2, iy2);
        }
    }

    void drawLine(Line2D.Float line) {
        float x1 = line.x1;
        float y1 = line.y1;
        float x2 = line.x2;
        float y2 = line.y2;
        this.drawLine(x1, y1, x2, y2);
    }

    static GeneralPath createGeneralPath(float x, float y) {
        GeneralPath p = new GeneralPath();
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.moveTo(ix, iy);
        return p;
    }

    Rectangle createRect(float x, float y, float width, float height) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iwidth = (int)(width * SBGraphics.getScale());
        int iheight = (int)(height * SBGraphics.getScale());
        return new Rectangle(ix, iy, iwidth, iheight);
    }

    private Shape getTextShape(String str, int x, int y) {
        FontRenderContext frc = this.g.getFontRenderContext();
        TextLayout tl = new TextLayout(str, this.g.getFont(), frc);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(x, y);
        return tl.getOutline(at);
    }

    Shape appendBnd(GeneralPath p, int bnd, float x1, float x2, float y1, float y2) {
        Shape s = null;
        float midx = x2 > x1 ? x1 + Math.abs(x1 - x2) / 2.0f : x1 - Math.abs(x1 - x2) / 2.0f;
        switch (bnd) {
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                SBGraphics.appendLine(p, x2, y2);
                break;
            }
            case 1: 
            case 2: {
                Line2D.Float line = new Line2D.Float((int)(x1 * SBGraphics.getScale()), (int)(y1 * SBGraphics.getScale()), (int)(x2 * SBGraphics.getScale()), (int)(y2 * SBGraphics.getScale()));
                s = this.getStroke().createStrokedShape(line);
                SBGraphics.appendMove(p, x2, y2);
                break;
            }
            case 4: {
                this.appendUnconf(p, x1, x2, y2, false, false, false, false);
                break;
            }
            case 5: {
                s = this.appendUnconf(p, x1, x2, y2, true, false, false, false);
            }
        }
        if (IGDIntervalZone.isFaultBnd((int)bnd)) {
            float w1 = 0.8f;
            float w2 = 0.16f;
            float w3 = 3.5f;
            float h = 1.75f;
            GeneralPath gp = new GeneralPath();
            switch (bnd) {
                case 7: {
                    Font font = this.g.getFont();
                    this.setFont(font.getName(), font.getStyle(), 2.0f);
                    gp.append(this.getTextShape("?", (int)((midx - 2.0f) * SBGraphics.getScale()), (int)((y2 - 0.3f) * SBGraphics.getScale())), false);
                    this.setFont(font);
                }
                case 6: {
                    this.appendEllipse(gp, midx - 0.4f, y2 - 1.75f, 0.8f, 0.8f, false);
                    this.appendRect(gp, midx - 0.08f, y2 - 1.75f + 0.4f, 0.16f, 1.35f, false);
                    break;
                }
                case 8: {
                    this.appendRect(gp, midx - 1.75f, y2 - 0.7f, 3.5f, 0.7f, false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            s = gp;
        }
        return s;
    }

    Shape appendUnconf(GeneralPath p, float x1, float x2, float y, boolean q, boolean flatStart, boolean flatEnd, boolean forceUp) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        boolean leftToRight = ix2 > ix1;
        int amp = (int)(1.3 * (double)SBGraphics.getScale());
        GeneralPath qs = null;
        Font font = null;
        if (q) {
            font = this.g.getFont();
            this.g.setFont(new Font(font.getName(), font.getStyle(), amp));
            qs = new GeneralPath();
        }
        int wavelength = (int)(2.25 * (double)SBGraphics.getScale());
        int space = Math.max(ix1, ix2) - Math.min(ix1, ix2);
        int tempNWaves = space / wavelength;
        int nWaves = (int)Math.floor(tempNWaves);
        if (nWaves > 0) {
            wavelength = space / nWaves;
            if (flatStart) {
                --nWaves;
            }
            if (flatEnd) {
                --nWaves;
            }
            boolean above = false;
            if (nWaves % 2 == 0 && !leftToRight) {
                above = true;
            }
            if (forceUp && nWaves % 2 != 0) {
                above = !above;
            }
            int start = ix1;
            int wavesDrawn = 0;
            if (flatStart) {
                p.lineTo(leftToRight ? (float)(start + wavelength) : (float)(start - wavelength), iy);
                start += leftToRight ? wavelength : -wavelength;
            }
            if (leftToRight) {
                int end = start + wavelength;
                while (wavesDrawn < nWaves) {
                    p.curveTo(start, iy, start + (end - start) / 2, above ? iy - amp : iy + amp, end, iy);
                    if (!above && q) {
                        qs.append(this.getTextShape("?", start + (int)((double)(end - start) / 2.75), iy + amp / 5), false);
                    }
                    start = end;
                    end = start + wavelength;
                    above = !above;
                    ++wavesDrawn;
                }
            } else {
                int end = start - wavelength;
                while (wavesDrawn < nWaves) {
                    p.curveTo(start, iy, start - (start - end) / 2, above ? iy - amp : iy + amp, end, iy);
                    if (!above && q) {
                        qs.append(this.getTextShape("?", start - (int)((double)(start - end) / 1.5), iy + amp / 5), false);
                    }
                    start = end;
                    end = start - wavelength;
                    above = !above;
                    ++wavesDrawn;
                }
            }
            if (font != null) {
                this.g.setFont(font);
            }
        } else if (DEBUG) {
            System.out.println("nWaves was 0");
        }
        if (flatEnd) {
            p.lineTo(ix2, iy);
        }
        return qs;
    }

    void drawUnconf(float x1, float y1, float x2, float y2, boolean drawQ, float wavelength) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float zlen = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        float znor = zlen / wavelength;
        znor = (int)((double)znor + 1.0);
        float rads = znor * 2.0f * (float)Math.PI;
        int sampleRate = 1;
        int nsamps = (int)rads * sampleRate;
        float xinc = (x2 - x1) / (float)nsamps;
        float yinc = (y2 - y1) / (float)nsamps;
        float zinc = rads / (float)nsamps;
        float zoff = 0.0f;
        float tw = 0.0f;
        float th = 0.0f;
        if (drawQ) {
            th = this.stringHeight();
            tw = this.stringWidth("?");
        }
        boolean drawNextQ = false;
        float theta = (double)Math.abs(x2 - x1) > 0.0 ? (float)Math.atan((y2 - y1) / (x2 - x1)) : 1.5707964f;
        for (int j = 0; j < nsamps; ++j) {
            if (j == 0) {
                x = x1;
                y = y1;
                z = 0.0f;
            } else {
                x += xinc;
                y += yinc;
                z += zinc;
            }
            float exzoff = zoff;
            zoff = (float)Math.sin(z) * 0.5f;
            float xp = x - (float)((double)zoff * Math.sin(theta));
            float yp = y + (float)((double)zoff * Math.cos(theta));
            if (lastX > 0.0f) {
                this.drawLine(lastX, lastY, xp, yp);
            }
            lastX = xp;
            lastY = yp;
            if (!drawQ) continue;
            if ((double)zoff < 0.0) {
                drawNextQ = true;
                continue;
            }
            if (!drawNextQ || !(zoff > exzoff)) continue;
            this.drawString("?", xp + 0.5f * tw, yp - th);
            drawNextQ = false;
        }
    }

    void setStroke(float size) {
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), 0, 0));
    }

    void setStroke(float size, int butt, int join) {
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), butt, join));
    }

    void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    BasicStroke getStroke() {
        return (BasicStroke)this.g.getStroke();
    }

    void setDashStroke(float width) {
        float[] dash = new float[]{width * 1.6f * SBGraphics.getScale(), width * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(width * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    void setDashStroke(float width, float size) {
        float[] dash = new float[]{size * SBGraphics.getScale(), size * 0.75f * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(width * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    void setDotStroke(float size) {
        float[] dash = new float[]{size * SBGraphics.getScale(), size * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    void drawString(String string, float x, float y) {
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)((y - this.stringHeightSB()) * SBGraphics.getScale()), (int)(this.stringWidth(string) * SBGraphics.getScale()), (int)(this.stringHeight() * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.g.drawString(string, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    void drawString(String string, float x, float y, float width, int alignment) {
        if ((string = this.truncateString(string, width)) != null && !string.isEmpty()) {
            float xPos;
            Object origFont = null;
            Object layout = null;
            switch (alignment) {
                case 0: {
                    xPos = (x + width / 2.0f - this.stringWidth(string) / 2.0f) * SBGraphics.getScale();
                    break;
                }
                case 2: {
                    xPos = x * SBGraphics.getScale() - this.stringWidth(string) * SBGraphics.getScale();
                    break;
                }
                default: {
                    this.drawString(string, x, y);
                    return;
                }
            }
            Rectangle rect = new Rectangle((int)xPos, (int)((y - this.stringHeightSB()) * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(this.stringHeight() * SBGraphics.getScale()));
            if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
                this.g.drawString(string, xPos, y * SBGraphics.getScale());
            }
        }
    }

    float drawStringBox(String string, float x, float y, float width, float height, int alignment) {
        float ypos = y + (float)this.getFont().getSize() / SBGraphics.getScale();
        if (this.stringWidth(string) < width) {
            this.drawString(string, x, ypos, width, alignment);
            return ypos + 0.5f;
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringTokenizer tokeniser = new StringTokenizer(string, " ");
        String text = "";
        while (tokeniser.hasMoreTokens()) {
            String tok = tokeniser.nextToken();
            StringBuilder stringBuilder = new StringBuilder();
            if (this.stringWidth(stringBuilder.append(text).append(tok).toString()) < width) {
                text = text + tok + ' ';
                continue;
            }
            if (this.stringWidth(tok) < width) {
                lines.add(text.trim());
                text = tok + ' ';
                continue;
            }
            text = this.addStringLine(lines, text + tok, width);
        }
        if (!text.isEmpty()) {
            lines.add(text.trim());
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            float nextypos = ypos + (float)this.getFont().getSize() / SBGraphics.getScale() + 0.5f;
            if (nextypos > y + height && i < lines.size() - 1) {
                line = line + "...";
            }
            this.drawString(line, x, ypos, width, alignment);
            ypos = nextypos;
            if (ypos > y + height) break;
        }
        return ypos;
    }

    private String addStringLine(List<String> lines, String strg, float width) {
        if (this.stringWidth(strg) < width) {
            return strg + ' ';
        }
        String trunc = strg.substring(0, strg.length() - 1) + '-';
        while (this.stringWidth(trunc) > width && trunc.length() > 1) {
            trunc = trunc.substring(0, trunc.length() - 2) + '-';
        }
        if (trunc.length() > 1) {
            lines.add(trunc);
            return this.addStringLine(lines, strg.substring(trunc.length() - 1), width);
        }
        lines.add("..");
        return "";
    }

    void drawString(AttributedString string, float x, float y, float maxWidth) {
        String strg = "";
        AttributedCharacterIterator it = string.getIterator();
        strg = strg + it.first();
        for (int i = it.getBeginIndex(); i < it.getEndIndex() - 1; ++i) {
            strg = strg + it.next();
        }
        it.setIndex(it.getBeginIndex());
        float width = this.stringWidth(strg) * SBGraphics.getScale();
        float height = this.stringHeight() * SBGraphics.getScale();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)width, (int)height);
        if ((this.visibleRect == null || this.visibleRect.intersects(rect)) && (it = this.truncateString(it, string, strg, maxWidth)) != null) {
            this.g.drawString(it, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    void drawStringVertical(String string, float x, float y, float maxHeight, boolean centre, boolean vertCentre) {
        float height = this.stringWidth(string) * SBGraphics.getScale();
        float width = this.stringHeight() * SBGraphics.getScale();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            if ((string = this.truncateString(string, maxHeight)) == null) {
                return;
            }
            if (centre) {
                x += this.stringHeightSB() / 2.0f;
            }
            if (vertCentre) {
                y = y - maxHeight / 2.0f + this.stringWidth(string) / 2.0f;
            }
            AffineTransform fontAT = new AffineTransform();
            Font font = this.g.getFont();
            fontAT.rotate(-1.5707963267948966);
            Font derivedFont = font.deriveFont(fontAT);
            this.g.setFont(derivedFont);
            this.g.drawString(string, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.setFont(font);
        }
    }

    private String truncateString(String string, float maxWidth) {
        if (string.isEmpty()) {
            return string;
        }
        float width = this.calcStringWidth(string);
        if (width > maxWidth) {
            block3: {
                do {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(this.calcStringWidth(stringBuilder.append(string).append("...").toString()) > maxWidth - 2.0f)) break block3;
                    if (string.length() >= 2) continue;
                    return null;
                } while (!(string = string.substring(0, string.length() - 1)).isEmpty());
                return "";
            }
            string = string.trim() + "...";
        }
        return string;
    }

    private float calcStringWidth(String string) {
        return this.stringWidth(string);
    }

    void drawStringAngleCentre(String string, float x, float y, double angle, double transX, double transY) {
        float width = this.g.getFontMetrics().stringWidth(string);
        if (angle != 0.0) {
            this.g.rotate(angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
        if (transX != 0.0 || transY != 0.0) {
            this.g.translate(transX * (double)SBGraphics.getScale(), transY * (double)SBGraphics.getScale());
        }
        this.g.drawString(string, x * SBGraphics.getScale() - width / 2.0f, y * SBGraphics.getScale());
        if (transX != 0.0 || transY != 0.0) {
            this.g.translate(-transX * (double)SBGraphics.getScale(), -transY * (double)SBGraphics.getScale());
        }
        if (angle != 0.0) {
            this.g.rotate(-angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    void rotate(double angle, float x, float y) {
        this.g.rotate(angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
    }

    void drawStringVertical(String string, float x, float y) {
        float height = this.stringWidth(string);
        float width = this.stringHeight();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.g.rotate(-1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.drawString(string, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.rotate(1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    void drawStringVertical(AttributedString string, float x, float y, float maxHeight) {
        String strg = "";
        AttributedCharacterIterator it = string.getIterator();
        strg = strg + it.first();
        for (int i = it.getBeginIndex(); i < it.getEndIndex() - 1; ++i) {
            strg = strg + it.next();
        }
        it.setIndex(it.getBeginIndex());
        float height = this.stringWidth(strg) * SBGraphics.getScale();
        float width = this.stringHeight() * SBGraphics.getScale();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        if ((this.visibleRect == null || this.visibleRect.intersects(rect)) && (it = this.truncateString(it, string, strg, maxHeight)) != null) {
            this.g.rotate(-1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.drawString(it, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.rotate(1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    void drawString(String string, Point2D point1, Point2D point2) {
        Point2D p2;
        Point2D p1;
        if (point1.getY() < point2.getY()) {
            p1 = point1;
            p2 = point2;
        } else {
            p1 = point2;
            p2 = point1;
        }
        double xpos = Math.min(p1.getX(), p2.getX()) + Math.abs(p1.getX() - p2.getX()) / 2.0 + 1.0;
        double ypos = p1.getY() + (p2.getY() - p1.getY()) / 2.0;
        if (Math.abs(p1.getY() - p2.getY()) < 1.0) {
            xpos -= (double)(this.stringWidth(string) / 2.0f);
            ypos += (double)(this.stringHeight() + 1.0f);
        } else if (Math.abs(p1.getX() - p2.getX()) < 1.0) {
            ypos += (double)(this.stringHeight() / 2.0f);
        } else if (p1.getX() > p2.getX()) {
            ypos += (double)this.stringHeight();
        }
        this.g.drawString(string, (float)xpos * SBGraphics.getScale(), (float)ypos * SBGraphics.getScale());
    }

    private AttributedCharacterIterator truncateString(AttributedCharacterIterator atIt, AttributedString atString, String string, float maxWidth) {
        float width = this.stringWidth(string);
        if (width > maxWidth) {
            while (this.stringWidth(string) > maxWidth - 2.0f) {
                if (string.length() < 1) {
                    return null;
                }
                if (!(string = string.substring(0, string.length() - 1)).isEmpty()) continue;
                return null;
            }
        }
        return atString.getIterator(null, 0, string.length());
    }

    boolean drawStringBox(String string, float left, float top, float width, float height, boolean vertical) {
        Rectangle2D stringRect = this.g.getFontMetrics().getStringBounds(string, this.g);
        Rectangle2D.Float bound = new Rectangle2D.Float(left * SBGraphics.getScale(), top * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        if (this.visibleRect == null || this.visibleRect.intersects(bound)) {
            if (vertical) {
                if (((RectangularShape)bound).getHeight() >= stringRect.getWidth() && ((RectangularShape)bound).getWidth() >= stringRect.getHeight()) {
                    this.g.rotate(-1.5707963267948966, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    this.g.drawString(string, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    this.g.rotate(1.5707963267948966, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    return true;
                }
                return false;
            }
            if (((RectangularShape)bound).getWidth() >= stringRect.getWidth() && ((RectangularShape)bound).getHeight() >= stringRect.getHeight()) {
                this.g.drawString(string, (float)(bound.getCenterX() - stringRect.getWidth() / 2.0), (float)(bound.getCenterY() + stringRect.getHeight() / 3.0));
                return true;
            }
            return false;
        }
        return true;
    }

    boolean drawStringBox(String string, float left, float top, float width, float height, boolean verticalPreferred, boolean verticalAllowed, int nIts) {
        return this.drawStringBox(string, null, left, top, width, height, verticalPreferred, verticalAllowed, nIts);
    }

    boolean drawStringBox(String string, String vertString, float left, float top, float width, float height, boolean verticalPreferred, boolean verticalAllowed, int nIts) {
        Rectangle2D.Float bound = new Rectangle2D.Float(left * SBGraphics.getScale(), top * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        float fontSize = (float)this.getFont().getSize() / SBGraphics.getScale();
        if (this.visibleRect == null || this.visibleRect.intersects(bound)) {
            boolean fitsVert = false;
            boolean fitsHorz = false;
            for (int i = 0; i < nIts; ++i) {
                Rectangle2D stringRect = this.g.getFontMetrics().getStringBounds(vertString != null && verticalPreferred ? vertString : string, this.g);
                if (stringRect.getWidth() < ((RectangularShape)bound).getHeight() && stringRect.getHeight() < ((RectangularShape)bound).getWidth()) {
                    fitsVert = true;
                }
                if (stringRect.getWidth() < ((RectangularShape)bound).getWidth() && stringRect.getHeight() < ((RectangularShape)bound).getHeight()) {
                    fitsHorz = true;
                }
                if (fitsVert && (verticalPreferred || !fitsHorz && verticalAllowed)) {
                    this.drawStringVertical(vertString != null ? vertString : string, left + width / 2.0f, top + height, height, true, true);
                    return true;
                }
                if (fitsHorz) {
                    this.drawString(string, left, top + height / 2.0f + this.stringHeightSB() / 2.0f, width, 0);
                    return true;
                }
                this.setFontSize(fontSize -= 0.5f);
            }
        }
        return false;
    }

    String drawString(String string, float x, float y, float width, float height, StringStrategy strategy, int alignment) {
        x *= SBGraphics.getScale();
        y *= SBGraphics.getScale();
        width *= SBGraphics.getScale();
        height *= SBGraphics.getScale();
        boolean horizontal = strategy.preferHorz;
        int action = 0;
        int nSizeChanges = 0;
        int origFontSize = this.getFont().getSize();
        float fontSizeIncrement = 0.5f * SBGraphics.getScale();
        boolean keepTrying = true;
        do {
            Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds(string, this.g);
            double d = stringBounds.getWidth();
            float f = horizontal ? width : height;
            if (d < (double)f) {
                this.drawStringBox(new String[]{string}, x, y, width, height, horizontal, alignment);
                return null;
            }
            String[] wrappedText = null;
            int maxLines = (int)Math.floor((double)(horizontal ? height : width) / stringBounds.getHeight());
            if (maxLines > 1 && (wrappedText = this.wrapText(string, horizontal ? width : height, maxLines, true)).length <= maxLines) {
                this.drawStringBox(wrappedText, x, y, width, height, horizontal, alignment);
                return null;
            }
            switch (strategy.getNextAction(action)) {
                case 1: {
                    if (nSizeChanges < StringStrategy.nIts) {
                        this.setFontSize((float)origFontSize - (float)(nSizeChanges + 1) * fontSizeIncrement);
                        ++nSizeChanges;
                        horizontal = strategy.preferHorz;
                        break;
                    }
                    keepTrying = false;
                    string = wrappedText[wrappedText.length - 1];
                    break;
                }
                case 2: {
                    boolean bl = horizontal = !horizontal;
                    if (!strategy.sizeFirst) break;
                    this.setFontSize((float)this.getFont().getSize() + fontSizeIncrement);
                }
            }
        } while (keepTrying);
        return string;
    }

    private FloatDimension getTextBounds(String[] lines) {
        float maxWidth = 0.0f;
        for (String line : lines) {
            Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds(line, this.g);
            maxWidth = Math.max(maxWidth, (float)stringBounds.getWidth());
        }
        return new FloatDimension(maxWidth, lines.length * this.g.getFontMetrics().getHeight());
    }

    private void drawStringBox(String[] text, float x, float y, float width, float height, boolean horz, int alignment) {
    }

    private String[] wrapText(String string, float width, int maxLines, boolean wholeWords) {
        return null;
    }

    void fillPolygon(float[] x, float[] y, int n, Color fillColor) {
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1))) {
            Color oldColor = this.g.getColor();
            this.g.setColor(fillColor);
            this.g.fillPolygon(ix, iy, n);
            this.g.setColor(oldColor);
            this.g.drawPolygon(ix, iy, n);
        }
    }

    void fillPolygon(float[] x, float[] y, int n) {
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1))) {
            this.g.fillPolygon(ix, iy, n);
        }
    }

    void fillShape(Shape s, Color colour) {
        if (this.visibleRect == null || this.visibleRect.intersects(s.getBounds())) {
            Color c = this.g.getColor();
            this.g.setColor(colour);
            this.g.fill(s);
            this.g.setColor(c);
        }
    }

    void drawShape(Shape s) {
        if (this.visibleRect == null || s.intersects(this.visibleRect)) {
            if (this.g instanceof PDFGraphics2D && this.g.getStroke() instanceof TextStroke) {
                Shape strokeShape = this.g.getStroke().createStrokedShape(s);
                this.g.setStroke(new BasicStroke(1.0f));
                this.g.fill(strokeShape);
            } else {
                this.g.draw(s);
            }
        }
    }

    boolean isVisible(float x, float y, float width, float height) {
        return this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())));
    }

    void drawIntersectingPolygons(float[] x1, float[] y1, float[] x2, float[] y2, int n1, int n2) {
        int[] ix1 = new int[n1];
        int[] iy1 = new int[n1];
        for (int i = 0; i < n1; ++i) {
            ix1[i] = (int)(x1[i] * SBGraphics.getScale());
            iy1[i] = (int)(y1[i] * SBGraphics.getScale());
        }
        int[] ix2 = new int[n2];
        int[] iy2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            ix2[i] = (int)(x2[i] * SBGraphics.getScale());
            iy2[i] = (int)(y2[i] * SBGraphics.getScale());
        }
        Polygon p1 = new Polygon(ix1, iy1, n1);
        Area a1 = new Area(p1);
        Polygon p2 = new Polygon(ix2, iy2, n2);
        Area a2 = new Area(p2);
        a1.intersect(a2);
        this.g.setColor(Color.GREEN);
        this.g.fill(a1);
    }

    void drawPolyline(float[] x, float[] y, int n, boolean visibilityTest) {
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        Rectangle rectangle = new Rectangle(minX, minY, maxX - minX - 1, maxY - minY - 1);
        if (!visibilityTest || this.visibleRect == null || this.visibleRect.intersects(rectangle)) {
            this.g.drawPolyline(ix, iy, n);
        }
    }

    void drawCross(float x, float y, int length) {
        Color color = this.g.getColor();
        this.g.setColor(Color.red);
        this.drawLine(x - (float)length, y, x + (float)length, y);
        this.drawLine(x, y - (float)length, x, y + (float)length);
        this.g.setColor(color);
    }

    float stringWidth(String string) {
        return (float)this.g.getFontMetrics(this.g.getFont()).stringWidth(string) / SBGraphics.getScale();
    }

    static float stringWidth(String string, float fontSize) {
        return (float)string.length() * fontSize * 0.545f;
    }

    float stringHeight() {
        return (float)this.g.getFontMetrics().getHeight() / SBGraphics.getScale();
    }

    float stringHeightSB() {
        return (float)this.g.getFontMetrics().getAscent() / SBGraphics.getScale() - (float)this.g.getFontMetrics().getDescent() / SBGraphics.getScale();
    }

    void fillEllipse(float x, float y, float width, float height, Color fillColor) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            Color oldColor = null;
            if (fillColor != null) {
                oldColor = this.g.getColor();
                this.g.setColor(fillColor);
            }
            this.g.fillOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
            if (fillColor != null) {
                this.g.setColor(oldColor);
                this.g.drawOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
            }
        }
    }

    void drawEllipse(float x, float y, float width, float height) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.drawOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    void drawRect(float x, float y, float width, float height) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.drawRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    void drawArc(float x, float y, float width, float height, int startAngle, int arcAngle) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.drawArc((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()), startAngle, arcAngle);
        }
    }

    void fillRect(float x, float y, float width, float height, Color fillColor) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            if (fillColor != null) {
                Color oldColor = this.g.getColor();
                this.g.setColor(fillColor);
                this.g.fillRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
                this.g.setColor(oldColor);
            }
            this.g.drawRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    void fillRect(float x, float y, float width, float height) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.fillRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    void paintRect(float x, float y, float width, float height, Color topColour, Color baseColour) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            float ix = x * SBGraphics.getScale();
            float iy = y * SBGraphics.getScale();
            float ih = height * SBGraphics.getScale();
            this.g.setPaint(new GradientPaint(ix, iy, topColour, ix, iy + ih, baseColour));
            this.g.fill(new Rectangle2D.Float(ix, iy, width * SBGraphics.getScale(), ih));
        }
    }

    void setClip(float x, float y, float width, float height) {
        if (x == 0.0f && y == 0.0f && width == 0.0f && height == 0.0f) {
            if (this.clip != null) {
                this.g.setClip(this.clip);
            }
            this.clip = null;
            return;
        }
        this.clip = this.g.getClip();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        this.g.clip(rect);
    }

    void setClip(Shape s) {
        if (s == null) {
            if (this.clip != null) {
                this.g.setClip(this.clip);
            }
            this.clip = null;
            return;
        }
        this.clip = this.g.getClip();
        this.g.clip(s);
    }

    void clearClip() {
        this.g.setClip(this.visibleRect);
    }

    public void drawImage(Image img, float x, float y, float width, float height) {
        this.g.drawImage(img, (int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()), null);
    }

    public void translate(float x, float y) {
        this.g.translate((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()));
    }

    void drawTextArea(String string, float x, float y, float width, float height) {
        Rectangle2D stringRect = this.g.getFontMetrics().getStringBounds(string, this.g);
        Rectangle2D.Float bound = new Rectangle2D.Float(x * SBGraphics.getScale(), y * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        JTextArea ta = new JTextArea(string);
        ta.setBounds((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        ta.setVisible(true);
        ta.paint(this.g);
    }

    private class FloatDimension {
        final float width;
        final float height;

        FloatDimension(float width, float height) {
            this.width = width;
            this.height = height;
        }
    }

    static enum StringStrategy {
        HORIZONTAL_PREF(true, true, true, false, "Prefer horizontal", "Plot horizontally as much as possible by wrapping and changing font size before plotting vertically."),
        HORIZONTAL_ALL(true, true, false, false, "Horizontal", "Fit text horizontally by wrapping and changing font size. Never plot vertically."),
        VERTICAL_PREF(true, false, true, false, "Prefer vertical", "Plot vertically as much as possible by wrapping and changing font size before plotting horizonally."),
        SAME_SIZE_PREF(true, true, true, true, "Prefer Consistent size", "Keep font size as consistent as possible, by wrapping then plotting vertically before changing font size."),
        SAME_SIZE_ALL(false, true, true, true, "Consistent size", "Fit text by wrapping and plotting vertically. Never change font size.");

        boolean allowSizeChange;
        boolean preferHorz;
        boolean allowAltOrientation;
        boolean sizeFirst;
        String shortDesc;
        String longDesc;
        static int nIts;
        static final int SIZE = 1;
        static final int ORIENTATION = 2;

        private StringStrategy(boolean allowSizeChange, boolean preferHorz, boolean allowAltOrientation, boolean sizeFirst, String shortDesc, String longDesc) {
            this.allowSizeChange = allowSizeChange;
            this.preferHorz = preferHorz;
            this.allowAltOrientation = allowAltOrientation;
            this.sizeFirst = sizeFirst;
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
        }

        int getNextAction(int currentAction) {
            switch (currentAction) {
                case 0: {
                    if (this.sizeFirst) {
                        return 1;
                    }
                    return 2;
                }
                case 1: {
                    if (this.allowAltOrientation) {
                        return 2;
                    }
                    return 1;
                }
                case 2: {
                    if (this.allowSizeChange) {
                        return 1;
                    }
                    return 2;
                }
            }
            throw new IllegalArgumentException("Unrecognised option type in StringStrategy: " + currentAction);
        }

        static {
            nIts = 3;
        }
    }
}

