/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import javax.swing.ImageIcon;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartPanel;
import jsbugs.ChartProperties;
import jsbugs.PanelProperties;
import jsbugs.SBGraphics;
import model2.SBdb;
import util.SBException;

public abstract class SBPanel
extends Observable
implements ChartPanel {
    static final float BRACKET_BASE = 2.5f;
    private boolean outline = false;
    static final float outlineWeight = 0.875f;
    static final int colourDensity = 85;

    abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, BlockProperties var5, Chart.Mode var6);

    abstract float getWidth(BlockProperties var1);

    abstract Object getObject(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    abstract String getTooltip(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    @Override
    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public boolean isOutline() {
        return this.outline;
    }

    void drawFrame(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, String caption, String subCaption) {
        this.drawFrame(g, x, y, p, bp);
        this.drawCaption(g, x, y, p, bp, caption, subCaption);
    }

    void drawCaption(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, String caption, String subCaption) {
        float fontSize;
        float ypos = y;
        if (caption != null && !caption.isEmpty()) {
            fontSize = cp.fontHeader - 1.0f;
            g.setFont(cp.font, 1, fontSize);
            ypos = g.drawStringBox(caption, x, y, this.getWidth(bp), cp.panelCaptionHeight, 0);
        }
        if (subCaption != null && !subCaption.isEmpty() && cp.panelCaptionHeight - (ypos - y) > (fontSize = cp.fontHeader - 2.0f)) {
            g.setFont(cp.font, 0, fontSize);
            g.drawStringBox(subCaption, x, ypos, this.getWidth(bp), cp.panelCaptionHeight - (ypos - y), 0);
        }
    }

    void drawFrame(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, String caption) {
        this.drawFrame(g, x, y, p, bp);
        if (caption != null && !caption.isEmpty()) {
            float fontSize = p.fontHeader;
            g.setFont(p.font, 1, fontSize);
            g.drawString(caption, x, y + p.panelCaptionHeight / 2.0f + fontSize / 2.0f, this.getWidth(bp), 0);
        }
    }

    private void drawFrame(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
        g.setColor(Color.BLACK);
        g.setStroke(this.outline ? 0.875f : 0.35f);
        Float height = Float.valueOf(bp.height);
        if (height.isNaN()) {
            height = Float.valueOf(0.0f);
        }
        g.drawRect(x, y, this.getWidth(bp), p.getPanelHeaderHeight() + height.floatValue());
        g.setStroke(0.2f);
        g.drawLine(x, y + p.panelCaptionHeight, x + this.getWidth(bp), y + p.panelCaptionHeight);
        g.drawLine(x, y + p.getPanelHeaderHeight(), x + this.getWidth(bp), y + p.getPanelHeaderHeight());
    }

    void drawOutline(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        Float height = Float.valueOf(bp.height);
        if (height.isNaN()) {
            height = Float.valueOf(0.0f);
        }
        g.setColor(Color.BLACK);
        g.setStroke(this.outline ? 0.875f : 0.35f);
        g.drawRect(x, y + SBPanel.getPanelHeaderHeight(p, mode), this.getWidth(bp), height.floatValue());
    }

    void drawSubHeader(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, String subHeader) {
        if (subHeader == null || subHeader.isEmpty()) {
            return;
        }
        g.setFont(p.font, 0, p.fontHeader);
        g.drawStringVertical(subHeader, x + this.getWidth(bp) / 2.0f, y + p.getPanelHeaderHeight() - p.fontHeader, p.panelSubHeaderHeight - p.fontHeader, true, false);
    }

    void drawSubHeader(SBGraphics g, float leftX, float rightX, float y, ChartProperties p, BlockProperties bp, String subHeader) {
        g.setFont(p.font, 0, p.fontHeader);
        g.drawStringVertical(subHeader, leftX + (rightX - leftX) / 2.0f, y + p.getPanelHeaderHeight() - p.fontHeader, p.panelSubHeaderHeight - p.fontHeader, true, false);
    }

    static void moveSamplePositions(int nSamples, float[] samplePosition, float symbolSize, float hSampPosition, float lSampPosition) {
        if (nSamples < 2) {
            if (samplePosition[0] < hSampPosition) {
                samplePosition[0] = hSampPosition;
            }
            if (samplePosition[nSamples - 1] > lSampPosition) {
                samplePosition[nSamples - 1] = lSampPosition;
            }
            return;
        }
        float[] symbolSizes = new float[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            symbolSizes[i] = symbolSize;
        }
        SBPanel.moveSamplePositions(nSamples, samplePosition, symbolSizes, hSampPosition, lSampPosition);
    }

    static void moveSamplePositions(int nSamples, float[] samplePosition, float[] symbolSize, float hSampPosition, float lSampPosition) {
        int j;
        int i;
        if (nSamples < 2) {
            if (samplePosition.length > 0) {
                if (samplePosition[0] < hSampPosition) {
                    samplePosition[0] = hSampPosition;
                }
                if (samplePosition[nSamples - 1] > lSampPosition) {
                    samplePosition[nSamples - 1] = lSampPosition;
                }
            }
            return;
        }
        int ITMAX = 800;
        float MINMOVE = 1.0E-4f;
        float[] force = new float[nSamples];
        float[] SPP = new float[nSamples];
        if (samplePosition[0] < samplePosition[nSamples - 1]) {
            for (i = 0; i < nSamples; ++i) {
                SPP[i] = samplePosition[i];
            }
        } else {
            j = nSamples;
            for (i = 0; i < nSamples; ++i) {
                SPP[i] = samplePosition[--j];
            }
        }
        boolean finished = false;
        int itNumber = 0;
        while (!finished) {
            boolean moveCell = false;
            float overlap = SPP[1] - SPP[0];
            if (overlap < symbolSize[0]) {
                force[0] = -1.0f * (symbolSize[0] - overlap);
                if (Math.abs(force[0]) > 1.0E-4f) {
                    moveCell = true;
                }
            } else {
                force[0] = 0.0f;
            }
            if ((overlap = SPP[nSamples - 1] - SPP[nSamples - 2]) < symbolSize[nSamples - 1]) {
                force[nSamples - 1] = symbolSize[nSamples - 1] - overlap;
                if (Math.abs(force[nSamples - 1]) > 1.0E-4f) {
                    moveCell = true;
                }
            } else {
                force[nSamples - 1] = 0.0f;
            }
            if (nSamples > 2) {
                for (i = 1; i < nSamples - 1; ++i) {
                    overlap = SPP[i] - SPP[i - 1];
                    if (overlap < symbolSize[i - 1]) {
                        force[i] = symbolSize[i - 1] - overlap;
                        if (Math.abs(force[i]) > 1.0E-4f) {
                            moveCell = true;
                        }
                    } else {
                        force[i] = 0.0f;
                    }
                    if (!((overlap = SPP[i + 1] - SPP[i]) < symbolSize[i])) continue;
                    force[i] = force[i] - (symbolSize[i] - overlap);
                    if (!(Math.abs(force[i]) > 1.0E-4f)) continue;
                    moveCell = true;
                }
            }
            float alpha = 0.45f;
            for (i = 0; i < nSamples; ++i) {
                float p;
                SPP[i] = p = SPP[i] + alpha * force[i];
            }
            if (SPP[0] < hSampPosition) {
                SPP[0] = hSampPosition;
            }
            if (SPP[nSamples - 1] > lSampPosition) {
                SPP[nSamples - 1] = lSampPosition;
            }
            boolean bl = finished = !moveCell;
            if (++itNumber <= 800) continue;
            finished = true;
        }
        if (samplePosition[0] < samplePosition[nSamples - 1]) {
            for (i = 0; i < nSamples; ++i) {
                samplePosition[i] = SPP[i];
            }
        } else {
            j = nSamples;
            for (i = 0; i < nSamples; ++i) {
                samplePosition[i] = SPP[--j];
            }
        }
    }

    static float getPanelHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.getPanelHeaderHeight();
    }

    static float getPanelCaptionHeight(ChartProperties cp, Chart.Mode mode) {
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.panelCaptionHeight;
    }

    static float getPanelSubHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.panelSubHeaderHeight;
    }

    float drawHorz(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
        return 0.0f;
    }

    void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException, IOException {
    }

    public SBPanel copy() {
        return null;
    }

    float getXPos(float age, BlockProperties bp) {
        float xpos = bp.ageLeftToRight ? (age - bp.min) * bp.scale : (bp.max - age) * bp.scale;
        return xpos;
    }

    abstract String getCaption();

    String getSubCaption() {
        return null;
    }

    String getSubHeader() {
        return "";
    }

    boolean pipe() {
        return true;
    }

    @Override
    public PanelProperties getProperties() {
        return null;
    }

    @Override
    public int getType() {
        return -1;
    }

    int getIdentifier() {
        return -1;
    }

    int getIdentifier2() {
        return -1;
    }

    static void savePreference(SBdb sbdb, String key, SBPanel panel, int panelNo) throws SQLException {
        PanelProperties pprop = panel.getProperties();
        if (pprop != null && panel.getType() > 0) {
            String panelNoString;
            String prefString = panel.getType() + "^";
            if (panel.getIdentifier() >= 0) {
                prefString = prefString + "#" + panel.getIdentifier() + "#";
                if (panel.getIdentifier2() >= 0) {
                    prefString = prefString + panel.getIdentifier2() + "#";
                }
            }
            if ((panelNoString = "" + panelNo).length() == 1) {
                panelNoString = "0" + panelNo;
            }
            pprop.writeProperties(sbdb, key + panelNoString, prefString);
        }
    }

    int size() {
        return 1;
    }

    static Map<AttributedCharacterIterator.Attribute, Object> getAttributes(SBGraphics g) {
        HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        Font font = g.getFont();
        atts.put(TextAttribute.FAMILY, font.getFamily());
        atts.put(TextAttribute.SIZE, new Float(font.getSize()));
        atts.put(TextAttribute.FOREGROUND, Color.black);
        return atts;
    }

    void handleException(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Exception e) {
        g.setFontSize(cp.fontPanel);
        g.setClip(x, y, this.getWidth(bp), bp.height);
        g.setColor(Color.BLACK);
        LinkedList<String> lines = new LinkedList<String>();
        StackTraceElement[] trace = e.getStackTrace();
        lines.add("Error drawing panel:");
        lines.add(e.toString());
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 8; ++i) {
            lines.add("" + trace[i]);
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        float ypos = y;
        for (String line : lines) {
            g.drawString(line, x + 1.0f, ypos += cp.fontPanel);
        }
        g.setClip(null);
    }

    class ChartImage {
        Image image;
        float origTop;
        float movedTop;
        Object object;
        double depth;
        float width;
        float height;

        ChartImage(ImageIcon icon, float origTop, float width, float height) {
            this.origTop = origTop;
            this.width = width;
            this.height = height;
            this.setImage(icon);
        }

        private void setImage(ImageIcon icon) {
            this.image = (float)icon.getIconWidth() > this.width * 100.0f || (float)icon.getIconHeight() > this.height * 100.0f ? icon.getImage().getScaledInstance((int)(this.width * 100.0f), (int)(this.height * 100.0f), 2) : icon.getImage();
        }
    }
}

