/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import jsbugs.ChartProperties;
import jsbugs.SBPanel;
import model2.Sample;

public abstract class SBPanelHTML
extends SBPanel {
    static final String TD = "<td>";
    static final String TD_END = "</td>";
    static final String BR = "<br>";
    static final String FONT_END = "</font>";

    abstract int addSamples(LinkedList<Sample> var1, ChartProperties var2);

    abstract String getRowString(LinkedList<Sample> var1, int var2, ChartProperties var3);

    String getCaptionString() {
        String cap = this.getColSpan() > 1 ? "<th colspan=\"" + this.getColSpan() + "\">" + this.getCaption() : "<th>" + this.getCaption();
        if (this.getSubCaption() != null) {
            cap = cap + BR + this.getSubCaption();
        }
        cap = cap + "</th>";
        return cap;
    }

    String getSubCaptionString() {
        return TD + (this.getSubCaption() != null ? this.getSubCaption() : "") + TD_END;
    }

    String getSubHeaderString() {
        return "<th>" + (this.getSubHeader() != null ? this.getSubHeader() : "") + "</th>";
    }

    int getColSpan() {
        return 1;
    }

    static String getHTMLRowspan(int span) {
        return "rowspan=\"" + span + "\"";
    }

    static String getHTMLFontColour(Color colour) {
        return "<font color=" + SBPanelHTML.getHexColour(colour) + ">";
    }

    static String getHexColour(Color colour) {
        String[] rgb = new String[]{Integer.toHexString(colour.getRed()), Integer.toHexString(colour.getGreen()), Integer.toHexString(colour.getBlue())};
        String hex = "#";
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i].equals("0")) {
                rgb[i] = "00";
            }
            hex = hex + rgb[i];
        }
        return hex;
    }
}

